/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.smartsearch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.hr.hbp.business.service.smartsearch.SmartSearchConfigService;
import kd.hr.hbp.common.enums.ESSearchTypeEnum;
import kd.hr.hbp.common.model.smartsearch.SmartSearchBoostGroup;
import kd.hr.hbp.common.model.smartsearch.SmartSearchEntity;
import kd.hr.hbp.common.model.smartsearch.SmartSearchWordConfig;
import kd.hr.hbp.common.util.QueryEntityUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class SmartSearchQueryBuilder {
    public static QueryBuilder getQueryBuilder(QueryEntityType dataEntityType, ESSearchTypeEnum searchType, String searchKey, List<SmartSearchWordConfig> wordConfigs) {
        if (wordConfigs == null || wordConfigs.isEmpty()) {
            return null;
        }
        if (wordConfigs.size() == 1) {
            SmartSearchWordConfig wordConfig = wordConfigs.get(0);
            return SmartSearchQueryBuilder.parseWordConfig(searchType, searchKey, dataEntityType, wordConfig.getBoostGroupList());
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (SmartSearchWordConfig wordConfig : wordConfigs) {
            QueryBuilder boostQueryBuilder = SmartSearchQueryBuilder.parseWordConfig(searchType, searchKey, dataEntityType, wordConfig.getBoostGroupList());
            boolQueryBuilder.should(boostQueryBuilder);
        }
        return boolQueryBuilder;
    }

    public static QueryBuilder parseWordConfig(ESSearchTypeEnum searchType, String searchKey, QueryEntityType dataEntityType, List<SmartSearchBoostGroup> boostGroupList) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (SmartSearchBoostGroup smartSearchBoostGroup : boostGroupList) {
            QueryBuilder singleQueryBuilder = SmartSearchQueryBuilder.parseBoostGroup(searchType, searchKey, dataEntityType, smartSearchBoostGroup);
            if (singleQueryBuilder == null) continue;
            boolQueryBuilder.should(singleQueryBuilder);
        }
        return boolQueryBuilder;
    }

    private static QueryBuilder parseBoostGroup(ESSearchTypeEnum searchType, String searchKey, QueryEntityType dataEntityType, SmartSearchBoostGroup smartSearchBoostGroup) {
        float boostValue = smartSearchBoostGroup.getBoostValue();
        List entityList = smartSearchBoostGroup.getEntityList();
        Set<String> oneToManyEntitys = SmartSearchConfigService.getOneToManyEntity(dataEntityType.getName());
        ArrayList queryBuilderList = Lists.newArrayListWithCapacity((int)entityList.size());
        for (SmartSearchEntity smartSearchEntity : entityList) {
            boolean isMainEntity = dataEntityType.getEntityName().equals(smartSearchEntity.getEntityNumber());
            String fieldStr = smartSearchEntity.getFieldAliasStr();
            if (!isMainEntity) {
                fieldStr = smartSearchEntity.getEntityNumber() + "." + fieldStr;
            }
            QueryBuilder queryBuilder = SmartSearchQueryBuilder.genSingleEntityQueryBuilder(smartSearchEntity.getEntityNumber(), fieldStr, searchType, searchKey, oneToManyEntitys);
            queryBuilderList.add(queryBuilder);
        }
        if (queryBuilderList.size() == 1) {
            return ((QueryBuilder)queryBuilderList.get(0)).boost(boostValue);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.boost(boostValue);
        for (QueryBuilder queryBuilder : queryBuilderList) {
            boolQueryBuilder.should(queryBuilder);
        }
        return boolQueryBuilder;
    }

    public static QueryBuilder genSingleEntityQueryBuilder(String entityNumber, String fullFieldStr, ESSearchTypeEnum searchType, String searchKey, Set<String> oneToManyEntitys) {
        IDataEntityProperty fieldProperty = QueryEntityUtil.getFieldProperty((String)entityNumber, (String)fullFieldStr);
        if (fieldProperty instanceof MuliLangTextProp) {
            String langStr = RequestContext.get().getLang().name();
            fullFieldStr = fullFieldStr + "_l." + langStr;
        }
        String path = oneToManyEntitys.contains(entityNumber) ? entityNumber : null;
        return SmartSearchQueryBuilder.buidQueryBuilderBase(path, fullFieldStr, searchType, searchKey);
    }

    private static QueryBuilder buidQueryBuilderBase(String path, String fieldStr, ESSearchTypeEnum esSearchype, String searchKey) {
        MatchQueryBuilder queryBuilder = null;
        if (ESSearchTypeEnum.MATCH == esSearchype) {
            queryBuilder = QueryBuilders.matchQuery((String)fieldStr, (Object)searchKey);
        } else if (ESSearchTypeEnum.MATCH_PHRASE == esSearchype) {
            queryBuilder = QueryBuilders.matchPhraseQuery((String)fieldStr, (Object)searchKey);
        } else if (ESSearchTypeEnum.TERMS == esSearchype) {
            queryBuilder = QueryBuilders.termQuery((String)fieldStr, (String)searchKey);
        } else if (ESSearchTypeEnum.WILDCARD == esSearchype) {
            queryBuilder = QueryBuilders.wildcardQuery((String)fieldStr, (String)searchKey);
        }
        if (StringUtils.isNotBlank((CharSequence)path) && null != queryBuilder) {
            queryBuilder = QueryBuilders.nestedQuery((String)path, (QueryBuilder)queryBuilder, (ScoreMode)ScoreMode.Max);
        }
        return queryBuilder;
    }
}

