/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class DiffServiceHelper {
    private static final String DIFF_HANDLER = "hbss_diffhandler";
    private static final String DIFF_IMPLEMENT = "hbss_diffimplement";
    private static final String HANDLER_FIELDS = "id,form,app,sourceclassname,sourcemethodname,sourcemethodsign,isoverride,hbss_difftarget.targetisv,hbss_difftarget.targetclassname,hbss_difftarget.targetmethodname";
    private static final String IMPLEMENT_FIELDS = "id,isv,number,name,desc,serviceimpl";
    public static Function<DynamicObject, Map<String, Object>> handlerResult = dynamicObject -> new HashMap<String, Object>(){
        private static final long serialVersionUID = -2147033913043513893L;
        {
            this.put("id", dynamicObject.getString("id"));
            this.put("form", Optional.ofNullable(dynamicObject.getDynamicObject("form")).map(it -> it.getString("id")).orElse(null));
            this.put("app", dynamicObject.getDynamicObject("app").getString("id"));
            this.put("sourceclassname", dynamicObject.getString("sourceclassname"));
            this.put("sourcemethodname", dynamicObject.getString("sourcemethodname"));
            this.put("sourcemethodsign", dynamicObject.getString("sourcemethodsign"));
            this.put("isoverride", dynamicObject.getString("isoverride"));
            this.put("difftarget", dynamicObject.getDynamicObjectCollection("hbss_difftarget").stream().map(target -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("targetisv", target.getString("targetisv"));
                map.put("targetclassname", target.getString("targetclassname"));
                map.put("targetmethodname", target.getString("targetmethodname"));
                return map;
            }).collect(Collectors.toList()));
        }
    };
    public static Function<DynamicObject, Map<String, Object>> implementResult = dynamicObject -> new HashMap<String, Object>(){
        private static final long serialVersionUID = -9024386409752067288L;
        {
            this.put("id", dynamicObject.getString("id"));
            this.put("isv", dynamicObject.getString("isv"));
            this.put("number", dynamicObject.getString("number"));
            this.put("name", dynamicObject.getString("name"));
            this.put("desc", dynamicObject.getString("desc"));
            this.put("serviceimpl", dynamicObject.getString("serviceimpl"));
        }
    };

    public static List<Map<String, Object>> listEnabledHandler() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(DIFF_HANDLER);
        return Arrays.stream(serviceHelper.query(HANDLER_FIELDS, new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))})).map(handlerResult::apply).collect(Collectors.toList());
    }

    public static List<Map<String, Object>> listById(List<Long> handlerIdList) {
        HRBaseServiceHelper handlerHelper = new HRBaseServiceHelper(DIFF_HANDLER);
        return Arrays.stream(handlerHelper.query(HANDLER_FIELDS, new QFilter[]{new QFilter("id", "in", handlerIdList)})).map(handlerResult::apply).collect(Collectors.toList());
    }

    public static void batchEnableHandler(List<Long> handlerIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper handlerHelper = new HRBaseServiceHelper(DIFF_HANDLER);
        for (DynamicObject item : items = handlerHelper.query("enable", new QFilter[]{new QFilter("id", "in", handlerIdList)})) {
            item.set("enable", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static void batchDisableHandler(List<Long> handlerIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper handlerHelper = new HRBaseServiceHelper(DIFF_HANDLER);
        for (DynamicObject item : items = handlerHelper.query("enable", new QFilter[]{new QFilter("id", "in", handlerIdList)})) {
            item.set("enable", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static List<Map<String, Object>> listEnabledImplement() {
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_IMPLEMENT);
        return Arrays.stream(implementHelper.query(IMPLEMENT_FIELDS, new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))})).map(implementResult::apply).collect(Collectors.toList());
    }

    public static List<Map<String, Object>> listImplementById(List<Long> implementIdList) {
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_IMPLEMENT);
        return Arrays.stream(implementHelper.query(IMPLEMENT_FIELDS, new QFilter[]{new QFilter("id", "in", implementIdList)})).map(implementResult::apply).collect(Collectors.toList());
    }

    public static void batchEnableImplement(List<Long> implementIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_IMPLEMENT);
        for (DynamicObject item : items = implementHelper.query("enable", new QFilter[]{new QFilter("id", "in", implementIdList)})) {
            item.set("enable", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static void batchDisableImplement(List<Long> implementIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_IMPLEMENT);
        for (DynamicObject item : items = implementHelper.query("enable", new QFilter[]{new QFilter("id", "in", implementIdList)})) {
            item.set("enable", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }
}

