/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.function.DynCollHandler;
import kd.hr.hbp.common.util.HRAssert;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HRBaseServiceHelper {
    private final Log logger;
    private String entityName;

    public static HRBaseServiceHelper create(String entityName) {
        return new HRBaseServiceHelper(entityName);
    }

    public HRBaseServiceHelper(String entityName) {
        this.entityName = entityName;
        this.logger = StringUtils.isBlank((CharSequence)entityName) ? LogFactory.getLog(HRBaseServiceHelper.class) : LogFactory.getLog((String)"HRBaseServiceHelper#".concat(entityName));
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public DynamicObject generateEmptyEntryDynamicObject(String entryEntity) {
        return this.generateEmptyEntryDynamicObject(this.getEntityName(), entryEntity);
    }

    public DynamicObject generateEmptyEntryDynamicObject(String entityName, String entryEntity) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityType type = (EntityType)mainType.getAllEntities().get(entryEntity);
        return (DynamicObject)type.createInstance();
    }

    public DynamicObjectCollection generateEmptyEntryCollection(DynamicObject dy, String entryEntity) {
        MainEntityType mainType = (MainEntityType)dy.getDataEntityType();
        EntityType type = (EntityType)mainType.getAllEntities().get(entryEntity);
        DynamicObjectCollection dyColl = new DynamicObjectCollection((DynamicObjectType)type, (Object)dy);
        dy.set(entryEntity, (Object)dyColl);
        return dyColl;
    }

    public Pair<DynamicObjectCollection, DynamicObjectType> genEmptyEntryColl(DynamicObject dynObj, String entryName) {
        DynamicObjectCollection dyCollPre = dynObj.getDynamicObjectCollection(entryName);
        DynamicObjectType dataEntityType = dyCollPre.getDynamicObjectType();
        DynamicObjectCollection dyCollNew = new DynamicObjectCollection(dataEntityType, (Object)dynObj);
        dynObj.set(entryName, (Object)dyCollNew);
        return Pair.of((Object)dynObj.getDynamicObjectCollection(entryName), (Object)dataEntityType);
    }

    public DynamicObjectCollection genEmptyEntryCollWithSize(DynamicObject dynObj, String entryName, int size) {
        MainEntityType mainType = (MainEntityType)dynObj.getDataEntityType();
        EntityType type = (EntityType)mainType.getAllEntities().get(entryName);
        DynamicObjectCollection dyColl = new DynamicObjectCollection((DynamicObjectType)type, (Object)dynObj);
        for (int i = 0; i < size; ++i) {
            dyColl.add((Object)new DynamicObject((DynamicObjectType)type));
        }
        dynObj.set(entryName, (Object)dyColl);
        return dyColl;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return this.generateEmptyDynamicObject(this.getEntityName());
    }

    public DynamicObject generateEmptyDynamicObject(String entityName) {
        return BusinessDataServiceHelper.newDynamicObject((String)entityName);
    }

    public DynamicObject generateDynamicObject(Object pk, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), pk, selectProperties);
    }

    public DynamicObject generateDynamicObject(DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), dobj, selectProperties);
    }

    public DynamicObject generateDynamicObject(String entityName, DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(entityName, dobj.getPkValue(), selectProperties);
    }

    public DynamicObject generateDynamicObject(String entityName, Object pk, String selectProperties) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName, (String)selectProperties);
    }

    public Object updateOne(DynamicObject dobj) {
        Object[] pks = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        return pks[0];
    }

    public Object updateSingleDynObjColl(String pkId, String entryName, DynCollHandler<List<Map<String, Object>>> dynCollHandler) {
        HRAssert.notBlank((String)pkId, (String)"pkId must not be blank", (Object[])new Object[0]);
        HRAssert.notBlank((String)entryName, (String)"entryName must not be blank", (Object[])new Object[0]);
        DynamicObject dynamicObject = this.queryOne(pkId);
        HRAssert.notNull((Object)dynamicObject, (String)String.format("dynamicObject\uff1apkid{%s} queryDB result is null", pkId), (Object[])new Object[0]);
        List paramList = (List)dynCollHandler.getParams();
        Pair<DynamicObjectCollection, DynamicObjectType> pair = this.genEmptyEntryColl(dynamicObject, entryName);
        if (CollectionUtils.isEmpty((Collection)paramList)) {
            this.logger.warn("DynCollHandler result is null, execute delete entry");
            dynCollHandler.buildDelEntryCollection((DynamicObjectCollection)pair.getLeft(), (DynamicObjectType)pair.getRight());
        } else {
            dynCollHandler.buildEntryCollection((DynamicObjectCollection)pair.getLeft(), (DynamicObjectType)pair.getRight(), paramList);
        }
        return this.updateOne(dynamicObject);
    }

    public Object updateMultDynObjColl(String pkId, DynCollHandler<Map<String, List<Map<String, Object>>>> dynCollHandler, String ... entryNames) {
        HRAssert.notBlank((String)pkId, (String)"pkId must not be blank", (Object[])new Object[0]);
        HRAssert.notNull((Object)entryNames, (String)"entryNames must not be blank", (Object[])new Object[0]);
        Map params = (Map)dynCollHandler.getParams();
        HRAssert.notEmpty((Map)params, (String)"params cannot be empty", (Object[])new Object[0]);
        DynamicObject dynamicObject = this.queryOne(pkId);
        HRAssert.notNull((Object)dynamicObject, (String)String.format("dynamicObject\uff1apkid{%s} queryDB result is null", pkId), (Object[])new Object[0]);
        for (String entryName : entryNames) {
            if (StringUtils.isBlank((CharSequence)entryName)) continue;
            List paramList = (List)MapUtils.getObject((Map)params, (Object)entryName);
            Pair<DynamicObjectCollection, DynamicObjectType> pair = this.genEmptyEntryColl(dynamicObject, entryName);
            if (CollectionUtils.isEmpty((Collection)paramList)) {
                this.logger.warn("DynCollHandler result is null, execute delete entry");
                dynCollHandler.buildDelEntryCollection((DynamicObjectCollection)pair.getLeft(), (DynamicObjectType)pair.getRight());
                continue;
            }
            dynCollHandler.buildEntryCollection((DynamicObjectCollection)pair.getLeft(), (DynamicObjectType)pair.getRight(), paramList);
        }
        List mainEntityParams = (List)MapUtils.getObject((Map)params, (Object)"MAIN_ENTITY_PARAMS");
        if (CollectionUtils.isNotEmpty((Collection)mainEntityParams)) {
            dynCollHandler.setMainEntityVal(dynamicObject, mainEntityParams);
        }
        return this.updateOne(dynamicObject);
    }

    public Object[] update(DynamicObject[] dobjs) {
        return SaveServiceHelper.save((DynamicObject[])dobjs);
    }

    public void updateDatas(DynamicObject[] dobjs) {
        SaveServiceHelper.save((DynamicObject[])dobjs);
    }

    public void updateDataOne(DynamicObject dobj) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
    }

    public DynamicObject queryOne(Object pk) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityName());
    }

    public DynamicObject queryOne(String selectProperties, Object pk) {
        QFilter filter = new QFilter("id", "=", pk);
        return this.queryOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOne(String selectProperties, QFilter filter) {
        return this.queryOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOne(QFilter[] filters) {
        DynamicObject[] dobjs = this.load(this.getEntityName(), filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOne(String selectProperties, QFilter[] filters) {
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOne(String selectProperties, QFilter[] filters, String order) {
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters, (String)order);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOriginalOne(String selectProperties, Object pk) {
        QFilter filter = new QFilter("id", "=", pk);
        return this.queryOriginalOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOriginalOne(QFilter filter) {
        return this.queryOriginalOne((String)null, new QFilter[]{filter});
    }

    public DynamicObject queryOriginalOne(QFilter[] filters) {
        return this.queryOriginalOne((String)null, filters);
    }

    public DynamicObject queryOriginalOne(String selectProperties, QFilter filter) {
        return this.queryOriginalOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOriginalOne(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryOne((String)this.getEntityName(), (String)selectFields, (QFilter[])filters);
    }

    public DynamicObject queryOriginalOne(String selectFields, QFilter[] filters, String orderBys) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys);
        if (collection.size() > 0) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public DynamicObjectCollection queryOriginalCollection(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.query((String)this.getEntityName(), (String)selectFields, (QFilter[])filters);
    }

    public DynamicObject[] queryOriginalArray(String selectFields, QFilter[] filters) {
        DynamicObjectCollection dyColl = this.queryOriginalCollection(selectFields, filters);
        DynamicObject[] dys = new DynamicObject[dyColl.size()];
        int size = dyColl.size();
        for (int i = 0; i < size; ++i) {
            dys[i] = (DynamicObject)dyColl.get(i);
        }
        return dys;
    }

    public DynamicObject[] queryOriginalArray(String selectFields, QFilter[] filters, String orderBys) {
        DynamicObjectCollection dyColl = this.queryOriginalCollection(selectFields, filters, orderBys);
        DynamicObject[] dys = new DynamicObject[dyColl.size()];
        int size = dyColl.size();
        for (int i = 0; i < size; ++i) {
            dys[i] = (DynamicObject)dyColl.get(i);
        }
        return dys;
    }

    public DynamicObjectCollection queryOriginalCollection(String selectFields, QFilter[] filters, String orderBys) {
        return QueryServiceHelper.query((String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public DynamicObject[] query(QFilter[] filters) {
        return this.load(this.getEntityName(), filters);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
    }

    public DynamicObject[] query(QFilter[] filters, String orderBys) {
        return this.load(this.getEntityName(), filters, orderBys);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters, String orderBys) {
        return this.load(this.getEntityName(), selectProperties, filters, orderBys);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters, String orderby, int top) {
        return this.load(this.getEntityName(), selectProperties, filters, orderby, top);
    }

    public DataSet queryMultiEntityDataSet(String selectFields, QFilter[] filters, String orderBys, boolean isLimitCount, int start, int limit) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        if (queryEntityType == null) {
            return null;
        }
        return HRQueryEntityHelper.getInstance().getQueryDataSet(queryEntityType, selectFields, filters, orderBys, isLimitCount, start, limit);
    }

    public DataSet queryDataSet(String algoKey, String selectFields) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, null, null);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, null, (String)orderBys);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, (QFilter[])filters, null);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters, String orderBys, int top) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
    }

    public <T> List<T> queryTranPropList(String selectFields, QFilter[] filters, String propName, Class<T> type) {
        boolean isMatch = Arrays.stream(StringUtils.split((String)selectFields, (String)",")).anyMatch(item -> propName.equalsIgnoreCase(item.trim()) || item.trim().toUpperCase().endsWith(" ".concat(propName).toUpperCase()));
        HRAssert.isTrue((boolean)isMatch, (String)String.format("selectFields[%s] must contain propName[%s]", selectFields, propName), (Object[])new Object[0]);
        Object[] dynamicObjects = this.queryOriginalArray(selectFields, filters);
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            return Stream.of(dynamicObjects).map(item -> {
                if (type.equals(Long.class)) {
                    return Long.valueOf(item.getLong(propName));
                }
                return item.getString(propName);
            }).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public boolean isExists(Object pk) {
        return QueryServiceHelper.exists((String)this.getEntityName(), (Object)pk);
    }

    public boolean isExists(QFilter filter) {
        return this.isExists(new QFilter[]{filter});
    }

    public boolean isExists(QFilter[] filters) {
        return QueryServiceHelper.exists((String)this.getEntityName(), (QFilter[])filters);
    }

    public void deleteOne(Object pk) {
        this.delete(this.getEntityName(), pk);
    }

    public void delete(Object[] pks) {
        this.delete(this.getEntityName(), pks);
    }

    public int deleteByFilter(QFilter[] filters) {
        return this.delete(this.getEntityName(), filters);
    }

    public Object saveOne(DynamicObject dobj) {
        Object[] pks = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        return pks[0];
    }

    public Object[] save(DynamicObject[] dobjs) {
        return SaveServiceHelper.save((DynamicObject[])dobjs);
    }

    public Object[] save(DynamicObjectCollection dobjColl) {
        int size;
        Object[] result = null;
        if (dobjColl != null && (size = dobjColl.size()) > 0) {
            DynamicObject[] dobjs = new DynamicObject[size];
            for (int i = 0; i < size; ++i) {
                dobjs[i] = (DynamicObject)dobjColl.get(i);
            }
            result = SaveServiceHelper.save((DynamicObject[])dobjs);
        }
        return result;
    }

    public int count(String entityName, QFilter[] filters) {
        ORM orm = ORM.create();
        return orm.count("QueryServiceHelper." + entityName, entityName, filters);
    }

    private DynamicObject[] load(String entityName, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])filters);
    }

    private DynamicObject[] load(String entityName, QFilter[] filters, String orderBys) {
        return BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])filters, (String)orderBys);
    }

    private DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBys) {
        return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBys);
    }

    private DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderby, int top) {
        return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderby, (int)top);
    }

    private void delete(String entityName, Object pk) {
        Object[] pks = new Object[]{pk};
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
    }

    private void delete(String entityName, Object[] pks) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
    }

    private int delete(String entityName, QFilter[] filters) {
        return DeleteServiceHelper.delete((String)entityName, (QFilter[])filters);
    }

    public DynamicObject[] loadDynamicObjectArray(QFilter[] filters) {
        return this.loadDynamicObjectArray(this.getEntityName(), filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] loadDynamicObjectArray(String entityName, QFilter[] filters) {
        ArrayList listIds = new ArrayList();
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"BusinessDataServiceHelper.LoadFromCache", (String)entityName, (String)"id", (QFilter[])filters, null);
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.load((Object[])listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)type);
    }

    public DynamicObject loadDynamicObject(QFilter filter) {
        return this.loadDynamicObject(new QFilter[]{filter});
    }

    public DynamicObject loadDynamicObject(QFilter[] filters) {
        DynamicObject[] dobjs = this.loadDynamicObjectArray(this.getEntityName(), filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject loadSingle(Object pk) {
        return this.loadSingle(this.getEntityName(), pk);
    }

    public DynamicObject loadSingle(String entityName, Object pk) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.loadSingle((Object)pk, (DynamicObjectType)type);
    }

    public DynamicObject[] loadDynamicObjectArray(Object[] pkArray) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        return BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)type);
    }

    public DynamicObject[] loadDynamicObjectArray(String entityName, Object[] pkArray) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)type);
    }
}

