/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRHistoryHelper {
    private static final String BRED = "bred";
    private static final String BREDT = "bredt";

    public static DynamicObject[] genCurrentDynamicObjects(DynamicObject[] hisDys) {
        if (hisDys != null && hisDys.length > 0) {
            DynamicObject[] dys = new DynamicObject[hisDys.length];
            for (int i = 0; i < hisDys.length; ++i) {
                dys[i] = HRHistoryHelper.genCurrentDynamicObject(null, hisDys[i]);
            }
            return dys;
        }
        return null;
    }

    public static DynamicObject genCurrentDynamicObject(DynamicObject hisDy) {
        return HRHistoryHelper.genCurrentDynamicObject(null, hisDy);
    }

    public static DynamicObject genCurrentDynamicObject(String entityName, DynamicObject hisDy) {
        if (HRStringUtils.isEmpty((String)entityName)) {
            String hisEntityName = hisDy.getDataEntityType().getName();
            StringBuffer entityNameStrBuf = new StringBuffer(hisEntityName);
            entityNameStrBuf = entityNameStrBuf.delete(entityNameStrBuf.length() - 3, entityNameStrBuf.length());
            entityName = entityNameStrBuf.toString();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject dy = serviceHelper.generateEmptyDynamicObject();
        Set<String> ignoreKeysSet = HRHistoryHelper.getIgnoreKeysSet();
        Map<String, String> transKeyMap = HRHistoryHelper.getTransKeyMap();
        HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)dy, ignoreKeysSet, transKeyMap);
        return dy;
    }

    public static DynamicObject updateCurrentDynamicObject(DynamicObject hisDy, DynamicObject currentDyn) {
        Set<String> ignoreKeysSet = HRHistoryHelper.getIgnoreKeysSet();
        Map<String, String> transKeyMap = HRHistoryHelper.getTransKeyMap();
        HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)currentDyn, ignoreKeysSet, transKeyMap);
        return currentDyn;
    }

    public static DynamicObject updateCurrentDynamicObject(DynamicObject hisDy, DynamicObject currentDyn, String versionIdFieldName) {
        Set<String> ignoreKeysSet = HRHistoryHelper.getIgnoreKeysSet();
        Map<String, String> transKeyMap = HRHistoryHelper.getTransKeyMap(versionIdFieldName);
        HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)currentDyn, ignoreKeysSet, transKeyMap);
        return currentDyn;
    }

    public static Set<String> getIgnoreKeysSet() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)25);
        set.add("bsed");
        set.add(BRED);
        set.add(BREDT);
        set.add("bsled");
        set.add("brled");
        set.add("brledt");
        set.add("ce");
        set.add("cedt");
        set.add("lme");
        set.add("lmedt");
        set.add("ee");
        set.add("eedt");
        set.add("lee");
        set.add("leedt");
        set.add("de");
        set.add("dedt");
        set.add("lde");
        set.add("ldedt");
        set.add("datastatus");
        set.add("islastversion");
        set.add("isnewbo");
        return set;
    }

    private static Map<String, String> getTransKeyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bo", "id");
        map.put("id", "vid");
        return map;
    }

    private static Map<String, String> getTransKeyMap(String versionIdFieldName) {
        if (HRStringUtils.isEmpty((String)versionIdFieldName)) {
            versionIdFieldName = "vid";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bo", "id");
        map.put("id", versionIdFieldName.toLowerCase(Locale.ROOT));
        return map;
    }

    public static DynamicObject[] getHistoryDynamicObjects(String entityName, long eventId) {
        QFilter filter = new QFilter("ce", "=", (Object)eventId);
        QFilter[] filters = new QFilter[]{filter};
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.query(filters);
    }

    public static DynamicObject getHistoryDynamicObject(String entityName, long eventId) {
        return HRHistoryHelper.getHistoryDynamicObject(entityName, eventId, 0L);
    }

    public static DynamicObject getHistoryDynamicObject(String entityName, long eventId, long entryId) {
        QFilter[] filters;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] dys;
        QFilter filter = new QFilter("ce", "=", (Object)eventId);
        if (entryId != 0L) {
            QFilter entryFilter = new QFilter("cee", "=", (Object)eventId);
            filter.and(entryFilter);
        }
        if ((dys = (serviceHelper = new HRBaseServiceHelper(entityName)).query(filters = new QFilter[]{filter})) != null && dys.length > 0) {
            return dys[0];
        }
        return null;
    }

    public static String convertHisEntityToCurrent(String historyEntityName) {
        if (HRStringUtils.isEmpty((String)historyEntityName)) {
            return null;
        }
        StringBuffer str = new StringBuffer(historyEntityName);
        str = str.delete(str.length() - 3, str.length());
        return str.toString();
    }

    public static String convertCurrentEntityToHis(String currentEntityName) {
        if (HRStringUtils.isEmpty((String)currentEntityName)) {
            return null;
        }
        StringBuilder str = new StringBuilder(currentEntityName);
        str.append("his");
        return str.toString();
    }

    public static void setEffectHisField(DynamicObject hisDy, long eventId, Date effectDate, long timestamp) {
        hisDy.set(BRED, (Object)effectDate);
        hisDy.set(BREDT, (Object)timestamp);
        hisDy.set("datastatus", (Object)"1");
        hisDy.set("ee", (Object)eventId);
    }

    public static void setEffectHisField(DynamicObject[] hisDys, long eventId, Date effectDate, long timestamp) {
        for (int i = 0; i < hisDys.length; ++i) {
            hisDys[i].set(BRED, (Object)effectDate);
            hisDys[i].set(BREDT, (Object)timestamp);
            hisDys[i].set("datastatus", (Object)"1");
            hisDys[i].set("ee", (Object)eventId);
        }
    }

    public static void setCreateField(DynamicObject dy) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date sysCurrentTime = new Date();
        Long creatorId = userId;
        Date createTime = sysCurrentTime;
        dy.set("creator", (Object)creatorId);
        dy.set("createtime", (Object)createTime);
    }

    public static void setModifyField(DynamicObject dy) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date sysCurrentTime = new Date();
        Long modifierId = userId;
        Date modifyTime = sysCurrentTime;
        dy.set("modifier", (Object)modifierId);
        dy.set("modifytime", (Object)modifyTime);
    }

    public static void setHisField(DynamicObject dy, DynamicObject hisDy) {
        Date bsed = dy.getDate("effdt");
        long eventId = dy.getLong("event");
        Date cedt = dy.getDate("cedt");
        long ceId = eventId;
        long lmeId = eventId;
        Date lmedt = cedt;
        String dataStatus = "0";
        hisDy.set("bsed", (Object)bsed);
        hisDy.set("ce", (Object)ceId);
        hisDy.set("cedt", (Object)cedt);
        hisDy.set("lme", (Object)lmeId);
        hisDy.set("lmedt", (Object)lmedt);
        hisDy.set("datastatus", (Object)dataStatus);
    }

    public static DynamicObject convertCurrentDyToHisDy(DynamicObject currentDy) {
        String entityName = currentDy.getDataEntityType().getName();
        return HRHistoryHelper.convertCurrentDyToHisDy(entityName, currentDy);
    }

    public static DynamicObject convertCurrentDyToHisDy(String entityName, DynamicObject currentDy) {
        String hisEntityName = HRHistoryHelper.convertCurrentEntityToHis(entityName);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityName);
        DynamicObject hisDy = serviceHelper.generateEmptyDynamicObject();
        Map<String, String> transKeyMap = HRHistoryHelper.getCurrentToHisTransKeyMap();
        Set<String> ignoreKeysSet = HRHistoryHelper.getCurrentToHisIgnoreKeysSet();
        HRDynamicObjectUtils.copy((DynamicObject)currentDy, (DynamicObject)hisDy, ignoreKeysSet, transKeyMap);
        return hisDy;
    }

    private static Map<String, String> getCurrentToHisTransKeyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", "bo");
        map.put("vid", "id");
        return map;
    }

    public static Set<String> getCurrentToHisIgnoreKeysSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("creator");
        set.add("createtime");
        set.add("modifier");
        set.add("modifytime");
        return set;
    }

    public static DynamicObject getNewDataHisDy(DynamicObject hisDy) {
        String hisEntityName = hisDy.getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityName);
        DynamicObject newDataHisDy = serviceHelper.generateEmptyDynamicObject();
        Set<String> ignoreKeysSet = HRHistoryHelper.getScheduleEffectOldHisIgnoreSet();
        HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDataHisDy, ignoreKeysSet, null);
        HRHistoryHelper.setCreateField(newDataHisDy);
        HRHistoryHelper.setModifyField(newDataHisDy);
        return newDataHisDy;
    }

    public static Set<String> getScheduleEffectOldHisIgnoreSet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("id");
        hashSet.add("ce");
        hashSet.add("cedt");
        hashSet.add("lme");
        hashSet.add("lmedt");
        hashSet.add("ee");
        hashSet.add("eedt");
        hashSet.add("lee");
        hashSet.add("leedt");
        hashSet.add("de");
        hashSet.add("dedt");
        hashSet.add("lde");
        hashSet.add("ldedt");
        hashSet.add("datastatus");
        hashSet.add("islastversion");
        hashSet.add("isnewbo");
        return hashSet;
    }

    public static QFilter getEffectHisFilter() {
        return new QFilter("datastatus", "=", (Object)"1");
    }

    public static QFilter getScheduleEffectHisFilter() {
        return new QFilter("datastatus", "=", (Object)"0");
    }
}

