/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRMessageServiceHelper {
    private static final Log logger = LogFactory.getLog(HRMessageServiceHelper.class);
    private static final String LICENSE_GROUP_SMS = "CP_SMS";
    private static final String PAGE_MSG_CHANNEL = "msg_channel";
    private static final String HWSMS = "hwsms";

    public static void sendShortMessage(Map<String, Object> map) {
        Boolean isUserInGroup = LicenseServiceHelper.checkPerformGroup((String)LICENSE_GROUP_SMS).getHasLicense();
        String notifyType = (String)map.get("notifyType");
        if (HRStringUtils.equals((String)notifyType, (String)HWSMS)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_MSG_CHANNEL);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            QFilter categoryFilter = new QFilter("category", "=", (Object)"shortMsg");
            QFilter numberFilter = new QFilter("number", "!=", (Object)"sms");
            statusFilter.and(categoryFilter);
            statusFilter.and(numberFilter);
            DynamicObject[] dys = serviceHelper.query("number", new QFilter[]{statusFilter});
            String number = "";
            if (dys != null && dys.length > 0) {
                number = dys[0].getString("number");
            }
            if (HRStringUtils.isEmpty((String)number)) {
                logger.error("Send Msg Failed! Your System Not Bought Msg Permission,Please contact Admin!");
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\u3002\u60a8\u7684\u7cfb\u7edf\u672a\u8d2d\u4e70\u77ed\u4fe1\u670d\u52a1\u4ea7\u54c1\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRMessageServiceHelper_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            MessageInfo messageInfo = HRMessageServiceHelper.getMessageInfo(map, notifyType);
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        } else if (isUserInGroup.booleanValue()) {
            String countryCode = (String)map.get("countryCode");
            String message = (String)map.get("message");
            List phoneList = (List)map.get("phone");
            String signature = (String)map.get("signature");
            ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
            shortMessageInfo.setCountryCode(countryCode);
            shortMessageInfo.setMessage(message);
            shortMessageInfo.setPhone(phoneList);
            shortMessageInfo.setSignature(signature);
            MessageServiceHelper.sendShortMessage((ShortMessageInfo)shortMessageInfo);
        }
    }

    private static MessageInfo getMessageInfo(Map<String, Object> map, String notifyType) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setNotifyType(notifyType);
        String content = String.valueOf(map.remove("content"));
        messageInfo.setContent(content);
        messageInfo.setParams(map);
        messageInfo.setType("message");
        messageInfo.setTitle(String.valueOf(map.get("title")));
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        messageInfo.setTemplateNumber(String.valueOf(map.get("templateNumber")));
        messageInfo.setEntityNumber(String.valueOf(map.get("entityNumber")));
        map.put("phone", "phoneValue");
        if (Objects.nonNull(map.get("bizDataId"))) {
            messageInfo.setBizDataId((Long)map.get("bizDataId"));
        }
        return messageInfo;
    }

    public static void sendEmail(Map<String, Object> map) {
        String notifyType = (String)map.get("notifyType");
        if (HRStringUtils.equals((String)notifyType, (String)"hwemail")) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_MSG_CHANNEL);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            QFilter categoryFilter = new QFilter("category", "=", (Object)"email");
            QFilter numberFilter = new QFilter("number", "!=", (Object)"email");
            statusFilter.and(categoryFilter);
            statusFilter.and(numberFilter);
            DynamicObject[] dys = serviceHelper.query("number", new QFilter[]{statusFilter});
            String number = "";
            if (dys != null && dys.length > 0) {
                number = dys[0].getString("number");
            }
            if (HRStringUtils.isEmpty((String)number)) {
                logger.error("Send Msg Failed! Your System Not Setting Email,Please contact Admin!");
                throw new KDBizException(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\u3002\u7cfb\u7edf\u672a\u914d\u7f6e\u90ae\u4ef6\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRMessageServiceHelper_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            MessageInfo messageInfo = HRMessageServiceHelper.getEmailMessageInfo(map, notifyType);
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        } else {
            MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)"email");
            if (msgChannelInfo != null) {
                String contentMimeType = (String)map.get("contentMimeType");
                String title = (String)map.get("title");
                List receiverList = (List)map.get("receiver");
                List copyReceiverList = (List)map.get("copyReceiver");
                List secretReceiverList = (List)map.get("secretReceiver");
                EmailInfo emailInfo = new EmailInfo();
                emailInfo.setContentMimeType(contentMimeType);
                emailInfo.setTitle(title);
                emailInfo.setReceiver(receiverList);
                emailInfo.setCopyReceiver(copyReceiverList);
                emailInfo.setSecretReceiver(secretReceiverList);
                MessageServiceHelper.sendEmail((EmailInfo)emailInfo);
            }
        }
    }

    private static MessageInfo getEmailMessageInfo(Map<String, Object> map, String notifyType) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setNotifyType(notifyType);
        String content = String.valueOf(map.remove("content"));
        messageInfo.setContent(content);
        messageInfo.setParams(map);
        messageInfo.setTitle(String.valueOf(map.get("title")));
        messageInfo.setTemplateNumber(String.valueOf(map.get("templateNumber")));
        messageInfo.setEntityNumber(String.valueOf(map.get("entityNumber")));
        map.put("email", "emailValue");
        if (Objects.nonNull(map.get("bizDataId"))) {
            messageInfo.setBizDataId((Long)map.get("bizDataId"));
        }
        return messageInfo;
    }

    public static void startChat(long userId, IFormView view) {
        boolean isYzjEnable = YzjConfigServiceHelper.isEnable();
        if (isYzjEnable) {
            HRMessageServiceHelper.startYzjChat(userId, view);
        } else {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_MSG_CHANNEL);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            QFilter categoryFilter = new QFilter("category", "=", (Object)"chart");
            statusFilter.and(categoryFilter);
            DynamicObject[] dys = serviceHelper.query("number", new QFilter[]{statusFilter});
            String number = "";
            if (dys != null && dys.length > 0) {
                number = dys[0].getString("number");
            }
            if (HRStringUtils.isEmpty((String)number)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u6682\u672a\u5f00\u901a\u5373\u65f6\u901a\u8baf\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRMessageServiceHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            MessageInfo messageInfo = new MessageInfo();
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("userId", userId);
            messageInfo.setParams(map);
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    private static void startYzjChat(Object userId, IFormView view) {
        try {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_user");
            QFilter f1 = new QFilter("id", "=", userId);
            QFilter[] filters = new QFilter[]{f1};
            DynamicObject user = serviceHelper.queryOne("id,name,useropenid", filters);
            if (user == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"HRMessageServiceHelper_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                return;
            }
            String openId = user.getString("useropenid");
            if (HRStringUtils.isEmpty((String)openId)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u4e0d\u5b58\u5728\u8be5\u7528\u6237\uff0c\u8bf7\u5148\u589e\u52a0\u7528\u6237\u3002", (String)"HRMessageServiceHelper_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> mData = new HashMap<String, String>();
            mData.put("oid", openId);
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("chatToYZJ_PC", mData);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u4e4b\u5bb6\u6c9f\u901a\u5931\u8d25\u3002%s", (String)"HRMessageServiceHelper_5", (String)"hrmp-hbp-business", (Object[])new Object[0]), e.getMessage());
            logger.error((Throwable)e);
            throw new KDException(BosErrorCode.render, new Object[]{msg});
        }
    }
}

