/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HRMetaDataServiceHelper {
    public static final HRBaseServiceHelper FORMMETA_SERVICE_HELPER = new HRBaseServiceHelper("bos_formmeta");
    public static final HRBaseServiceHelper BIZAPP_SERVICE_HELPER = new HRBaseServiceHelper("bos_devportal_bizapp");
    public static final String FORMMETA_SELECT_FIELDS = "id,number,istemplate,modeltype,inheritpath,basedatafield,parentid,type,version,createdate,modifydate,modifierid,masterid,bizappid,isv,industry,isextended,enabled";

    public static DynamicObject getFormMeta(String entityNum, String bizAppId) {
        return FORMMETA_SERVICE_HELPER.queryOne(FORMMETA_SELECT_FIELDS, new QFilter[]{new QFilter("number", "=", (Object)entityNum), new QFilter("bizappid", "=", (Object)bizAppId)});
    }

    public static String getFormMetaId(String entityNum, String bizAppId) {
        DynamicObject formMeta = FORMMETA_SERVICE_HELPER.queryOriginalOne("id", new QFilter[]{new QFilter("number", "=", (Object)entityNum), new QFilter("bizappid", "=", (Object)bizAppId)});
        return formMeta == null ? "" : formMeta.getString("id");
    }

    public static String getBizAppId(String bizAppNum) {
        DynamicObject bizApp = BIZAPP_SERVICE_HELPER.queryOriginalOne("id", new QFilter[]{new QFilter("number", "=", (Object)bizAppNum)});
        return bizApp == null ? "" : bizApp.getString("id");
    }

    public static EntityMetadata getEntityMetadata(String entityNum, String bizAppId) {
        AbstractMetadata abstractMetadata = MetadataDao.readMeta((String)HRMetaDataServiceHelper.getFormMetaId(entityNum, bizAppId), (MetaCategory)MetaCategory.Entity);
        return abstractMetadata instanceof EntityMetadata ? (EntityMetadata)abstractMetadata : null;
    }

    public static MainEntity getMainEntity(String entityNum, String bizAppId) {
        EntityMetadata entityMetadata = HRMetaDataServiceHelper.getEntityMetadata(entityNum, bizAppId);
        return entityMetadata == null ? null : entityMetadata.getRootEntity();
    }

    public static QueryEntity getQueryEntity(String entityNum, String bizAppId) {
        MainEntity mainEntity = HRMetaDataServiceHelper.getMainEntity(entityNum, bizAppId);
        return mainEntity instanceof QueryEntity ? (QueryEntity)mainEntity : null;
    }

    public static List<QuerySelectField> listQuerySelectField(String entityNum, String bizAppId) {
        QueryEntity queryEntity = HRMetaDataServiceHelper.getQueryEntity(entityNum, bizAppId);
        return queryEntity == null ? Lists.newArrayListWithExpectedSize((int)16) : queryEntity.getSelectFields();
    }
}

