/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper.org;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.constants.org.OrgTreeSearchParam;
import kd.hr.hbp.common.constants.org.TreeTemplateConstants;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;

public class TreeTemplateHelper {
    protected static final Log logger = LogFactory.getLog(TreeTemplateHelper.class);
    private static final String OT_TREE_FOCUS_KEY = "ot_tree_focus_key";

    public static DynamicObject getCurTreeRootNodeDynamicObj(String structEntityName, String selectFields, QFilter permFilter, QFilter commonFilter) {
        return TreeTemplateHelper.getCurTreeRootNodeDynamicObj(structEntityName, selectFields, permFilter, commonFilter, commonFilter);
    }

    public static DynamicObject getCurTreeRootNodeDynamicObj(String structEntityName, String selectFields, QFilter permFilter, QFilter treeBizFilter, QFilter commonFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityName);
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray(selectFields, new QFilter[]{permFilter, treeBizFilter});
        if (null == dynamicObjects || 1 > dynamicObjects.length) {
            return null;
        }
        if (1 == dynamicObjects.length) {
            return dynamicObjects[0];
        }
        String commonParentStructLongNumber = TreeTemplateHelper.getParentOrgStructLongNumberByOrgArray(dynamicObjects);
        QFilter[] filters = new QFilter[]{new QFilter("structlongnumber", "=", (Object)commonParentStructLongNumber), commonFilter};
        return serviceHelper.queryOriginalOne(selectFields, filters);
    }

    public static DynamicObject getCurOrgTeamTreeRootNodeDyn(String structEntityName, String selectFields, QFilter treeBizFilter, QFilter commonFilter) {
        Object dyn;
        String otClassify;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityName);
        String queryFields = "id,orgteam.boid boid,structlongnumber,orgteam.otclassify.id otclassify";
        Object[] dynArr = serviceHelper.queryOriginalArray(queryFields, new QFilter[]{treeBizFilter, commonFilter});
        if (ObjectUtils.isEmpty((Object[])dynArr)) {
            return null;
        }
        if (1 == dynArr.length && "1010".equals(otClassify = (dyn = dynArr[0]).getString("otclassify"))) {
            return serviceHelper.queryOriginalOne(selectFields, dyn.getLong("id"));
        }
        String commonPrefixLongNumber = TreeTemplateHelper.getParentOrgStructLongNumberByOrgArray((DynamicObject[])dynArr);
        if (commonPrefixLongNumber.length() == TreeTemplateConstants.TWO_LONG_NUMBER_LENGTH.intValue()) {
            QFilter longNumberFilter = new QFilter("structlongnumber", "=", (Object)commonPrefixLongNumber);
            return serviceHelper.queryOriginalOne(selectFields, new QFilter[]{longNumberFilter, commonFilter});
        }
        List<String> structNumberList = Arrays.asList(commonPrefixLongNumber.split("!"));
        DynamicObjectCollection dynCol = serviceHelper.queryOriginalCollection(queryFields, new QFilter[]{new QFilter("orgteam.structnumber", "in", structNumberList), commonFilter}, null);
        if (!ObjectUtils.isEmpty((Object)dynCol)) {
            dynCol.sort(Comparator.comparing(o -> o.getString("structlongnumber").length()));
        }
        String commonPrefixLongNumberNew = null;
        for (int i = dynCol.size() - 1; i >= 0; --i) {
            DynamicObject dyn2 = (DynamicObject)dynCol.get(i);
            String otClassify2 = dyn2.getString("otclassify");
            if (!"1010".equals(otClassify2)) continue;
            commonPrefixLongNumberNew = dyn2.getString("structlongnumber");
            break;
        }
        QFilter[] filters = new QFilter[]{new QFilter("structlongnumber", "=", commonPrefixLongNumberNew), commonFilter};
        return serviceHelper.queryOriginalOne(selectFields, filters);
    }

    public static QFilter getAllPermissionStructNumbers(String currentStructLongNumber, String entityName, QFilter orgEnableFilter, QFilter dataStatusAndBsedFilter, String subStructNumberProperty) {
        List<String> allPermissionStructLongNumbers = TreeTemplateHelper.getAllPermissionStructLongNumbers(entityName, orgEnableFilter, dataStatusAndBsedFilter);
        List<String> subStructNumbers = OrgTreeUtils.getSubStructNumbers(currentStructLongNumber, allPermissionStructLongNumbers, false);
        return new QFilter(subStructNumberProperty, "in", subStructNumbers);
    }

    public static List<String> getAllPermissionStructLongNumbers(String entityName, QFilter orgEnableFilter, QFilter dataStatusAndBsedFilter) {
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance(entityName).queryColl("structlongnumber", new QFilter[]{orgEnableFilter, dataStatusAndBsedFilter}, null);
        return collection.stream().map(dynamicObject -> dynamicObject.getString("structlongnumber")).collect(Collectors.toList());
    }

    public static List<String> getAllPermissionStructLongNumbers(String entityName, QFilter[] qFilters, String orderBys) {
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance(entityName).queryColl("structlongnumber", qFilters, orderBys);
        return collection.stream().map(dynamicObject -> dynamicObject.getString("structlongnumber")).collect(Collectors.toList());
    }

    public static List<String> getPermissionStructLongNumbersWithSub(AuthorizedOrgResultWithSub permissionModel, String entityName, QFilter orgTreeFilter, String orgIdProperty, String orderBys) {
        QFilter likeQFilter = TreeTemplateHelper.getPermStructLongNumberFilter(permissionModel, orgIdProperty);
        if (likeQFilter == null) {
            return new ArrayList<String>();
        }
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance(entityName).queryColl("structlongnumber", new QFilter[]{orgTreeFilter, likeQFilter}, orderBys);
        return collection.stream().map(dynamicObject -> dynamicObject.getString("structlongnumber")).collect(Collectors.toList());
    }

    public static List<String> getPermStructLongNumberWithSubInOrgTeam(AuthorizedOrgResultWithSub permissionModel, String entityName, QFilter orgTreeFilter, QFilter otTreeFocusFilter, String orgIdProperty, Set<Long> leafTreeOtClass) {
        QFilter likeQFilter = TreeTemplateHelper.getPermStructLongNumberFilter(permissionModel, orgIdProperty);
        if (likeQFilter == null) {
            return new ArrayList<String>();
        }
        String selectFiled = String.join((CharSequence)",", "orgteam.structnumber", "structlongnumber", "orgteam.id");
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance(entityName).queryColl(selectFiled, new QFilter[]{orgTreeFilter, likeQFilter}, null);
        return TreeTemplateHelper.getTreeOrgTypeStructLongNumber(entityName, collection, leafTreeOtClass, otTreeFocusFilter);
    }

    public static QFilter getPermStructLongNumberFilter(AuthorizedOrgResultWithSub permissionModel, String orgIdProperty) {
        ArrayList orgIdWithOutSub = Lists.newArrayList();
        AtomicReference<QFilter> structLongNumberFilters = new AtomicReference<QFilter>();
        TreeTemplateHelper.assemblyStructLongNumberFilterInPerm(permissionModel, orgIdWithOutSub, structLongNumberFilters);
        QFilter orgIdWithOutSubFilter = TreeTemplateHelper.getOrgIdWithSubFilter(orgIdWithOutSub, orgIdProperty);
        QFilter likeQFilter = structLongNumberFilters.get();
        if (likeQFilter == null && orgIdWithOutSubFilter != null) {
            likeQFilter = orgIdWithOutSubFilter;
        } else if (likeQFilter != null && orgIdWithOutSubFilter != null) {
            likeQFilter.or(orgIdWithOutSubFilter);
        }
        return likeQFilter;
    }

    public static QFilter getOrgIdWithSubFilter(List<Long> orgIdWithOutSub, String orgIdProperty) {
        if (!CollectionUtils.isEmpty(orgIdWithOutSub)) {
            return new QFilter(orgIdProperty, "in", orgIdWithOutSub);
        }
        return null;
    }

    public static void assemblyStructLongNumberFilterInPerm(AuthorizedOrgResultWithSub permissionModel, List<Long> orgIdWithOutSub, AtomicReference<QFilter> structLongNumberFilters) {
        List permOrgWithSub = permissionModel.getHasPermOrgsWithSub();
        permOrgWithSub.forEach(adminOrg -> TreeTemplateHelper.getPermStructLongNumberLikeAndOutSub(orgIdWithOutSub, structLongNumberFilters, adminOrg));
    }

    public static void getPermStructLongNumberLikeAndOutSub(List<Long> orgIdWithOutSub, AtomicReference<QFilter> structLongNumberFilters, OrgSubInfo orgSubInfo) {
        String longStructNumber = orgSubInfo.getLongStructNumber();
        if (orgSubInfo.isContainsSub()) {
            QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(longStructNumber + "%"));
            if (null == structLongNumberFilters.get()) {
                structLongNumberFilters.set(structLongNumberFilter);
            } else {
                structLongNumberFilters.get().or(structLongNumberFilter);
            }
        } else {
            orgIdWithOutSub.add(orgSubInfo.getOrgId());
        }
    }

    public static QFilter getOrgAndSubInPermFilter(AuthorizedOrgResultWithSub permissionModel, String orgIdProperty) {
        ArrayList orgIdWithOutSub = Lists.newArrayList();
        AtomicReference<QFilter> structLongNumberFilters = new AtomicReference<QFilter>();
        TreeTemplateHelper.assemblyStructLongNumberFilterInPerm(permissionModel, orgIdWithOutSub, structLongNumberFilters);
        QFilter structLongNumberFilter = structLongNumberFilters.get();
        if (ObjectUtils.isEmpty((Object)structLongNumberFilters.get()) && !CollectionUtils.isEmpty((Collection)orgIdWithOutSub)) {
            return new QFilter(orgIdProperty, "in", (Object)orgIdWithOutSub);
        }
        if (!ObjectUtils.isEmpty((Object)structLongNumberFilters.get()) && !CollectionUtils.isEmpty((Collection)orgIdWithOutSub)) {
            return structLongNumberFilter.or(new QFilter(orgIdProperty, "in", (Object)orgIdWithOutSub));
        }
        return structLongNumberFilter;
    }

    public static List<String> getOrgStructLongNumberByPermOrg(OrgTreeModel orgTreeModel, QFilter orgTreeFilter, AuthorizedOrgResultWithSub permissionModel, String orgIdProperty, String orderBys) {
        String entityName = orgTreeModel.getEntityName();
        if (permissionModel.isHasAllOrgPerm()) {
            return TreeTemplateHelper.getAllPermissionStructLongNumbers(entityName, new QFilter[]{orgTreeFilter}, orderBys);
        }
        return TreeTemplateHelper.getPermissionStructLongNumbersWithSub(permissionModel, entityName, orgTreeFilter, orgIdProperty, orderBys);
    }

    public static String getParentOrgStructLongNumberByOrgArray(DynamicObject[] adminStructDyObjs) {
        HashSet<String> structLongNumSet = new HashSet<String>(4);
        for (DynamicObject adminStructDy : adminStructDyObjs) {
            structLongNumSet.add(adminStructDy.getString("structlongnumber"));
        }
        return OrgTreeUtils.getCommonPrefixStructLongNumber(new ArrayList<String>(structLongNumSet));
    }

    public static void encapsulateRootOrgTeamNode(TreeNode rootNode, DynamicObject dyn, OrgTreeModel orgTreeModel) {
        String nodeIdKey = orgTreeModel.getNodeIdKey();
        String nodeTextKey = orgTreeModel.getNodeTextKey();
        rootNode.setId(dyn.getString(StringUtils.isEmpty((CharSequence)nodeIdKey) ? "id" : nodeIdKey));
        rootNode.setText(dyn.getString(StringUtils.isEmpty((CharSequence)nodeTextKey) ? "name" : nodeTextKey));
        rootNode.setLongNumber(dyn.getString("structlongnumber"));
        rootNode.setIsOpened(true);
        rootNode.setChildren(new ArrayList(16));
        rootNode.setData((Object)dyn.getString("boid"));
    }

    public static DynamicObject getHisTreeRootMainDynByRootId(OrgTreeModel orgTreeModel, QFilter currentVersionVal) {
        String mainEntityFields = "id, name, boid";
        return TreeTemplateHelper.getHisTreeMainDynByBoid(mainEntityFields, orgTreeModel.getMainEntityName(), OrgServiceUtil.getAdminRootOrgId(), currentVersionVal);
    }

    public static DynamicObject getHisTreeRootMainDynByRootId(OrgTreeModel orgTreeModel, QFilter currentVersionVal, long rootId) {
        String mainEntityFields = "id, name, boid";
        return TreeTemplateHelper.getHisTreeMainDynByBoid(mainEntityFields, orgTreeModel.getMainEntityName(), rootId, currentVersionVal);
    }

    public static DynamicObject getHisTreeMainDynByBoid(String mainEntityFields, String mainEntityName, Long boId, QFilter hisFilter) {
        QFilter mainFilter = new QFilter("boid", "=", (Object)boId);
        return HRBaseDaoFactory.getInstance(mainEntityName).queryOriginalOne(mainEntityFields, new QFilter[]{mainFilter.and(hisFilter)});
    }

    public static DynamicObject getHisTreeRootStructDynByRootId(String structEntityFields, String idFilterProperty, OrgTreeModel orgTreeModel, String currentVersionVal) {
        QFilter structFilter = new QFilter(idFilterProperty, "=", (Object)OrgServiceUtil.getAdminRootOrgId());
        structFilter.and("iscurrentversion", "=", (Object)currentVersionVal);
        DynamicObject structEntityInfo = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryOriginalOne(structEntityFields, new QFilter[]{structFilter});
        return structEntityInfo;
    }

    public static DynamicObject getHisTreeRootDynInPerm(String structEntityFields, String mainEntityFields, OrgTreeModel orgTreeModel, QFilter structLongNumberFilter, QFilter structFilter, QFilter orgFilter) {
        DynamicObjectCollection structDyns = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl(structEntityFields, new QFilter[]{structLongNumberFilter, structFilter}, null);
        if (null == structDyns || structDyns.size() == 0) {
            return null;
        }
        ArrayList<String> structLongNumberList = new ArrayList<String>(16);
        HashMap structIdLongNUmberMap = new HashMap(16);
        structDyns.forEach(dyn -> {
            String structLongNumber = dyn.getString("structlongnumber");
            structLongNumberList.add(structLongNumber);
            structIdLongNUmberMap.put(structLongNumber, dyn);
        });
        String commonPrefixStructLongNumber = OrgTreeUtils.getCommonPrefixStructLongNumber(structLongNumberList);
        if (HRStringUtils.isEmpty((String)commonPrefixStructLongNumber)) {
            return null;
        }
        DynamicObject rootNodeStructHisDyn = (DynamicObject)structIdLongNUmberMap.get(commonPrefixStructLongNumber);
        Long rootNodeBoId = null;
        if (null == rootNodeStructHisDyn) {
            structLongNumberFilter = new QFilter("structlongnumber", "in", (Object)commonPrefixStructLongNumber);
            DynamicObjectCollection dynamicObjects = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl(structEntityFields, new QFilter[]{structLongNumberFilter, structFilter}, null);
            if (!ObjectUtils.isEmpty((Object)dynamicObjects)) {
                rootNodeStructHisDyn = (DynamicObject)dynamicObjects.get(0);
                rootNodeBoId = rootNodeStructHisDyn.getLong("id");
            }
        } else {
            rootNodeBoId = rootNodeStructHisDyn.getLong("boid");
        }
        DynamicObject hisMainTreeDyn = TreeTemplateHelper.getHisTreeMainDynByBoid(mainEntityFields, orgTreeModel.getMainEntityName(), rootNodeBoId, orgFilter);
        if (null != rootNodeStructHisDyn && hisMainTreeDyn != null) {
            rootNodeStructHisDyn.set("id", hisMainTreeDyn.get("id"));
            rootNodeStructHisDyn.set("name", hisMainTreeDyn.get("name"));
        }
        return rootNodeStructHisDyn;
    }

    public static String getStructLongNumberByBoId(Long adminOrgId, String entityName, QFilter dataStatusAndBSedFilter, QFilter adminOrgEnableFilter, String filterProperty) {
        DynamicObject dyn = HRBaseDaoFactory.getInstance(entityName).queryOne("structlongnumber", new QFilter[]{new QFilter(filterProperty, "=", (Object)adminOrgId), dataStatusAndBSedFilter, adminOrgEnableFilter});
        if (dyn != null) {
            return dyn.getString("structlongnumber");
        }
        return null;
    }

    public static String getHisStructLongNumberByBoId(String boIdStr, QFilter dataStatusAndBSedFilter, QFilter adminOrgEnableFilter, String hisMainBoIdFilterProperty, OrgTreeModel orgTreeModel) {
        QFilter adminOrgFilter = new QFilter("id", "=", (Object)Long.parseLong(boIdStr));
        QFilter[] hisMainFilter = new QFilter[]{adminOrgFilter, dataStatusAndBSedFilter, adminOrgEnableFilter};
        DynamicObject mainEntityInfo = HRBaseDaoFactory.getInstance(orgTreeModel.getMainEntityName()).queryOne("id, boid", hisMainFilter);
        if (null == mainEntityInfo) {
            return null;
        }
        QFilter hisMainBoIdFilter = new QFilter(hisMainBoIdFilterProperty, "=", mainEntityInfo.get("boid"));
        DynamicObject structEntityInfo = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryOne("structlongnumber", new QFilter[]{hisMainBoIdFilter, dataStatusAndBSedFilter, adminOrgEnableFilter});
        return structEntityInfo.getString("structlongnumber");
    }

    public static void lazyCurTreeNodeChildren(DynamicObjectCollection structDynCols, OrgTreeSearchParam searchParam, TreeNode node, String nodeIdPropertyName, String parentIdPropertyName) {
        TreeView treeView = searchParam.getTreeView();
        TreeNode parentNode = searchParam.getRootNode();
        for (DynamicObject dynamicObject : structDynCols) {
            String orgId = dynamicObject.getString(nodeIdPropertyName);
            if ((parentNode = OrgTreeUtils.getNode(parentNode, orgId)) != null && !ObjectUtils.isEmpty((Object)parentNode.getChildren()) && !node.getParentid().equals(orgId)) continue;
            String parentId = dynamicObject.getString(parentIdPropertyName);
            treeView.queryTreeNodeChildren(parentId, orgId);
        }
    }

    public static void lazyHisTreeNodeChildren(DynamicObjectCollection dynCol, OrgTreeSearchParam searchParam, TreeNode node, String parentKey) {
        TreeView treeView = searchParam.getTreeView();
        TreeNode parentNode = searchParam.getRootNode();
        for (DynamicObject dynamicObject : dynCol) {
            String nodeId = dynamicObject.getString("id");
            if ((parentNode = OrgTreeUtils.getNode(parentNode, nodeId)) != null && !ObjectUtils.isEmpty((Object)parentNode.getChildren()) && !node.getParentid().equals(nodeId)) continue;
            String parentId = dynamicObject.getString(parentKey);
            treeView.queryTreeNodeChildren(parentId, nodeId);
        }
    }

    public static void assemblyCurTreeSearchNodes(List<TreeNode> treeNodes, String entityName, String selectFields, String parentProperty, QFilter[] filters, String orderBy) {
        DynamicObjectCollection dynamicObjects = HRBaseDaoFactory.getInstance(entityName).queryColl(selectFields, filters, null);
        if (dynamicObjects == null) {
            return;
        }
        OrgTreeUtils.sortDynColsOrderBys(dynamicObjects, orderBy);
        dynamicObjects.forEach(dynamicObject -> {
            String orgId = dynamicObject.getString("id");
            TreeNode treeNode = new TreeNode(dynamicObject.getString(parentProperty), orgId, dynamicObject.getString("name"));
            treeNode.setLongNumber(dynamicObject.getString("structlongnumber"));
            treeNode.setData((Object)dynamicObject.getString("boid"));
            treeNodes.add(treeNode);
        });
    }

    public static void assemblyCurTreeSearchNodes(List<TreeNode> treeNodes, String entityName, OrgTreeModel orgTreeModel, String selectFields, String parentProperty, QFilter[] filters, String orderBy) {
        DynamicObjectCollection orgDynCol = HRBaseDaoFactory.getInstance(entityName).queryColl(selectFields, filters, null);
        if (orgDynCol == null) {
            return;
        }
        OrgTreeUtils.sortDynColsOrderBys(orgDynCol, orderBy);
        boolean isResetId = false;
        if (orgTreeModel.isHisTree() && orgTreeModel.isCurNowDate()) {
            isResetId = true;
        }
        for (DynamicObject dyn : orgDynCol) {
            String orgId = dyn.getString("id");
            if (isResetId) {
                orgId = dyn.getString("sourcevid");
            }
            TreeNode treeNode = new TreeNode(dyn.getString(parentProperty), orgId, dyn.getString("name"));
            treeNode.setLongNumber(dyn.getString("structlongnumber"));
            treeNode.setData((Object)dyn.getString("boid"));
            treeNodes.add(treeNode);
        }
    }

    public static Map<Long, DynamicObject> getHisMainDynMap(String structEntityName, String mainEntityFields, QFilter[] filters) {
        DynamicObjectCollection hisMainDynCol = HRBaseDaoFactory.getInstance(structEntityName).queryColl(mainEntityFields, filters, null);
        if (hisMainDynCol == null) {
            return new HashMap<Long, DynamicObject>();
        }
        return hisMainDynCol.stream().collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn, (k1, k2) -> k1));
    }

    public static DynamicObject getMainDynByVidAndCommonFilter(String mainEntityName, QFilter orgEnableFilter, QFilter dataStatusAndBSedFilter, Long vid) {
        String selectFields = "id,boid";
        QFilter boIdFilter = new QFilter("id", "=", (Object)vid);
        DynamicObject structDyn = HRBaseDaoFactory.getInstance(mainEntityName).queryOriginalOne(selectFields, new QFilter[]{boIdFilter, orgEnableFilter, dataStatusAndBSedFilter});
        return structDyn;
    }

    public static Map<Long, DynamicObject> getHisMainOrgMap(Set<Long> orgBoIdSet, QFilter orgEnableFilter, QFilter dataStatusAndBSedFilter, OrgTreeModel orgTreeModel) {
        String selectProperties = "id, name, boid, enable";
        DynamicObjectCollection hisMainDyns = TreeTemplateHelper.getHisMainOrgDynCol(orgBoIdSet, selectProperties, orgEnableFilter, dataStatusAndBSedFilter, orgTreeModel);
        return hisMainDyns.stream().collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn, (k1, k2) -> k1));
    }

    private static DynamicObjectCollection getHisMainOrgDynCol(Set<Long> orgBoIdSet, String selectProperties, QFilter orgEnableFilter, QFilter dataStatusAndBSedFilter, OrgTreeModel orgTreeModel) {
        QFilter mainFilter = new QFilter("boid", "in", orgBoIdSet);
        QFilter[] filters = new QFilter[]{mainFilter, orgEnableFilter, dataStatusAndBSedFilter};
        return HRBaseDaoFactory.getInstance(orgTreeModel.getMainEntityName()).queryColl(selectProperties, filters, null);
    }

    public static List<Long> getAllOrgBoId(ITreeModel treeModel, OrgTreeModel orgTreeModel, AuthorizedOrgResultWithSub permOrgResultWithSub, Map<String, Boolean> orgSubStructLongNumberPermMap, QFilter orgTreeFilter, String orgIdProperty, boolean isDefDirectlySubOrg, String dynParentProperty) {
        logger.info("TreeTemplateHelper.getAllOrgBoId start, orgTreeModel={}, orgTreeFilter={}, orgIdProperty={}", (Object)SerializationUtils.toJsonString((Object)orgTreeModel), (Object)SerializationUtils.toJsonString((Object)orgTreeFilter));
        long startTime = System.currentTimeMillis();
        ArrayList<Long> list = new ArrayList<Long>(16);
        Object currentNodeId = treeModel.getCurrentNodeId();
        if (currentNodeId == null) {
            return list;
        }
        String curNodeIdStr = currentNodeId.toString();
        TreeNode treeNode = OrgTreeUtils.getNode(treeModel.getRoot(), curNodeIdStr);
        if (treeNode == null) {
            logger.info("TreeTemplateHelper.getAllOrgBoId, rootNode is null");
            return list;
        }
        if (treeNode.getData() == null) {
            logger.info("TreeTemplateHelper.getAllOrgBoId, treeNode.getData() is null,treeNode={}", (Object)SerializationUtils.toJsonString((Object)treeNode));
            return list;
        }
        long orgBoId = Long.parseLong(treeNode.getData().toString());
        String curLongNumber = treeNode.getLongNumber();
        if (!orgTreeModel.isIncludeChild()) {
            return TreeTemplateHelper.getNotIncludeChildIdList(orgTreeModel, permOrgResultWithSub, orgSubStructLongNumberPermMap, treeNode, orgTreeFilter, orgIdProperty, isDefDirectlySubOrg, dynParentProperty);
        }
        logger.info("TreeTemplateHelper.getAllOrgBoId,orgBoId={}, curLongNumber={}", (Object)orgBoId, (Object)curLongNumber);
        if (!orgTreeModel.isFilterTreePerm() || permOrgResultWithSub.isHasAllOrgPerm()) {
            return TreeTemplateHelper.getHasAllOrgPerm(orgTreeModel, orgTreeFilter, orgIdProperty, list, orgBoId, curLongNumber);
        }
        return TreeTemplateHelper.getHasOrgPermId(orgTreeModel, permOrgResultWithSub, orgTreeFilter, orgIdProperty, startTime, curLongNumber);
    }

    public static List<Long> getAllOrgTeamBoId(ITreeModel treeModel, OrgTreeModel orgTreeModel, AuthorizedOrgTeamResult permOrgTeamResult, Set<Long> hasPermOrgTeamIdSet, QFilter orgTreeFilter, boolean isDefDirectlySubOrg, String dynParentProperty, List<Long> orgTreeListClassify) {
        logger.info("TreeTemplateHelper.getAllOrgTeamBoId start, orgTreeModel={}, orgTreeFilter={}, orgIdProperty={}", (Object)SerializationUtils.toJsonString((Object)orgTreeModel), (Object)SerializationUtils.toJsonString((Object)orgTreeFilter));
        long startTime = System.currentTimeMillis();
        ArrayList<Long> list = new ArrayList<Long>(16);
        Object currentNodeId = treeModel.getCurrentNodeId();
        if (currentNodeId == null) {
            return list;
        }
        String curNodeIdStr = currentNodeId.toString();
        TreeNode treeNode = OrgTreeUtils.getNode(treeModel.getRoot(), curNodeIdStr);
        if (treeNode == null) {
            logger.info("TreeTemplateHelper.getAllOrgTeamBoId, rootNode is null");
            return list;
        }
        if (treeNode.getData() == null) {
            logger.info("TreeTemplateHelper.getAllOrgTeamBoId, treeNode.getData() is null,treeNode={}", (Object)SerializationUtils.toJsonString((Object)treeNode));
            return list;
        }
        long orgBoId = Long.parseLong(treeNode.getData().toString());
        String curLongNumber = treeNode.getLongNumber();
        logger.info("getNotIncludeChildOrgTeamId,orgBoId={}", (Object)orgBoId);
        DynamicObject cunMainDyn = HRBaseDaoFactory.getInstance(orgTreeModel.getMainEntityName()).queryOne("otclassify.id", orgBoId);
        if (cunMainDyn != null) {
            orgTreeModel.setCurTreeOtClassify(Long.valueOf(cunMainDyn.getLong("otclassify.id")));
        }
        if (!orgTreeModel.isIncludeChild()) {
            return TreeTemplateHelper.getNotIncludeChildOrgTeamId(orgTreeModel, permOrgTeamResult, hasPermOrgTeamIdSet, treeNode, orgTreeFilter, isDefDirectlySubOrg, dynParentProperty, orgTreeListClassify);
        }
        logger.info("TreeTemplateHelper.getAllOrgTeamBoId,orgBoId={}, curLongNumber={}", (Object)orgBoId, (Object)curLongNumber);
        orgTreeFilter.and(new QFilter("orgteam.otclassify", "in", (Object)orgTreeModel.getListOtClassify()));
        if (!orgTreeModel.isFilterTreePerm() || permOrgTeamResult.isHasAllOrgPerm()) {
            return TreeTemplateHelper.getHasAllOrgTeamPerm(orgTreeModel, orgTreeFilter, "orgteam.boid", list, orgBoId, curLongNumber, orgTreeListClassify);
        }
        return TreeTemplateHelper.getHasOrgPermOrgTeamId(orgTreeModel, hasPermOrgTeamIdSet, orgTreeFilter, startTime, curLongNumber, orgTreeListClassify);
    }

    private static List<Long> getNotIncludeChildIdList(OrgTreeModel orgTreeModel, AuthorizedOrgResultWithSub permOrgResultWithSub, Map<String, Boolean> orgSubStructLongNumberPermMap, TreeNode treeNode, QFilter orgTreeFilter, String orgIdProperty, boolean isDefDirectlySubOrg, String dynParentProperty) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        Long orgBoId = Long.parseLong(treeNode.getData().toString());
        if (!orgTreeModel.isFilterTreePerm() || permOrgResultWithSub.isHasAllOrgPerm()) {
            list.add(orgBoId);
            if (!isDefDirectlySubOrg) {
                return list;
            }
            QFilter parentFilter = new QFilter(dynParentProperty, "=", (Object)orgBoId);
            DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl(orgIdProperty, new QFilter[]{parentFilter, orgTreeFilter}, null);
            List queryRetIdList = dynCol.stream().map(dyn -> dyn.getLong(orgIdProperty)).collect(Collectors.toList());
            list.addAll(queryRetIdList);
            return list;
        }
        if (orgSubStructLongNumberPermMap == null) {
            return list;
        }
        String curLongNumber = treeNode.getLongNumber();
        List<Long> retList = TreeTemplateHelper.getNotIncludeChildIdInPerm(orgSubStructLongNumberPermMap, list, orgBoId, curLongNumber);
        if (!isDefDirectlySubOrg) {
            return retList;
        }
        List<Long> retData = TreeTemplateHelper.getDefDirectlySubOrgList(orgTreeModel, permOrgResultWithSub, orgTreeFilter, orgIdProperty, dynParentProperty, orgBoId);
        retData.addAll(retList);
        return retData;
    }

    private static List<Long> getNotIncludeChildOrgTeamId(OrgTreeModel orgTreeModel, AuthorizedOrgTeamResult permOrgTeamResult, Set<Long> hasPermOrgTeamIdSet, TreeNode treeNode, QFilter orgTreeFilter, boolean isDefDirectlySubOrg, String dynParentProperty, List<Long> orgTreeListClassify) {
        Long orgBoId = Long.parseLong(treeNode.getData().toString());
        ArrayList<Long> list = new ArrayList<Long>(16);
        if (!orgTreeModel.isFilterTreePerm() || permOrgTeamResult.isHasAllOrgPerm()) {
            TreeTemplateHelper.addOrgBoId(orgTreeListClassify, orgBoId, orgTreeModel.getCurTreeOtClassify(), list);
            if (!isDefDirectlySubOrg) {
                return list;
            }
            QFilter parentFilter = new QFilter(dynParentProperty, "=", (Object)orgBoId);
            DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl("orgteam.boid", new QFilter[]{parentFilter, orgTreeFilter, TreeTemplateHelper.getOtClassifyFilter(orgTreeListClassify)}, null);
            List queryRetIdList = dynCol.stream().map(dyn -> dyn.getLong("orgteam.boid")).collect(Collectors.toList());
            list.addAll(queryRetIdList);
            return list;
        }
        if (hasPermOrgTeamIdSet.contains(orgBoId)) {
            TreeTemplateHelper.addOrgBoId(orgTreeListClassify, orgBoId, orgTreeModel.getCurTreeOtClassify(), list);
        }
        if (!isDefDirectlySubOrg) {
            return list;
        }
        List<Long> retData = TreeTemplateHelper.getDefDirectlySubOrgTeam(orgTreeModel, hasPermOrgTeamIdSet, orgTreeFilter, dynParentProperty, orgBoId, orgTreeListClassify);
        retData.addAll(list);
        return retData;
    }

    private static QFilter getOtClassifyFilter(List<Long> orgTeamTreeListClassify) {
        return new QFilter("orgteam.otclassify.id", "in", orgTeamTreeListClassify);
    }

    private static void addOrgBoId(List<Long> OrgTreeListClassify, Long orgBoId, Long curOtClassify, List<Long> list) {
        if (OrgTreeListClassify.contains(curOtClassify)) {
            list.add(orgBoId);
        }
    }

    private static List<Long> getHasOrgPermId(OrgTreeModel orgTreeModel, AuthorizedOrgResultWithSub permOrgResultWithSub, QFilter orgTreeFilter, String orgIdProperty, long startTime, String curLongNumber) {
        QFilter longNumberAndOrgIdFilterInPerm = TreeTemplateHelper.getOrgAndSubInPermFilter(permOrgResultWithSub, orgIdProperty);
        longNumberAndOrgIdFilterInPerm = TreeTemplateHelper.andLikeLongNumberFilter(longNumberAndOrgIdFilterInPerm, curLongNumber);
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl(orgIdProperty, new QFilter[]{longNumberAndOrgIdFilterInPerm, orgTreeFilter}, null);
        if (dynCol == null) {
            return Lists.newArrayList();
        }
        List<Long> retData = dynCol.stream().map(dyn -> dyn.getLong(orgIdProperty)).collect(Collectors.toList());
        logger.info("TreeTemplateHelper.getAllOrgBoId end, cost={}ms,retData.size={}", (Object)(System.currentTimeMillis() - startTime), retData);
        return retData;
    }

    private static QFilter andLikeLongNumberFilter(QFilter filter, String curLongNumber) {
        if (filter == null) {
            return new QFilter("structlongnumber", "like", (Object)(curLongNumber + "%"));
        }
        return filter.and(new QFilter("structlongnumber", "like", (Object)(curLongNumber + "%")));
    }

    private static List<Long> getHasOrgPermOrgTeamId(OrgTreeModel orgTreeModel, Set<Long> hasPermOrgTeamIdSet, QFilter orgTreeFilter, long startTime, String curLongNumber, List<Long> orgTreeListClassify) {
        QFilter orgTeamFilter = new QFilter("orgteam.boid", "in", hasPermOrgTeamIdSet);
        orgTeamFilter = TreeTemplateHelper.andLikeLongNumberFilter(orgTeamFilter, curLongNumber);
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl("orgteam.boid", new QFilter[]{orgTeamFilter, orgTreeFilter, TreeTemplateHelper.getOtClassifyFilter(orgTreeListClassify)}, null);
        if (dynCol == null) {
            return Lists.newArrayList();
        }
        List<Long> retData = dynCol.stream().map(dyn -> dyn.getLong("orgteam.boid")).collect(Collectors.toList());
        logger.info("TreeTemplateHelper.getHasOrgPermOrgTeamId end, cost={}ms,retData.size={}", (Object)(System.currentTimeMillis() - startTime), retData);
        return retData;
    }

    private static List<Long> getNotIncludeChildIdInPerm(Map<String, Boolean> orgSubStructLongNumberPermMap, List<Long> list, long orgBoId, String curLongNumber) {
        if (orgSubStructLongNumberPermMap.get(curLongNumber) != null) {
            list.add(orgBoId);
            return list;
        }
        for (Map.Entry<String, Boolean> entry : orgSubStructLongNumberPermMap.entrySet()) {
            String structLongNumber = entry.getKey();
            Boolean isContainSub = entry.getValue();
            if (!curLongNumber.startsWith(structLongNumber) || !isContainSub.booleanValue()) continue;
            list.add(orgBoId);
            break;
        }
        return list;
    }

    private static List<Long> getDefDirectlySubOrgList(OrgTreeModel orgTreeModel, AuthorizedOrgResultWithSub permOrgResultWithSub, QFilter orgTreeFilter, String orgIdProperty, String dynParentProperty, long orgBoId) {
        QFilter longNumberAndOrgIdFilterInPerm = TreeTemplateHelper.getOrgAndSubInPermFilter(permOrgResultWithSub, orgIdProperty);
        longNumberAndOrgIdFilterInPerm.and(new QFilter(dynParentProperty, "=", (Object)orgBoId));
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl(orgIdProperty, new QFilter[]{longNumberAndOrgIdFilterInPerm, orgTreeFilter}, null);
        List<Long> retData = dynCol.stream().map(dyn -> dyn.getLong(orgIdProperty)).collect(Collectors.toList());
        return retData;
    }

    private static List<Long> getDefDirectlySubOrgTeam(OrgTreeModel orgTreeModel, Set<Long> hasPermOrgTeamIdSet, QFilter orgTreeFilter, String dynParentProperty, long orgBoId, List<Long> orgTreeListClassify) {
        QFilter orgTeamFilter = new QFilter("orgteam.boid", "in", hasPermOrgTeamIdSet);
        orgTeamFilter.and(new QFilter(dynParentProperty, "=", (Object)orgBoId));
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl("orgteam.boid", new QFilter[]{orgTeamFilter, orgTreeFilter, TreeTemplateHelper.getOtClassifyFilter(orgTreeListClassify)}, null);
        List<Long> retData = dynCol.stream().map(dyn -> dyn.getLong("orgteam.boid")).collect(Collectors.toList());
        return retData;
    }

    private static List<Long> getHasAllOrgTeamPerm(OrgTreeModel orgTreeModel, QFilter orgTreeFilter, String orgIdProperty, List<Long> list, long orgBoId, String curLongNumber, List<Long> orgTreeListClassify) {
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(curLongNumber + "%"));
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl(orgIdProperty, new QFilter[]{structLongNumberFilter, orgTreeFilter, TreeTemplateHelper.getOtClassifyFilter(orgTreeListClassify)}, null);
        if (dynCol == null) {
            return list;
        }
        return dynCol.stream().map(dyn -> dyn.getLong(orgIdProperty)).collect(Collectors.toList());
    }

    private static List<Long> getHasAllOrgPerm(OrgTreeModel orgTreeModel, QFilter orgTreeFilter, String orgIdProperty, List<Long> list, long orgBoId, String curLongNumber) {
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(curLongNumber + "%"));
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryColl(orgIdProperty, new QFilter[]{structLongNumberFilter, orgTreeFilter}, null);
        if (dynCol == null) {
            list.add(orgBoId);
            return list;
        }
        return dynCol.stream().map(dyn -> dyn.getLong(orgIdProperty)).collect(Collectors.toList());
    }

    public static DynamicObjectCollection getHisAdminOrgDynCol(StringBuilder sqlStr, List<Object> paramList, String algoKey) {
        DynamicObjectCollection retDynCol;
        logger.info("AdminOrgTreeListTemplate.getHisAdminOrgDynCol begin, algoKey={}, paramList={}", (Object)algoKey, (Object)SerializationUtils.toJsonString(paramList));
        long startTime = System.currentTimeMillis();
        ORM orm = ORM.create();
        try (DataSet rs = HRDBUtil.queryDataSet((String)algoKey, (DBRoute)new DBRoute("hr"), (String)sqlStr.toString(), (Object[])paramList.toArray());){
            retDynCol = orm.toPlainDynamicObjectCollection(rs);
        }
        logger.info("AdminOrgTreeListTemplate.getHisAdminOrgDynCol end, cost={} ms,retDynCol.size={}", (Object)(System.currentTimeMillis() - startTime), (Object)retDynCol.size());
        return retDynCol;
    }

    public static List<String> getTreeOrgTypeStructLongNumber(String entityName, DynamicObjectCollection structDynCol, Set<Long> leafTreeOtClassify, QFilter otTreeFocusFilter) {
        List<String> retList;
        logger.info("getTreeOrgTypeStructLongNumber, structDynCol.size={}", (Object)structDynCol.size());
        if (leafTreeOtClassify == null || leafTreeOtClassify.size() == 0) {
            return structDynCol.stream().map(dyn -> dyn.getString("structlongnumber")).collect(Collectors.toList());
        }
        if (leafTreeOtClassify.size() == 1) {
            HashSet structNumberSet = new HashSet(structDynCol.size());
            HashSet curLongNumberSet = new HashSet(structDynCol.size());
            structDynCol.forEach(dyn -> {
                String longNumber = dyn.getString("structlongnumber");
                int endIdx = longNumber.lastIndexOf("!");
                String newLongNumber = longNumber.substring(0, endIdx);
                String[] split = newLongNumber.split("!");
                Collections.addAll(structNumberSet, split);
                curLongNumberSet.add(longNumber);
            });
            QFilter structNumberFilter = new QFilter("orgteam.structnumber", "in", structNumberSet);
            String selectFiled = String.join((CharSequence)",", "structlongnumber", "orgteam.id");
            DynamicObjectCollection structLNBDynCol = HRBaseDaoFactory.getInstance(entityName).queryColl(selectFiled, new QFilter[]{structNumberFilter, otTreeFocusFilter}, null);
            Set longNumberSet = structLNBDynCol.stream().map(dyn -> dyn.getString("structlongnumber")).collect(Collectors.toSet());
            longNumberSet.addAll(curLongNumberSet);
            retList = new ArrayList(longNumberSet);
        } else {
            retList = structDynCol.stream().map(dyn -> dyn.getString("structlongnumber")).collect(Collectors.toList());
        }
        logger.info("getTreeOrgTypeStructLongNumber, retList.size={}", (Object)retList.size());
        return retList;
    }

    public static QFilter getOTClassifyFilter(QFilter dataStatusAndBSedFilter, QFilter orgEnableFilter, List<Long> otTreeFocusList) {
        QFilter filter = dataStatusAndBSedFilter;
        HashSet<Long> otTreeFocus = new HashSet<Long>(otTreeFocusList);
        filter.and(orgEnableFilter).and(new QFilter("orgteam.otclassify", "in", otTreeFocus));
        return filter;
    }

    public static void removeRootAndStructLongNumberCache(IPageCache pageCache) {
        pageCache.remove("all_struct_long_number_in_perm");
        pageCache.remove("org_root_node");
        pageCache.remove("all_struct_long_number");
        pageCache.remove("perm_org_result_withsub");
        pageCache.remove("perm_org_result");
        pageCache.remove("all_conditional_org");
        pageCache.remove("do_not_have_parent_org_structlongnumber");
        pageCache.remove("common_prefix_struct_long_number");
        pageCache.remove("common_prefix_struct_long_number");
        pageCache.remove("CACHE_PERM_ORG_TEAM_RESULT");
        pageCache.remove("CACHE_PERM_ORG_TEAM_LONG_NUMBER");
        pageCache.remove("CACHE_PERM_RESET_HIS_TREE_MARK");
        pageCache.remove("permorgids");
    }

    public static LocalDate date2LocalDate(Date date) {
        if (date != null) {
            return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
        return LocalDate.now();
    }

    public static QFilter buildVirtualNodeClickFilter(IPageCache pageCache, boolean isInCludeChild) {
        String conditionalOrgIdStr = pageCache.get("all_conditional_org");
        if (conditionalOrgIdStr == null) {
            return new QFilter("id", "=", (Object)-1);
        }
        if (isInCludeChild) {
            List conditionalOrgIds = (List)SerializationUtils.fromJsonString((String)conditionalOrgIdStr, List.class);
            return new QFilter("boid", "in", (Object)conditionalOrgIds);
        }
        String doNotHaveParentOrgStructLongNumberStr = pageCache.get("do_not_have_parent_org_structlongnumber");
        Set doNotHaveParentOrgStructLongNumber = (Set)SerializationUtils.fromJsonString((String)doNotHaveParentOrgStructLongNumberStr, Set.class);
        return new QFilter("structnumber", "in", (Object)doNotHaveParentOrgStructLongNumber);
    }

    public static QFilter getHisCommonQFilter(Date queryDate) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"0");
        filter.and("datastatus", "in", Arrays.asList("1", "2"));
        filter.and("bsed", "<=", (Object)queryDate);
        filter.and("bsled", ">=", (Object)queryDate);
        return filter;
    }

    public static DynamicObject getRootDynamicObjectByCommonParentSLN(String commonParentStructLongNumber, String structEntityFields, String idFilterProperty, OrgTreeModel orgTreeModel, Date queryDate) {
        return TreeTemplateHelper.getRootDynamicObjectByCommonParentSLN(commonParentStructLongNumber, structEntityFields, idFilterProperty, orgTreeModel, queryDate, null);
    }

    public static DynamicObject getRootDynamicObjectByCommonParentSLN(String commonParentStructLongNumber, String structEntityFields, String idFilterProperty, OrgTreeModel orgTreeModel, Date queryDate, QFilter structProjectQFilter) {
        QFilter structNumberFilter;
        if (commonParentStructLongNumber.length() > TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH) {
            String[] split = commonParentStructLongNumber.split("!");
            structNumberFilter = new QFilter("structnumber", "=", (Object)split[split.length - 1]);
        } else {
            structNumberFilter = new QFilter("structnumber", "=", (Object)commonParentStructLongNumber);
        }
        QFilter hisFilter = TreeTemplateHelper.getHisCommonQFilter(queryDate);
        DynamicObject mainEntityInfo = HRBaseDaoFactory.getInstance(orgTreeModel.getMainEntityName()).queryOriginalOne("id,name,boid", new QFilter[]{structNumberFilter, hisFilter});
        if (mainEntityInfo == null) {
            return null;
        }
        QFilter structFilter = new QFilter(idFilterProperty, "=", (Object)mainEntityInfo.getLong("boid"));
        if (structProjectQFilter != null) {
            structFilter.and(structProjectQFilter);
        }
        DynamicObject structEntityInfo = HRBaseDaoFactory.getInstance(orgTreeModel.getEntityName()).queryOriginalOne(structEntityFields, new QFilter[]{structFilter, hisFilter});
        structEntityInfo.set("id", mainEntityInfo.get("id"));
        structEntityInfo.set("name", mainEntityInfo.get("name"));
        return structEntityInfo;
    }

    public static HasPermOrgResult getHRPermOrg(long userId, String orgViewType, String appId, String entityNumber, String permId) {
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityNumber, (String)permId, (boolean)false);
    }

    public static void getHisPermStructLongNumberLikeAndOutSub(AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> orgIdWithOutSub, List<String> structLongNumberList) {
        List permOrgWithSub = permOrgResultWithSub.getHasPermOrgsWithSub();
        for (OrgSubInfo subInfo : permOrgWithSub) {
            String longStructNumber = subInfo.getLongStructNumber();
            if (subInfo.isContainsSub()) {
                structLongNumberList.add(longStructNumber + "%");
                continue;
            }
            orgIdWithOutSub.add(subInfo.getOrgId());
        }
    }
}

