/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper.org.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.constants.org.OrgTreeSearchParam;
import kd.hr.hbp.common.constants.org.TreeTemplateConstants;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.compress.utils.Lists;

public class OrgTreeUtils {
    private static final Log LOGGER = LogFactory.getLog(OrgTreeUtils.class);

    public static String getCommonPrefixStructLongNumber(List<String> structLongNumbers) {
        if (CollectionUtils.isEmpty(structLongNumbers)) {
            return null;
        }
        String prefix = "";
        Optional min = structLongNumbers.stream().min(String::compareTo);
        if (min.isPresent()) {
            prefix = (String)min.get();
        }
        for (String str : structLongNumbers) {
            while (!str.startsWith(prefix)) {
                int idx = prefix.lastIndexOf("!");
                if (idx == -1) {
                    return null;
                }
                prefix = prefix.substring(0, idx);
            }
        }
        return prefix;
    }

    public static List<String> getSubStructNumbers(String currentStructLongNumber, List<String> structLongNumbers, boolean includeOwn) {
        if (StringUtils.isBlank((CharSequence)currentStructLongNumber) || CollectionUtils.isEmpty(structLongNumbers)) {
            return Lists.newArrayList();
        }
        return OrgTreeUtils.getMultiLayerSubStructNumber(currentStructLongNumber, structLongNumbers, includeOwn, 1);
    }

    public static List<String> getMultiLayerSubStructNumber(String currentStructLongNumber, List<String> structLongNumbers, boolean includeOwn, Integer layerCount) {
        LOGGER.info("getMultiLayerSubStructNumber,currentStructLongNumber={},structLongNumbers.size={},layerCount={}", new Object[]{currentStructLongNumber, structLongNumbers.size(), layerCount});
        Set<String> subStructNumberSet = OrgTreeUtils.getSubStructNumberSetByPermAndLayer(currentStructLongNumber, includeOwn, layerCount, structLongNumbers);
        LOGGER.info("getMultiLayerSubStructNumber,subStructNumberSet.size={}", (Object)(subStructNumberSet == null ? 0 : subStructNumberSet.size()));
        return new ArrayList<String>(subStructNumberSet);
    }

    public static List<String> getMultiLayerSubStructNumberForHis(String currentStructLongNumber, AuthorizedOrgResultWithSub permissionModel, boolean includeOwn, Integer layerCount, String entityName, QFilter orgTreeFilter) {
        LOGGER.info(String.format("OrgTreeUtils.getMultiLayerSubStructNumberForHis currentStructLongNumber=%s", currentStructLongNumber));
        QFilter structLongNumberAndSubFilter = TreeTemplateHelper.getOrgAndSubInPermFilter(permissionModel, "adminorg.boid");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObjectCollection dynObjColl = serviceHelper.queryOriginalCollection("adminorg.boid", new QFilter[]{structLongNumberAndSubFilter});
        Set adminOrgBoIdSet = dynObjColl.stream().map(dynObj -> dynObj.getLong("adminorg.boid")).collect(Collectors.toSet());
        DynamicObjectCollection structLongNumberDynObjColl = serviceHelper.queryOriginalCollection("structlongnumber", new QFilter[]{orgTreeFilter, new QFilter("adminorg.boid", "in", adminOrgBoIdSet)});
        List<String> structLongNumbers = structLongNumberDynObjColl.stream().map(dyn -> dyn.getString("structlongnumber")).collect(Collectors.toList());
        Set<String> subStructNumberSet = OrgTreeUtils.getSubStructNumberSetByPermAndLayer(currentStructLongNumber, includeOwn, layerCount, structLongNumbers);
        return new ArrayList<String>(subStructNumberSet);
    }

    private static Set<String> getSubStructNumberSetByPermAndLayer(String currentStructLongNumber, boolean includeOwn, Integer layerCount, List<String> structLongNumbers) {
        LOGGER.info("getSubStructNumberSetByPermAndLayer,currentStructLongNumber={},structLongNumbers.size={},layerCount={}", new Object[]{currentStructLongNumber, structLongNumbers.size(), layerCount});
        HashSet<String> subStructNumberSet = new HashSet<String>(structLongNumbers.size());
        if (layerCount == null || layerCount <= 0) {
            layerCount = 1;
        }
        for (String structLongNumber : structLongNumbers) {
            if (!structLongNumber.startsWith(currentStructLongNumber) || structLongNumber.equals(currentStructLongNumber)) continue;
            int length = currentStructLongNumber.length();
            if (structLongNumber.length() <= length) continue;
            int lastIndexOf = structLongNumber.lastIndexOf("!");
            if (structLongNumber.length() == lastIndexOf + 1) continue;
            int layerLength = length + TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH * layerCount;
            if (structLongNumber.length() < layerLength) {
                String allSubStructNumber = structLongNumber.substring(length + 1);
                if (allSubStructNumber.length() >= TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH) {
                    subStructNumberSet.addAll(Arrays.asList(allSubStructNumber.split("!")));
                    continue;
                }
                subStructNumberSet.add(structLongNumber.substring(length + 1));
                continue;
            }
            if (layerCount > 1) {
                String substring = structLongNumber.substring(length + 1, layerLength);
                subStructNumberSet.addAll(Arrays.asList(substring.split("!")));
                continue;
            }
            subStructNumberSet.add(structLongNumber.substring(length + 1, length + TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH));
        }
        if (includeOwn) {
            String structNumber = currentStructLongNumber.contains("!") ? currentStructLongNumber.substring(currentStructLongNumber.lastIndexOf("!") + 1) : currentStructLongNumber;
            subStructNumberSet.add(structNumber);
        }
        LOGGER.info("getSubStructNumberSetByPermAndLayer,subStructNumberSet.size={}", (Object)subStructNumberSet.size());
        return subStructNumberSet;
    }

    public static List<String> getAllSubStructNumbers(String currentStructLongNumber, List<String> structLongNumbers, boolean includeOwn) {
        if (StringUtils.isBlank((CharSequence)currentStructLongNumber) || CollectionUtils.isEmpty(structLongNumbers)) {
            return Lists.newArrayList();
        }
        ArrayList subStructNumbers = Lists.newArrayList();
        structLongNumbers.forEach(structLongNumber -> {
            if (structLongNumber.startsWith(currentStructLongNumber) && !structLongNumber.equals(currentStructLongNumber)) {
                structLongNumber = structLongNumber.replace(currentStructLongNumber + "!", "");
                String[] subStructLongNumbers = structLongNumber.split("!");
                Collections.addAll(subStructNumbers, subStructLongNumbers);
            }
        });
        if (includeOwn) {
            String structNumber = currentStructLongNumber.contains("!") ? currentStructLongNumber.substring(currentStructLongNumber.lastIndexOf("!") + 1) : currentStructLongNumber;
            subStructNumbers.add(structNumber);
        }
        return subStructNumbers;
    }

    public static List<TreeNode> buildTreeNodes(List<TreeNode> childNodes) {
        ArrayList list = Lists.newArrayList();
        HashMap dctItems = Maps.newHashMap();
        childNodes.forEach(childNode -> dctItems.put(childNode.getId(), childNode));
        childNodes.forEach(childNode -> {
            TreeNode parentNode = (TreeNode)dctItems.get(childNode.getParentid());
            if (null != parentNode) {
                if (parentNode.getChildren() == null) {
                    parentNode.addChildren((List)Lists.newArrayList());
                }
                parentNode.getChildren().add(childNode);
            } else {
                list.add(childNode);
            }
        });
        return list;
    }

    public static boolean isChildNode(TreeNode parentNode, TreeNode node) {
        if (parentNode != null && !CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
            TreeNode child;
            Iterator children = parentNode.getChildren().iterator();
            do {
                if (!children.hasNext()) {
                    return false;
                }
                child = (TreeNode)children.next();
            } while (!node.getId().equals(child.getId()));
            return true;
        }
        return false;
    }

    public static void expandParentNode(OrgTreeSearchParam searchParam, String nodeId, Set<String> loopController, List<String> expendIds, int recursionCount) {
        TreeNode rootNode;
        if (recursionCount > 20) {
            return;
        }
        if (searchParam != null && !StringUtils.isBlank((CharSequence)nodeId) && loopController != null && (rootNode = searchParam.getRootNode()) != null) {
            loopController.add(nodeId);
            TreeNode treeNode = OrgTreeUtils.getNode(rootNode, nodeId);
            if (treeNode != null && !treeNode.isExpend()) {
                if (expendIds == null) {
                    searchParam.getTreeView().expand(nodeId);
                } else {
                    expendIds.add(nodeId);
                }
                treeNode.setExpend(true);
                OrgTreeUtils.expandParentNode(searchParam, treeNode.getParentid(), loopController, expendIds, recursionCount);
            }
        }
    }

    public static TreeNode getNode(TreeNode rootNode, Object nodeId) {
        return rootNode != null && !StringUtils.isBlank((Object)nodeId) ? rootNode.getTreeNode(nodeId.toString(), 20) : null;
    }

    public static void sortDynColsOrderBys(DynamicObjectCollection dynCol, String orderBys) {
        String[] orderByArr;
        LOGGER.info("OrgTreeUtils.sortDynColsOrderBys, orderBys={}", (Object)orderBys);
        if (StringUtils.isEmpty((CharSequence)orderBys)) {
            return;
        }
        for (String orderStr : orderByArr = orderBys.split(",")) {
            dynCol.stream().forEach(dynamicObject -> {
                if (HRStringUtils.isEmpty((String)dynamicObject.getString(orderStr))) {
                    dynamicObject.set(orderStr, (Object)"");
                }
            });
        }
        if (orderByArr.length == 1) {
            dynCol.sort(Comparator.comparing(o -> o.getString(orderByArr[0].trim())));
            return;
        }
        dynCol.sort(Comparator.comparing(o -> o.getString(orderByArr[0].trim())).thenComparing(o -> o.getString(orderByArr[1].trim())));
        LOGGER.info("OrgTreeUtils.sortDynColsOrderBys end");
    }

    public static void setParamQueryDate(Date queryDate, List<Object> paramList, int dateNum) {
        if (paramList == null) {
            return;
        }
        if (dateNum == 0) {
            return;
        }
        for (int i = 0; i < dateNum; ++i) {
            paramList.add(queryDate);
        }
    }

    public static void assemblyStructNumberSql(StringBuilder sqlStr, String andPropertyInList, int forSize) {
        if (forSize == 0) {
            return;
        }
        sqlStr.append(" AND ").append(andPropertyInList).append(" in (");
        ArrayList<String> placeholderList = new ArrayList<String>(forSize);
        for (int i = 0; i < forSize; ++i) {
            placeholderList.add("?");
        }
        String join = String.join((CharSequence)",", placeholderList);
        sqlStr.append(join).append(")");
    }

    public static void assemblyEnableSql(StringBuilder sqlStr, boolean showDisable) {
        if (showDisable) {
            sqlStr.append(" AND (A.FENABLE = '1' OR A.FENABLE = '0') AND (A1.FENABLE = '1' OR A1.FENABLE = '0')");
        } else {
            sqlStr.append(" AND A.FENABLE = '1' AND A1.FENABLE = '1' ");
        }
    }

    public static List<TreeNode> buildSearchTreeNodeList(DynamicObjectCollection retDynCol, String parentProperty) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        if (retDynCol == null) {
            return treeNodes;
        }
        for (DynamicObject dyn : retDynCol) {
            TreeNode treeNode = new TreeNode(dyn.getString(parentProperty), dyn.getString("id"), dyn.getString("name"));
            treeNode.setLongNumber(dyn.getString("structlongnumber"));
            treeNode.setLabelShowType(1);
            treeNode.setExpend(true);
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }
}

