/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.virtulentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlListDataProvider;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.service.query.util.QueryJoinExprUtil;
import kd.hr.hbp.business.servicehelper.EntityReleaseInfoService;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.business.virtulentity.HRVirtualEntityQueryInfo;
import kd.hr.hbp.common.enums.query.EnumQueryEntityDatasourceType;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.sdk.annotation.SdkInternal;

public class HRVirtualEntityHelper {
    private static final HRVirtualEntityHelper INSTANCE = new HRVirtualEntityHelper();
    private static final String FIELD_DATASOURCETYPE = "datasourcetype";
    private static final String FIELD_KSQLQUERYTYPE = "ksqlquerytype";
    private static final String FIELD_KSQLUSEUNION = "ksqluseunion";

    private HRVirtualEntityHelper() {
    }

    public static HRVirtualEntityHelper getInstance() {
        return INSTANCE;
    }

    @SdkInternal
    public DynamicObjectCollection getQueryDyoColl(HRVirtualEntityQueryInfo virtualEntityQueryInfo) {
        try (DataSet dataSet = this.getQueryDataSet(virtualEntityQueryInfo);){
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection((Iterator)dataSet.iterator(), (RowMeta)dataSet.getRowMeta(), (String)virtualEntityQueryInfo.getQueryEntityType().getEntityName());
            return dynamicObjectCollection;
        }
    }

    @SdkInternal
    public DataSet getQueryDataSet(HRVirtualEntityQueryInfo virtualEntityQueryInfo) {
        HRComplexObjContext context = this.getHrComplexObjContext(virtualEntityQueryInfo);
        if (context == null) {
            return null;
        }
        return this.getQueryDataSet(context, virtualEntityQueryInfo.getStart(), virtualEntityQueryInfo.getLimit());
    }

    @SdkInternal
    public DataSet getQueryDataSet(HRComplexObjContext context, int start, int limit) {
        if (context == null) {
            return null;
        }
        ReportQueryService reportQueryService = new ReportQueryService(context);
        return reportQueryService.queryDataSet(start, limit);
    }

    public HRComplexObjContext getHrComplexObjContext(HRVirtualEntityQueryInfo virtualEntityQueryInfo) {
        QueryEntityType queryEntityType = virtualEntityQueryInfo.getQueryEntityType();
        String queryFields = virtualEntityQueryInfo.getQueryFields();
        if (queryEntityType == null || HRStringUtils.isEmpty((String)queryFields)) {
            return null;
        }
        List<QFilter> qFilters = virtualEntityQueryInfo.getWhereQFilters();
        String orderBys = virtualEntityQueryInfo.getOrderBys();
        long reportId = virtualEntityQueryInfo.getReportId();
        HRComplexObjContext context = new HRComplexObjContext();
        List<HRComplexObjFieldInfo> allComplexObjFieldInfoList = queryEntityType.getSelectFields().stream().map(field -> {
            IDataEntityProperty fieldProperty = QueryEntityUtil.getFieldProperty((MainEntityType)queryEntityType, (String)field.getAlias());
            if (fieldProperty == null) {
                return null;
            }
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo();
            fieldInfo.setDataType(QueryEntityUtil.tranPropType((IDataEntityProperty)fieldProperty));
            fieldInfo.setFieldType("1");
            fieldInfo.setAlias(field.getAlias());
            fieldInfo.setFullPath(field.getAlias());
            return fieldInfo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<HRComplexObjFieldInfo> complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(allComplexObjFieldInfoList.size());
        Map fieldInfoMap = allComplexObjFieldInfoList.stream().collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, Function.identity()));
        if (HRStringUtils.isNotEmpty((String)queryFields)) {
            String[] fields;
            for (String fieldAlias : fields = queryFields.split(",")) {
                IDataEntityProperty fieldProperty;
                HRComplexObjFieldInfo fieldInfo = (HRComplexObjFieldInfo)fieldInfoMap.get(fieldAlias);
                if (fieldInfo == null && fieldAlias.endsWith(".id") && (fieldProperty = QueryEntityUtil.getFieldProperty((MainEntityType)queryEntityType, (String)fieldAlias)) != null) {
                    fieldInfo = new HRComplexObjFieldInfo();
                    fieldInfo.setDataType(QueryEntityUtil.tranPropType((IDataEntityProperty)fieldProperty));
                    fieldInfo.setFieldType("1");
                    fieldInfo.setAlias(fieldAlias);
                    fieldInfo.setFullPath(fieldAlias);
                }
                if (fieldInfo == null) continue;
                complexObjFieldInfoList.add(fieldInfo);
            }
            complexObjFieldInfoList.remove(null);
        }
        context.setComplexObjFieldInfoList(complexObjFieldInfoList);
        context.setQfilterList(qFilters);
        if (HRStringUtils.isNotEmpty((String)orderBys)) {
            List<SortFieldInfo> sortFieldInfoList = this.getSortFieldInfos(orderBys, reportId, allComplexObjFieldInfoList);
            context.setSortFieldInfoList(sortFieldInfoList);
        }
        context.setEntityNumber(queryEntityType.getEditEntityName());
        context.setEntityTable(HREntityHelper.getTableName(queryEntityType.getEditEntityName()));
        List<HRComplexObjJoinRelation> joinRelationList = this.genJoinRelationList(queryEntityType);
        context.setJoinRelationList(joinRelationList);
        Map<String, List<QFilter>> relationMap = this.genRelationMap(virtualEntityQueryInfo.getOnQFilters(), joinRelationList);
        this.appendQFilterToJoinCondition(relationMap, context.getJoinRelationList());
        return context;
    }

    private List<SortFieldInfo> getSortFieldInfos(String orderBys, long reportId, List<HRComplexObjFieldInfo> allComplexObjFieldInfoList) {
        Map<String, DataTypeEnum> fieldTypeMap = allComplexObjFieldInfoList.stream().collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, HRComplexObjFieldInfo::getDataType));
        String[] orderBy = orderBys.split(",");
        ArrayList<SortFieldInfo> sortFieldInfoList = new ArrayList<SortFieldInfo>(orderBy.length);
        int i = 0;
        for (String o : orderBy) {
            String[] str = o.split(" ");
            SortFieldInfo sortFieldInfo = new SortFieldInfo();
            sortFieldInfo.setSeq(i++);
            sortFieldInfo.setFieldAlias(str[0]);
            sortFieldInfo.setDataType(fieldTypeMap.get(str[0]));
            if (str.length == 2) {
                if (SortFieldInfo.SORTORD_USER_DEFINED.equals(str[1])) {
                    if (null == (sortFieldInfo = this.getCustomSort(reportId, sortFieldInfo))) continue;
                    sortFieldInfoList.add(sortFieldInfo);
                    continue;
                }
                sortFieldInfo.setSortord(str[1]);
                sortFieldInfoList.add(sortFieldInfo);
                continue;
            }
            sortFieldInfo.setSortord(SortFieldInfo.SORTORD_ASC);
            sortFieldInfoList.add(sortFieldInfo);
        }
        return sortFieldInfoList;
    }

    private List<HRComplexObjJoinRelation> genJoinRelationList(QueryEntityType queryEntityType) {
        ArrayList<HRComplexObjJoinRelation> joinRelationList = new ArrayList<HRComplexObjJoinRelation>(queryEntityType.getJoinRelations().size());
        for (QuerySourceJoinRelation querySourceJoinRelation : queryEntityType.getJoinRelations()) {
            HRComplexObjJoinRelation complexObjJoinRelation = new HRComplexObjJoinRelation();
            complexObjJoinRelation.setEntityNumber(querySourceJoinRelation.getEntityNumber());
            complexObjJoinRelation.setEntityAlias(querySourceJoinRelation.getEntityNumber());
            complexObjJoinRelation.setRelEntityNumber(QueryEntityUtil.getEntityNameByAlias((String)querySourceJoinRelation.getRelEntityNumber(), (QueryEntityType)queryEntityType));
            complexObjJoinRelation.setRelEntityAlias(querySourceJoinRelation.getRelEntityNumber());
            complexObjJoinRelation.setJoinType(querySourceJoinRelation.getJoinType());
            complexObjJoinRelation.setCondition(querySourceJoinRelation.getCondition().stream().map(row -> new HRComplexObjConditionRow(row.getLeftItem().toString(), row.getRightItem().toString(), row.getCompareOp(), QueryJoinExprUtil.itemIsField(queryEntityType, row.getRightItem().toString()))).collect(Collectors.toList()));
            joinRelationList.add(complexObjJoinRelation);
        }
        return joinRelationList;
    }

    private Map<String, List<QFilter>> genRelationMap(List<QFilter> onQFilterList, List<HRComplexObjJoinRelation> joinRelationList) {
        HashMap<String, List<QFilter>> relationMap = new HashMap<String, List<QFilter>>(16);
        Map<String, String> relEntityMap = joinRelationList.stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        for (QFilter qFilter : onQFilterList) {
            String property = qFilter.getProperty();
            String fieldEntityAlias = FieldFullPathParseUtil.getFieldEntityAlias(relEntityMap, property);
            if (fieldEntityAlias == null) continue;
            List<QFilter> qFilterList = MapCacheUtil.getMapListQFilterVal(relationMap, fieldEntityAlias);
            qFilterList.add(qFilter);
            relationMap.put(fieldEntityAlias, qFilterList);
        }
        return relationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    public List<Object> queryAllPkByKSql(HRVirtualEntityQueryInfo virtualEntityQueryInfo) {
        QueryEntityType queryEntityType = virtualEntityQueryInfo.getQueryEntityType();
        if (queryEntityType == null) {
            return null;
        }
        List<QFilter> qFilters = virtualEntityQueryInfo.getWhereQFilters();
        String orderBys = virtualEntityQueryInfo.getOrderBys();
        int start = virtualEntityQueryInfo.getStart();
        int limit = virtualEntityQueryInfo.getLimit();
        Map<String, List<QFilter>> relationMap = this.genRelationMap(virtualEntityQueryInfo.getOnQFilters(), this.genJoinRelationList(queryEntityType));
        Map<String, Object> confMap = this.queryEntityReleaseInfo(queryEntityType.getName());
        String dataSourceTypeStr = "ALGO";
        String datasourcetype = (String)confMap.get(FIELD_DATASOURCETYPE);
        if (HRStringUtils.isNotEmpty((String)datasourcetype)) {
            dataSourceTypeStr = datasourcetype;
        }
        List<Object> pkIds = null;
        if (HRStringUtils.equals((String)EnumQueryEntityDatasourceType.KSQL.getType(), (String)dataSourceTypeStr)) {
            String ksqlQueryType = (String)confMap.get(FIELD_KSQLQUERYTYPE);
            boolean ksqlUseUnion = (Boolean)confMap.get(FIELD_KSQLUSEUNION);
            String cacheKey = queryEntityType.getName() + UUID.randomUUID().toString().substring(1, 26);
            String queryType = "FULLSQL";
            if (HRStringUtils.equals((String)ksqlQueryType, (String)"IDQUERY")) {
                queryType = "PKSQL";
            }
            KsqlListDataProvider ksqlListDataProvider = new KsqlListDataProvider(new KsqlConfig(), "hbp", cacheKey, queryType, (Boolean)ksqlUseUnion);
            pkIds = ksqlListDataProvider.queryAllPk(queryEntityType, qFilters.toArray(new QFilter[0]), orderBys, start, limit, relationMap);
        } else {
            try (DataSet dataSet = null;){
                dataSet = queryEntityType.getQueryDataSet("id", qFilters.toArray(new QFilter[0]), orderBys);
                if (dataSet != null) {
                    pkIds = Lists.newArrayListWithExpectedSize((int)16);
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        pkIds.add(next.getLong("id"));
                    }
                }
            }
        }
        return pkIds;
    }

    @SdkInternal
    public Map<String, Object> queryEntityReleaseInfo(String queryEntityName) {
        HashMap confMap = Maps.newHashMapWithExpectedSize((int)3);
        DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName(queryEntityName);
        if (Objects.isNull(entityReleaseInfo)) {
            return confMap;
        }
        confMap.put(FIELD_DATASOURCETYPE, entityReleaseInfo.getString(FIELD_DATASOURCETYPE));
        confMap.put(FIELD_KSQLQUERYTYPE, entityReleaseInfo.getString(FIELD_KSQLQUERYTYPE));
        confMap.put(FIELD_KSQLUSEUNION, entityReleaseInfo.getBoolean(FIELD_KSQLUSEUNION));
        return confMap;
    }

    private SortFieldInfo getCustomSort(long reportId, SortFieldInfo sortFieldInfo) {
        if (reportId != 0L) {
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"hrptmc_customsort", (String)"rptfieldid,valuetype,entryentity.string,entryentity.long", (QFilter[])new QFilter[]{new QFilter("rptmanage", "=", (Object)reportId), new QFilter("entityfield", "=", (Object)sortFieldInfo.getFieldAlias())});
            String valueType = dy.getString("valuetype");
            sortFieldInfo.setFieldId(Long.valueOf(dy.getLong("rptfieldid")));
            sortFieldInfo.setReportId(Long.valueOf(reportId));
            sortFieldInfo.setValueType(valueType);
            sortFieldInfo.setDataType(DataTypeEnum.of((String)valueType));
            if ("string".equals(valueType)) {
                DynamicObjectCollection coll = dy.getDynamicObjectCollection("entryentity");
                sortFieldInfo.setValue(coll.stream().map(entryDy -> entryDy.getString("string")).collect(Collectors.toList()));
            } else {
                DynamicObjectCollection coll = dy.getDynamicObjectCollection("entryentity");
                sortFieldInfo.setValue(coll.stream().map(entryDy -> entryDy.getString("long")).collect(Collectors.toList()));
            }
            sortFieldInfo.setSortord("custom");
            return sortFieldInfo;
        }
        return null;
    }

    private void appendQFilterToJoinCondition(Map<String, List<QFilter>> joinConditionMap, List<HRComplexObjJoinRelation> joinRelationList) {
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            String relEntityAlias = joinRelation.getRelEntityAlias();
            List<QFilter> qFilterList = joinConditionMap.get(relEntityAlias);
            if (CollectionUtils.isEmpty(qFilterList)) continue;
            ArrayList<HRComplexObjConditionRow> appendCondList = new ArrayList<HRComplexObjConditionRow>(10);
            for (QFilter qFilter : qFilterList) {
                String itemVal = QFilterUtilHR.parametertoString(qFilter.getValue());
                HRComplexObjConditionRow row = new HRComplexObjConditionRow(qFilter.getProperty(), itemVal, false);
                row.setCompareOp(qFilter.getCP());
                appendCondList.add(row);
            }
            joinRelation.getCondition().addAll(appendCondList);
        }
    }
}

