/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRAdminOrgTreeList;
import kd.hr.hbp.formplugin.web.imp.AdminOrgTreeHelper;

@ExcludeFromJacocoGeneratedReport
public class HRAdminOrgSearchTreeList
extends HRAdminOrgTreeList {
    private static final String PAGECACHE_SEARCH_MODE_KEY = "lefttree_search_mode";
    private static final String ORG_SELECT_FIELDS = "adminorg.id id, adminorg.name name,adminorg.number number, parentorg parent,structlongnumber,isleaf, sortcode,adminorg.structnumber structnumber";
    private static final String ORG_ORDER_FIELDS = "sortcode, adminorg.number";
    private static final String PROP_LONG_NUMBER = "structlongnumber";

    protected boolean isCustomTreeSearch() {
        return false;
    }

    private void setTreeSearchMode(boolean searchMode) {
        this.getPageCache().put(PAGECACHE_SEARCH_MODE_KEY, searchMode + "");
    }

    private boolean isTreeSearchMode() {
        return HRStringUtils.equals((String)this.getPageCache().get(PAGECACHE_SEARCH_MODE_KEY), (String)"true");
    }

    @Override
    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        if (this.isTreeSearchMode()) {
            return;
        }
        super.treeNodeClick(treeNodeEvent);
    }

    @Override
    public void refreshNode(RefreshNodeEvent refreshNodeEvent) {
        if (this.isTreeSearchMode()) {
            return;
        }
        super.refreshNode(refreshNodeEvent);
    }

    public void search(SearchEnterEvent evt) {
        if (!this.isCustomTreeSearch()) {
            super.search(evt);
            return;
        }
        String searchText = evt.getText();
        TreeView treeView = this.treeListView.getTreeView();
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.setTreeSearchMode(false);
            treeView.deleteAllNodes();
            TreeNode rootNode = this.getRootNode();
            treeView.addNode(rootNode);
            treeView.focusNode(rootNode);
            treeView.treeNodeClick("", rootNode.getId());
            this.setInCludeChild(true);
        } else {
            this.setTreeSearchMode(true);
            treeView.deleteAllNodes();
            QFilter searchFilter = new QFilter("adminorg.name", "ftlike", (Object)searchText);
            QFilter[] filters = AdminOrgTreeHelper.getFilterArrayByFilterParams(searchFilter, this.isShowDepartment(), this.isShowDisable(), this.isShowUnUsing());
            DynamicObjectCollection searchedCollection = this.getOrgHelper().queryOriginalCollection(ORG_SELECT_FIELDS, filters, ORG_ORDER_FIELDS);
            DynamicObjectCollection authorizedCollection = this.filterAuthorizedOrg(searchedCollection);
            DynamicObjectCollection toShowCollection = this.getPatrilineOrgs(authorizedCollection);
            TreeNode rootNode = this.buildRootNodeWithChildren(toShowCollection);
            if (rootNode != null) {
                treeView.addNode(rootNode);
                treeView.focusNode(rootNode);
            }
        }
    }

    private HRBaseServiceHelper getOrgHelper() {
        return new HRBaseServiceHelper(this.getEntityName());
    }

    private TreeNode buildRootNodeWithChildren(DynamicObjectCollection toShowCollection) {
        ArrayList toShowNodeList = Lists.newArrayListWithExpectedSize((int)16);
        TreeNode rootNode = null;
        Set parentIds = toShowCollection.stream().map(dyno -> dyno.getString("parent")).collect(Collectors.toSet());
        for (DynamicObject orgDyno : toShowCollection) {
            if (HRStringUtils.equals((String)orgDyno.getString("id"), (String)(OrgServiceUtil.getAdminRootOrgId() + ""))) {
                rootNode = this.getRootNode();
                toShowNodeList.add(rootNode);
                continue;
            }
            String id = orgDyno.getString("id");
            boolean isParent = parentIds.contains(id);
            TreeNode node2 = new TreeNode(orgDyno.getString("parent"), id, orgDyno.getString("name"), isParent);
            if (isParent) {
                node2.setIsOpened(true);
            }
            toShowNodeList.add(node2);
        }
        Map<String, TreeNode> nodeMap = toShowNodeList.stream().collect(Collectors.toMap(node -> node.getId(), node -> node));
        for (TreeNode node3 : toShowNodeList) {
            String parentId = node3.getParentid();
            TreeNode parentNode = nodeMap.get(parentId);
            if (!HRStringUtils.isNotEmpty((String)parentId) || parentNode == null) continue;
            parentNode.addChild(node3);
        }
        return rootNode;
    }

    private DynamicObjectCollection getPatrilineOrgs(DynamicObjectCollection authorizedCollection) {
        HashSet structNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject orgDyno : authorizedCollection) {
            String structLongNumber = orgDyno.getString(PROP_LONG_NUMBER);
            String[] structNumberArr = structLongNumber.split("!");
            structNumberSet.addAll(Arrays.stream(structNumberArr).collect(Collectors.toSet()));
        }
        QFilter toShowOrgFilter = new QFilter("adminorg.structnumber", "in", (Object)structNumberSet);
        return this.getOrgHelper().queryOriginalCollection(ORG_SELECT_FIELDS, toShowOrgFilter.toArray(), ORG_ORDER_FIELDS);
    }

    private DynamicObjectCollection filterAuthorizedOrg(DynamicObjectCollection searchedCollection) {
        AuthorizedOrgResultWithSub authorizedOrgResult = this.getPermOrgResultWithSub();
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            return searchedCollection;
        }
        DynamicObjectCollection authorizedCollection = new DynamicObjectCollection();
        List hasPermOrgList = authorizedOrgResult.getHasPermOrgsWithSub();
        for (DynamicObject orgDyno : searchedCollection) {
            if (!this.judgeHasOrgPerm(orgDyno, hasPermOrgList)) continue;
            authorizedCollection.add((Object)orgDyno);
        }
        return authorizedCollection;
    }

    private boolean judgeHasOrgPerm(DynamicObject orgDyno, List<OrgSubInfo> hasPermOrgList) {
        if (CollectionUtils.isEmpty(hasPermOrgList)) {
            return false;
        }
        String orgLongNumber = orgDyno.getString(PROP_LONG_NUMBER);
        for (OrgSubInfo orgInfo : hasPermOrgList) {
            if ((orgInfo.isContainsSub() || !HRStringUtils.equals((String)orgLongNumber, (String)orgInfo.getLongStructNumber())) && (!orgInfo.isContainsSub() || !HRStringUtils.startsWithIgnoreCase((String)orgLongNumber, (String)orgInfo.getLongStructNumber()))) continue;
            return true;
        }
        return false;
    }
}

