/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.model.AdminOrgQueryParamInfo;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.HRFilterFieldInfo;
import kd.hr.hbp.common.model.HRFilterFieldItemInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRStandardTreeList;
import kd.hr.hbp.formplugin.web.imp.AdminOrgTreeHelper;

public class HRAdminOrgTreeList
extends HRStandardTreeList {
    public static final String CHK_SHOW_DEPT = "chkshowdept";
    public static final String CHK_SHOW_DISABLE = "chkshowdisable";
    public static final String ID_ORGTYPE_GROUP = "1010";
    public static final String ID_ORGTYPE_COMPANY = "1020";
    public static final String ID_ORGTYPE_REGION = "1030";
    public static final String ID_ORGTYPE_DEPARTMENT = "1040";

    public HRAdminOrgTreeList() {
        super("haos_adminorgstruct", OrgServiceUtil.getAdminRootOrgId() + "", false);
    }

    @Override
    protected DynamicObject getRootDynamicObject() {
        String selectFields = "adminorg.id id, adminorg.name name,structlongnumber longnumber";
        QFilter filter = new QFilter("adminorg", "=", (Object)Long.valueOf(this.getRootId()));
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter, currentFilter};
        return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOriginalOne(selectFields, filters);
    }

    @Override
    protected DynamicObjectCollection getTreeViewCollection(String entityName, String parentId) {
        boolean showDepartment = this.isShowDepartment();
        boolean showDisable = this.isShowDisable();
        boolean showUnUsing = this.isShowUnUsing();
        this.getPageCache().put(CHK_SHOW_DEPT, String.valueOf(showDepartment));
        this.getPageCache().put(CHK_SHOW_DISABLE, String.valueOf(showDisable));
        AdminOrgQueryParamInfo queryParamInfo = new AdminOrgQueryParamInfo(showDepartment, showDisable, showUnUsing);
        String selectFields = "adminorg.id id, adminorg.name name,parentorg,structlongnumber longnumber,isleaf,adminorg.structnumber structnumber";
        QFilter filter = new QFilter("parentorg", "=", (Object)Long.valueOf(parentId));
        filter.and("structproject", "=", (Object)1010L);
        QFilter[] filters = AdminOrgTreeHelper.getFilterArrayByFilterParams(filter, showDepartment, showDisable, showUnUsing);
        DynamicObjectCollection firstLevelCollection = HRBaseDaoFactory.getInstance((String)entityName).queryColl(selectFields, filters, "level ASC,adminorg.id ASC");
        List<String> firstLevelIdList = this.getOrgIdList(firstLevelCollection);
        AuthorizedOrgResultWithSub permOrgResult = this.getPermOrgResultWithSub();
        return AdminOrgTreeHelper.getFirstLevelCollection(parentId, firstLevelCollection, firstLevelIdList, permOrgResult, queryParamInfo);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    protected HRFilterFieldInfo getHRFilterFieldInfo() {
        ArrayList<HRFilterFieldItemInfo> filterFieldItemInfos = new ArrayList<HRFilterFieldItemInfo>();
        HRFilterFieldItemInfo hrFilterFieldItemInfo = new HRFilterFieldItemInfo("adminorg", "adminorg");
        filterFieldItemInfos.add(hrFilterFieldItemInfo);
        return new HRFilterFieldInfo(filterFieldItemInfos);
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (HRStringUtils.equals((String)evt.getItemKey().toLowerCase(Locale.ROOT), (String)"tblrefresh")) {
            this.getPageCache().put("treeOrgIds", null);
            this.getPageCache().put("permorgids", null);
            this.getPageCache().put("permfilter", null);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    protected boolean isShowDisable() {
        boolean isShow;
        Boolean isshowdisableparam = (Boolean)this.getView().getFormShowParameter().getCustomParam(CHK_SHOW_DISABLE);
        if (isshowdisableparam == null) {
            String cacheStrShow = this.getPageCache().get(CHK_SHOW_DISABLE);
            isShow = Boolean.parseBoolean(cacheStrShow);
        } else {
            isShow = isshowdisableparam;
        }
        return isShow;
    }

    protected boolean isShowDepartment() {
        String cacheStrShowDept;
        Boolean isShowDepartmentParam = (Boolean)this.getView().getFormShowParameter().getCustomParam(CHK_SHOW_DEPT);
        boolean isdepartment = isShowDepartmentParam == null ? (cacheStrShowDept = this.getPageCache().get(CHK_SHOW_DEPT)) == null || Boolean.parseBoolean(cacheStrShowDept) : isShowDepartmentParam;
        return isdepartment;
    }

    protected boolean isShowUnUsing() {
        return true;
    }

    private List<String> getOrgIdList(DynamicObjectCollection dynObjColl) {
        ArrayList<String> orgIdList = new ArrayList<String>(dynObjColl.size());
        for (DynamicObject dynamicObject : dynObjColl) {
            orgIdList.add(String.valueOf(dynamicObject.get("id")));
        }
        return orgIdList;
    }
}

