/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRBUFilterList
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        HasPermOrgResult permOrgResult = this.getPermOrgs();
        if (permOrgResult.hasAllOrgPerm()) {
            return;
        }
        String buProp = this.getBUProp();
        if (HRStringUtils.isEmpty((String)buProp)) {
            buProp = "org";
        }
        QFilter mainOrgFilter = new QFilter(buProp, "in", (Object)permOrgResult.getHasPermOrgs());
        setFilterEvent.getQFilters().add(mainOrgFilter);
    }

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        String fieldName;
        String buProp = this.getBUProp();
        if (HRStringUtils.isEmpty((String)buProp)) {
            buProp = "org";
        }
        if (!(fieldName = evt.getFieldName()).split("\\.")[0].equals(buProp) || !"bos_org".equals(evt.getRefEntityId())) {
            return;
        }
        HasPermOrgResult permOrgResult = this.getPermOrgs();
        if (permOrgResult.hasAllOrgPerm()) {
            return;
        }
        evt.getQfilters().add(new QFilter("id", "in", (Object)permOrgResult.getHasPermOrgs()));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String buProp = this.getBUProp();
        if (HRStringUtils.isEmpty((String)buProp)) {
            buProp = "org";
        }
        for (FilterColumn filterColumn : filterColumnList) {
            if (!HRStringUtils.equals((String)(buProp + ".number"), (String)filterColumn.getFieldName()) && !HRStringUtils.equals((String)(buProp + ".name"), (String)filterColumn.getFieldName())) continue;
            HasPermOrgResult permOrgResult = this.getPermOrgs();
            if (permOrgResult.hasAllOrgPerm()) {
                return;
            }
            QFilter hasPermFilter = new QFilter("id", "in", (Object)permOrgResult.getHasPermOrgs());
            DynamicObjectCollection orgCollection = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{hasPermFilter}, (String)"id");
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
            this.addCombos(orgCollection, combos);
            commonFilterColumn.setComboItems(combos);
        }
    }

    private void addCombos(DynamicObjectCollection orgCollection, List<ComboItem> combos) {
        for (DynamicObject org : orgCollection) {
            if (org == null) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString("name")));
            item.setValue(String.valueOf(org.get("id")));
            combos.add(item);
        }
    }

    private HasPermOrgResult getPermOrgs() {
        String appNumber;
        AppInfo appInfo;
        String appId;
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entityName = this.getEntityName();
        if (HRStringUtils.isEmpty((String)entityName)) {
            entityName = listParameter.getBillFormId();
        }
        if (HRStringUtils.isEmpty((String)(appId = this.getAppId())) && (appInfo = AppMetadataCache.getAppInfo((String)(appNumber = listParameter.getAppId()))) != null) {
            appId = appInfo.getId();
        }
        return HRPermissionServiceHelper.getPermOrgs((String)appId, (String)entityName);
    }

    protected String getEntityName() {
        return null;
    }

    protected String getBUProp() {
        return null;
    }

    protected String getAppId() {
        return null;
    }
}

