/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.customcontrol.HRCustomControlConstants;
import kd.bos.ext.hr.customcontrol.IHRCustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class HRCustomControlPlugin
extends AbstractBasePlugIn {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            BillShowParameter parameter = (BillShowParameter)formShowParameter;
            this.updateCustomControlStatus(parameter.getBillStatus().getValue());
        } else {
            this.updateCustomControlStatus(formShowParameter.getStatus().getValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey)) {
            this.updateCustomControlStatus();
        }
    }

    private void updateCustomControlStatus(int status) {
        ArrayList iHRCustomControlList = Lists.newArrayListWithCapacity((int)8);
        ArrayList customControlList = Lists.newArrayListWithCapacity((int)8);
        this.handleCustomControl(iHRCustomControlList, customControlList);
        if (!iHRCustomControlList.isEmpty()) {
            this.setFromStatus(iHRCustomControlList, status);
        }
        if (!customControlList.isEmpty()) {
            customControlList.forEach(customControl -> {
                if (this.isLock(status, customControl.getLock())) {
                    customControl.setData((Object)"VIEW");
                } else {
                    customControl.setData((Object)"EDIT");
                }
            });
        }
    }

    public boolean isLock(int status, String lock) {
        if (StringUtils.isEmpty((CharSequence)lock)) {
            return false;
        }
        return BillOperationStatus.ADDNEW.getValue() == status && lock.contains(HRCustomControlConstants.LOCK_NEW) || BillOperationStatus.EDIT.getValue() == status && lock.contains(HRCustomControlConstants.LOCK_EDIT) || BillOperationStatus.VIEW.getValue() == status && lock.contains(HRCustomControlConstants.LOCK_VIEW) || BillOperationStatus.SUBMIT.getValue() == status && lock.contains(HRCustomControlConstants.LOCK_SUBMIT) || BillOperationStatus.AUDIT.getValue() == status && lock.contains(HRCustomControlConstants.LOCK_AUDIT);
    }

    @ExcludeFromJacocoGeneratedReport
    public void updateCustomControlStatus() {
        String billStatus;
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        if (mainEntityType instanceof BillEntityType && !StringUtils.isBlank((CharSequence)(billStatus = ((BillEntityType)mainEntityType).getBillStatus())) && this.getModel().getProperty(billStatus) != null) {
            BillOperationStatus curOptStatus = null;
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                curOptStatus = BillOperationStatus.VIEW;
            } else {
                String value = (String)this.getModel().getValue(billStatus);
                if ("A".equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    curOptStatus = bFromDb ? BillOperationStatus.EDIT : BillOperationStatus.ADDNEW;
                } else if ("B".equals(value)) {
                    curOptStatus = BillOperationStatus.SUBMIT;
                } else if ("C".equals(value)) {
                    curOptStatus = BillOperationStatus.AUDIT;
                }
            }
            if (curOptStatus != null) {
                this.updateCustomControlStatus(curOptStatus.getValue());
            }
        }
    }

    private void handleCustomControl(List<IHRCustomControl> iHRCustomControlList, List<CustomControl> customControlList) {
        String iHRCustomControlKeyJson = this.getView().getPageCache().get("iHRCustomControlKeyList");
        String customControlKeyJson = this.getView().getPageCache().get("customControlKeyList");
        if (StringUtils.isEmpty((CharSequence)iHRCustomControlKeyJson)) {
            FormRoot formRoot = (FormRoot)this.getView().getRootControl();
            for (Control control2 : formRoot.getItems()) {
                this.getAllCustomControl(control2, iHRCustomControlList, customControlList);
            }
            List iHRCustomControlKeyList = iHRCustomControlList.stream().map(control -> ((Control)control).getKey()).collect(Collectors.toList());
            this.getView().getPageCache().put("iHRCustomControlKeyList", SerializationUtils.toJsonString(iHRCustomControlKeyList));
            List customControlKeyList = customControlList.stream().map(Control::getKey).collect(Collectors.toList());
            this.getView().getPageCache().put("customControlKeyList", SerializationUtils.toJsonString(customControlKeyList));
        } else {
            List iHRCustomControlKeyList = SerializationUtils.fromJsonStringToList((String)iHRCustomControlKeyJson, String.class);
            iHRCustomControlList.addAll(iHRCustomControlKeyList.stream().map(key -> (IHRCustomControl)this.getView().getControl(key)).collect(Collectors.toList()));
            List customControlKeyList = SerializationUtils.fromJsonStringToList((String)customControlKeyJson, String.class);
            customControlList.addAll(customControlKeyList.stream().map(key -> (CustomControl)this.getView().getControl(key)).collect(Collectors.toList()));
        }
    }

    private void getAllCustomControl(Control control, List<IHRCustomControl> iHRCustomControlList, List<CustomControl> customControlList) {
        if (control instanceof Container) {
            for (Control children : ((Container)control).getItems()) {
                this.getAllCustomControl(children, iHRCustomControlList, customControlList);
            }
        } else if (control instanceof IHRCustomControl) {
            iHRCustomControlList.add((IHRCustomControl)control);
        } else if (control instanceof CustomControl) {
            customControlList.add((CustomControl)control);
        }
    }

    private void setFromStatus(List<IHRCustomControl> iHRCustomControlList, int status) {
        iHRCustomControlList.forEach(ihrCustomControl -> ihrCustomControl.setFormStatus(status));
    }
}

