/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.control.events.MapSelectEvent;
import kd.bos.ext.form.control.events.MapSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

@ExcludeFromJacocoGeneratedReport
public class HRDynamicFormMapPlugin
extends HRDynamicFormBasePlugin
implements MapSelectListener {
    private static final Log logger = LogFactory.getLog(HRDynamicFormMapPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        MapControl map = (MapControl)this.getView().getControl("mapcontrolap");
        map.addSelectListener((MapSelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        this.setReturnDataToParent(args);
    }

    private void setReturnDataToParent(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("donothing".equals(formOperate.getOperateKey())) {
            Object city = this.getModel().getValue("mapcity");
            Object province = this.getModel().getValue("mapprovince");
            Object address = this.getModel().getValue("mapaddress");
            if (HRStringUtils.isEmpty((String)city.toString()) && HRStringUtils.isEmpty((String)province.toString()) && HRStringUtils.isEmpty((String)address.toString())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u5730\u56fe\u4e0a\u7684\u5b9a\u4f4d\u7ea2\u70b9\uff0c\u7136\u540e\u70b9\u51fb\u786e\u5b9a\u6309\u94ae\u4ee5\u4fbf\u83b7\u53d6\u5b9a\u4f4d\u4fe1\u606f\u3002", (String)"HRDynamicFormMapPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            } else {
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put("mapcity", city);
                returnData.put("mapprovince", province);
                returnData.put("mapaddress", this.handleFiledValue(ObjectUtils.isEmpty((Object)address) ? "" : address.toString()));
                if (logger.isInfoEnabled()) {
                    logger.info("Return the positioning information to the parent page as a map collection ,setReturnDataToParent,returnData=" + SerializationUtils.toJsonString(returnData));
                }
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    private String handleFiledValue(String filedValue) {
        Object[] split;
        if (filedValue.contains("=") && !ObjectUtils.isEmpty((Object[])(split = HRStringUtils.split((String)filedValue, (String)"="))) && StringUtils.isNotBlank((CharSequence)split[1])) {
            filedValue = HRStringUtils.replace((String)split[1], (String)"}", (String)"").trim();
        }
        return filedValue;
    }

    public void select(MapSelectEvent evt) {
        this.setSelectData(evt);
    }

    private void setSelectData(MapSelectEvent evt) {
        Map map = evt.getPoint();
        IDataModel iDataModel = this.getView().getModel();
        String city = (String)map.get("city");
        String address = (String)map.get("address");
        String province = (String)map.get("province");
        iDataModel.setValue("mapcity", (Object)city);
        iDataModel.setValue("mapaddress", (Object)address);
        iDataModel.setValue("mapprovince", (Object)province);
    }
}

