/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

@ExcludeFromJacocoGeneratedReport
public class HRMapOperationPlugin
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(HRMapOperationPlugin.class);
    private static final String HRMP_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"mapaddress"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        boolean isChanged = this.getView().getModel().getDataChanged();
        if (logger.isInfoEnabled()) {
            logger.info("-----------Change Test Status Start----------------");
        }
        IDataModel iDataModel = this.getModel();
        String businessAddress = String.valueOf(iDataModel.getValue("businessaddress"));
        iDataModel.setValue("mapaddress", (Object)businessAddress);
        if (!isChanged) {
            logger.info("false");
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.setClick(evt);
    }

    private void setClick(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"mapaddress")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hbp_map");
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u8be6\u7ec6\u5730\u5740", (String)"HRMapOperationPlugin_0", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hbp_map"));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.setReturnData(closedCallBackEvent);
    }

    private void setReturnData(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel iDataModel = this.getModel();
        if (StringUtils.equals((CharSequence)"hbp_map", (CharSequence)closedCallBackEvent.getActionId())) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (logger.isInfoEnabled()) {
                logger.info("Handle Map ChildView Return Data, setReturnData,returnData=" + SerializationUtils.toJsonString((Object)returnData));
            }
            if (returnData != null) {
                Object cityObj = returnData.get("mapcity");
                String city = "";
                if (cityObj != null) {
                    city = cityObj.toString();
                }
                Object addressObj = returnData.get("mapaddress");
                String address = "";
                if (addressObj != null) {
                    address = addressObj.toString();
                }
                if (logger.isInfoEnabled()) {
                    logger.info("Handle Map ChildView Return Data,setReturnData,city=" + city + ",address=" + address);
                }
                Integer cityNumber = this.getCityNumber(city);
                if (logger.isInfoEnabled()) {
                    logger.info("Handle Map ChildView Return Data ,setReturnData,cityNumber=" + cityNumber);
                }
                iDataModel.setValue("city", (Object)cityNumber);
                iDataModel.setValue("mapaddress", (Object)address);
                iDataModel.setValue("businessaddress", (Object)address);
            }
        }
    }

    private Integer getCityNumber(String city) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bd_admindivision");
        Integer cityNumber = null;
        if (city.contains(ResManager.loadKDString((String)"\u5e02", (String)"HRMapOperationPlugin_1", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]))) {
            city = HRStringUtils.replace((String)city, (String)ResManager.loadKDString((String)"\u5e02", (String)"HRMapOperationPlugin_1", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]), (String)"");
        }
        if (!HRStringUtils.isEmpty((String)(city = this.handleFiledValue(city)))) {
            DynamicObject queryResult;
            QFilter filter = new QFilter("name", "=", (Object)city);
            QFilter[] filters = new QFilter[]{filter};
            if (logger.isInfoEnabled()) {
                logger.info("getCityNumber,city=" + city + ",filter=" + SerializationUtils.toJsonString((Object)filter));
            }
            if (null != (queryResult = serviceHelper.queryOne(filters))) {
                cityNumber = queryResult.getInt("number");
            }
        }
        return cityNumber;
    }

    private String handleFiledValue(String filedValue) {
        Object[] split;
        if (filedValue.contains("=") && !ObjectUtils.isEmpty((Object[])(split = HRStringUtils.split((String)filedValue, (String)"="))) && StringUtils.isNotBlank((CharSequence)split[1])) {
            filedValue = HRStringUtils.replace((String)split[1], (String)"}", (String)"").trim();
        }
        return filedValue;
    }
}

