/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.model.HRFilterFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;

public class HRStandardTreeList
extends StandardTreeListPlugin {
    private static final String IHRCS_PERM_SERVICE = "IHRCSBizDataPermissionService";
    private static final String IHRCS_PERMISSION_SERVICE = "IHRCSDataPermissionService";
    private static final String HRCS = "hrcs";
    private static final String PERMORGIDS = "permorgids";
    private static final String CACHE_PERM_ORG_RESULT = "perm_org_result";
    private static final String CACHE_PERM_ORG_RESULT_WITHSUB = "perm_org_result_withsub";
    private static final String PERMFILTER = "permfilter";
    public static final String PAGE_CACHE_TREE_PERM_STRUCTPROJECTIDS = "tree_perm_structprojectids";
    private String entityName;
    private String rootId = "1010";
    private boolean isInCludeChild = true;
    private static final Log LOGGER = LogFactory.getLog(HRStandardTreeList.class);

    @ExcludeFromJacocoGeneratedReport
    public HRStandardTreeList(String entityName) {
        this.entityName = entityName;
    }

    @ExcludeFromJacocoGeneratedReport
    public HRStandardTreeList(String entityName, String rootId) {
        this.entityName = entityName;
        this.rootId = rootId;
    }

    public HRStandardTreeList(String entityName, boolean isInCludeChild) {
        this.entityName = entityName;
        this.isInCludeChild = isInCludeChild;
    }

    public HRStandardTreeList(String entityName, String rootId, boolean isInCludeChild) {
        this.entityName = entityName;
        this.rootId = rootId;
        this.isInCludeChild = isInCludeChild;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
    }

    public void initializeTree(EventObject e) {
        this.initHRStandardTree();
    }

    private void initHRStandardTree() {
        TreeNode root = this.getRootNode();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    protected TreeNode getRootNode() {
        TreeNode root = new TreeNode();
        DynamicObject rootDy = this.getRootDynamicObject();
        if (rootDy == null) {
            rootDy = this.getDefaultRootDynamicObject();
        }
        if (rootDy == null) {
            root = this.getDefaultRoot();
            return root;
        }
        String rootDyId = rootDy.getString("id");
        String rootName = rootDy.getString("name");
        String rootLongNumber = rootDy.getString("longnumber");
        root.setId(rootDyId);
        root.setText(rootName);
        root.setData((Object)rootLongNumber);
        root.setParentid("");
        root.setChildren(new ArrayList());
        root.setIsOpened(true);
        return root;
    }

    protected TreeNode getDefaultRoot() {
        return new TreeNode();
    }

    protected DynamicObject getRootDynamicObject() {
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private DynamicObject getDefaultRootDynamicObject() {
        String selectFields = "id, name, longnumber";
        String rootId = this.getRootId();
        if (Pattern.matches("^[0-9]+$", rootId)) {
            return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOne(selectFields, (Object)Long.valueOf(rootId));
        }
        return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOne(selectFields, (Object)rootId);
    }

    protected List<TreeNode> getChildNodesWrap(String entityName, String parentId) {
        return this.getChildNodes(entityName, parentId);
    }

    private List<TreeNode> getChildNodes(String entityName, String parentId) {
        List<Map<String, String>> treeView = this.getTreeViewByParent(entityName, parentId);
        List<TreeNode> list = this.buildTreeChildNodes(treeView);
        return list;
    }

    protected List<TreeNode> buildTreeChildNodes(List<Map<String, String>> treeView) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        if (treeView != null && treeView.size() > 0) {
            for (Map<String, String> map : treeView) {
                nodes.add(this.genTreeNodeWrap(map));
            }
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (nodes.size() < 1) {
            return list;
        }
        HashMap<String, TreeNode> dctItems = new HashMap<String, TreeNode>(nodes.size());
        for (TreeNode node : nodes) {
            dctItems.put(node.getId(), node);
        }
        for (TreeNode node : nodes) {
            TreeNode parentNode = (TreeNode)dctItems.get(node.getParentid());
            if (parentNode != null) {
                if (parentNode.getChildren() == null) {
                    parentNode.addChildren(new ArrayList());
                }
                parentNode.getChildren().add(node);
            } else {
                list.add(node);
            }
            this.setLazyNodeLeafChildren(node);
        }
        return list;
    }

    protected void setLazyNodeLeafChildren(TreeNode node) {
    }

    protected List<Map<String, String>> getTreeViewByParentId(String entityName, String parentId) {
        return null;
    }

    private List<Map<String, String>> getTreeViewByParent(String entityName, String parentId) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        DynamicObjectCollection dyColl = this.getTreeViewCollection(entityName, parentId);
        if (dyColl == null) {
            dyColl = this.getDefaultTreeViewCollection(entityName, parentId);
        }
        if (dyColl == null || dyColl.size() == 0) {
            return list;
        }
        String parent = "parent";
        if (!HRStringUtils.isEmpty((String)entityName)) {
            Map allFields = EntityMetadataCache.getDataEntityType((String)entityName).getAllFields();
            if (allFields.containsKey("parentorg")) {
                parent = "parentorg";
            } else if (allFields.containsKey("parentorgteam")) {
                parent = "parentorgteam";
            }
        }
        for (DynamicObject dy : dyColl) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dy.getString("id"));
            map.put("name", dy.getString("name"));
            map.put("parent", dy.getString(parent));
            map.put("isleaf", dy.getBoolean("isleaf") ? "1" : "0");
            list.add(map);
        }
        return list;
    }

    protected DynamicObjectCollection getTreeViewCollection(String entityName, String parentId) {
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private DynamicObjectCollection getDefaultTreeViewCollection(String entityName, String parentId) {
        QFilter filter = null;
        if (this.isInCludeChild) {
            DynamicObject parentDy = HRBaseDaoFactory.getInstance((String)entityName).queryOne("longnumber", (Object)parentId);
            if (parentDy == null) {
                return null;
            }
            String parentLongNumber = (String)parentDy.get("longnumber");
            filter = new QFilter("longnumber", "like", (Object)(parentLongNumber + "%"));
        } else {
            filter = new QFilter("parent", "=", this.convertObj(parentId));
        }
        QFilter parentFilter = new QFilter("id", "!=", (Object)parentId);
        filter = filter.and(parentFilter);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id, name, parent, isleaf, longnumber";
        DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)entityName).queryColl(selectFields, filters, "sortcode,longnumber");
        return dyColl;
    }

    private Object convertObj(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            return value;
        }
    }

    protected TreeNode genTreeNodeWrap(Map<String, String> map) {
        return this.genTreeNode(map);
    }

    private TreeNode genTreeNode(Map<String, String> map) {
        TreeNode node = new TreeNode();
        String parentId = map.get("parent");
        node.setParentid(parentId);
        String nodeId = map.get("id");
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return node;
        }
        node.setId(nodeId);
        String nodeName = map.get("name");
        if (HRStringUtils.isEmpty((String)nodeName)) {
            return node;
        }
        node.setText(nodeName);
        String longNumber = map.get("longnumber");
        node.setData((Object)longNumber);
        String isLeaf = map.get("isleaf");
        if ("0".equals(isLeaf)) {
            ArrayList list = new ArrayList();
            node.setChildren(list);
        }
        return node;
    }

    public void refreshNode(RefreshNodeEvent refreshNodeEvent) {
        List<Object> childNodes = new ArrayList();
        String nodeId = refreshNodeEvent.getNodeId().toString();
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 15);
        if (this.getTreeModel().getRoot().getId().equals(nodeId)) {
            childNodes = this.getChildNodes(this.getEntityName(), this.getRootId());
        } else {
            childNodes = this.getChildNodes(this.getEntityName(), nodeId);
            if (childNodes.size() > 0) {
                node.setIsOpened(true);
            }
        }
        refreshNodeEvent.setChildNodes(childNodes);
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        if (!this.isInCludeChild) {
            List children;
            String currentNodeId = treeNodeEvent.getNodeId().toString();
            TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 15);
            if (currentNode != null && (children = currentNode.getChildren()) != null) {
                this.addChildNode(currentNodeId, children);
            }
        }
    }

    protected void addChildNodeWrap(String currentNodeId, List<TreeNode> children) {
        this.addChildNode(currentNodeId, children);
    }

    private void addChildNode(String currentNodeId, List<TreeNode> children) {
        int maxDepth = children.size();
        ArrayList<String> childIdList = new ArrayList<String>(maxDepth);
        for (int i = maxDepth - 1; i >= 0; --i) {
            TreeNode childNode = children.get(i);
            this.treeListView.getTreeView().deleteNode(childNode.getId());
            childIdList.add(childNode.getId());
        }
        if (maxDepth > 0) {
            TreeListModel treeListModel = (TreeListModel)this.getTreeModel();
            treeListModel.deleteNodes(childIdList, true);
        }
        List<TreeNode> childNodes = this.getChildNodesWrap(this.getEntityName(), currentNodeId);
        this.treeListView.getTreeView().addNodes(childNodes);
        if (childNodes.size() > 0) {
            TreeListModel treeListModel = (TreeListModel)this.getTreeModel();
            treeListModel.addNodes((Object)currentNodeId, childNodes);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        QFilter filter = this.buildNodeClickFilter(buildTreeListFilterEvent);
        QFilter permFiter = this.getPermFilter();
        if (filter != null) {
            filter.and(permFiter);
            buildTreeListFilterEvent.addQFilter(filter);
            buildTreeListFilterEvent.setCancel(true);
        } else if (permFiter != null) {
            buildTreeListFilterEvent.addQFilter(permFiter);
            buildTreeListFilterEvent.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.getQFilters().add(this.getPermFilter());
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    @ExcludeFromJacocoGeneratedReport
    protected List<Long> getPermOrgs() {
        List orgIds = new ArrayList(16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String orgIdsString = this.getPageCache().get(PERMORGIDS);
        if (!HRStringUtils.isEmpty((String)orgIdsString)) {
            orgIds = SerializationUtils.fromJsonStringToList((String)orgIdsString, Long.class);
            return orgIds;
        }
        AuthorizedOrgResult orgResult = this.getPermOrgResult();
        orgIds = !orgResult.isHasAllOrgPerm() ? orgResult.getHasPermOrgs() : (List)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAllAdminOrgs", (Object[])new Object[]{this.isAdminOrgFilterEnable()});
        this.getPageCache().put(PERMORGIDS, SerializationUtils.toJsonString(orgIds));
        return orgIds;
    }

    @ExcludeFromJacocoGeneratedReport
    protected AuthorizedOrgResult getPermOrgResult() {
        AuthorizedOrgResult permResult;
        boolean isIgnoreDataRule;
        Long userId = RequestContext.get().getCurrUserId();
        String orgResultString = this.getPageCache().get(CACHE_PERM_ORG_RESULT);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResult)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResult.class);
        }
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String permEntityId = listParameter.getBillFormId();
        String permItemId = "47150e89000000ac";
        Boolean isF7 = listParameter.isLookUp();
        if (isF7.booleanValue()) {
            permEntityId = HRPermUtil.getF7ParentEntityId(this.getView());
            permItemId = HRPermUtil.getF7ParentPermItemId(this.getView());
        }
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = this.getAppIdWithDealThirdApp((FormShowParameter)listParameter, permEntityId);
        if (this.isCheckIgnoreConfig() && (isIgnoreDataRule = ((Boolean)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"isIgnoreEntityDataRule", (Object[])new Object[]{appId, permEntityId})).booleanValue())) {
            AuthorizedOrgResult permResult2 = AuthorizedOrgResult.allOrg();
            this.getPageCache().put(CACHE_PERM_ORG_RESULT, SerializationUtils.toJsonString((Object)permResult2));
            return permResult2;
        }
        if (isF7.booleanValue()) {
            String propByEntity = this.getPropByEntity(permEntityId);
            String parentF7Prop = HRStringUtils.isNotEmpty((String)propByEntity) ? propByEntity : this.getParentF7Prop(listParameter);
            permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getUserAdminOrgsF7", (Object[])new Object[]{userId, appId, permEntityId, permItemId, parentF7Prop, this.getStructProjectCustomInParam(parentF7Prop)});
        } else {
            String propByEntity = this.getPropByEntity(permEntityId);
            String listPermProKey = HRStringUtils.isNotEmpty((String)propByEntity) ? propByEntity : this.getListPermProKey();
            permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getUserAdminOrgs", (Object[])new Object[]{userId, appId, permEntityId, permItemId, listPermProKey, this.getStructProjectCustomInParam(listPermProKey)});
        }
        this.getPageCache().put(CACHE_PERM_ORG_RESULT, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    protected AuthorizedOrgTeamResult getPermOrgTeamResult() {
        AuthorizedOrgTeamResult permResult;
        boolean isIgnoreDataRule;
        Long userId = RequestContext.get().getCurrUserId();
        String orgResultString = this.getPageCache().get("CACHE_PERM_ORG_TEAM_RESULT");
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgTeamResult)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgTeamResult.class);
        }
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String permEntityId = listParameter.getBillFormId();
        String permItemId = "47150e89000000ac";
        Boolean isF7 = listParameter.isLookUp();
        if (isF7.booleanValue()) {
            permEntityId = HRPermUtil.getF7ParentEntityId(this.getView());
            permItemId = HRPermUtil.getF7ParentPermItemId(this.getView());
        }
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = this.getAppIdWithDealThirdApp((FormShowParameter)listParameter, permEntityId);
        if (this.isCheckIgnoreConfig() && (isIgnoreDataRule = ((Boolean)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"isIgnoreEntityDataRule", (Object[])new Object[]{appId, permEntityId})).booleanValue())) {
            AuthorizedOrgTeamResult permResult2 = AuthorizedOrgTeamResult.allOrg();
            this.getPageCache().put(CACHE_PERM_ORG_RESULT, SerializationUtils.toJsonString((Object)permResult2));
            return permResult2;
        }
        if (isF7.booleanValue()) {
            String propByEntity = this.getPropByEntity(permEntityId);
            String parentF7Prop = HRStringUtils.isNotEmpty((String)propByEntity) ? propByEntity : this.getParentF7Prop(listParameter);
            permResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{userId, appId, permEntityId, permItemId, parentF7Prop});
        } else {
            String propByEntity = this.getPropByEntity(permEntityId);
            String listPermProKey = HRStringUtils.isNotEmpty((String)propByEntity) ? propByEntity : this.getListPermProKey();
            permResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedOrgTeams", (Object[])new Object[]{userId, appId, permEntityId, permItemId, listPermProKey});
        }
        this.getPageCache().put("CACHE_PERM_ORG_TEAM_RESULT", SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        AuthorizedOrgResultWithSub permResult;
        boolean isIgnoreDataRule;
        Long userId = RequestContext.get().getCurrUserId();
        String orgResultString = this.getPageCache().get(CACHE_PERM_ORG_RESULT_WITHSUB);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResultWithSub)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResultWithSub.class);
        }
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String permEntityId = listParameter.getBillFormId();
        String permItemId = "47150e89000000ac";
        Boolean isF7 = listParameter.isLookUp();
        if (isF7.booleanValue()) {
            permEntityId = HRPermUtil.getF7ParentEntityId(this.getView());
            permItemId = HRPermUtil.getF7ParentPermItemId(this.getView());
        }
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = this.getAppIdWithDealThirdApp((FormShowParameter)listParameter, permEntityId);
        if (this.isCheckIgnoreConfig() && (isIgnoreDataRule = ((Boolean)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"isIgnoreEntityDataRule", (Object[])new Object[]{appId, permEntityId})).booleanValue())) {
            AuthorizedOrgResultWithSub permResult2 = AuthorizedOrgResultWithSub.allOrg();
            this.getPageCache().put(CACHE_PERM_ORG_RESULT, SerializationUtils.toJsonString((Object)permResult2));
            return permResult2;
        }
        if (isF7.booleanValue()) {
            String propByEntity = this.getPropByEntity(permEntityId);
            String parentF7Prop = HRStringUtils.isNotEmpty((String)propByEntity) ? propByEntity : this.getParentF7Prop(listParameter);
            permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getUserAdminOrgsF7WithSub", (Object[])new Object[]{userId, appId, permEntityId, permItemId, parentF7Prop, this.getStructProjectCustomInParam(parentF7Prop)});
        } else {
            String propByEntity = this.getPropByEntity(permEntityId);
            String listPermProKey = HRStringUtils.isNotEmpty((String)propByEntity) ? propByEntity : this.getListPermProKey();
            permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getUserAdminOrgsWithSub", (Object[])new Object[]{userId, appId, permEntityId, permItemId, listPermProKey, this.getStructProjectCustomInParam(listPermProKey)});
        }
        this.getPageCache().put(CACHE_PERM_ORG_RESULT_WITHSUB, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    protected String getListPermProKey() {
        return null;
    }

    public final String getPropByEntity(String entityNumber) {
        String propKey = (String)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getOrgTreePermPropCfg", (Object[])new Object[]{entityNumber});
        LOGGER.info("getPropByEntity entityNumber:{},propKey:{}", (Object)entityNumber, (Object)propKey);
        return propKey;
    }

    protected QFilter getListPermFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ListShowParameter listParameter = (ListShowParameter)formShowParameter;
        String permEntityId = listParameter.getBillFormId();
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String entryAppId = HRPermUtil.getAppIdFromShowParam(formShowParameter);
        String appId = AppIdServiceHelper.getPermAppId((String)entryAppId, (String)permEntityId);
        QFilter permFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERMISSION_SERVICE, (String)"getDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, permEntityId, "47150e89000000ac", Maps.newHashMap()});
        return permFilter;
    }

    private String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = HRPermUtil.getAppIdFromShowParam(showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    protected boolean isCheckIgnoreConfig() {
        return true;
    }

    private String getParentF7Prop(ListShowParameter listParameter) {
        return this.getParentF7PropWrap(listParameter);
    }

    protected String getParentF7PropWrap(ListShowParameter listParameter) {
        return listParameter.getCloseCallBack().getControlKey();
    }

    protected boolean isAdminOrgFilterEnable() {
        return false;
    }

    protected QFilter getPermFilter() {
        return null;
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        return null;
    }

    protected HRFilterFieldInfo getHRFilterFieldInfo() {
        return new HRFilterFieldInfo(new ArrayList());
    }

    public void initTreeToolbar(EventObject eventObject) {
        super.initTreeToolbar(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getRootId() {
        return this.rootId;
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    public boolean isInCludeChild() {
        return this.isInCludeChild;
    }

    public void setInCludeChild(boolean isInCludeChild) {
        this.isInCludeChild = isInCludeChild;
    }

    @ExcludeFromJacocoGeneratedReport
    public String getAppId() {
        String permEntityId = this.getListEntityNumber();
        String entryAppId = HRPermUtil.getAppIdFromShowParam(this.getView().getFormShowParameter());
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)permEntityId);
    }

    public String getListEntityNumber() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ListShowParameter listParameter = (ListShowParameter)formShowParameter;
        String permEntityId = listParameter.getBillFormId();
        return QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
    }

    public final List<Long> getStructProjectIdsFromCache() {
        String ids = this.getView().getPageCache().get(PAGE_CACHE_TREE_PERM_STRUCTPROJECTIDS);
        if (ids != null) {
            return SerializationUtils.fromJsonStringToList((String)ids, Long.class);
        }
        return new ArrayList<Long>();
    }

    private Map<String, Object> getStructProjectCustomInParam(String prop) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hr_dataperm_structprojectid_prop_" + prop, this.getStructProjectIdsFromCache());
        return map;
    }
}

