/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.activity;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.ActivityServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.activity.ActivityTplParentPlugin;

@ExcludeFromJacocoGeneratedReport
public class ActivityBillTplPlugin
extends ActivityTplParentPlugin {
    private static final Log LOGGER = LogFactory.getLog(ActivityBillTplPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"consent", "reject", "terminate", "transfer", "viewflowpicture"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == null || pkValue == 0L) {
            return;
        }
        String name = this.getModel().getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(name);
        DynamicObject billDy = serviceHelper.loadSingle((Object)pkValue);
        long activityInsId = billDy.getLong("activityins.id");
        DynamicObject activityInsItem = ActivityServiceHelper.getActivityInsById(null, (Long)activityInsId);
        if (activityInsItem == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"consent", "reject", "terminate", "transfer"});
        } else {
            Object status = activityInsItem.get("taskstatus");
            if ("20".equals(status) || "10".equals(status)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"consent", "reject", "terminate", "transfer"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"consent", "reject", "terminate", "transfer"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (!operation.contains(operateKey)) {
            return;
        }
        String name = this.getModel().getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(name);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == null || pkValue == 0L) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"ActivityBillTplPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject billDy = serviceHelper.loadSingle((Object)pkValue);
        long activityInsId = billDy.getLong("activityins.id");
        DynamicObject activityInsItem = ActivityServiceHelper.getActivityInsById(null, (Long)activityInsId);
        if (activityInsItem == null && !"viewflowpicture".equals(operateKey)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3b\u52a8\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActivityBillTplPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!("viewflowpicture".equals(operateKey) || "transfer".equals(operateKey) || "reject".equals(operateKey))) {
            this.updateDealUser(billDy, serviceHelper);
        }
        super.doOperation(args, operateKey, activityInsId, activityInsItem, this.getView(), billDy);
    }
}

