/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.bgtask;

import kd.bos.form.IFormView;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import org.apache.commons.lang.StringUtils;

public class AbstractBizTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs args) {
        TaskInfo taskInfo = this.queryTask();
        IFormView parentView = this.getBizParentView();
        if (taskInfo.isTaskEnd()) {
            HRBackgroundTaskHelper helper = HRBackgroundTaskHelper.getInstance();
            helper.confirmEndTask(this.getTaskId(), taskInfo.getStatus(), false);
            args.setClearTask(true);
            this.excuteOnEndTask(parentView);
        } else {
            long timeout_MS = 1000 * this.getJobFormInfo().getTimeout();
            if (taskInfo.getRunTime() + timeout_MS < System.currentTimeMillis()) {
                HRBackgroundTaskHelper helper = HRBackgroundTaskHelper.getInstance();
                helper.confirmEndTask(this.getTaskId(), "TIMEOUT", false);
                args.setClearTask(true);
                this.excuteOnOvertimeTask(parentView);
            } else {
                this.excuteOnRunningTask(parentView);
            }
        }
    }

    public IFormView getBizParentView() {
        IFormView parentView = this.getParentView();
        if (parentView == null || parentView.getMainView() == null || !StringUtils.equals((String)parentView.getMainView().getPageId(), (String)this.getMainView().getPageId())) {
            return this.getMainView();
        }
        return parentView;
    }

    protected void excuteOnEndTask(IFormView parentView) {
    }

    protected void excuteOnOvertimeTask(IFormView parentView) {
    }

    protected void excuteOnRunningTask(IFormView parentView) {
    }

    public boolean release() {
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo.isTaskEnd()) {
            HRBackgroundTaskHelper.getInstance().confirmEndTask(this.getTaskId(), taskInfo.getStatus());
            return true;
        }
        return false;
    }

    public TaskInfo queryTask() {
        return HRBackgroundTaskHelper.getInstance().getTaskInfo(this.getTaskId());
    }

    public JobFormInfo getJobFormInfo() {
        return HRBackgroundTaskHelper.getInstance().getJobFormInfoByTaskId(this.getTaskId());
    }

    public boolean isExistProgressForm() {
        IFormView progressView;
        String progressPageId = HRBackgroundTaskHelper.getInstance().getProgressPageId(this.getMainView(), this.getTaskId());
        return !StringUtils.isEmpty((String)progressPageId) && (progressView = this.getMainView().getViewNoPlugin(progressPageId)) != null;
    }

    public void setProgressPageId(String progressPageId) {
        HRBackgroundTaskHelper.getInstance().setProgressPageId(this.getMainView(), this.getTaskId(), progressPageId);
    }

    public void clearProgressPageId() {
        HRBackgroundTaskHelper.getInstance().removeProgressPageId(this.getMainView(), this.getTaskId());
    }
}

