/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.control;

import java.util.Date;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.CredentialsInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class CredentialsPlugin
extends HRDynamicFormBasePlugin
implements ICloseCallBack {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"editap"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.setCredentialsCard();
    }

    private void setCredentialsCard() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bgImageKey = (String)formShowParameter.getCustomParam("bgImageKey");
        String credentialsType = (String)formShowParameter.getCustomParam("credentialsType");
        boolean countryCodeRight = (Boolean)formShowParameter.getCustomParam("countryCodeRight");
        String otherInfoName = (String)formShowParameter.getCustomParam("otherInfoName");
        boolean credentialsToolBar = (Boolean)formShowParameter.getCustomParam("credentialsToolBar");
        Long credentialsPK = (Long)formShowParameter.getCustomParam("credentialsPK");
        String credentialsInfoAPP = (String)formShowParameter.getCustomParam("credentialsInfoAPP");
        String credentialsInfoInterface = (String)formShowParameter.getCustomParam("credentialsInfoInterface");
        String credentialsInfoMethod = (String)formShowParameter.getCustomParam("credentialsInfoMethod");
        CredentialsInfo credentialsInfo = (CredentialsInfo)HRMServiceHelper.invokeHRService((String)credentialsInfoAPP, (String)credentialsInfoInterface, (String)credentialsInfoMethod, (Object[])new Object[]{credentialsPK});
        String personName = credentialsInfo.getPersonName();
        String credentialsNo = credentialsInfo.getCredentialsNo();
        String countryCode = credentialsInfo.getCountryCode();
        Date expirationDate = credentialsInfo.getExpirationDate();
        boolean isnofixedterm = credentialsInfo.isIsnofixedterm();
        String otherInfo = credentialsInfo.getOtherInfo();
        if (!credentialsToolBar) {
            Container cardPanel = (Container)this.getControl("cardflexpanelap");
            cardPanel.setBackgroundImg(bgImageKey);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarpanelap"});
        } else {
            Container allPanel = (Container)this.getControl("mainflexpanelap");
            allPanel.setBackgroundImg(bgImageKey);
        }
        Label personNameLbl = (Label)this.getControl("personnameap");
        personNameLbl.setText(personName);
        Label credentialStypeLbl = (Label)this.getControl("credentialstypeap");
        credentialStypeLbl.setText(credentialsType);
        Label credentialsNoLbl = (Label)this.getControl("credentialsnoap");
        credentialsNoLbl.setText(credentialsNo);
        this.setCountryCode(countryCodeRight, countryCode, expirationDate, isnofixedterm);
        Label otherInfoNameLbl = (Label)this.getControl("otherinfonameap");
        otherInfoNameLbl.setText(otherInfoName);
        Label otherInfoLbl = (Label)this.getControl("otherinfoap");
        otherInfoLbl.setText(otherInfo);
    }

    private void setCountryCode(boolean countryCodeRight, String countryCode, Date expirationDate, boolean isnofixedterm) {
        Label expirationDateLbl = (Label)this.getControl("expirationdateap");
        if (isnofixedterm) {
            expirationDateLbl.setText(ResManager.loadKDString((String)"\u81f3\u4eca", (String)"CredentialsPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        } else {
            String expirationDateStr = expirationDate != null ? HRDateTimeUtils.format((Date)expirationDate, (String)"yyyy.mm.dd") : ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"CredentialsPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            expirationDateLbl.setText(expirationDateStr);
        }
        if (countryCodeRight) {
            Label countryCodeLbl = (Label)this.getControl("countrycodeap");
            countryCodeLbl.setText(countryCode);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"countrycodenameap,countrycodeap"});
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "editap": {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String credentialsEditForm = (String)formShowParameter.getCustomParam("credentialsEditForm");
                Long credentialsPK = (Long)formShowParameter.getCustomParam("credentialsPK");
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setFormId(credentialsEditForm);
                baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
                baseShowParameter.setPkId((Object)credentialsPK);
                baseShowParameter.setStatus(OperationStatus.EDIT);
                baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)baseShowParameter);
                break;
            }
            case "deleteap": {
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)this.getView().getEntityId())) {
            this.getView().close();
        }
    }
}

