/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.datagrade;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.datagrade.control.DataGradeDecisionTable;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.datagrade.ConditionValueVO;
import kd.hr.hbp.common.datagrade.DataGradeTableVO;
import kd.hr.hbp.common.datagrade.DefValue;
import kd.hr.hbp.common.datagrade.DefaultResult;
import kd.hr.hbp.common.datagrade.EntryVO;
import kd.hr.hbp.common.datagrade.ParamVO;
import kd.hr.hbp.common.datagrade.ParamValue;
import kd.hr.hbp.common.datagrade.ResultValue;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import org.apache.commons.lang3.StringUtils;

public class DataGradeEdit
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(DataGradeEdit.class);
    private static final String NUMBER_CHECK_REP = "^[A-Za-z0-9 +\\-/\\\\*(){}\\[\\]=<>@!`#$|%^&'\"~_:;.,?]+$";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[A-Za-z0-9 +\\-/\\\\*(){}\\[\\]=<>@!`#$|%^&'\"~_:;.,?]+$");
    private static final String CONFIGURATION_BTN = "configurationbtn";
    private static final String ANALOG_OPERATION_BTN = "analogoperationbtn";
    private static final String CONFIG_CALLBACK_KEY = "configCallbackKey";
    private static final String CONTROL_EMPTY_FLEX = "emptyflex";
    public static final String DATAGRADEDECISIONTABLEAP_ALLVALUE = "datagradedecisiontableap#$_allvalue";
    public static final String DATAGRADEDECISIONTABLEAP_VALUE = "datagradedecisiontableap#$_value";
    public static final String DATAGRADEDECISIONTABLEAP_DEFVALUE = "datagradedecisiontableap#$_defvalue";

    public void registerListener(EventObject eventObject) {
        try {
            super.registerListener(eventObject);
            this.addClickListeners(new String[]{CONFIGURATION_BTN, ANALOG_OPERATION_BTN});
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void beforeBindData(EventObject e) {
        try {
            super.beforeBindData(e);
            BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Object currentDataId = this.getView().getFormShowParameter().getCustomParam("currentDataId");
            if (baseShowParameter.getPkId() != null) {
                long id;
                this.getView().setVisible(Boolean.TRUE, new String[]{"datagradedecisiontableap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_EMPTY_FLEX});
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(this.getView().getModel().getDataEntityType().getName());
                if (baseShowParameter.getPkId() instanceof String) {
                    String idStr = (String)baseShowParameter.getPkId();
                    id = Long.parseLong(idStr);
                } else {
                    id = (Long)baseShowParameter.getPkId();
                }
                DynamicObject dynamicObject = hrBaseServiceHelper.queryOriginalOne("datagradeparam", (Object)id);
                String datagradeparam = dynamicObject.getString("datagradeparam");
                DataGradeDecisionTable dataGradeDecisionTable = (DataGradeDecisionTable)this.getView().getControl("datagradedecisiontableap");
                try {
                    DataGradeTableVO dataGradeTableVO = (DataGradeTableVO)HRJSONUtils.cast((String)datagradeparam, DataGradeTableVO.class);
                    BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
                    if (billStatus.equals((Object)BillOperationStatus.EDIT) || billStatus.equals((Object)BillOperationStatus.ADDNEW)) {
                        dataGradeTableVO.setBillStatus("edit");
                    } else {
                        dataGradeTableVO.setBillStatus("view");
                    }
                    dataGradeDecisionTable.updateControlData(HRJSONUtils.toString((Object)dataGradeTableVO));
                    this.getPageCache().put(DATAGRADEDECISIONTABLEAP_VALUE, HRJSONUtils.toString((Object)dataGradeTableVO.getValue()));
                    this.getPageCache().put(DATAGRADEDECISIONTABLEAP_DEFVALUE, HRJSONUtils.toString((Object)dataGradeTableVO.getDefValue()));
                }
                catch (IOException ioException) {
                    LOGGER.error("kd.hr.hbp.formplugin.web.datagrade.DataGradeEdit.beforeBindData{}", (Object)ioException.getMessage());
                }
            } else if (!Objects.isNull(currentDataId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"datagradedecisiontableap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_EMPTY_FLEX});
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(this.getView().getModel().getDataEntityType().getName());
                DynamicObject dynamicObject = hrBaseServiceHelper.queryOriginalOne("datagradeparam", currentDataId);
                String datagradeparam = dynamicObject.getString("datagradeparam");
                DataGradeDecisionTable dataGradeDecisionTable = (DataGradeDecisionTable)this.getView().getControl("datagradedecisiontableap");
                try {
                    DataGradeTableVO dataGradeTableVO = (DataGradeTableVO)HRJSONUtils.cast((String)datagradeparam, DataGradeTableVO.class);
                    dataGradeTableVO.setBillStatus("edit");
                    this.getPageCache().put(DATAGRADEDECISIONTABLEAP_VALUE, HRJSONUtils.toString((Object)dataGradeTableVO.getValue()));
                    this.getPageCache().put(DATAGRADEDECISIONTABLEAP_DEFVALUE, HRJSONUtils.toString((Object)dataGradeTableVO.getDefValue()));
                    dataGradeDecisionTable.updateControlData(HRJSONUtils.toString((Object)dataGradeTableVO));
                }
                catch (IOException ioException) {
                    LOGGER.error("kd.hr.hbp.formplugin.web.datagrade.DataGradeEdit.beforeBindData:{}", (Object)ioException.getMessage());
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"datagradedecisiontableap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_EMPTY_FLEX});
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        try {
            super.afterDoOperation(afterDoOperationEventArgs);
            DataGradeDecisionTable dataGradeDecisionTable = (DataGradeDecisionTable)this.getView().getControl("datagradedecisiontableap");
            FormOperate fo = (FormOperate)afterDoOperationEventArgs.getSource();
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            String fromPage = (String)this.getView().getFormShowParameter().getCustomParam("fromPage");
            LOGGER.info("kd.hr.hbp.formplugin.web.datagrade.DataGradeEdit.afterDoOperation:" + fo.getOperateKey());
            if ("unsubmit".equalsIgnoreCase(fo.getOperateKey()) || "unaudit".equalsIgnoreCase(fo.getOperateKey())) {
                dataGradeDecisionTable.updateBillStatus("edit");
            } else if ("submit".equalsIgnoreCase(fo.getOperateKey()) && operationResult.isSuccess()) {
                dataGradeDecisionTable.updateBillStatus("view");
            }
            String formId = this.getView().getModel().getDataEntityType().getName();
            if ("save".equalsIgnoreCase(fo.getOperateKey())) {
                if ("revise".equalsIgnoreCase(fromPage) && operationResult.isSuccess()) {
                    dataGradeDecisionTable.updateBillStatus("view");
                } else {
                    boolean audit = HRBaseDataConfigUtil.getAudit((String)formId);
                    if (operationResult.isSuccess() && !audit) {
                        if (this.isStartLogHis()) {
                            LOGGER.info("kd.hr.hbp.formplugin.web.datagrade.DataGradeEdit.afterDoOperation isStartLogHis:" + fo.getOperateKey());
                            dataGradeDecisionTable.updateBillStatus("view");
                        } else {
                            dataGradeDecisionTable.updateBillStatus("edit");
                        }
                    }
                }
            }
            if (("confirmchangenoaudit".equalsIgnoreCase(fo.getOperateKey()) || "confirmchange".equalsIgnoreCase(fo.getOperateKey())) && operationResult.isSuccess()) {
                dataGradeDecisionTable.updateBillStatus("view");
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    private boolean isStartLogHis() {
        String enable = (String)this.getModel().getValue("enable");
        String status = (String)this.getModel().getValue("status");
        return HRStringUtils.equals((String)status, (String)"C") && !HRStringUtils.equals((String)enable, (String)"10");
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            Control source = (Control)evt.getSource();
            if (CONFIGURATION_BTN.equals(source.getKey())) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("hbp_datagradeparam");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONFIG_CALLBACK_KEY));
                String allValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_ALLVALUE);
                showParameter.setCustomParam("datagradeparam", (Object)allValueStr);
                this.getView().showForm(showParameter);
            } else if (ANALOG_OPERATION_BTN.equals(source.getKey())) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("hbp_dgsimulatecal");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                String allValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_ALLVALUE);
                String valueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_VALUE);
                String defValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_DEFVALUE);
                if (HRStringUtils.isEmpty((String)allValueStr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u53c2\u6570\u518d\u8fdb\u884c\u6a21\u62df\u8fd0\u7b97\u3002", (String)"DataGradeEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    return;
                }
                try {
                    DataGradeTableVO dataGradeTableVO = (DataGradeTableVO)HRJSONUtils.cast((String)allValueStr, DataGradeTableVO.class);
                    List paramValue = HRStringUtils.isEmpty((String)valueStr) ? new ArrayList(10) : (List)HRJSONUtils.cast((String)valueStr, List.class, (Class[])new Class[]{ParamValue.class});
                    DefValue defValue = HRStringUtils.isEmpty((String)defValueStr) ? new DefValue() : (DefValue)HRJSONUtils.cast((String)defValueStr, DefValue.class);
                    dataGradeTableVO.setValue(paramValue);
                    dataGradeTableVO.setDefValue(defValue);
                    showParameter.setCustomParam("datagradeparam", (Object)HRJSONUtils.toString((Object)dataGradeTableVO));
                    this.getView().showForm(showParameter);
                }
                catch (IOException e) {
                    LOGGER.error("simulate_cal_DataGradeTableVO_cast_error", (Throwable)e);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        try {
            super.beforeClosed(beforeClosedEvent);
            String allValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_ALLVALUE);
            if (allValueStr == null) {
                return;
            }
            try {
                DataGradeTableVO dataGradeTableVO = (DataGradeTableVO)HRJSONUtils.cast((String)allValueStr, DataGradeTableVO.class);
                String valueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_VALUE);
                String defValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_DEFVALUE);
                if (valueStr == null || defValueStr == null) {
                    return;
                }
                List paramValue = (List)HRJSONUtils.cast((String)valueStr, List.class, (Class[])new Class[]{ParamValue.class});
                DefValue defValue = (DefValue)HRJSONUtils.cast((String)defValueStr, DefValue.class);
                dataGradeTableVO.setDefValue(defValue);
                dataGradeTableVO.setValue(paramValue);
                dataGradeTableVO.setBillStatus("view");
                this.getModel().setValue("datagradeparam", (Object)HRJSONUtils.toString((Object)dataGradeTableVO));
                this.setUniqueCode();
            }
            catch (IOException e) {
                LOGGER.error("kd.hr.hbp.formplugin.web.datagrade.DataGradeEdit.beforeClosed:{}", (Object)e.getMessage());
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            super.beforeDoOperation(args);
            FormOperate fo = (FormOperate)args.getSource();
            if ("save".equalsIgnoreCase(fo.getOperateKey()) || "confirmchangenoaudit".equalsIgnoreCase(fo.getOperateKey()) || "confirmchange".equalsIgnoreCase(fo.getOperateKey()) || "submit".equalsIgnoreCase(fo.getOperateKey())) {
                String number = (String)this.getModel().getValue("number");
                if (!NUMBER_PATTERN.matcher(number).matches()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u4e2d\u6587\u5b57\u7b26\u3002", (String)"HRDataGradeValidator_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String allValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_ALLVALUE);
                String valueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_VALUE);
                String defValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_DEFVALUE);
                Long id = (Long)this.getModel().getDataEntity().getPkValue();
                if (Objects.isNull(id) || 0L == id) {
                    this.getModel().setValue("id", (Object)ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType()));
                }
                if (StringUtils.isEmpty((CharSequence)allValueStr) || StringUtils.isEmpty((CharSequence)valueStr) || StringUtils.isEmpty((CharSequence)defValueStr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                try {
                    DataGradeTableVO dataGradeTableVO = (DataGradeTableVO)HRJSONUtils.cast((String)allValueStr, DataGradeTableVO.class);
                    List paramValue = (List)HRJSONUtils.cast((String)valueStr, List.class, (Class[])new Class[]{ParamValue.class});
                    DefValue defValue = (DefValue)HRJSONUtils.cast((String)defValueStr, DefValue.class);
                    if (paramValue.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    dataGradeTableVO.setDefValue(defValue);
                    dataGradeTableVO.setValue(paramValue);
                    dataGradeTableVO.setBillStatus("view");
                    String returnStr = dataGradeTableVO.validateData();
                    if (!StringUtils.isEmpty((CharSequence)returnStr)) {
                        this.getView().showTipNotification(returnStr);
                        args.setCancel(true);
                        return;
                    }
                    this.getModel().setValue("datagradeparam", (Object)HRJSONUtils.toString((Object)dataGradeTableVO));
                    this.setUniqueCode();
                }
                catch (IOException e) {
                    LOGGER.error("kd.hr.hbp.formplugin.web.datagrade.DataGradeEdit.beforeDoOperation:{}", (Object)e.getMessage());
                    args.setCancel(true);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        try {
            super.closedCallBack(closedCallBackEvent);
            String actionId = closedCallBackEvent.getActionId();
            if (CONFIG_CALLBACK_KEY.equals(actionId)) {
                String returnData = (String)closedCallBackEvent.getReturnData();
                if (HRStringUtils.isEmpty((String)returnData)) {
                    if (this.getPageCache().get(DATAGRADEDECISIONTABLEAP_ALLVALUE) == null) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"datagradedecisiontableap"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_EMPTY_FLEX});
                    }
                    return;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"datagradedecisiontableap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_EMPTY_FLEX});
                DataGradeDecisionTable dataGradeDecisionTable = (DataGradeDecisionTable)this.getView().getControl("datagradedecisiontableap");
                String allValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_ALLVALUE);
                if (HRStringUtils.isEmpty((String)allValueStr)) {
                    try {
                        DataGradeTableVO dataGradeTableVO = (DataGradeTableVO)HRJSONUtils.cast((String)returnData, DataGradeTableVO.class);
                        dataGradeTableVO.setBillStatus("edit");
                        dataGradeDecisionTable.updateControlData(HRJSONUtils.toString((Object)dataGradeTableVO));
                    }
                    catch (IOException e) {
                        LOGGER.error((Throwable)e);
                    }
                } else {
                    try {
                        DataGradeTableVO dataGradeTableVO = (DataGradeTableVO)HRJSONUtils.cast((String)returnData, DataGradeTableVO.class);
                        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
                        if (billStatus.equals((Object)BillOperationStatus.EDIT) || billStatus.equals((Object)BillOperationStatus.ADDNEW)) {
                            dataGradeTableVO.setBillStatus("edit");
                        } else {
                            dataGradeTableVO.setBillStatus("view");
                        }
                        String valueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_VALUE);
                        String defValueStr = this.getPageCache().get(DATAGRADEDECISIONTABLEAP_DEFVALUE);
                        if (!HRStringUtils.isEmpty((String)valueStr)) {
                            List paramValue = (List)HRJSONUtils.cast((String)valueStr, List.class, (Class[])new Class[]{ParamValue.class});
                            this.compareValue(paramValue, dataGradeTableVO.getHead());
                            dataGradeTableVO.setValue(paramValue);
                            this.getPageCache().put(DATAGRADEDECISIONTABLEAP_VALUE, HRJSONUtils.toString((Object)paramValue));
                        }
                        if (!HRStringUtils.isEmpty((String)defValueStr)) {
                            DefValue defValue = (DefValue)HRJSONUtils.cast((String)defValueStr, DefValue.class);
                            this.compareDefValue(defValue.getDefaultValue(), dataGradeTableVO.getHead());
                            dataGradeTableVO.setDefValue(defValue);
                            this.getPageCache().put(DATAGRADEDECISIONTABLEAP_DEFVALUE, HRJSONUtils.toString((Object)defValue));
                        }
                        dataGradeDecisionTable.updateControlData(HRJSONUtils.toString((Object)dataGradeTableVO));
                    }
                    catch (IOException e) {
                        LOGGER.error("kd.hr.hbp.formplugin.web.datagrade.DataGradeEdit.closedCallBack {}", (Object)e.getMessage());
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    private void compareDefValue(List<DefaultResult> defaultResultList, ParamVO head) {
        List newResult = head.getResult();
        List newRIds = newResult.stream().map(EntryVO::getId).collect(Collectors.toList());
        Map newResultMap = newResult.stream().collect(Collectors.toMap(EntryVO::getId, Function.identity()));
        List oldRIds = defaultResultList.stream().map(DefaultResult::getId).collect(Collectors.toList());
        newResultMap.keySet().removeAll(oldRIds);
        if (newResultMap.size() > 0) {
            for (Map.Entry longEntryVOEntry : newResultMap.entrySet()) {
                DefaultResult defaultResult2 = new DefaultResult();
                defaultResult2.setId(longEntryVOEntry.getKey().longValue());
                defaultResult2.setValue("");
                defaultResult2.setBasedataId("");
                defaultResult2.setBasedatafield(((EntryVO)longEntryVOEntry.getValue()).getBasedatafield() == null ? "" : ((EntryVO)longEntryVOEntry.getValue()).getBasedatafield());
                defaultResult2.setPropsName(((EntryVO)longEntryVOEntry.getValue()).getPropsName() == null ? "" : ((EntryVO)longEntryVOEntry.getValue()).getPropsName());
                defaultResultList.add(defaultResult2);
            }
        }
        oldRIds.removeAll(newRIds);
        if (oldRIds.size() > 0) {
            defaultResultList.removeIf(defaultResult -> oldRIds.contains(defaultResult.getId()));
        }
    }

    private void compareValue(List<ParamValue> paramValue, ParamVO head) {
        List conditionListVO = head.getCondition();
        List newCIds = conditionListVO.stream().map(EntryVO::getId).collect(Collectors.toList());
        Map newConditionMap = conditionListVO.stream().collect(Collectors.toMap(EntryVO::getId, Function.identity()));
        for (ParamValue value : paramValue) {
            List conditionList = value.getCondition();
            List oldCIds = conditionList.stream().map(ConditionValueVO::getId).collect(Collectors.toList());
            newConditionMap.keySet().removeAll(oldCIds);
            if (newConditionMap.size() > 0) {
                for (Map.Entry longEntryVOEntry : newConditionMap.entrySet()) {
                    ConditionValueVO conditionValueVO2 = new ConditionValueVO();
                    conditionValueVO2.setId(longEntryVOEntry.getKey().longValue());
                    conditionValueVO2.setCompare("and");
                    conditionValueVO2.setValue(new ArrayList());
                    conditionValueVO2.setBasedatafield(((EntryVO)longEntryVOEntry.getValue()).getBasedatafield() == null ? "" : ((EntryVO)longEntryVOEntry.getValue()).getBasedatafield());
                    conditionValueVO2.setPropsName(((EntryVO)longEntryVOEntry.getValue()).getPropsName() == null ? "" : ((EntryVO)longEntryVOEntry.getValue()).getPropsName());
                    conditionList.add(conditionValueVO2);
                }
            }
            oldCIds.removeAll(newCIds);
            if (oldCIds.size() > 0) {
                conditionList.removeIf(conditionValueVO -> oldCIds.contains(conditionValueVO.getId()));
            }
            for (ConditionValueVO conditionValueVO3 : conditionList) {
                for (EntryVO entryVO : conditionListVO) {
                    if (conditionValueVO3.getId() != entryVO.getId() || StringUtils.equalsIgnoreCase((CharSequence)conditionValueVO3.getPropsName(), (CharSequence)entryVO.getPropsName())) continue;
                    conditionValueVO3.setCompare("and");
                    conditionValueVO3.setValue(new ArrayList());
                    conditionValueVO3.setBasedatafield(entryVO.getBasedatafield());
                    conditionValueVO3.setPropsName(entryVO.getPropsName());
                }
            }
        }
        List newResult = head.getResult();
        List newRIds = newResult.stream().map(EntryVO::getId).collect(Collectors.toList());
        Map newResultMap = newResult.stream().collect(Collectors.toMap(EntryVO::getId, Function.identity()));
        for (ParamValue value : paramValue) {
            List oldResult = value.getResult();
            List oldRIds = oldResult.stream().map(ResultValue::getId).collect(Collectors.toList());
            newResultMap.keySet().removeAll(oldRIds);
            if (newResultMap.size() > 0) {
                for (Map.Entry longEntryVOEntry : newResultMap.entrySet()) {
                    ResultValue resultValue2 = new ResultValue();
                    resultValue2.setId(longEntryVOEntry.getKey().longValue());
                    resultValue2.setValue("");
                    resultValue2.setBasedataId("");
                    resultValue2.setBasedatafield(((EntryVO)longEntryVOEntry.getValue()).getBasedatafield() == null ? "" : ((EntryVO)longEntryVOEntry.getValue()).getBasedatafield());
                    resultValue2.setPropsName(((EntryVO)longEntryVOEntry.getValue()).getPropsName() == null ? "" : ((EntryVO)longEntryVOEntry.getValue()).getPropsName());
                    oldResult.add(resultValue2);
                }
            }
            oldRIds.removeAll(newRIds);
            if (oldRIds.size() > 0) {
                oldResult.removeIf(resultValue -> oldRIds.contains(resultValue.getId()));
            }
            for (ResultValue resultValue3 : oldResult) {
                for (EntryVO entryVO : newResult) {
                    if (resultValue3.getId() != entryVO.getId() || StringUtils.equalsIgnoreCase((CharSequence)resultValue3.getPropsName(), (CharSequence)entryVO.getPropsName())) continue;
                    resultValue3.setValue("");
                    resultValue3.setPropsName(entryVO.getPropsName());
                    resultValue3.setBasedataId("");
                    resultValue3.setBasedatafield(entryVO.getBasedatafield());
                }
            }
        }
    }

    protected void setUniqueCode() {
        Object uniqueCode = this.getModel().getValue("boid");
        if (Objects.isNull(uniqueCode) || "0".equals(String.valueOf(uniqueCode))) {
            uniqueCode = this.getModel().getDataEntity().getPkValue();
        }
        if (!String.valueOf(uniqueCode).equals(this.getModel().getValue("uniquecode"))) {
            this.getModel().setValue("uniquecode", (Object)String.valueOf(uniqueCode));
        }
    }
}

