/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.export;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.io.File;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.export.Header;
import kd.hr.hbp.business.export.MultiEntityExportEvent;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.enums.HRExportTemplateType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class HRMultiEntityExportPlugin
extends HRDataBaseList
implements MultiEntityExportEvent {
    private static final Log LOGGER = LogFactory.getLog(HRMultiEntityExportPlugin.class);
    private static final String BILL_LIST_AP = "billlistap";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String Q_FILTERS = "qFilters";
    private static final String ALL_PK_IDS = "allPkIds";
    private static final String TEMPLATE_TYPE = "templateType";
    private static final String TEMPLATE_ID = "templateId";
    private static final Map<String, String> EXPORT_OPERATION_TYPE = ImmutableMap.of((Object)"exportlist", (Object)"exportlist", (Object)"exportlist_expt", (Object)"exportlist_expt");

    protected Long customTemplateId(BeforeDoOperationEventArgs args) {
        return null;
    }

    protected void beforeQueryFilter(List<QFilter> paramFilters, BeforeDoOperationEventArgs args) {
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        ArrayList<String> qFilterStr = new ArrayList<String>();
        List qFilters = setFilterEvent.getQFilters();
        List dataPermQFilters = setFilterEvent.getDataPermQFilters();
        QFilter mainOrgQFilter = setFilterEvent.getMainOrgQFilter();
        if (!CollectionUtils.isEmpty((Collection)dataPermQFilters)) {
            qFilters.addAll(dataPermQFilters);
            LOGGER.info("HRMultiEntityExportPlugin.setFilter add perm qfilter is {}", (Object)dataPermQFilters);
        }
        if (Objects.nonNull(mainOrgQFilter)) {
            qFilters.add(mainOrgQFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)qFilters)) {
            for (QFilter qFilter : qFilters) {
                String qfStr;
                if (qFilter == null || qFilterStr.contains(qfStr = qFilter.toSerializedString())) continue;
                qFilterStr.add(qfStr);
            }
        }
        pageCache.put(Q_FILTERS, qFilterStr);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isByList;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operationType = formOperate.getType();
        boolean bl = isByList = formOperate.getParameter().get("byList") == null ? false : (Boolean)formOperate.getParameter().get("byList");
        if (EXPORT_OPERATION_TYPE.containsKey(operationType) && !isByList) {
            args.setCancel(true);
            HRPageCache pageCache = new HRPageCache(this.getPageCache());
            Long templateId = this.customTemplateId(args);
            if (templateId != null) {
                pageCache.put(TEMPLATE_ID, (Object)templateId);
            }
            String entityNumber = formOperate.getPermissionEntityId();
            pageCache.put(ENTITY_NUMBER, (Object)entityNumber);
            List<Long> allPkIdsFromFilters = this.getAllPkIdsByFilters(entityNumber, args);
            pageCache.put(ALL_PK_IDS, allPkIdsFromFilters);
            pageCache.put(TEMPLATE_TYPE, (Object)this.getOperationTemplateType(operationType));
            LOGGER.info("HRMultiEntityExportPlugin#beforeDoOperation...");
            this.invokeOperation();
            this.writeOpLog(entityNumber);
        }
    }

    private List<Long> getAllPkIdsByFilters(String entityNumber, BeforeDoOperationEventArgs args) {
        HRPageCache pageCache;
        List qFilterStr;
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!ObjectUtils.isEmpty((Object[])primaryKeyValues)) {
            qFilters.add(new QFilter("id", "in", (Object)Lists.newArrayList((Object[])primaryKeyValues)));
        }
        if (!CollectionUtils.isEmpty((Collection)(qFilterStr = (List)(pageCache = new HRPageCache(this.getPageCache())).get(Q_FILTERS, List.class)))) {
            for (String filter : qFilterStr) {
                qFilters.add(QFilter.fromSerializedString((String)filter));
            }
        }
        this.beforeQueryFilter(qFilters, args);
        LOGGER.info("HRMultiEntityExportPlugin.getAllPkIdsByFilters:{}", qFilters);
        return this.getAllPkIdsByFilters(entityNumber, qFilters);
    }

    protected List<Long> getAllPkIdsByFilters(String entityNumber, List<QFilter> qFilters) {
        LOGGER.info("HRMultiEntityExportPlugin#getAllPkIdsByFilters, entityNumber:{}", (Object)entityNumber);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (queryEntityType == null) {
            return null;
        }
        List pkObjects = HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, qFilters.toArray(new QFilter[0]), null);
        List<Long> pkIds = pkObjects.stream().map(pk -> Long.valueOf(pk.toString())).collect(Collectors.toList());
        LOGGER.info("HRMultiEntityExportPlugin#getAllPkIdsByFilters, pkIds.size():{}", (Object)pkIds.size());
        return pkIds;
    }

    private int getSelectNum() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        AbstractGrid.GridState state = billList.getEntryState();
        boolean isExportAll = state.isSelectAllRows();
        int billNum = !isExportAll ? billList.getSelectedRows().getPrimaryKeyValues().length : billList.queryBillDataCount();
        return billNum;
    }

    private String getOperationTemplateType(String operationKey) {
        String[] split = operationKey.split("_");
        String templateType = split[split.length - 1];
        if (HRExportTemplateType.EXPT.getTemplateType().toLowerCase(Locale.ROOT).equals(templateType)) {
            return HRExportTemplateType.EXPT.getTemplateType();
        }
        return HRExportTemplateType.IMPT.getTemplateType();
    }

    private void startJob(List<Long> allPkIds, String fileName) {
        boolean fillParent = false;
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("hbp");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName("MultiEntityExportUrl");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.hr.hbp.business.export.HRBigDataMultiEntityExportTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        if (HRExportTemplateType.EXPT.getTemplateType().toLowerCase(Locale.ROOT).equals(pageCache.get(TEMPLATE_TYPE, String.class))) {
            fillParent = true;
        }
        params.put("fileName", fileName);
        params.put("entitynumber", pageCache.get(ENTITY_NUMBER, String.class));
        params.put("plugin", ((Object)((Object)this)).getClass().getName());
        params.put("allPKIds", allPkIds);
        params.put("tplId", pageCache.get(TEMPLATE_ID, Long.class));
        params.put("templatetype", pageCache.get(TEMPLATE_TYPE, String.class));
        params.put("fillParent", fillParent);
        params.put("qFilterStr", this.getExportInitQFilterStr());
        jobInfo.setParams(params);
        this.getView().getFormShowParameter().getCustomParams().putAll(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exportUrl");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u4efb\u52a1", (String)"HRMultiEntityExportPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName("kd.hr.hbp.business.export.ExportTaskClick");
        this.dispatch(jobFormInfo, this.getView());
    }

    protected List<String> getExportInitQFilterStr() {
        return new ArrayList<String>();
    }

    protected List<String> getQFilterStr() {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        return (List)pageCache.get(Q_FILTERS, List.class);
    }

    private void dispatch(JobFormInfo jobFormInfo, IFormView view) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_exportdataprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (HRStringUtils.isEmpty((String)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (HRStringUtils.isEmpty((String)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        showParameter.setCustomParams(jobFormInfo.getJobInfo().getParams());
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)((String)pageCache.get(ENTITY_NUMBER, String.class)));
        showParameter.setCustomParam("entitynumber", pageCache.get(ENTITY_NUMBER, String.class));
        showParameter.setCustomParam("entityname", (Object)queryEntityType.getDisplayName().getLocaleValue());
        showParameter.setCustomParam(TEMPLATE_ID, pageCache.get(TEMPLATE_ID, Long.class));
        showParameter.setCustomParam("ServiceAppId", (Object)view.getFormShowParameter().getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)view.getFormShowParameter().getCheckRightAppId());
        showParameter.setCustomParam("BillFormId", view.getFormShowParameter().getCustomParam("BillFormId"));
        showParameter.setCustomParam("OperateKey", view.getFormShowParameter().getCustomParam("OperateKey"));
        showParameter.setCustomParam("taskClassName", (Object)"kd.hr.hbp.business.export.HRBigDataMultiEntityExportTask");
        view.showForm(showParameter);
    }

    private String getFileName() {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        Long templateId = (Long)pageCache.get(TEMPLATE_ID, Long.class);
        DynamicObject templateData = templateId > 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bos_importtemplate") : null;
        String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_", (String)"HRMultiEntityExportPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
        if (templateData != null) {
            fileName = fileName + templateData.get("name");
        } else {
            BillEntityType listEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)((String)pageCache.get(ENTITY_NUMBER, String.class))).getEntityTypeId());
            fileName = fileName + listEntityType.getDisplayName();
        }
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth());
        return fileName.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "").replaceAll(" ", "_");
    }

    private void getReturnExportUrl(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("export URL is :" + returnData + ((Object)((Object)this)).toString());
        }
        Optional.ofNullable(returnData).ifPresent(data -> {
            Map result;
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo")) {
                String taskInfoStr = (String)result.get("taskinfo");
                TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
                this.handleTaskInfo(taskInfo);
            }
        });
    }

    private void handleTaskInfo(TaskInfo taskInfo) {
        if (taskInfo.isTaskEnd()) {
            Map taskInfoMap = (Map)JSONObject.parseObject((String)taskInfo.getData(), Map.class);
            if (Objects.isNull(taskInfoMap)) {
                return;
            }
            String exportUrl = (String)taskInfoMap.get("exportUrl");
            if (HRStringUtils.isNotEmpty((String)exportUrl)) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)exportUrl);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u5efa\u5bfc\u51faURL\u5931\u8d25\u3002", (String)"HRMultiEntityExportPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    public OperationResult invokeOperation() {
        if (!(this.getView() instanceof IListView)) {
            return null;
        }
        int billNum = this.getSelectNum();
        if (billNum == 0) {
            LOGGER.info("HRMultiEntityExportPlugin#invokeOperation...");
            HRPageCache pageCache = new HRPageCache(this.getPageCache());
            List allPKIds = (List)pageCache.get(ALL_PK_IDS, List.class);
            LOGGER.info("HRMultiEntityExportPlugin#invokeOperation, allPKIds.size(): {}", (Object)allPKIds.size());
            if (allPKIds.size() > 0) {
                String showMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa{0}\u5f20\u5355\u636e\uff0c\u786e\u8ba4\u662f\u5426\u5bfc\u51fa\uff1f", (String)"HRMultiEntityExportPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), allPKIds.size());
                this.getView().showConfirm(showMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("HRMultiEntityExportConfirmCallBack", (IFormPlugin)this));
                LOGGER.info("HRMultiEntityExportPlugin#invokeOperation, showConfirm...");
                return null;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"HRMultiEntityExportPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        } else {
            this.export();
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"exportUrl")) {
            this.getReturnExportUrl(closedCallBackEvent);
            return;
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"selectexporttemplate") && closedCallBackEvent.getReturnData() != null) {
            Object[] templates = (Object[])closedCallBackEvent.getReturnData();
            HRPageCache pageCache = new HRPageCache(this.getPageCache());
            pageCache.put(TEMPLATE_ID, (Object)((Long)templates[0]));
            this.startJob((List)pageCache.get(ALL_PK_IDS, List.class), this.getFileName());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"HRMultiEntityExportConfirmCallBack") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.export();
        }
    }

    private void export() {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        if (pageCache.get(TEMPLATE_ID, Long.class) != null) {
            this.startJob((List)pageCache.get(ALL_PK_IDS, List.class), this.getFileName());
        } else {
            Long userId = Long.parseLong(RequestContext.getOrCreate().getUserId());
            QFilter validScope = new QFilter("applyscope", "=", (Object)"0").or("creator", "=", (Object)userId).or(new QFilter("applyscope", "=", (Object)"1").and("users.fbasedataid.id", "in", (Object)userId));
            QFilter[] filters = new QFilter[]{new QFilter("bizobject.number", "=", pageCache.get(ENTITY_NUMBER, String.class)), new QFilter("templatetype", "=", pageCache.get(TEMPLATE_TYPE, String.class)).or(new QFilter("templatetype", "is null", null)), validScope};
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters, (String)"", (int)2);
            if (pkIds.size() == 1) {
                pageCache.put(TEMPLATE_ID, (Object)((Long)pkIds.get(0)));
                this.startJob((List)pageCache.get(ALL_PK_IDS, List.class), this.getFileName());
            }
            if (pkIds.size() == 2) {
                this.showSelectTemplate();
            }
        }
    }

    private void showSelectTemplate() {
        FormShowParameter showParameter = new FormShowParameter();
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        showParameter.setFormId("bos_selectexporttemplate");
        showParameter.setCustomParam("TemplateType", pageCache.get(TEMPLATE_TYPE, String.class));
        showParameter.setCustomParam("BillTypeId", (Object)((ListShowParameter)this.getView().getFormShowParameter()).getBillTypeId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "selectexporttemplate");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void writeOpLog(String entityNumber) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setOpName("exportdata", new MultiLangEnumBridge("\u5bfc\u51fa\u6570\u636e", "HRMultiEntityExportPlugin_5", "hrmp-hbp-formplugin"));
        appLogInfo.setOpDesc(new MultiLangEnumBridge("\u6309\u5bfc\u5165/\u5bfc\u51fa\u6a21\u677f", "HRMultiEntityExportPlugin_6", "hrmp-hbp-formplugin"), new String[0]);
        this.getView().getFormShowParameter().getFormId();
        appLogInfo.setBizObjID(entityNumber);
        appLogInfo.setBizAppID(PermCommonUtil.getAppIdFromSuspectedAppNum((String)this.getView().getFormShowParameter().getAppId()));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        service.addLog((AppLogInfo)appLogInfo);
    }

    public void multiAfterExportFile(File file) {
    }

    public List<Header> multiEditHeader(List<Header> headers) {
        return headers;
    }

    public List<String> multiCusQueryAttrs() {
        return null;
    }

    public DynamicObjectCollection multiEditData(DynamicObjectCollection data, List<Header> headers, Table<String, Long, DynamicObject> langOrmValueTable) {
        return data;
    }

    public DynamicObjectCollection multiEditData(DynamicObjectCollection data, List<String> qFilterStr) {
        return data;
    }

    public DynamicObjectCollection multiEditData(DynamicObjectCollection data) {
        return data;
    }

    public int multiEditBatchSize() {
        return 10000;
    }

    public String multiEditFileName(String name) {
        return name;
    }
}

