/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.flow.FieldVo;

public class DynamicPopupEdit
extends HRDataBaseEdit {
    private static final String FIELD_CONTENT_PANEL = "contentpanel";
    private static final String FIELD_DY_FLEX_PANEL = "dyflexpanel";
    private static final String FIELD_INSERT_CONTROL = "insertcontrol";
    public static final String CUSTOM_INSERT_VALUE = "value";
    public static final String CUSTOM_CONTROL_TYPE = "controlType";
    public static final String CUSTOM_FORM_NAME = "formName";
    public static final String CUSTOM_FIELD_DISPLAY_NAME = "fieldDisplayName";
    public static final String CUSTOM_COMBO_CONTROL_VALUE_ITEM_JSON_ARRAY = "valueItemJsonArray";
    public static final String CUSTOM_COMBO_ITEM_IMAGE = "itemImage";
    public static final String CUSTOM_COMBO_ITEM_NAME = "itemName";
    public static final String CUSTOM_COMBO_ITEM_VALUE = "itemValue";
    public static final String META_NUMBER_HBP_DYNAMIC_POPUP = "hbp_dynamic_popup";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private FieldVo fieldVo;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs metasArgs) {
        super.loadCustomControlMetas(metasArgs);
        FlexPanelAp flexPanelAp = this.getFlexPanelAp();
        FieldAp fieldAp = this.getFieldAp((FormShowParameter)metasArgs.getSource());
        flexPanelAp.getItems().add(fieldAp);
        List items = metasArgs.getItems();
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", FIELD_CONTENT_PANEL);
        mapEntry.put("items", (String)flexPanelAp.createControl().get("items"));
        items.add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (HRStringUtils.equals((String)FIELD_INSERT_CONTROL, (String)e.getKey())) {
            FieldEdit fieldEdit = this.getFieldVo(this.getView().getFormShowParameter()).getFieldEdit();
            fieldEdit.setKey(FIELD_INSERT_CONTROL);
            fieldEdit.setView(this.getView());
            e.setControl((Control)fieldEdit);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        Object oldValue = this.getView().getFormShowParameter().getCustomParam(CUSTOM_INSERT_VALUE);
        String formName = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_FORM_NAME);
        Object convertValue = this.getInsertValue(oldValue);
        dataEntity.set(FIELD_INSERT_CONTROL, convertValue);
        e.setDataEntity((Object)dataEntity);
        if (Objects.nonNull(formName)) {
            this.getView().setFormTitle(new LocaleString(formName));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FlexPanelAp flexPanelAp = this.getFlexPanelAp();
        FieldAp fieldAp = this.getFieldAp(this.getView().getFormShowParameter());
        flexPanelAp.getItems().add(fieldAp);
        Container myFldPanel = (Container)this.getView().getControl(FIELD_CONTENT_PANEL);
        myFldPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            Object insertValue = this.getInsertValue(this.getModel().getValue(FIELD_INSERT_CONTROL));
            if (Objects.nonNull(insertValue)) {
                this.getView().returnDataToParent(insertValue);
            } else {
                this.getView().returnDataToParent(null);
            }
            this.getView().close();
        } else if (BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private FlexPanelAp getFlexPanelAp() {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(FIELD_DY_FLEX_PANEL);
        return flexPanelAp;
    }

    private FieldAp getFieldAp(FormShowParameter showParameter) {
        String fieldDisplayName = (String)showParameter.getCustomParam(CUSTOM_FIELD_DISPLAY_NAME);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(FIELD_INSERT_CONTROL);
        fieldAp.setKey(FIELD_INSERT_CONTROL);
        fieldAp.setName(new LocaleString(fieldDisplayName));
        fieldAp.setFireUpdEvt(true);
        Field<? extends DynamicProperty> field = this.getFieldVo(showParameter).getField();
        field.setId(FIELD_INSERT_CONTROL);
        field.setKey(FIELD_INSERT_CONTROL);
        fieldAp.setField(field);
        return fieldAp;
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        String fieldDisplayName = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_FIELD_DISPLAY_NAME);
        FieldProp fieldProp = this.getFieldVo(this.getView().getFormShowParameter()).getFieldProp();
        fieldProp.setName(FIELD_INSERT_CONTROL);
        fieldProp.setDisplayName(new LocaleString(fieldDisplayName));
        fieldProp.setDbIgnore(true);
        fieldProp.setAlias("");
        newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
    }

    private Class<? extends FieldProp> getCustomControlClass(Object obj) {
        Class<?> clazz = null;
        if (obj instanceof Class) {
            clazz = (Class<?>)obj;
        } else if (obj instanceof String) {
            try {
                clazz = Class.forName(String.valueOf(obj));
            }
            catch (ClassNotFoundException e) {
                throw new KDBizException(String.format(Locale.ROOT, "can't find class %1$s", obj));
            }
        }
        return clazz;
    }

    private FieldVo getFieldVo(FormShowParameter formShowParameter) {
        if (Objects.isNull(this.fieldVo)) {
            Object value = formShowParameter.getCustomParam(CUSTOM_CONTROL_TYPE);
            Class<? extends FieldProp> clazz = this.getCustomControlClass(value);
            if (Objects.isNull(clazz)) {
                throw new KDBizException(String.format(Locale.ROOT, "can't find class %1$s", value));
            }
            this.fieldVo = this.getFieldVoClassType(clazz, formShowParameter);
            return this.fieldVo;
        }
        return this.fieldVo;
    }

    private FieldVo getFieldVoClassType(Class<? extends FieldProp> clazz, FormShowParameter formShowParameter) {
        FieldVo fieldVo;
        if (clazz.isAssignableFrom(DateTimeProp.class)) {
            fieldVo = new FieldVo((FieldProp)new DateTimeProp(), (Field<? extends DynamicProperty>)new DateTimeField(), (FieldEdit)new DateTimeEdit());
        } else if (clazz.isAssignableFrom(DateProp.class)) {
            fieldVo = new FieldVo((FieldProp)new DateProp(), (Field<? extends DynamicProperty>)new DateField(), (FieldEdit)new DateEdit());
        } else if (clazz.isAssignableFrom(DecimalProp.class)) {
            DecimalProp decimalProp = new DecimalProp();
            DecimalField decimalField = new DecimalField();
            decimalProp.setZeroShow(true);
            fieldVo = new FieldVo((FieldProp)decimalProp, (Field<? extends DynamicProperty>)decimalField, (FieldEdit)new DecimalEdit());
        } else if (clazz.isAssignableFrom(IntegerProp.class)) {
            fieldVo = new FieldVo((FieldProp)new IntegerProp(), (Field<? extends DynamicProperty>)new IntegerField(), (FieldEdit)new IntegerEdit());
        } else if (clazz.isAssignableFrom(ComboProp.class)) {
            JSONArray valueItemJsonArray = (JSONArray)formShowParameter.getCustomParam(CUSTOM_COMBO_CONTROL_VALUE_ITEM_JSON_ARRAY);
            ComboProp comboProp = new ComboProp();
            ComboField comboField = new ComboField();
            ComboEdit comboEdit = new ComboEdit();
            if (Objects.nonNull(valueItemJsonArray)) {
                ArrayList propItems = Lists.newArrayListWithExpectedSize((int)valueItemJsonArray.size());
                ArrayList fieldItems = Lists.newArrayListWithExpectedSize((int)valueItemJsonArray.size());
                for (int index = 0; index < valueItemJsonArray.size(); ++index) {
                    JSONObject itemJson = valueItemJsonArray.getJSONObject(index);
                    LocaleString name = new LocaleString(itemJson.getString(CUSTOM_COMBO_ITEM_NAME));
                    String image = itemJson.getString(CUSTOM_COMBO_ITEM_IMAGE);
                    String value = itemJson.getString(CUSTOM_COMBO_ITEM_VALUE);
                    propItems.add(new ValueMapItem(image, value, name));
                    fieldItems.add(new ComboItem(index, name, value, image));
                }
                comboProp.setComboItems((List)propItems);
                comboField.setItems((List)fieldItems);
            }
            fieldVo = new FieldVo((FieldProp)comboProp, (Field<? extends DynamicProperty>)comboField, (FieldEdit)comboEdit);
        } else {
            fieldVo = new FieldVo((FieldProp)new TextProp(), (Field<? extends DynamicProperty>)new TextField(), (FieldEdit)new TextEdit());
        }
        return fieldVo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getInsertValue(Object controlValue) {
        Object controlTypeClassObj = this.getView().getFormShowParameter().getCustomParam(CUSTOM_CONTROL_TYPE);
        Class<? extends FieldProp> clazz = this.getCustomControlClass(controlTypeClassObj);
        String insertValue = null;
        if (!Objects.nonNull(controlValue)) return insertValue;
        if (!Objects.nonNull(clazz)) return insertValue;
        if (clazz.isAssignableFrom(DateProp.class)) {
            try {
                if (controlValue instanceof Date) {
                    return HRDateTimeUtils.formatDate((Date)((Date)controlValue));
                }
                if (!HRStringUtils.isNotEmpty((String)String.valueOf(controlValue))) return insertValue;
                return HRDateTimeUtils.parseDate((String)String.valueOf(controlValue));
            }
            catch (ParseException e) {
                throw new KDBizException(String.format(Locale.ROOT, "%1$s can't parse to date", controlValue));
            }
        }
        if (!clazz.isAssignableFrom(DecimalProp.class)) return String.valueOf(controlValue);
        if (!(controlValue instanceof BigDecimal)) return String.valueOf(controlValue);
        return ((BigDecimal)controlValue).stripTrailingZeros().toPlainString();
    }
}

