/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.flow;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.flow.JobNode;
import kd.hr.hbp.business.flow.helper.FlowJobHelper;
import kd.hr.hbp.business.flow.job.HRFlowJobHandler;
import kd.hr.hbp.business.flow.job.HRFlowJobRequest;
import kd.hr.hbp.business.flow.job.HRFlowJobResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.flow.FlowJobStatusEnum;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FlowListTest
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(FlowListTest.class);
    private static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newCachedExecutorService((String)"flowListTest-run-Thread", (int)3, (int)10);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("run".equals(formOperate.getOperateKey())) {
            String entityId = ((ListView)this.getView()).getBillFormId();
            MainEntityType runningEntityType = EntityMetadataCache.getDataEntityType((String)entityId.replace("flow", "flowins"));
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
            HRBaseServiceHelper flowInsHelper = new HRBaseServiceHelper(runningEntityType.getName());
            HRBaseServiceHelper jobInsHelper = new HRBaseServiceHelper(entityId.replace("flow", "jobins"));
            RequestContext requestContext = RequestContext.get();
            for (ListSelectedRow row : selectedRows) {
                EXECUTOR_SERVICE.execute(() -> {
                    try {
                        LOGGER.info("run_flow_start_" + row.getName());
                        DynamicObject settingDy = helper.loadSingle(row.getPrimaryKeyValue());
                        long flowInstanceId = FlowJobHelper.createFlowInstance((DynamicObject)settingDy, (DynamicObjectType)runningEntityType);
                        LOGGER.info("flow_instance_create_success" + row.getName());
                        DynamicObject runningDy = flowInsHelper.loadSingle((Object)flowInstanceId);
                        JobNode rootInsNode = FlowJobHelper.buildTreeModel((DynamicObject)runningDy);
                        this.jobRun(jobInsHelper, requestContext, rootInsNode, 0L);
                    }
                    catch (Exception e) {
                        LOGGER.error("run_flow_error_" + ExceptionUtils.getStackTrace((Throwable)e));
                    }
                });
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fd0\u884c\u6210\u529f", (String)"FlowListTest_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    private void jobRun(HRBaseServiceHelper jobInsHelper, RequestContext requestContext, JobNode rootInsNode, long jobNodeId) {
        List entryJobNodeIdList = FlowJobHelper.getEntryNextList((Long)rootInsNode.getId(), (Long)jobNodeId);
        if (Objects.nonNull(entryJobNodeIdList) && !entryJobNodeIdList.isEmpty()) {
            block0: for (Object jobId : entryJobNodeIdList) {
                if ("-1".equals(String.valueOf(jobId))) break;
                DynamicObject jobInsDy = jobInsHelper.loadSingle((Object)Long.valueOf(String.valueOf(jobId)));
                HRFlowJobHandler jobHandler = new HRFlowJobHandler(jobInsDy, requestContext);
                DynamicObjectCollection actionArray = jobInsDy.getDynamicObjectCollection("jobaction");
                for (DynamicObject action : actionArray) {
                    if (!"execute".equals(action.getString("actiontype"))) continue;
                    HRFlowJobRequest request = new HRFlowJobRequest();
                    request.setJobActionType("execute");
                    Map<String, Object> params = action.getDynamicObjectCollection("inparam").stream().collect(Collectors.toMap(dy -> dy.getString("inparamname"), dy -> {
                        Object value = dy.get("runvalue");
                        if ("bizObject".equals(dy.get("inparamtype"))) {
                            try {
                                value = Long.valueOf(String.valueOf(value));
                            }
                            catch (Exception e) {
                                value = String.valueOf(value);
                            }
                        }
                        return value;
                    }));
                    request.setRequestData(params);
                    HRFlowJobResponse response = jobHandler.execute(request);
                    if (FlowJobStatusEnum.STATUS_RUN_SUCCESS != response.getJobStatus()) continue block0;
                    this.jobRun(jobInsHelper, requestContext, rootInsNode, Long.parseLong(String.valueOf(jobId)));
                    continue block0;
                }
            }
        }
    }
}

