/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.flow.chart.FlowChartVo;
import kd.hr.hbp.business.flow.helper.FlowJobHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class JobFlowEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String CONTROL_FLOW_ENTRY_TOOL_BARS = "flowentrytoolbars";
    private static final String CONTROL_INSERT_DETAIL_ENTRY_BTN = "insertdetailentrybtn";
    private static final String CONTROL_MOVE_DETAIL_ENTRY_UP_BTN = "movedetailentryupbtn";
    private static final String CONTROL_MOVE_DETAIL_ENTRY_DOWN_BTN = "movedetailentrydownbtn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit frontNodeNameText = (TextEdit)this.getView().getControl("frontnodename");
        frontNodeNameText.addClickListener((ClickListener)this);
        BasedataEdit jobFlowF7 = (BasedataEdit)this.getView().getControl("jobflow");
        if (Objects.nonNull(jobFlowF7)) {
            jobFlowF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{CONTROL_FLOW_ENTRY_TOOL_BARS});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object boId = baseShowParameter.getCustomParam("boid");
        if (Objects.nonNull(baseShowParameter.getPkId()) || Objects.nonNull(boId)) {
            DynamicObjectCollection flowDetail = this.getModel().getEntryEntity("hrflowentry");
            Map<String, DynamicObject> entryMap = flowDetail.stream().collect(Collectors.toMap(dy -> dy.getString("entryboid"), dy -> dy));
            for (DynamicObject detail : flowDetail) {
                String idsStr = detail.getString("frontnodeentryids");
                String frontNodeName = this.getNewFrontNodeName(entryMap, idsStr);
                detail.set("frontnodename", (Object)frontNodeName);
            }
            this.getModel().setDataChanged(false);
        } else {
            DynamicObjectCollection flowDetail = this.getModel().getEntryEntity("hrflowentry");
            if (flowDetail.size() < 2) {
                for (int index = flowDetail.size(); index < 2; ++index) {
                    flowDetail.addNew();
                }
            }
            long[] entryIds = ORM.create().genLongIds((IDataEntityType)flowDetail.getDynamicObjectType(), flowDetail.size());
            for (int index = 0; index < flowDetail.size(); ++index) {
                DynamicObject detail = (DynamicObject)flowDetail.get(index);
                Object pkValue = detail.getPkValue();
                if (!Objects.isNull(pkValue) && !"0".equals(String.valueOf(pkValue))) continue;
                long entryId = entryIds[index];
                ISimpleProperty primaryKey = detail.getDynamicObjectType().getPrimaryKey();
                detail.set((IDataEntityProperty)primaryKey, (Object)entryId);
                detail.set("entryboid", (Object)entryId);
                if (index == 0) {
                    detail.set("type", (Object)"start");
                    continue;
                }
                if (index != 1) continue;
                detail.set("type", (Object)"end");
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection flowDetail = this.getModel().getEntryEntity("hrflowentry");
        for (int index = 0; index < flowDetail.size(); ++index) {
            DynamicObject detail = (DynamicObject)flowDetail.get(index);
            String type = detail.getString("type");
            if ("jobflow".equals(type)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"job"});
                continue;
            }
            if ("job".equals(type)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"jobflow"});
                continue;
            }
            if ("start".equals(type)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"type", "job", "jobflow", "frontnodename"});
                continue;
            }
            if ("end".equals(type)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"type", "job", "jobflow"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"job", "jobflow", "frontnodename"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess() && "showflowchart".equalsIgnoreCase(operate.getOperateKey())) {
            this.openFlowChart();
        }
    }

    private void openFlowChart() {
        Object id;
        BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object boId = baseShowParameter.getCustomParam("boid");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hbp_flow_chart");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setClientParam("billId", (Object)"hbp_flow_chart");
        formShowParameter.setShowTitle(true);
        formShowParameter.setShowFullScreen(true);
        Object object = Objects.nonNull(baseShowParameter.getPkId()) ? baseShowParameter.getPkId() : (id = Objects.nonNull(boId) ? boId : null);
        if (Objects.nonNull(id)) {
            formShowParameter.setCustomParam("customIsServiceGetVo", (Object)Boolean.TRUE);
            formShowParameter.setCustomParam("customFlowChartDyId", id);
            formShowParameter.setCustomParam("customFlowChartDyMetaNumber", (Object)baseShowParameter.getFormId());
            formShowParameter.setCustomParam("customFlowServicePath", (Object)"kd.hr.hbp.business.flow.chart.FlowSettingChartServiceImpl");
        } else {
            FlowChartVo flowChartVo = FlowJobHelper.getFlowChartVo((DynamicObject)this.getModel().getDataEntity(true), (boolean)false);
            formShowParameter.setCustomParam("customFlowChartVoKey", (Object)flowChartVo);
        }
        this.getView().showForm(formShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("frontnodename".equals(fieldKey)) {
            ChangeData inFrontNodeNameChange = changeSet[0];
            int rowIndex = inFrontNodeNameChange.getRowIndex();
            if (Objects.isNull(inFrontNodeNameChange.getNewValue()) || HRStringUtils.isEmpty((String)String.valueOf(inFrontNodeNameChange.getNewValue()))) {
                this.getModel().setValue("frontnodeentryids", null, rowIndex);
            }
        } else if ("type".equals(fieldKey)) {
            ChangeData inTypeChange = changeSet[0];
            int rowIndex = inTypeChange.getRowIndex();
            Object newValue = inTypeChange.getNewValue();
            if ("job".equals(newValue)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"job", "frontnodename"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"jobflow"});
                this.getModel().setValue("jobflow", null, rowIndex);
            } else if ("jobflow".equals(newValue)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"job"});
                this.getModel().setValue("job", null, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"jobflow", "frontnodename"});
            } else if ("end".equals(newValue)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"job", "jobflow"});
                this.getModel().setValue("job", null, rowIndex);
                this.getModel().setValue("jobflow", null, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"frontnodename"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"job", "jobflow", "frontnodename"});
                this.getModel().setValue("job", null, rowIndex);
                this.getModel().setValue("jobflow", null, rowIndex);
                this.getModel().setValue("frontnodeentryids", null, rowIndex);
                this.getModel().setValue("frontnodename", null, rowIndex);
            }
            this.refreshOtherNodeFrontNodeIdsAndName(rowIndex, true);
        } else if ("jobflow".equals(fieldKey) || "job".equals(fieldKey)) {
            ChangeData baseDataChange = changeSet[0];
            int rowIndex = baseDataChange.getRowIndex();
            this.refreshOtherNodeFrontNodeIdsAndName(rowIndex, false);
        } else if ("bizapp".equals(fieldKey)) {
            DynamicObject bizApp = (DynamicObject)this.getModel().getValue(fieldKey);
            if (Objects.nonNull(bizApp)) {
                this.getModel().setValue("bizcloud", bizApp.get("bizcloud.id"));
            } else {
                this.getModel().setValue("bizcloud", null);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObjectCollection detailEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("hrflowentry");
        for (DynamicObject detail : detailEntry) {
            DataEntityState dataEntityState = detail.getDataEntityState();
            for (IDataEntityProperty iDataEntityProperty : dataEntityState.getBizChangedProperties()) {
                String name = iDataEntityProperty.getName();
                if (!"frontnodeentryids".equals(name)) continue;
                dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
        }
        super.beforeClosed(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            TextEdit source = (TextEdit)evt.getSource();
            String entryKey = source.getEntryKey();
            if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                return;
            }
            if ("hrflowentry".equals(entryKey)) {
                int rowNum = this.getModel().getEntryCurrentRowIndex("hrflowentry");
                String fieldKey = source.getKey();
                if (HRStringUtils.equals((String)"frontnodename", (String)fieldKey)) {
                    DynamicObjectCollection flowDetailEntry = this.getModel().getEntryEntity("hrflowentry");
                    DynamicObject currentDy = (DynamicObject)flowDetailEntry.get(rowNum);
                    boolean isEnd = "end".equals(currentDy.getString("type"));
                    Set<Object> childNodeIds = this.getChildNodeIds(Sets.newHashSet((Object[])new Object[]{currentDy.get("entryboid")}), flowDetailEntry);
                    childNodeIds.add(currentDy.get("entryboid"));
                    List<DynamicObject> filteredDys = flowDetailEntry.stream().filter(dy -> !childNodeIds.contains(dy.get("entryboid"))).filter(dy -> !"end".equals(dy.getString("type"))).filter(dy -> !isEnd || !this.getAllFrontNodeIdsExceptEnd(flowDetailEntry).contains(dy.getString("entryboid"))).filter(dy -> !isEnd || !"start".equals(dy.getString("type"))).collect(Collectors.toList());
                    this.openFrontNodeListF7(filteredDys, rowNum);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.contains("frontnodename")) {
            int selectRowIndex = Integer.parseInt(actionId.split("_")[1]);
            DynamicObjectCollection returnData = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            if (returnData != null) {
                StringBuilder idsStr = new StringBuilder();
                StringBuilder namesStr = new StringBuilder();
                for (DynamicObject entry : returnData) {
                    String type = entry.getString("type");
                    idsStr.append(entry.getString("id")).append(';');
                    if ("start".equals(type) || "end".equals(type)) {
                        IDataEntityProperty property = (IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)"type");
                        if (!(property instanceof ComboProp)) continue;
                        ComboProp comboProp = (ComboProp)property;
                        namesStr.append(comboProp.getItemByName(type)).append(';');
                        continue;
                    }
                    namesStr.append(entry.getString("frontnodename")).append(';');
                }
                this.getModel().setValue("frontnodeentryids", (Object)idsStr.toString(), selectRowIndex);
                this.getModel().setValue("frontnodename", (Object)namesStr.toString(), selectRowIndex);
                DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("hrflowentry");
                DynamicObject changeEntry = (DynamicObject)detailEntry.get(selectRowIndex);
                this.cleanOtherReferenceNodeFrontId(changeEntry.getString("entryboid"));
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs rowEventArgs) {
        super.beforeDeleteRow(rowEventArgs);
        EntryProp entryProp = rowEventArgs.getEntryProp();
        if ("hrflowentry".equals(entryProp.getName())) {
            int[] rowIndices = rowEventArgs.getRowIndexs();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryProp.getName());
            ComboProp typeProperty = (ComboProp)entryEntity.getDynamicObjectType().getProperty("type");
            for (int rowIndex : rowIndices) {
                DynamicObject entity = (DynamicObject)entryEntity.get(rowIndex);
                String type = entity.getString((IDataEntityProperty)typeProperty);
                if ("start".equals(type) || "end".equals(type)) {
                    FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)this.getView().getEntityId(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
                    Optional<ControlAp> flowEntryApControlApOp = formMetadata.getItems().stream().filter(controlAp -> "hrflowentryap".equals(controlAp.getKey())).findFirst();
                    String flowApName = "";
                    if (flowEntryApControlApOp.isPresent()) {
                        flowApName = flowEntryApControlApOp.get().getName().getLocaleValue();
                    }
                    String typeDisplayName = typeProperty.getItemByName(type);
                    this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\u7b2c[{1}]\u884c[{2}]\u5b57\u6bb5\u4e3a[{3}],\u4e0d\u80fd\u5220\u9664", (String)"JobFlowEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), flowApName, rowIndex + 1, typeProperty.getDisplayName().getLocaleValue(), typeDisplayName));
                    rowEventArgs.setCancel(true);
                }
                this.refreshOtherNodeFrontNodeIdsAndName(rowIndex, true);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        AbstractGrid grid;
        int focusRow;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (CONTROL_INSERT_DETAIL_ENTRY_BTN.equals(itemKey)) {
            AbstractGrid grid2 = (AbstractGrid)this.getView().getControl("hrflowentry");
            int rowCount = this.getModel().getEntryRowCount("hrflowentry");
            if (rowCount > 0) {
                grid2.getEntryState().setFocusRow(rowCount - 1);
                grid2.selectRows(rowCount - 1);
            }
        } else if (CONTROL_MOVE_DETAIL_ENTRY_UP_BTN.equals(itemKey)) {
            AbstractGrid grid3 = (AbstractGrid)this.getView().getControl("hrflowentry");
            int focusRow2 = grid3.getEntryState().getFocusRow();
            if (focusRow2 != -1) {
                DynamicObjectCollection detail = this.getModel().getEntryEntity("hrflowentry");
                ComboProp typeProp = (ComboProp)detail.getDynamicObjectType().getProperty("type");
                DynamicObject rowEntry = (DynamicObject)detail.get(focusRow2);
                String type = rowEntry.getString((IDataEntityProperty)typeProp);
                if ("end".equals(type)) {
                    String displayName = typeProp.getItemByName(type);
                    this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u884c\u8282\u70b9\u4e0d\u80fd\u4e0a\u79fb", (String)"JobFlowEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), displayName));
                    evt.setCancel(true);
                }
            }
        } else if (CONTROL_MOVE_DETAIL_ENTRY_DOWN_BTN.equals(itemKey) && (focusRow = (grid = (AbstractGrid)this.getView().getControl("hrflowentry")).getEntryState().getFocusRow()) != -1) {
            DynamicObjectCollection detail = this.getModel().getEntryEntity("hrflowentry");
            ComboProp typeProp = (ComboProp)detail.getDynamicObjectType().getProperty("type");
            DynamicObject rowEntry = (DynamicObject)detail.get(focusRow);
            String type = rowEntry.getString((IDataEntityProperty)typeProp);
            if ("start".equals(type)) {
                String displayName = typeProp.getItemByName(type);
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u884c\u8282\u70b9\u4e0d\u80fd\u4e0b\u79fb", (String)"JobFlowEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), displayName));
                evt.setCancel(true);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs rowEventArgs) {
        super.afterAddRow(rowEventArgs);
        String entryName = rowEventArgs.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = rowEventArgs.getRowDataEntities();
        long entryId = ORM.create().genLongId((IDataEntityType)rowEventArgs.getEntryProp().getDynamicCollectionItemPropertyType());
        if (Objects.nonNull(rowDataEntities) && rowDataEntities.length > 0) {
            for (RowDataEntity rowData : rowDataEntities) {
                int rowIndex = rowData.getRowIndex();
                if (!"hrflowentry".equals(entryName)) continue;
                DynamicObject dataEntity = rowData.getDataEntity();
                ISimpleProperty primaryKey = dataEntity.getDynamicObjectType().getPrimaryKey();
                dataEntity.set((IDataEntityProperty)primaryKey, (Object)entryId);
                dataEntity.set("entryboid", (Object)entryId);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"job", "jobflow", "frontnodename"});
            }
        }
    }

    private void openFrontNodeListF7(List<DynamicObject> dys, int rowNum) {
        JSONArray showDyArray = new JSONArray(dys.size());
        for (DynamicObject dy : dys) {
            JSONObject frontNodeJson = this.getFrontNodeJson(dy);
            if (frontNodeJson == null) {
                return;
            }
            showDyArray.add((Object)frontNodeJson);
        }
        DynamicObjectCollection allDyEntries = this.getModel().getEntryEntity("hrflowentry");
        JSONArray allDyArray = new JSONArray(allDyEntries.size());
        for (DynamicObject dy : allDyEntries) {
            JSONObject entryJson = this.getFrontNodeJson(dy);
            if (entryJson == null) {
                return;
            }
            allDyArray.add((Object)entryJson);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hbp_jobflowfrontnode");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("frontFlowEntry", (Object)showDyArray);
        formShowParameter.setCustomParam("allEntryDataCache", (Object)allDyArray);
        formShowParameter.setCustomParam("selectEntryId", this.getModel().getValue("frontnodeentryids", rowNum));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "frontnodename_" + rowNum));
        this.getView().showForm(formShowParameter);
    }

    private JSONObject getFrontNodeJson(DynamicObject dy) {
        JSONObject jsonObj = new JSONObject();
        int seq = dy.getInt("seq");
        jsonObj.put("id", dy.get("entryboid"));
        jsonObj.put("seq", (Object)seq);
        IDataEntityProperty typeProp = (IDataEntityProperty)dy.getDataEntityType().getProperties().get((Object)"type");
        String type = dy.getString(typeProp);
        if (HRStringUtils.isEmpty((String)type)) {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b2c[{0}]\u884c[{1}]\u7684\u5b57\u6bb5\u503c", (String)"JobFlowEdit_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), seq, typeProp.getDisplayName().getLocaleValue()));
            return null;
        }
        jsonObj.put("type", (Object)type);
        jsonObj.put("frontnodeentryids", (Object)dy.getString("frontnodeentryids"));
        if ("jobflow".equals(type)) {
            IDataEntityProperty jobFlowProp = (IDataEntityProperty)dy.getDataEntityType().getProperties().get((Object)"jobflow");
            DynamicObject jobFlow = dy.getDynamicObject(jobFlowProp);
            if (Objects.isNull(jobFlow)) {
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b2c[{0}]\u884c[{1}]\u7684\u5b57\u6bb5\u503c", (String)"JobFlowEdit_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), seq, jobFlowProp.getDisplayName().getLocaleValue()));
                return null;
            }
            jsonObj.put("frontnodename", (Object)jobFlow.getString("name"));
        } else if ("job".equals(type)) {
            IDataEntityProperty jobProp = (IDataEntityProperty)dy.getDataEntityType().getProperties().get((Object)"job");
            DynamicObject job = dy.getDynamicObject(jobProp);
            if (Objects.isNull(job)) {
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b2c[{0}]\u884c[{1}]\u7684\u5b57\u6bb5\u503c", (String)"JobFlowEdit_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), seq, jobProp.getDisplayName().getLocaleValue()));
                return null;
            }
            jsonObj.put("frontnodename", (Object)job.getString("name"));
        }
        return jsonObj;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object pkValue;
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if ("jobflow".equals(fieldName) && Objects.nonNull(pkValue = this.getModel().getDataEntity().get("boid"))) {
            QFilter idFilter = new QFilter("id", "!=", pkValue);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(idFilter);
        }
    }

    private Set<Object> getChildNodeIds(Set<Object> parentIds, DynamicObjectCollection entries) {
        Set<Object> childIds = entries.stream().filter(entry -> {
            String frontNodeIds = entry.getString("frontnodeentryids");
            if (HRStringUtils.isNotEmpty((String)frontNodeIds)) {
                for (Object id : parentIds) {
                    if (!frontNodeIds.contains(String.valueOf(id))) continue;
                    return true;
                }
            }
            return false;
        }).map(dy -> dy.get("entryboid")).collect(Collectors.toSet());
        if (childIds.isEmpty()) {
            return childIds;
        }
        childIds.addAll(this.getChildNodeIds(childIds, entries));
        return childIds;
    }

    private Set<String> getAllFrontNodeIdsExceptEnd(DynamicObjectCollection entries) {
        return entries.stream().filter(dy -> !"end".equals(dy.getString("type"))).flatMap(dy -> Arrays.stream(dy.getString("frontnodeentryids").split(";"))).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet());
    }

    private void refreshOtherNodeFrontNodeIdsAndName(int rowIndex, boolean isUpdateIds) {
        DynamicObjectCollection detailEntity = this.getModel().getEntryEntity("hrflowentry");
        DynamicObject currentDetail = (DynamicObject)detailEntity.get(rowIndex);
        String entryBoId = currentDetail.getString("entryboid");
        if (HRStringUtils.isNotEmpty((String)entryBoId)) {
            Map<String, DynamicObject> entryBoIdToDy = detailEntity.stream().collect(Collectors.toMap(dy -> dy.getString("entryboid"), dy -> dy));
            for (DynamicObject detail : detailEntity) {
                String newFrontIds;
                String frontNodeIds = detail.getString("frontnodeentryids");
                if (!HRStringUtils.isNotEmpty((String)frontNodeIds) || !frontNodeIds.contains(entryBoId)) continue;
                if (isUpdateIds) {
                    newFrontIds = frontNodeIds.replace(entryBoId + ";", "");
                    detail.set("frontnodeentryids", (Object)newFrontIds);
                } else {
                    newFrontIds = frontNodeIds;
                }
                detail.set("frontnodename", (Object)this.getNewFrontNodeName(entryBoIdToDy, newFrontIds));
                this.getView().updateView("frontnodename", detail.getInt("seq") - 1);
            }
        }
    }

    private void cleanOtherReferenceNodeFrontId(String entryBoId) {
        DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("hrflowentry");
        Map<String, DynamicObject> entryBoIdToDy = detailEntry.stream().collect(Collectors.toMap(dy -> dy.getString("entryboid"), dy -> dy));
        Set<String> parentNodeIds = this.getParentNodeIds(Sets.newHashSet((Object[])new String[]{entryBoId}), detailEntry);
        for (int index = 0; index < detailEntry.size(); ++index) {
            Object[] parentIdArray;
            Sets.SetView intersection;
            DynamicObject entry = (DynamicObject)detailEntry.get(index);
            String frontNodeIdStr = entry.getString("frontnodeentryids");
            if (!HRStringUtils.isNotEmpty((String)frontNodeIdStr) || !frontNodeIdStr.contains(entryBoId) || (intersection = Sets.intersection(parentNodeIds, (Set)Sets.newHashSet((Object[])(parentIdArray = frontNodeIdStr.split(";"))))).isEmpty()) continue;
            String newFrontNodeIds = frontNodeIdStr;
            for (String sameId : intersection) {
                newFrontNodeIds = newFrontNodeIds.replace(sameId + ";", "");
            }
            entry.set("frontnodeentryids", (Object)newFrontNodeIds);
            entry.set("frontnodename", (Object)this.getNewFrontNodeName(entryBoIdToDy, newFrontNodeIds));
            this.getView().updateView("frontnodename", index);
        }
    }

    private Set<String> getParentNodeIds(Set<String> childIds, DynamicObjectCollection entries) {
        HashSet parentIds = Sets.newHashSetWithExpectedSize((int)entries.size());
        for (DynamicObject entry : entries) {
            String[] parentIdArray;
            String frontNodeIdStr;
            String boId = entry.getString("entryboid");
            if (!childIds.contains(boId) || !HRStringUtils.isNotEmpty((String)(frontNodeIdStr = entry.getString("frontnodeentryids")))) continue;
            for (String parentId : parentIdArray = frontNodeIdStr.split(";")) {
                if (!HRStringUtils.isNotEmpty((String)parentId)) continue;
                parentIds.add(parentId);
            }
        }
        if (parentIds.isEmpty()) {
            return parentIds;
        }
        parentIds.addAll(this.getParentNodeIds(parentIds, entries));
        return parentIds;
    }

    private String getNewFrontNodeName(Map<String, DynamicObject> entryBoIdToDy, String newFrontIds) {
        StringBuilder name = new StringBuilder();
        if (HRStringUtils.isNotEmpty((String)newFrontIds)) {
            String[] entryBoIds;
            for (String id : entryBoIds = newFrontIds.split(";")) {
                String flowEntryEntityName;
                DynamicObject entryDy = entryBoIdToDy.get(id);
                if (!Objects.nonNull(entryDy) || !HRStringUtils.isNotEmpty((String)(flowEntryEntityName = FlowJobHelper.getFlowEntryEntityName((DynamicObject)entryDy)))) continue;
                name.append(flowEntryEntityName).append(';');
            }
        }
        return name.toString();
    }
}

