/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class JobFlowFrontNodeEdit
extends HRDataBaseEdit {
    public static final String META_NUMBER = "hbp_jobflowfrontnode";
    public static final String CUSTOM_FRONT_FLOW_ENTRY = "frontFlowEntry";
    public static final String CUSTOM_ALL_ENTRY_DATA_CACHE = "allEntryDataCache";
    public static final String CUSTOM_SELECT_ENTRY_ID = "selectEntryId";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private DynamicObjectCollection returnData = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            EntryGrid frontFlowEntryGrid = (EntryGrid)this.getView().getControl("hrflowentry");
            int[] selectRows = frontFlowEntryGrid.getSelectRows();
            if (selectRows != null && selectRows.length > 0) {
                DynamicObjectCollection frontFlowEntry = this.getModel().getEntryEntity("hrflowentry");
                DynamicObjectCollection result = new DynamicObjectCollection();
                for (int row : selectRows) {
                    result.add(frontFlowEntry.get(row));
                }
                this.returnData = result;
                this.getView().returnDataToParent((Object)this.returnData);
            }
            this.getView().close();
        } else if (BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONArray dys = (JSONArray)formShowParameter.getCustomParam(CUSTOM_FRONT_FLOW_ENTRY);
        DynamicObjectCollection flowDetailEntry = this.getModel().getEntryEntity("hrflowentry");
        if (Objects.nonNull(dys)) {
            for (int index = 0; index < dys.size(); ++index) {
                JSONObject dy = dys.getJSONObject(index);
                DynamicObject newDy = flowDetailEntry.addNew();
                newDy.set("id", dy.get((Object)"id"));
                newDy.set("seq", dy.get((Object)"seq"));
                newDy.set("type", dy.get((Object)"type"));
                newDy.set("frontnodename", dy.get((Object)"frontnodename"));
            }
        }
    }

    public void afterBindData(EventObject e) {
        String selectEntryIds;
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String string = selectEntryIds = Objects.nonNull(formShowParameter.getCustomParam(CUSTOM_SELECT_ENTRY_ID)) ? (String)formShowParameter.getCustomParam(CUSTOM_SELECT_ENTRY_ID) : "";
        if (HRStringUtils.isNotEmpty((String)selectEntryIds)) {
            DynamicObjectCollection flowDetailEntry = this.getModel().getEntryEntity("hrflowentry");
            EntryGrid grid = (EntryGrid)this.getView().getControl("hrflowentry");
            ArrayList indexList = Lists.newArrayListWithExpectedSize((int)flowDetailEntry.size());
            for (int index = 0; index < flowDetailEntry.size(); ++index) {
                DynamicObject entry = (DynamicObject)flowDetailEntry.get(index);
                String id = entry.getString("id");
                if (!selectEntryIds.contains(id)) continue;
                indexList.add(index);
            }
            if (!indexList.isEmpty()) {
                grid.selectRows(indexList.stream().mapToInt(Integer::intValue).toArray(), ((Integer)indexList.get(0)).intValue());
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (Objects.nonNull(this.returnData)) {
            boolean isCancel = false;
            Map<String, DynamicObject> idToDyMap = this.returnData.stream().collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
            JSONArray allEntryDataCache = (JSONArray)this.getView().getFormShowParameter().getCustomParam(CUSTOM_ALL_ENTRY_DATA_CACHE);
            boolean isMultiSelect = this.returnData.size() > 1;
            for (DynamicObject dy2 : this.returnData) {
                ComboProp typeProp = (ComboProp)dy2.getDataEntityType().getProperties().get((Object)"type");
                String type = dy2.getString((IDataEntityProperty)typeProp);
                if (isMultiSelect && "start".equals(type)) {
                    String typeDisplayName = typeProp.getItemByName(type);
                    this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9009\u62e9[{0}]\u8282\u70b9\u540e,\u4e0d\u80fd\u518d\u591a\u9009\u5176\u4ed6\u8282\u70b9\u4f5c\u4e3a\u524d\u5e8f\u8282\u70b9", (String)"JobFlowFrontNodeEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), typeDisplayName));
                    isCancel = true;
                }
                Set<String> parentNodeIds = this.getParentNodeIds(Sets.newHashSet((Object[])new String[]{dy2.getString("id")}), allEntryDataCache);
                for (Map.Entry<String, DynamicObject> entry : idToDyMap.entrySet()) {
                    if (!parentNodeIds.contains(entry.getKey())) continue;
                    isCancel = true;
                    String parentNodeName = this.getNodeName(entry.getValue());
                    this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8282\u70b9[{0}]\u4e0e\u8282\u70b9[{1}]\u5b58\u5728\u524d\u540e\u8282\u70b9\u4f9d\u8d56\u5173\u7cfb,\u4e0d\u80fd\u540c\u65f6\u4f5c\u4e3a\u5176\u4ed6\u8282\u70b9\u7684\u524d\u5e8f\u8282\u70b9,\u8bf7\u4fee\u6539", (String)"JobFlowFrontNodeEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), parentNodeName, this.getNodeName(dy2)));
                }
            }
            e.setCancel(isCancel);
        }
    }

    private String getNodeName(DynamicObject node) {
        IDataEntityProperty property;
        String nodeName = node.getString("frontnodename");
        String type = node.getString("type");
        if (("start".equals(type) || "end".equals(type)) && (property = (IDataEntityProperty)node.getDataEntityType().getProperties().get((Object)"type")) instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)property;
            nodeName = comboProp.getItemByName(type);
        }
        return nodeName;
    }

    private Set<String> getParentNodeIds(Set<String> childIds, JSONArray entries) {
        HashSet parentIds = Sets.newHashSetWithExpectedSize((int)entries.size());
        for (int index = 0; index < entries.size(); ++index) {
            String[] parentIdArray;
            JSONObject entry = entries.getJSONObject(index);
            String id = entry.getString("id");
            if (!childIds.contains(id)) continue;
            for (String parentId : parentIdArray = entry.getString("frontnodeentryids").split(";")) {
                if (!HRStringUtils.isNotEmpty((String)parentId)) continue;
                parentIds.add(parentId);
            }
        }
        if (parentIds.isEmpty()) {
            return parentIds;
        }
        parentIds.addAll(this.getParentNodeIds(parentIds, entries));
        return parentIds;
    }
}

