/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.flow.FlowJobStatusEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class JobSettingInsEdit
extends HRDataBaseEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit displayValueText = (TextEdit)this.getView().getControl("displayvalue");
        displayValueText.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (Objects.nonNull(baseShowParameter.getPkId())) {
            DynamicObjectCollection opEntries = this.getModel().getEntryEntity("jobaction");
            for (DynamicObject op : opEntries) {
                DynamicObjectCollection inParams = op.getDynamicObjectCollection("inparam");
                for (DynamicObject inParam : inParams) {
                    this.setLocateFieldName(inParam);
                }
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        String jobStatus;
        super.afterBindData(e);
        BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        int rowCount = this.getModel().getEntryRowCount("inparam");
        Boolean isEnable = Boolean.FALSE;
        Boolean btnIsVisible = Boolean.FALSE;
        if (Objects.nonNull(baseShowParameter.getPkId()) && (HRStringUtils.isEmpty((String)(jobStatus = (String)this.getModel().getValue("jobstatus"))) || FlowJobStatusEnum.STATUS_RUN_FAIL.getStatus().equals(jobStatus))) {
            isEnable = Boolean.TRUE;
            btnIsVisible = Boolean.TRUE;
        }
        for (int row = 0; row < rowCount; ++row) {
            this.getView().setEnable(isEnable, row, new String[]{"displayvalue"});
        }
        this.getView().setVisible(btnIsVisible, new String[]{"bar_save"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("displayvalue".equals(fieldName)) {
            ChangeData inDisplayValueChange = changeSet[0];
            int rowIndex = inDisplayValueChange.getRowIndex();
            if (Objects.isNull(inDisplayValueChange.getNewValue()) || HRStringUtils.isEmpty((String)String.valueOf(inDisplayValueChange.getNewValue()))) {
                this.getModel().setValue("runvalue", null, rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            TextEdit source = (TextEdit)evt.getSource();
            String entryKey = source.getEntryKey();
            if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                return;
            }
            if ("inparam".equals(entryKey)) {
                int parentRowIndex = this.getModel().getEntryCurrentRowIndex("jobaction");
                int rowNum = this.getModel().getEntryCurrentRowIndex("inparam");
                String fieldKey = source.getKey();
                if (HRStringUtils.equals((String)"displayvalue", (String)fieldKey)) {
                    String inParamType = (String)this.getModel().getValue("inparamtype", rowNum, parentRowIndex);
                    if (HRStringUtils.isEmpty((String)inParamType)) {
                        DynamicProperty typeProp = this.getModel().getDataEntityType().getProperty("inparamtype");
                        String inParamDisplayName = this.getInParamControlApDisplayName();
                        this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9[{0}]\u7b2c[{1}]\u884c[{2}]\u5b57\u6bb5", (String)"JobSettingInsEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), inParamDisplayName, rowNum + 1, typeProp.getDisplayName().getLocaleValue()));
                        return;
                    }
                    this.openWindowByParamType(inParamType, rowNum, parentRowIndex);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.isNotEmpty((String)actionId)) {
            if (actionId.contains("bizObject")) {
                ListSelectedRowCollection selectedRows;
                String[] keys = actionId.split("_");
                Object returnData = closedCallBackEvent.getReturnData();
                if (returnData instanceof ListSelectedRowCollection && !(selectedRows = (ListSelectedRowCollection)returnData).isEmpty()) {
                    ListSelectedRow selectedRow = selectedRows.get(0);
                    this.getModel().setValue("runvalue", selectedRow.getPrimaryKeyValue(), Integer.parseInt(keys[1]), Integer.parseInt(keys[2]));
                    this.getModel().setValue("displayvalue", (Object)selectedRow.getName(), Integer.parseInt(keys[1]), Integer.parseInt(keys[2]));
                }
            } else if (actionId.contains("enum")) {
                String[] keys = actionId.split("_");
                Object returnData = closedCallBackEvent.getReturnData();
                if (returnData instanceof Map) {
                    Map selectNode = (Map)returnData;
                    this.getModel().setValue("runvalue", selectNode.get("selectValue"), Integer.parseInt(keys[1]), Integer.parseInt(keys[2]));
                    this.getModel().setValue("displayvalue", selectNode.get("selectDisplayName"), Integer.parseInt(keys[1]), Integer.parseInt(keys[2]));
                }
            } else if (actionId.contains("string") || actionId.contains("date") || actionId.contains("number") || actionId.contains("boolean")) {
                String[] keys = actionId.split("_");
                Object returnData = closedCallBackEvent.getReturnData();
                if (Objects.nonNull(returnData)) {
                    this.getModel().setValue("runvalue", returnData, Integer.parseInt(keys[1]), Integer.parseInt(keys[2]));
                    this.getModel().setValue("displayvalue", returnData, Integer.parseInt(keys[1]), Integer.parseInt(keys[2]));
                }
            }
        }
    }

    private void setLocateFieldName(DynamicObject inParam) {
        String inParamType = inParam.getString("inparamtype");
        DynamicObject bizObject = inParam.getDynamicObject("inparambizobject");
        String runValue = inParam.getString("runvalue");
        if (HRStringUtils.isNotEmpty((String)runValue)) {
            if ("enum".equals(inParamType)) {
                if (Objects.nonNull(bizObject)) {
                    String property = inParam.getString("inobjectproperty");
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.getString("number"));
                    DynamicProperty entityTypeProperty = mainEntityType.getProperty(property);
                    if (Objects.nonNull(entityTypeProperty)) {
                        inParam.set("inobjectpropertyname", (Object)entityTypeProperty.getDisplayName().getLocaleValue());
                        if (entityTypeProperty instanceof ComboProp) {
                            ComboProp comboProp = (ComboProp)entityTypeProperty;
                            inParam.set("displayvalue", (Object)comboProp.getItemByName(runValue));
                        }
                    }
                }
            } else if ("bizObject".equals(inParamType)) {
                BasedataEntityType basedataEntityType;
                String nameProperty;
                MainEntityType mainEntityType;
                if (Objects.nonNull(bizObject) && (mainEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.getString("number"))) instanceof BasedataEntityType && HRStringUtils.isNotEmpty((String)(nameProperty = (basedataEntityType = (BasedataEntityType)mainEntityType).getNameProperty()))) {
                    DynamicObject dbDy;
                    ISimpleProperty primaryKey = basedataEntityType.getPrimaryKey();
                    HRBaseServiceHelper helper = new HRBaseServiceHelper(basedataEntityType.getName());
                    Object pkId = runValue;
                    if (primaryKey instanceof LongProp) {
                        pkId = Long.valueOf(runValue);
                    }
                    if (Objects.nonNull(dbDy = helper.queryOriginalOne(nameProperty, pkId))) {
                        inParam.set("displayvalue", (Object)dbDy.getString(nameProperty));
                    }
                }
            } else {
                inParam.set("displayvalue", (Object)runValue);
            }
        }
    }

    private void openWindowByParamType(String paramType, int rowNum, int parentRowNum) {
        if ("bizObject".equals(paramType)) {
            this.openBaseDataF7(rowNum, parentRowNum);
        } else if ("string".equals(paramType)) {
            this.openDynamicPopupByBaseType(paramType, TextProp.class, rowNum, parentRowNum);
        } else if ("date".equals(paramType)) {
            this.openDynamicPopupByBaseType(paramType, DateProp.class, rowNum, parentRowNum);
        } else if ("number".equals(paramType)) {
            this.openDynamicPopupByBaseType(paramType, DecimalProp.class, rowNum, parentRowNum);
        } else if ("boolean".equals(paramType)) {
            HashMap otherParamsMap = Maps.newHashMapWithExpectedSize((int)1);
            JSONArray itemArray = new JSONArray();
            itemArray.add((Object)this.getItemJsonObject("", "true", "true"));
            itemArray.add((Object)this.getItemJsonObject("", "false", "false"));
            otherParamsMap.put("valueItemJsonArray", itemArray);
            this.openDynamicPopupByBaseType(paramType, ComboProp.class, rowNum, parentRowNum, otherParamsMap);
        } else if ("enum".equals(paramType)) {
            this.openDynamicObjPropertyEnumF7(rowNum, parentRowNum);
        } else {
            this.openDynamicPopupByBaseType(paramType, TextProp.class, rowNum, parentRowNum);
        }
    }

    private void openBaseDataF7(int rowNum, int parentRowNum) {
        DynamicObject bizObject = (DynamicObject)this.getModel().getValue("inparambizobject", rowNum, parentRowNum);
        if (Objects.isNull(bizObject)) {
            DynamicProperty bizObjProp = this.getModel().getDataEntityType().getProperty("inparambizobject");
            String inParamDisplayName = this.getInParamControlApDisplayName();
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9[{0}]\u7b2c[{1}]\u884c[{2}]\u5b57\u6bb5", (String)"JobSettingInsEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), inParamDisplayName, rowNum + 1, bizObjProp.getDisplayName().getLocaleValue()));
            return;
        }
        Object oldId = this.getModel().getValue("runvalue", rowNum, parentRowNum);
        String metaNumber = bizObject.getString("number");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(metaNumber);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizObject_" + rowNum + "_" + parentRowNum));
        listShowParameter.setLookUp(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setF7Style(0);
        if (Objects.nonNull(oldId) && HRStringUtils.isNotEmpty((String)String.valueOf(oldId))) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)metaNumber);
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            if (primaryKey instanceof LongProp) {
                oldId = Long.valueOf(String.valueOf(oldId));
            }
            listShowParameter.setSelectedRows(new Object[]{oldId});
        }
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.setMultiSelect(false);
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)metaNumber);
        if (Objects.nonNull(listFormConfig)) {
            listShowParameter.setFormId(listFormConfig.getF7ListFormId());
            listShowParameter.getOpenStyle().setInlineStyleCss(css);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5143\u6570\u636e[{0}]\u672a\u7ed1\u5b9a\u5217\u8868\u6570\u636e\u8bf7\u68c0\u67e5", (String)"JobSettingInsEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), bizObject.getString("name")));
        }
    }

    private void openDynamicPopupByBaseType(String typeKey, Class<? extends FieldProp> clazz, int rowNum, int parentRowNum) {
        this.openDynamicPopupByBaseType(typeKey, clazz, rowNum, parentRowNum, null);
    }

    private void openDynamicPopupByBaseType(String typeKey, Class<? extends FieldProp> clazz, int rowNum, int parentRowNum, Map<String, Object> otherParamsMap) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hbp_dynamic_popup");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("formName", (Object)"");
        Object oldValue = this.getModel().getValue("runvalue", rowNum, parentRowNum);
        formShowParameter.setCustomParam("value", oldValue);
        formShowParameter.setCustomParam("fieldDisplayName", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"JobSettingInsEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("controlType", clazz);
        if (Objects.nonNull(otherParamsMap)) {
            for (Map.Entry<String, Object> entry : otherParamsMap.entrySet()) {
                formShowParameter.setCustomParam(entry.getKey(), entry.getValue());
            }
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, typeKey + "_" + rowNum + "_" + parentRowNum));
        this.getView().showForm(formShowParameter);
    }

    private void openDynamicObjPropertyEnumF7(int rowNum, int parentRowNum) {
        DynamicObject bizObject = (DynamicObject)this.getModel().getValue("inparambizobject", rowNum, parentRowNum);
        String inParamDisplayName = this.getInParamControlApDisplayName();
        if (Objects.isNull(bizObject)) {
            DynamicProperty bizObjProp = this.getModel().getDataEntityType().getProperty("inparambizobject");
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9[{0}]\u7b2c[{1}]\u884c[{2}]\u5b57\u6bb5", (String)"JobSettingInsEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), inParamDisplayName, rowNum + 1, bizObjProp.getDisplayName().getLocaleValue()));
            return;
        }
        String propertyNumber = (String)this.getModel().getValue("inobjectproperty", rowNum, parentRowNum);
        DynamicProperty propertyNumberNameProp = this.getModel().getDataEntityType().getProperty("inobjectpropertyname");
        if (HRStringUtils.isEmpty((String)propertyNumber)) {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9[{0}]\u7b2c[{1}]\u884c[{2}]\u5b57\u6bb5", (String)"JobSettingInsEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), inParamDisplayName, rowNum + 1, propertyNumberNameProp.getDisplayName().getLocaleValue()));
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.getString("number"));
        DynamicProperty property = mainEntityType.getProperty(propertyNumber);
        if (!(property instanceof ComboProp)) {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u7b2c[{1}]\u884c[{2}]\u5b57\u6bb5[{3}]\u5728\u5143\u6570\u636e[{4}]\u4e2d\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662f\u679a\u4e3e\u7c7b\u578b\u5b57\u6bb5", (String)"JobSettingInsEdit_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), inParamDisplayName, rowNum + 1, propertyNumberNameProp.getDisplayName().getLocaleValue(), this.getModel().getValue("inobjectpropertyname", rowNum, parentRowNum), bizObject.getString("name")));
            return;
        }
        ComboProp comboProp = (ComboProp)property;
        TreeNode rootNode = new TreeNode("", comboProp.getName(), comboProp.getDisplayName().getLocaleValue());
        List comboItems = comboProp.getComboItems();
        for (ValueMapItem item : comboItems) {
            rootNode.addChild(new TreeNode(comboProp.getName(), item.getValue(), item.getName().getLocaleValue()));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hbp_treefield_f7");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("treeNodes", (Object)SerializationUtils.toJsonString((Object)rootNode));
        Object oldValue = this.getModel().getValue("runvalue", rowNum, parentRowNum);
        formShowParameter.setCustomParam("selectValue", oldValue);
        formShowParameter.setCustomParam("formTitle", (Object)bizObject.getString("name"));
        formShowParameter.setCustomParam("selectDisplayName", this.getModel().getValue("displayvalue", rowNum, parentRowNum));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "enum_" + rowNum + "_" + parentRowNum));
        this.getView().showForm(formShowParameter);
    }

    private JSONObject getItemJsonObject(String image, String name, String value) {
        JSONObject itemJson = new JSONObject();
        itemJson.put("itemImage", (Object)image);
        itemJson.put("itemName", (Object)name);
        itemJson.put("itemValue", (Object)value);
        return itemJson;
    }

    private String getInParamControlApDisplayName() {
        String inParamDisplayName = "";
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)this.getView().getEntityId(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        Optional<ControlAp> inParamControlApOp = formMetadata.getItems().stream().filter(controlAp -> "inparamap".equals(controlAp.getKey())).findFirst();
        if (inParamControlApOp.isPresent()) {
            inParamDisplayName = inParamControlApOp.get().getName().getLocaleValue();
        }
        return inParamDisplayName;
    }
}

