/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.formula;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.cal.enums.AddSumTypeEnum;
import kd.hr.hbp.business.service.formula.cal.vo.AddSumVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultDetailVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultVO;
import kd.hr.hbp.business.service.formula.demo.CalDemoServiceTest;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.utils.FormulaCacheUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class CalUnitTestEdit
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(CalUnitTestEdit.class);
    private static final String UNIT_TEST = "UNIT_TEST";
    private static final String CUSTOM_TEST = "CUSTOM_TEST";
    private static final String BASE_DATA_ITEM_TEST = "BASE_DATA_ITEM_TEST";

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("testformula".equals(name)) {
            DynamicObject newValue;
            Set<String> uniqueCodeSet;
            int fieldRowCount = this.getModel().getEntryRowCount("entryentity");
            if (fieldRowCount > 0) {
                this.getModel().deleteEntryRows("entryentity", this.getIntArray(fieldRowCount));
            }
            if (!(uniqueCodeSet = this.getUniqueCodeSet(newValue = (DynamicObject)e.getChangeSet()[0].getNewValue())).isEmpty()) {
                this.getModel().batchCreateNewEntryRow("entryentity", uniqueCodeSet.size());
                BasedataProp property = (BasedataProp)((EntityType)this.getModel().getDataEntityType().getAllEntities().get("entryentity")).getProperty("resultitem");
                int index = 0;
                Map mapObjects = this.getModel().loadReferenceDataBatch(property.getDynamicComplexPropertyType(), uniqueCodeSet.toArray());
                for (String id : uniqueCodeSet) {
                    if (mapObjects.containsKey(id)) {
                        this.getModel().setValue("resultitem", (Object)id, index);
                        ++index;
                        continue;
                    }
                    this.getModel().deleteEntryRow("entryentity", index);
                }
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.initResultItemCache(this.getTreeNodeItems().orElseGet(() -> Lists.newArrayListWithExpectedSize((int)0)), false);
    }

    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int rowI = 0; rowI < intArray.length; ++rowI) {
            intArray[rowI] = rowI;
        }
        return intArray;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"calbtn"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && "calbtn".equals(key = ((Button)source).getKey())) {
            AddSumVO addSumVO;
            BasedataProp accumulator;
            HRBaseServiceHelper helper;
            DynamicObject[] addData;
            IDataEntityProperty property;
            DynamicObject testFormula = (DynamicObject)this.getModel().getValue("testformula");
            if (Objects.isNull(testFormula)) {
                this.getView().showTipNotification("test formula can't be empty");
                return;
            }
            BasedataProp testFormulaProperty = (BasedataProp)this.getModel().getDataEntityType().getProperty("testformula");
            DynamicObject db = new HRBaseServiceHelper(testFormulaProperty.getBaseEntityId()).loadSingle(testFormula.getPkValue());
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            HashMap customParams = null;
            HashMap<String, CalItemVO> uniqueCodeCalItemMap = new HashMap<String, CalItemVO>(16);
            uniqueCodeCalItemMap.computeIfAbsent(db.getString("resultitemuniquecode"), k -> {
                CalItemVO vo = new CalItemVO();
                vo.setUniqueCode(db.getString("resultitemuniquecode"));
                vo.setName(db.getString("resultitemuniquecode"));
                vo.setRoundingMode(RoundingMode.HALF_UP);
                vo.setDataLength(Integer.valueOf(db.getInt("resultitemdatalength") == 0 ? 30 : db.getInt("resultitemdatalength")));
                vo.setDataType(DataTypeEnum.getDataType((String)db.getString("resultitemdatatype")));
                vo.setScale(Integer.valueOf(db.getInt("resultitemscale")));
                return vo;
            });
            Set<String> uniqueCodeSet = this.getUniqueCodeSet(db);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            HashSet uniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
            if (Objects.nonNull(entryEntity) && !entryEntity.isEmpty()) {
                customParams = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
                for (DynamicObject dy : entryEntity) {
                    DynamicObject resultItem = dy.getDynamicObject("resultitem");
                    Object[] paramValue = dy.getString("paramvalue");
                    if (HRStringUtils.isEmpty((String)paramValue) || Objects.isNull(resultItem)) {
                        this.getView().showTipNotification("param can't be empty");
                        return;
                    }
                    String uniqueCode = resultItem.getString("uniquecode");
                    DynamicObject itemValue = paramValue;
                    DynamicObject[] entityNumber = resultItem.getString("entitynumber");
                    DataTypeEnum dataTypeEnum = DataTypeEnum.getDataType((String)resultItem.getString("datatype"));
                    if (DataTypeEnum.BASE == dataTypeEnum && HRStringUtils.isNotEmpty((String)entityNumber)) {
                        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
                        if (primaryKey instanceof LongProp) {
                            try {
                                itemValue = Long.valueOf((String)paramValue);
                            }
                            catch (Exception e) {
                                this.getView().showTipNotification(String.format(Locale.ROOT, "[%1$s] is not a long value", new Object[]{paramValue}));
                                return;
                            }
                        }
                        itemValue = new DynamicObject((DynamicObjectType)dataEntityType, (Object)itemValue);
                    } else if (DataTypeEnum.ARRAY_OBJECT == dataTypeEnum) {
                        try {
                            itemValue = JSONArray.parseArray((String)paramValue, Object.class).toArray();
                        }
                        catch (Exception e) {
                            this.getView().showTipNotification(String.format(Locale.ROOT, "[%1$s] is not a array value", new Object[]{paramValue}));
                            return;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)uniqueCode) && uniqueCode.contains(CUSTOM_TEST)) {
                        customParams.put(uniqueCode, itemValue);
                    } else {
                        params.put(uniqueCode, itemValue);
                    }
                    uniqueCodeCalItemMap.computeIfAbsent(uniqueCode, ke -> {
                        CalItemVO vo = new CalItemVO();
                        vo.setId(resultItem.getString("id"));
                        vo.setUniqueCode(uniqueCode);
                        vo.setRoundingMode(RoundingMode.HALF_UP);
                        vo.setDataLength(Integer.valueOf(resultItem.getInt("datalength") == 0 ? 30 : resultItem.getInt("datalength")));
                        vo.setDataType(DataTypeEnum.getDataType((String)resultItem.getString("datatype")));
                        vo.setScale(Integer.valueOf(2));
                        vo.setName(resultItem.getString("name"));
                        return vo;
                    });
                    uniqueCodes.add(uniqueCode);
                }
            }
            uniqueCodeSet.removeAll(uniqueCodes);
            HashMap addSumVOMap = Maps.newHashMapWithExpectedSize((int)16);
            String addSumMetaNumber = null;
            if (!uniqueCodeSet.isEmpty() && (property = (IDataEntityProperty)db.getDataEntityType().getProperties().get((Object)"accumulator")) instanceof BasedataProp && Objects.nonNull(addData = (helper = new HRBaseServiceHelper(addSumMetaNumber = (accumulator = (BasedataProp)property).getBaseEntityId())).loadDynamicObjectArray(new QFilter[]{new QFilter("number", "in", uniqueCodeSet)})) && addData.length > 0) {
                for (DynamicObject add : addData) {
                    addSumVO = new AddSumVO();
                    addSumVO.setAddSumId(add.getString("id"));
                    addSumVO.setUniqueCode(add.getString("number"));
                    addSumVO.setAddSumType(AddSumTypeEnum.valueOf((String)add.getString("addsumtype").toUpperCase(Locale.ROOT)));
                    addSumVO.setScale(Integer.valueOf(add.getInt("scale")));
                    addSumVO.setOriginalValue((Object)add.getBigDecimal("originalvalue"));
                    DynamicObjectCollection addUniqueCodes = add.getDynamicObjectCollection("entryentity");
                    HashSet addUniqueCodeSet = Sets.newHashSetWithExpectedSize((int)addUniqueCodes.size());
                    HashMap itemIsAddMap = Maps.newHashMapWithExpectedSize((int)addUniqueCodes.size());
                    HashMap itemProportionMap = Maps.newHashMapWithExpectedSize((int)addUniqueCodes.size());
                    for (DynamicObject addCode : addUniqueCodes) {
                        String code = addCode.getString("adduniquecode");
                        addUniqueCodeSet.add(code);
                        itemIsAddMap.put(code, Boolean.parseBoolean(addCode.getString("isadd")));
                        itemProportionMap.put(code, addCode.getBigDecimal("proportion").divide(new BigDecimal(100)));
                    }
                    addSumVO.setAddSumItemUniqueCodeSet((Set)addUniqueCodeSet);
                    addSumVO.setItemIsAddMap((Map)itemIsAddMap);
                    addSumVO.setItemProportionMap((Map)itemProportionMap);
                    params.put(addSumVO.getUniqueCode(), addSumVO.getOriginalValue());
                    addSumVOMap.put(addSumVO.getUniqueCode(), addSumVO);
                }
            }
            try {
                DynamicObject[] addSumData;
                CalResultDetailVO calResultDetailVO = CalDemoServiceTest.calFormulaTest((DynamicObject)db, (Map)params, uniqueCodeCalItemMap, (Map)customParams, (Map)addSumVOMap);
                Map addSumMap = calResultDetailVO.getAddSumMap();
                if (Objects.nonNull(addSumMap) && addSumMap.size() > 0 && HRStringUtils.isNotEmpty((String)addSumMetaNumber) && Objects.nonNull(addSumData = (helper = new HRBaseServiceHelper(addSumMetaNumber)).loadDynamicObjectArray(new QFilter[]{new QFilter("number", "in", addSumMap.keySet())})) && addSumData.length > 0) {
                    for (DynamicObject addSum : addSumData) {
                        addSumVO = (AddSumVO)addSumMap.get(addSum.getString("number"));
                        addSum.set("originalvalue", (Object)addSumVO.getTotalValue());
                        addSum.set("currentcalvalue", addSumVO.getCurrentCalValue());
                        addSum.set("totalvalue", (Object)addSumVO.getTotalValue());
                    }
                    helper.update(addSumData);
                }
                StringBuilder resultBd = new StringBuilder();
                Map sumResultMap = calResultDetailVO.getSumResultMap();
                if (Objects.isNull(sumResultMap) || sumResultMap.isEmpty()) {
                    String errorMsg = calResultDetailVO.getCalRecord().getErrorMsg();
                    if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                        this.getView().showTipNotification(errorMsg);
                    } else {
                        this.getView().showTipNotification("result is empty");
                    }
                } else {
                    for (Map.Entry entry : sumResultMap.entrySet()) {
                        resultBd.append((String)entry.getKey()).append(':');
                        CalResultVO calResultVO = (CalResultVO)entry.getValue();
                        if (calResultVO == null) continue;
                        Object calResultValue = calResultVO.getCalResultValue();
                        if (calResultValue instanceof Object[]) {
                            resultBd.append(Arrays.toString((Object[])calResultValue));
                        } else {
                            resultBd.append(String.valueOf(calResultValue));
                        }
                        resultBd.append(';');
                    }
                }
                Map outCustomItemResultMap = calResultDetailVO.getOutCustomItemResultMap();
                for (Map.Entry outputItemEntry : outCustomItemResultMap.entrySet()) {
                    resultBd.append((String)outputItemEntry.getKey()).append(':');
                    Object customValue = outputItemEntry.getValue();
                    if (customValue instanceof Object[]) {
                        resultBd.append(Arrays.toString((Object[])customValue));
                    } else {
                        resultBd.append(String.valueOf(customValue));
                    }
                    resultBd.append(';');
                }
                this.getView().showSuccessNotification(String.valueOf(resultBd));
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
            }
        }
    }

    protected void initResultItemCache(List<CalItem> resultItemList, boolean isUpdateCache) {
        List resultItemIds = (List)FormulaCacheUtils.getValueFromPageCache((IFormView)this.getView(), (String)"cache_init_result_item_id_key", List.class);
        if (Objects.nonNull(resultItemList)) {
            BasedataProp property = (BasedataProp)this.getModel().getProperty("resultitem");
            int size = resultItemList.size();
            ArrayList resultList = new ArrayList(size);
            if (Objects.isNull(property)) {
                return;
            }
            IDataEntityType dynamicObjectType = property.getComplexType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dynamicObjectType);
            if (Objects.nonNull(resultItemIds) && size == cacheManager.get(resultItemIds.toArray()).size()) {
                return;
            }
            ArrayList resultTmpIds = new ArrayList(size);
            for (CalItem calItemObj : resultItemList) {
                CalUnitTestEdit.convertObjToResultItem(calItemObj).ifPresent(resultItem -> {
                    String id = resultItem.getId();
                    DynamicObject data = new DynamicObject((DynamicObjectType)dynamicObjectType);
                    data.set("id", (Object)id);
                    resultTmpIds.add(id);
                    data.set("name", (Object)resultItem.getName());
                    data.set("itemcategory", (Object)resultItem.getItemCategory());
                    data.set("number", (Object)resultItem.getUniqueCode());
                    data.set("uniquecode", (Object)resultItem.getUniqueCode());
                    data.set("datatype", (Object)resultItem.getDataType().name());
                    data.set("entitynumber", (Object)resultItem.getEntityNumber());
                    data.set("propertyfield", (Object)resultItem.getPropertyField());
                    data.getDataEntityState().setFromDatabase(true);
                    resultList.add(data);
                });
            }
            if (!resultList.isEmpty()) {
                cacheManager.put(resultList.toArray());
                FormulaCacheUtils.putValueIntoPageCache((IFormView)this.getView(), (String)"cache_init_result_item_id_key", resultTmpIds);
            }
        }
    }

    private static Optional<CalItem> convertObjToResultItem(Object obj) {
        if (Objects.nonNull(obj)) {
            CalItem nodeItem = null;
            if (obj instanceof Map) {
                nodeItem = (CalItem)FormulaUtils.convertMapToObject((Map)((Map)obj), CalItem.class);
            }
            if (obj instanceof CalItem) {
                nodeItem = (CalItem)obj;
            }
            return Optional.ofNullable(nodeItem);
        }
        return Optional.empty();
    }

    private Optional<List<CalItem>> getTreeNodeItems() {
        QFilter statusFilter;
        QFilter enableFilter;
        BasedataProp customItemProp;
        String metaNumber;
        HRBaseServiceHelper helper;
        DynamicObject[] data;
        CalItem calItem;
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)(DataTypeEnum.values().length + 1));
        for (DataTypeEnum type : DataTypeEnum.values()) {
            calItem = new CalItem(UNIT_TEST, "UNIT_TEST_" + type.getCode(), UNIT_TEST, MessageFormat.format(ResManager.loadKDString((String)"\u6d4b\u8bd5-{0}", (String)"CalUnitTestEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), type.getAlias()), "UNIT_TEST_" + type.getCode(), type);
            nodes.add(calItem);
        }
        for (DataTypeEnum type : DataTypeEnum.values()) {
            calItem = new CalItem(CUSTOM_TEST, "CUSTOM_TEST_" + type.getCode(), CUSTOM_TEST, MessageFormat.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5-{0}", (String)"CalUnitTestEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), type.getAlias()), "CUSTOM_TEST_" + type.getCode(), type, true);
            nodes.add(calItem);
        }
        CalItem floatBase = new CalItem(UNIT_TEST, "UNIT_TEST_FLOAT_BASE", UNIT_TEST, ResManager.loadKDString((String)"\u6d4b\u8bd5-\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u9009\u9879", (String)"CalUnitTestEdit_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "UNIT_TEST_FLOAT_BASE", DataTypeEnum.BASE);
        floatBase.setItemType(CalItemTypeEnum.BASE_DATA);
        floatBase.setEntityNumber("hbss_nationality");
        floatBase.setPropertyField("name");
        nodes.add(floatBase);
        CalItem floatBaseText = new CalItem(UNIT_TEST, "UNIT_TEST_FLOAT_BASE_TEXT", UNIT_TEST, ResManager.loadKDString((String)"\u6d4b\u8bd5-\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u6587\u672c\u9009\u9879", (String)"CalUnitTestEdit_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "UNIT_TEST_FLOAT_BASE_TEXT", DataTypeEnum.TEXT);
        floatBaseText.setItemType(CalItemTypeEnum.BASE_DATA);
        floatBaseText.setEntityNumber("hbss_flok");
        floatBaseText.setPropertyField("name");
        nodes.add(floatBaseText);
        CalItem floatEnum = new CalItem(UNIT_TEST, "UNIT_TEST_FLOAT_ENUM", UNIT_TEST, ResManager.loadKDString((String)"\u6d4b\u8bd5-\u679a\u4e3e\u60ac\u6d6e\u6846\u9009\u9879", (String)"CalUnitTestEdit_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "UNIT_TEST_FLOAT_ENUM", DataTypeEnum.TEXT);
        floatEnum.setItemType(CalItemTypeEnum.ENUM);
        floatEnum.setEntityNumber("hbss_nationality");
        floatEnum.setPropertyField("initstatus");
        nodes.add(floatEnum);
        CalItem CustFloatBase = new CalItem(CUSTOM_TEST, "CUSTOM_TEST_FLOAT_BASE", CUSTOM_TEST, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5-\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u9009\u9879", (String)"CalUnitTestEdit_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "CUSTOM_TEST_FLOAT_BASE", DataTypeEnum.BASE);
        CustFloatBase.setItemType(CalItemTypeEnum.BASE_DATA);
        CustFloatBase.setEntityNumber("hbss_nationality");
        CustFloatBase.setPropertyField("name");
        CustFloatBase.setCustomItem(true);
        nodes.add(CustFloatBase);
        CalItem CustFloatBaseText = new CalItem(CUSTOM_TEST, "CUSTOM_TEST_FLOAT_BASE_SEX", CUSTOM_TEST, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5-\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u6027\u522b", (String)"CalUnitTestEdit_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "CUSTOM_TEST_FLOAT_BASE_SEX", DataTypeEnum.BASE);
        CustFloatBaseText.setItemType(CalItemTypeEnum.BASE_DATA);
        CustFloatBaseText.setEntityNumber("hbss_sex");
        CustFloatBaseText.setPropertyField("name");
        CustFloatBaseText.setCustomItem(true);
        nodes.add(CustFloatBaseText);
        CalItem CustFloatEnum = new CalItem(CUSTOM_TEST, "CUSTOM_TEST_FLOAT_ENUM", CUSTOM_TEST, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5-\u679a\u4e3e\u60ac\u6d6e\u6846\u9009\u9879", (String)"CalUnitTestEdit_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "CUSTOM_TEST_FLOAT_ENUM", DataTypeEnum.TEXT);
        CustFloatEnum.setItemType(CalItemTypeEnum.ENUM);
        CustFloatEnum.setEntityNumber("hbss_nationality");
        CustFloatEnum.setPropertyField("initstatus");
        CustFloatEnum.setCustomItem(true);
        nodes.add(CustFloatEnum);
        BasedataProp testFormulaProperty = (BasedataProp)this.getModel().getDataEntityType().getProperty("testformula");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)testFormulaProperty.getBaseEntityId());
        DynamicProperty baseDataItemProp = dataEntityType.getProperty("basedataitem");
        if (baseDataItemProp instanceof BasedataProp && Objects.nonNull(data = (helper = new HRBaseServiceHelper(metaNumber = (customItemProp = (BasedataProp)baseDataItemProp).getBaseEntityId())).loadDynamicObjectArray(new QFilter[]{enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C")})) && data.length > 0) {
            for (DynamicObject sum : data) {
                try {
                    CalItem baseDataItem = new CalItem(BASE_DATA_ITEM_TEST, "_" + sum.getString("id"), BASE_DATA_ITEM_TEST, sum.getString("name"), "_" + sum.getString("id"), DataTypeEnum.getDataType((String)sum.getString("datatype")));
                    nodes.add(baseDataItem);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }
        return Optional.of(nodes);
    }

    private Set<String> getUniqueCodeSet(DynamicObject newValue) {
        String dependentCalItemForDg;
        String dependentCalItemForFunc;
        String dependentCustItem;
        HashSet<String> uniqueCodeSet = new HashSet<String>(16);
        String dependentCalItem = newValue.getString("dependentcalitem");
        if (HRStringUtils.isNotEmpty((String)dependentCalItem)) {
            uniqueCodeSet.addAll(Arrays.asList(dependentCalItem.split(",")));
        }
        if (HRStringUtils.isNotEmpty((String)(dependentCustItem = newValue.getString("dependentcustitem")))) {
            uniqueCodeSet.addAll(Arrays.asList(dependentCustItem.split(",")));
        }
        if (HRStringUtils.isNotEmpty((String)(dependentCalItemForFunc = newValue.getString("dependentcalitemforfunc")))) {
            uniqueCodeSet.addAll(Arrays.asList(dependentCalItemForFunc.split(",")));
        }
        if (HRStringUtils.isNotEmpty((String)(dependentCalItemForDg = newValue.getString("dependentcalitemfordg")))) {
            uniqueCodeSet.addAll(Arrays.asList(dependentCalItemForDg.split(",")));
        }
        return uniqueCodeSet;
    }
}

