/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.formula;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.FormulaFormatService;
import kd.hr.hbp.business.service.formula.FormulaParseService;
import kd.hr.hbp.business.service.formula.entity.FormulaInfo;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeItem;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.Item;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.helper.FormulaDataServiceHelper;
import kd.hr.hbp.business.service.formula.helper.FormulaReplaceHelper;
import kd.hr.hbp.business.service.formula.helper.FormulaSplitHelper;
import kd.hr.hbp.business.service.formula.helper.FormulaViewServiceHelper;
import kd.hr.hbp.business.service.formula.utils.FormulaCacheUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaListUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaOperatorUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaTreeNodeUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.formula.control.FormulaResultItemEdit;
import kd.sdk.annotation.SdkPlugin;

@SdkPlugin(name="\u516c\u5f0f\u8ba1\u7b97\u914d\u7f6e\u6a21\u677f\u62bd\u8c61\u7c7b\u63d2\u4ef6")
public abstract class FormulaSettingEdit
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(FormulaSettingEdit.class);
    private static final String[] BTNKEYARRAY = new String[]{"oper_plus", "oper_subtract", "oper_multiply", "oper_divide", "oper_quot", "oper_point", "oper_//", "oper_equal", "oper_unequal", "oper_lt", "oper_gt", "oper_ltorequal", "oper_gtorequal", "oper_parentheses", "condition_if", "condition_then", "condition_elseif", "condition_else", "condition_and", "condition_or", "condition_like", "condition_result", "bar_save", "bar_saveasdraft", "bar_example", "bar_format", "bar_close", "imageap", "condition_endif", "oper_assign", "complex_while", "complex_while_end", "type_text", "type_int", "type_num", "type_boolean", "type_date", "type_datetime", "type_object", "type_arr_number", "type_arr_text", "type_arr_boolean", "type_arr_int", "type_arr_date", "type_arr_obj", "invoke_length", "oper_long_annotation", "condition_null", "condition_exit", "op_export", "show_more", "hide_more"};
    private static final String FORMULAEDITOR = "formulaeditor";
    private static final String FORMULAPREVIEW = "formulapreview";
    private static final String FORMULAFORMAT = "formulaformat";
    private static final String GRAMMAR_CHECK = "grammarcheck";
    private static final String DESCHTML = "deschtml";
    private static final String ITEMTREEVIEW = "itemtreeview";
    private static final String FUNCTREE = "functree";
    private static final String CONTROL_FS_BASE_INFO = "fs_baseinfo";
    private static final String CONTROL_OPER_PANEL = "flexpanelap14";
    private static final String CACHE_INIT_RESULT_ITEM_ID_KEY = "cache_init_result_item_id_key";
    private static final String BTN_GRAMMAR_CHECK = "grammarcheckbtn";
    private static final String BTN_FORMAT = "formatbtn";
    private static final String BTN_PRE_VIEW = "previewbtn";
    private static final String CONTROL_OPERATOR_MORE = "opermorepanel";

    protected abstract Optional<List<TreeNodeItem>> getTreeNodeItemList();

    protected abstract Optional<List<ResultItem>> getResultItemList();

    protected Optional<List<TreeNodeItem>> getDataGradeItemList() {
        return Optional.empty();
    }

    protected Set<String> getExtFuncTypeNumbers() {
        return null;
    }

    protected Set<String> getExtFuncTypeNames() {
        return null;
    }

    protected String getOriginalExp() {
        this.getModel().updateCache();
        return (String)this.getModel().getValue("originalexp");
    }

    protected String getShowFormulaByUniqueCodeExp() {
        String uniqueCodeExp = (String)this.getModel().getValue("uniquecodeexp");
        FormulaSplitHelper splitHelper = new FormulaSplitHelper();
        List splitNodes = splitHelper.getOriginalNodes(uniqueCodeExp, null);
        Map<String, String> uniqueCodeDisplayNameMap = this.getUniqueCodeToDisplayNameMap();
        String formulaExp = FormulaFormatService.formatFormulaExp((String)FormulaReplaceHelper.transfer((List)splitNodes, uniqueCodeDisplayNameMap), (IFormView)this.getView());
        IDataEntityProperty originalExpProp = this.getModel().getProperty("originalexp");
        this.getModel().setValue("originalexp", (Object)formulaExp);
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(originalExpProp.getOrdinal(), false);
        return formulaExp;
    }

    private Map<String, String> getUniqueCodeToDisplayNameMap() {
        Map functionItems = FormulaCacheUtils.getMapCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_fuc_map_cache_key", FunctionItem.class);
        Map dataGradeItems = FormulaCacheUtils.getMapCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_data_grade_map_cache_key", DataGradeItem.class);
        Map calItems = FormulaCacheUtils.getMapCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_cal_item_map_cache_key", CalItem.class);
        return FormulaReplaceHelper.getUniqueCodeToDisplayNameMap((DynamicObject)this.getModel().getDataEntity(true), functionItems.values(), dataGradeItems.values(), calItems.values());
    }

    protected void initItemTree(List<TreeNodeItem> treeNodeCacheList, boolean isUpdateCache) {
        Optional optionalTreeNodes = FormulaTreeNodeUtils.loadTreeNodeItemList(treeNodeCacheList);
        TreeView treeView = (TreeView)this.getView().getControl(ITEMTREEVIEW);
        if (optionalTreeNodes.isPresent()) {
            List treeNodes = (List)optionalTreeNodes.get();
            LOGGER.info("initItemTree_size_is_{},isUpdateCache = {}", (Object)treeNodes.size(), (Object)isUpdateCache);
            treeView.deleteAllNodes();
            treeView.addNodes(treeNodes);
        } else {
            treeView.deleteAllNodes();
        }
        if (isUpdateCache) {
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
            HashSet itemCategorySet = new HashSet(FormulaCacheUtils.getListBaseValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_item_category_set_cache_key", String.class));
            tempMap.put("formula_cal_item_map_cache_key", FormulaUtils.itemListToMap(treeNodeCacheList));
            tempMap.put("formula_cal_item_tree_node_cache_key", treeNodeCacheList);
            tempMap.put("formula_cal_item_node_id_cache_key", treeNodeCacheList.stream().filter(item -> item instanceof CalItem).collect(Collectors.toMap(Item::getId, item -> item)));
            itemCategorySet.addAll(FormulaUtils.getItemCategorySet(treeNodeCacheList));
            tempMap.put("formula_item_category_set_cache_key", itemCategorySet);
            this.updateFormulaAllCacheMap(tempMap);
            this.refreshFormulaEdit();
        }
    }

    protected void initDataGradeTree(List<TreeNodeItem> treeNodeCacheList, boolean isUpdateCache) {
        if (Objects.nonNull(treeNodeCacheList)) {
            LOGGER.info("initDataGradeTree_size_is_{},isUpdateCache = {}", (Object)treeNodeCacheList.size(), (Object)isUpdateCache);
            List dataGradeTreeItemList = FormulaUtils.getDataGradeTreeItemList(treeNodeCacheList);
            TreeView treeView = (TreeView)this.getView().getControl(FUNCTREE);
            TreeNodeItem rootItem = this.getDataGradeRootItem();
            dataGradeTreeItemList.add(rootItem);
            Optional optionalTreeNodes = FormulaTreeNodeUtils.loadTreeNodeItemList((List)dataGradeTreeItemList);
            if (optionalTreeNodes.isPresent()) {
                List treeNodes = (List)optionalTreeNodes.get();
                treeView.deleteNode(rootItem.getId());
                TreeNode treeNode = (TreeNode)treeNodes.get(0);
                if (Objects.nonNull(treeNode.getChildren()) && !treeNode.getChildren().isEmpty()) {
                    LOGGER.info("addDataGradeNode_size_is_{},isUpdateCache = {}", (Object)treeNode.getChildren().size(), (Object)isUpdateCache);
                    treeView.addNodes(treeNodes);
                }
            }
            if (isUpdateCache) {
                HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
                HashSet itemCategorySet = new HashSet(FormulaCacheUtils.getListBaseValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_item_category_set_cache_key", String.class));
                tempMap.put("formula_data_grade_map_cache_key", FormulaUtils.itemListToMap(treeNodeCacheList));
                tempMap.put("formula_data_grade_tree_node_cache_key", treeNodeCacheList);
                itemCategorySet.addAll(FormulaUtils.getItemCategorySet(treeNodeCacheList));
                tempMap.put("formula_item_category_set_cache_key", itemCategorySet);
                this.updateFormulaAllCacheMap(tempMap);
                this.refreshFormulaEdit();
            }
        }
    }

    protected void initResultItemCache(List<ResultItem> resultItemList, boolean isUpdateCache) {
        List resultItemIds = (List)FormulaCacheUtils.getValueFromPageCache((IFormView)this.getView(), (String)CACHE_INIT_RESULT_ITEM_ID_KEY, List.class);
        if (Objects.nonNull(resultItemList)) {
            LOGGER.info("initResultItemCache_size_is_{},isUpdateCache = {}", (Object)resultItemList.size(), (Object)isUpdateCache);
            BasedataProp property = (BasedataProp)this.getModel().getProperty("resultitem");
            int size = resultItemList.size();
            ArrayList resultList = new ArrayList(size);
            if (Objects.isNull(property)) {
                return;
            }
            IDataEntityType dynamicObjectType = property.getComplexType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dynamicObjectType);
            if (Objects.nonNull(resultItemIds) && resultItemIds.containsAll(cacheManager.get(resultItemIds.toArray()).keySet())) {
                return;
            }
            ArrayList resultTmpIds = new ArrayList(size);
            for (ResultItem resultItemObj : resultItemList) {
                FormulaSettingEdit.convertObjToResultItem(resultItemObj).ifPresent(resultItem -> {
                    String uniqueCode = resultItem.getUniqueCode();
                    if (HRStringUtils.isNotEmpty((String)uniqueCode) && !"0".equals(uniqueCode)) {
                        String id = resultItem.getId();
                        DynamicObject data = new DynamicObject((DynamicObjectType)dynamicObjectType);
                        data.set("id", (Object)id);
                        resultTmpIds.add(id);
                        data.set("name", (Object)resultItem.getName());
                        data.set("itemcategory", (Object)resultItem.getItemCategory());
                        data.set("number", (Object)uniqueCode);
                        data.set("uniquecode", (Object)uniqueCode);
                        data.set("datatype", (Object)resultItem.getDataType().name());
                        data.set("datalength", (Object)resultItem.getDataLength());
                        data.set("scale", (Object)resultItem.getScale());
                        data.set("issubsectionitem", (Object)(resultItem.isCalProportionItem() ? "1" : "0"));
                        data.set("entitynumber", (Object)resultItem.getEntityNumber());
                        data.set("propertyfield", (Object)resultItem.getPropertyField());
                        data.getDataEntityState().setFromDatabase(true);
                        resultList.add(data);
                    }
                });
            }
            if (!resultList.isEmpty()) {
                cacheManager.put(resultList.toArray());
                FormulaCacheUtils.putValueIntoPageCache((IFormView)this.getView(), (String)CACHE_INIT_RESULT_ITEM_ID_KEY, resultTmpIds);
            }
            if (isUpdateCache) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>(2);
                tempMap.put("formula_result_item_map_cache_key", FormulaUtils.itemListToMap(new ArrayList<ResultItem>(resultItemList)));
                tempMap.put("formula_result_item_list_cache_key", resultItemList);
                this.updateFormulaAllCacheMap(tempMap);
                this.refreshFormulaEdit();
            }
        }
    }

    protected FormulaParseService getFormulaParseService() {
        return new FormulaParseService();
    }

    protected void afterSettingParseModelValue(FormulaInfo formulaInfo) {
    }

    protected void setFormulaEditorValue(String originalExp) {
        CustomControl formulaEditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, String> data = new HashMap<String, String>(3);
        data.put("method", "setValue");
        data.put("value", originalExp);
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaEditor.setData(data);
    }

    public void registerListener(EventObject eventObject) {
        try {
            super.registerListener(eventObject);
            this.addClickListeners(BTNKEYARRAY);
            this.createDynamicBaseDataEdit().ifPresent(item -> {
                ArrayList<FormulaResultItemEdit> items = new ArrayList<FormulaResultItemEdit>(1);
                items.add((FormulaResultItemEdit)((Object)item));
                this.getView().createControlIndex(items);
            });
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void initialize() {
        try {
            super.initialize();
            this.initResultItemCache(this.getResultItemCache(), false);
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        try {
            super.beforeBindData(eventObject);
            this.initTree("formula_fuc_tree_node_cache_key");
            this.initTree("formula_cal_item_tree_node_cache_key");
            this.initTree("formula_data_grade_tree_node_cache_key");
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void afterBindData(EventObject eventObject) {
        try {
            super.afterBindData(eventObject);
            this.initFormulaEditor(this.getFormulaAllCacheMap());
            this.showToolBtn();
            Container baseInfo = (Container)this.getView().getControl(CONTROL_FS_BASE_INFO);
            boolean viewStatus = FormulaViewServiceHelper.isViewStatus((IFormView)this.getView());
            baseInfo.setCollapse(viewStatus);
            this.getView().setVisible(Boolean.valueOf(!viewStatus), new String[]{CONTROL_OPER_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OPERATOR_MORE});
            this.getView().setVisible(Boolean.TRUE, new String[]{"show_more"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"hide_more"});
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            String key = ((Control)evt.getSource()).getKey();
            if (key.startsWith("num_") || key.startsWith("op_") || key.startsWith("oper_") || key.startsWith("condition_") || key.startsWith("complex_") || key.startsWith("type_") || key.startsWith("invoke_")) {
                this.addOperationToEditor(key);
            }
            if ("show_more".equals(key)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_OPERATOR_MORE});
                this.getView().setVisible(Boolean.FALSE, new String[]{"show_more"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"hide_more"});
            } else if ("hide_more".equals(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OPERATOR_MORE});
                this.getView().setVisible(Boolean.FALSE, new String[]{"hide_more"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"show_more"});
            }
        }
        catch (Exception e) {
            LOGGER.error("error_", (Throwable)e);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        try {
            super.beforeItemClick(evt);
            String operationKey = evt.getOperationKey();
            if (HRStringUtils.isNotEmpty((String)operationKey)) {
                switch (operationKey) {
                    case "save": 
                    case "submit": 
                    case "saveandnew": 
                    case "confirmchange": 
                    case "confirmchangenoaudit": {
                        if (!this.refreshCacheAndCheckFormulaIsEmpty() && this.checkAndParseExpBeforeSave()) break;
                        evt.setCancel(true);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            super.beforeDoOperation(args);
            FormOperate operate = (FormOperate)args.getSource();
            switch (operate.getOperateKey()) {
                case "formulapreview": {
                    this.openFormulaExamplePage("hbp_formulapreview", ShowType.Modal, this.getOriginalExp());
                    args.setCancel(true);
                    break;
                }
                case "formulaformat": {
                    if (!this.refreshCacheAndCheckFormulaIsEmpty() && !this.formatFormulaExp()) break;
                    args.setCancel(true);
                    break;
                }
                case "grammarcheck": {
                    if (!this.refreshCacheAndCheckFormulaIsEmpty() && !this.checkExp()) break;
                    args.setCancel(true);
                    break;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        try {
            super.afterDoOperation(args);
            FormOperate operate = (FormOperate)args.getSource();
            switch (operate.getOperateKey()) {
                case "unsubmit": {
                    this.setFormulaEditorReadOnly(false);
                    this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GRAMMAR_CHECK, BTN_FORMAT});
                    this.getPageCache().remove("pageStatus");
                    break;
                }
                case "submit": 
                case "confirmchange": 
                case "confirmchangenoaudit": {
                    if (!args.getOperationResult().isSuccess()) {
                        return;
                    }
                    this.setFormulaEditorReadOnly(true);
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_GRAMMAR_CHECK, BTN_FORMAT});
                    this.getPageCache().put("pageStatus", "view");
                    break;
                }
                case "refresh": {
                    Html html = (Html)this.getView().getControl(DESCHTML);
                    html.setConent(null);
                    this.setFormulaEditorValue(this.getShowFormulaByUniqueCodeExp());
                    break;
                }
                case "new": {
                    this.setFormulaEditorValue("");
                    break;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        try {
            String key = eventArgs.getKey();
            String args = eventArgs.getEventArgs();
            if (FORMULAEDITOR.equals(key)) {
                this.updateOriginalExp(args);
            }
        }
        catch (Exception exception) {
            LOGGER.error("error_", (Throwable)exception);
        }
    }

    private Optional<FormulaResultItemEdit> createDynamicBaseDataEdit() {
        BasedataEdit resultItemControl;
        if (Objects.nonNull(this.getView()) && Objects.nonNull(resultItemControl = (BasedataEdit)this.getView().getControl("resultitem")) && !(resultItemControl instanceof FormulaResultItemEdit)) {
            FormulaResultItemEdit resultItemEdit = new FormulaResultItemEdit();
            resultItemEdit.setView(resultItemControl.getView());
            resultItemEdit.setModel(resultItemControl.getModel());
            resultItemEdit.setDisplayProp(resultItemControl.getDisplayProp());
            resultItemEdit.setEditSearchProp(resultItemControl.getEditSearchProp());
            resultItemEdit.setLayoutId(resultItemControl.getLayoutId());
            resultItemEdit.setKey(resultItemControl.getKey());
            resultItemEdit.setLock(resultItemControl.getLock());
            return Optional.of(resultItemEdit);
        }
        return Optional.empty();
    }

    private void initFormulaEditor(Map<String, Object> dataMap) {
        CustomControl formulaeditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("key", FormulaDataServiceHelper.getEditorKey((IFormView)this.getView(), dataMap));
        String showValue = null;
        try {
            showValue = this.getShowFormulaByUniqueCodeExp();
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ROOT, "translate_lang_error_id_is_%1$s", this.getModel().getDataEntity().getPkValue()), (Throwable)e);
            showValue = this.getOriginalExp();
        }
        data.put("value", showValue);
        if (FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
            data.put("readOnly", "nocursor");
        }
        data.put("method", "init");
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaeditor.setData(data);
    }

    protected void initFuncTree(List<TreeNodeItem> treeNodeCacheList, boolean isUpdateCache) {
        if (Objects.nonNull(treeNodeCacheList)) {
            LOGGER.info("initFuncTree_size_is_{},isUpdateCache = {}", (Object)treeNodeCacheList.size(), (Object)isUpdateCache);
            treeNodeCacheList.add(FormulaTreeNodeUtils.getFunctionRootItem());
            FormulaTreeNodeUtils.loadTreeNodeItemList(treeNodeCacheList).ifPresent(treeNodes -> {
                TreeView treeView = (TreeView)this.getView().getControl(FUNCTREE);
                treeView.deleteNode("FC");
                treeView.addNodes(treeNodes);
            });
            if (isUpdateCache) {
                HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
                HashSet itemCategorySet = new HashSet(FormulaCacheUtils.getListBaseValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_item_category_set_cache_key", String.class));
                tempMap.put("formula_fuc_tree_node_cache_key", treeNodeCacheList);
                tempMap.put("formula_fuc_map_cache_key", FormulaUtils.itemListToMap(treeNodeCacheList));
                itemCategorySet.addAll(FormulaUtils.getItemCategorySet(treeNodeCacheList));
                tempMap.put("formula_item_category_set_cache_key", itemCategorySet);
                this.updateFormulaAllCacheMap(tempMap);
                this.refreshFormulaEdit();
            }
        }
    }

    public void initTree(String key) {
        if (Objects.isNull(key)) {
            return;
        }
        switch (key) {
            case "formula_fuc_tree_node_cache_key": {
                this.initFuncTree(this.getFunctionTreeNodeCache(), false);
                break;
            }
            case "formula_cal_item_tree_node_cache_key": {
                this.initItemTree(this.getCalItemTreeNodeCache(), false);
                break;
            }
            case "formula_data_grade_tree_node_cache_key": {
                this.initDataGradeTree(this.getDataGradeItemTreeNodeCache(), false);
                break;
            }
        }
    }

    private void addOperationToEditor(String key) {
        CustomControl formulaEditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("method", "insertValue");
        String value = FormulaOperatorUtils.getOperatorValue((String)key);
        if (key.startsWith("condition_") || key.startsWith("complex_") || key.startsWith("type_")) {
            value = " " + value + " ";
            if (HRStringUtils.equals((String)key, (String)"condition_result")) {
                value = value + "= ";
            }
        }
        if (key.startsWith("op_")) {
            value = value + " ";
        }
        data.put("value", value);
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaEditor.setData(data);
    }

    @ExcludeFromJacocoGeneratedReport
    private void setFormulaEditorReadOnly(boolean readOnly) {
        CustomControl formulaEditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("method", "setReadOnly");
        if (readOnly) {
            data.put("readOnly", "nocursor");
        } else {
            data.put("readOnly", false);
        }
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaEditor.setData(data);
    }

    private void updateOriginalExp(String args) {
        String originalExp = (String)this.getModel().getValue("originalexp");
        if (!HRStringUtils.equals((String)originalExp, (String)args)) {
            this.getModel().setValue("originalexp", (Object)args);
        }
    }

    private boolean checkExp() {
        FormulaParseService formulaParse = this.getFormulaParseService();
        try {
            formulaParse.parseFormula(this.getModel().getDataEntity(), 0L, this.getView());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bed\u6cd5\u6821\u9a8c\u6210\u529f\u3002", (String)"FormulaSettingEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        catch (KDBizException kdBizException) {
            LOGGER.error("checkExp_error:", (Throwable)kdBizException);
            String msg = kdBizException.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u516c\u5f0f\u8bed\u6cd5\u4e0d\u6b63\u786e\u3002", (String)"FormulaSettingEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            }
            this.getView().showTipNotification(msg);
        }
        catch (Exception e1) {
            LOGGER.error("checkExp_error:", (Throwable)e1);
            String msg = ResManager.loadKDString((String)"\u516c\u5f0f\u8bed\u6cd5\u4e0d\u6b63\u786e\u3002", (String)"FormulaSettingEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    protected boolean checkAndParseExpBeforeSave() {
        boolean checkSuccess = true;
        FormulaParseService formulaParse = this.getFormulaParseService();
        try {
            long formulaId = 0L;
            long boId = (Long)this.getModel().getValue("boid");
            if (boId == 0L) {
                long id = ORM.create().genLongId("hbp_formulatpl");
                this.getModel().setValue("id", (Object)id);
                formulaId = id;
            } else {
                formulaId = boId;
            }
            FormulaInfo formulaInfo = formulaParse.parseFormula(this.getModel().getDataEntity(), formulaId, this.getView());
            this.setFormulaSaveValue(formulaInfo);
        }
        catch (KDBizException kdBizException) {
            LOGGER.error("checkExp_error:", (Throwable)kdBizException);
            String msg = kdBizException.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u516c\u5f0f\u8bed\u6cd5\u4e0d\u6b63\u786e\u3002", (String)"FormulaSettingEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            }
            this.showErrorMsg(msg);
            checkSuccess = false;
        }
        catch (Exception e1) {
            LOGGER.error("checkExp_error:", (Throwable)e1);
            String msg = ResManager.loadKDString((String)"\u516c\u5f0f\u8bed\u6cd5\u4e0d\u6b63\u786e\u3002", (String)"FormulaSettingEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            this.showErrorMsg(msg);
            checkSuccess = false;
        }
        return checkSuccess;
    }

    @ExcludeFromJacocoGeneratedReport
    private void setFormulaSaveValue(FormulaInfo formulaInfo) {
        this.getModel().beginInit();
        this.getModel().setValue("executeexp", (Object)formulaInfo.getExecuteCode());
        this.getModel().setValue("uniquecodeexp", (Object)formulaInfo.getUniqueKeyCode());
        this.getModel().setValue("originalexp", (Object)formulaInfo.getOriginalCode());
        this.getModel().setValue("isdraft", (Object)Boolean.FALSE);
        this.getModel().setValue("dependentfunc", (Object)FormulaListUtils.join((Collection)formulaInfo.getFcUniqueCodeSet(), (String)","));
        this.getModel().setValue("dependentcalitem", (Object)FormulaListUtils.join(formulaInfo.getCalUniqueCodeKeyMap().keySet(), (String)","));
        this.getModel().setValue("dependentcustitem", (Object)FormulaListUtils.join((Collection)formulaInfo.getCalCustomUniqueCodeSet(), (String)","));
        this.getModel().setValue("dependentcalitemforfunc", (Object)FormulaListUtils.join(formulaInfo.getCalForFuncUniqueCodeKeyMap().keySet(), (String)","));
        this.getModel().setValue("dependentcalitemfordg", (Object)FormulaListUtils.join(formulaInfo.getCalForDataGradeUniqueCodeKeyMap().keySet(), (String)","));
        this.getModel().setValue("dependentdatagrade", (Object)FormulaListUtils.join((Collection)formulaInfo.getDataGradeUniqueCodeSet(), (String)","));
        this.getModel().setValue("dependentbasedata", (Object)FormulaListUtils.join((Collection)formulaInfo.getBaseDataUniqueCodeSet(), (String)","));
        this.getModel().setValue("dependentenum", (Object)FormulaListUtils.join((Collection)formulaInfo.getEnumUniqueCodeSet(), (String)","));
        this.getModel().setValue("resultitemcategory", (Object)formulaInfo.getResultItem().getItemCategory());
        this.getModel().setValue("resultitemuniquecode", (Object)formulaInfo.getResultItem().getUniqueCode());
        this.getModel().setValue("resultitemdatatype", (Object)formulaInfo.getResultItem().getDataType().name());
        this.getModel().setValue("resultitemdatalength", (Object)formulaInfo.getResultItem().getDataLength());
        this.getModel().setValue("resultitemscale", (Object)formulaInfo.getResultItem().getScale());
        HashSet outputItemCodeSet = Sets.newHashSetWithExpectedSize((int)16);
        outputItemCodeSet.addAll(formulaInfo.getOutputCalItemMap().keySet());
        outputItemCodeSet.addAll(formulaInfo.getOutputCustomCalItemMap().keySet());
        this.getModel().setValue("exportitem", (Object)FormulaListUtils.join((Collection)outputItemCodeSet, (String)","));
        this.getModel().endInit();
        this.afterSettingParseModelValue(formulaInfo);
    }

    private boolean formatFormulaExp() {
        try {
            String formulaInfo = FormulaFormatService.formatFormulaExp((String)this.getOriginalExp(), (IFormView)this.getView());
            this.setFormulaEditorValue(formulaInfo);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u683c\u5f0f\u5316\u6210\u529f\u3002", (String)"FormulaSettingEdit_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e1) {
            LOGGER.error("formatFormulaExp_error:", (Throwable)e1);
            this.getView().showTipNotification(e1.getMessage());
        }
        return true;
    }

    private void openFormulaExamplePage(String formId, ShowType type, String args) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(type);
        showParameter.setCustomParam("content", (Object)args);
        showParameter.setCustomParam("keys", (Object)FormulaDataServiceHelper.getEditorKey((IFormView)this.getView(), null));
        this.getView().showForm(showParameter);
    }

    private static Optional<ResultItem> convertObjToResultItem(Object obj) {
        if (Objects.nonNull(obj)) {
            ResultItem nodeItem = null;
            if (obj instanceof Map) {
                nodeItem = (ResultItem)FormulaUtils.convertMapToObject((Map)((Map)obj), ResultItem.class);
            }
            if (obj instanceof ResultItem) {
                nodeItem = (ResultItem)obj;
            }
            return Optional.ofNullable(nodeItem);
        }
        return Optional.empty();
    }

    private Map<String, Object> getFormulaAllCacheMap() {
        HashMap cacheMap = (HashMap)FormulaCacheUtils.getValueFromPageCache((IFormView)this.getView(), (String)"hbp_formula_cache_key", Map.class);
        if (Objects.isNull(cacheMap)) {
            cacheMap = new HashMap(16);
        }
        return cacheMap;
    }

    public void updateFormulaAllCacheMap(Map<String, Object> updateMap) {
        try (DLock lock = DLock.create((String)("HRMP_HBP_FORMULA_" + this.getView().getPageId()));){
            lock.lock();
            Map<String, Object> allCacheMap = this.getFormulaAllCacheMap();
            allCacheMap.putAll(updateMap);
            FormulaCacheUtils.putValueIntoPageCache((IFormView)this.getView(), (String)"hbp_formula_cache_key", allCacheMap);
        }
    }

    private List<ResultItem> getResultItemCache() {
        List resultItemCache = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_result_item_list_cache_key", ResultItem.class);
        if (resultItemCache.isEmpty()) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>(2);
            this.getResultItemList().ifPresent(resultItemList -> {
                if (!CollectionUtils.isEmpty((Collection)resultItemList)) {
                    BasedataEdit control = (BasedataEdit)this.getView().getControl("resultitem");
                    String resultItemPropertyName = control.getProperty().getDisplayName().getLocaleValue();
                    List sortList = resultItemList.stream().filter(item -> {
                        try {
                            ResultItem.checkValueIsNull((ResultItem)item, (String)resultItemPropertyName);
                            return true;
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }).sorted(Comparator.comparing(Item::getUniqueCode)).collect(Collectors.toList());
                    tempMap.put("formula_result_item_map_cache_key", FormulaUtils.itemListToMap(sortList));
                    tempMap.put("formula_result_item_list_cache_key", sortList);
                    resultItemCache.addAll(resultItemList);
                }
            });
            this.updateFormulaAllCacheMap(tempMap);
        }
        return resultItemCache;
    }

    private List<TreeNodeItem> getFunctionTreeNodeCache() {
        List functionNodeCache = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_fuc_tree_node_cache_key", TreeNodeItem.class);
        if (functionNodeCache.isEmpty()) {
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
            HashSet<String> itemCategorySet = new HashSet<String>(FormulaCacheUtils.getListBaseValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_item_category_set_cache_key", String.class));
            itemCategorySet.add("FC");
            String bizAppNumber = this.getView().getFormShowParameter().getFormConfig().getBizAppNumber();
            FormulaDataServiceHelper.getFuncList((String)bizAppNumber, this.getExtFuncTypeNumbers(), this.getExtFuncTypeNames()).ifPresent(funcList -> {
                if (!CollectionUtils.isEmpty((Collection)funcList)) {
                    funcList = funcList.stream().filter(item -> HRStringUtils.isNotEmpty((String)item.getUniqueCode()) && !"0".equals(item.getUniqueCode())).collect(Collectors.toList());
                    tempMap.put("formula_fuc_tree_node_cache_key", funcList);
                    tempMap.put("formula_fuc_map_cache_key", FormulaUtils.itemListToMap(funcList));
                    itemCategorySet.addAll(FormulaUtils.getItemCategorySet(funcList));
                    functionNodeCache.addAll(funcList);
                }
            });
            tempMap.put("formula_item_category_set_cache_key", itemCategorySet);
            this.updateFormulaAllCacheMap(tempMap);
        }
        return functionNodeCache;
    }

    public List<TreeNodeItem> getCalItemTreeNodeCache() {
        List calItemNodeCache = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_cal_item_tree_node_cache_key", TreeNodeItem.class);
        if (calItemNodeCache.isEmpty()) {
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
            HashSet itemCategorySet = new HashSet(FormulaCacheUtils.getListBaseValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_item_category_set_cache_key", String.class));
            this.getTreeNodeItemList().ifPresent(itemList -> {
                if (!CollectionUtils.isEmpty((Collection)itemList)) {
                    itemList = itemList.stream().filter(item -> HRStringUtils.isNotEmpty((String)item.getUniqueCode()) && !"0".equals(item.getUniqueCode())).collect(Collectors.toList());
                    tempMap.put("formula_cal_item_tree_node_cache_key", itemList);
                    tempMap.put("formula_cal_item_map_cache_key", FormulaUtils.itemListToMap(itemList));
                    tempMap.put("formula_cal_item_node_id_cache_key", itemList.stream().filter(item -> item instanceof CalItem).collect(Collectors.toMap(Item::getId, item -> item)));
                    itemCategorySet.addAll(FormulaUtils.getItemCategorySet(itemList));
                    calItemNodeCache.addAll(itemList);
                }
            });
            tempMap.put("formula_item_category_set_cache_key", itemCategorySet);
            this.updateFormulaAllCacheMap(tempMap);
        }
        return calItemNodeCache;
    }

    private List<TreeNodeItem> getDataGradeItemTreeNodeCache() {
        List dataGradeItemNodeCache = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_data_grade_tree_node_cache_key", TreeNodeItem.class);
        if (dataGradeItemNodeCache.isEmpty()) {
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
            HashSet<String> itemCategorySet = new HashSet<String>(FormulaCacheUtils.getListBaseValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_item_category_set_cache_key", String.class));
            itemCategorySet.add("DG");
            this.getDataGradeItemList().ifPresent(dataGradeItemList -> {
                if (!dataGradeItemList.isEmpty()) {
                    dataGradeItemList = dataGradeItemList.stream().filter(item -> HRStringUtils.isNotEmpty((String)item.getUniqueCode()) && !"0".equals(item.getUniqueCode())).collect(Collectors.toList());
                    tempMap.put("formula_data_grade_map_cache_key", FormulaUtils.itemListToMap(dataGradeItemList));
                    tempMap.put("formula_data_grade_tree_node_cache_key", dataGradeItemList);
                    dataGradeItemNodeCache.addAll(dataGradeItemList);
                    itemCategorySet.addAll(FormulaUtils.getItemCategorySet(dataGradeItemList));
                }
            });
            tempMap.put("formula_item_category_set_cache_key", itemCategorySet);
            this.updateFormulaAllCacheMap(tempMap);
        }
        return dataGradeItemNodeCache;
    }

    protected void showToolBtn() {
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParam("fromPage");
        if (HRStringUtils.equals((String)"fromHisAction", (String)fromPage) && !FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
            Container toolBar = (Container)this.getView().getControl("tbmain");
            toolBar.insertControls(1, FormulaSettingEdit.genGrammarCheckBtn());
            toolBar.insertControls(2, FormulaSettingEdit.genFormatBtn());
            toolBar.insertControls(3, FormulaSettingEdit.genPreViewBtn());
        }
    }

    private static List<Map<String, Object>> genGrammarCheckBtn() {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        BarItemAp grammarCheckBtn = new BarItemAp();
        grammarCheckBtn.setKey(BTN_GRAMMAR_CHECK);
        grammarCheckBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u8bed\u6cd5\u6821\u9a8c", (String)"FormulaSettingEdit_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        grammarCheckBtn.setOperationKey(GRAMMAR_CHECK);
        items.add(grammarCheckBtn.createControl());
        return items;
    }

    private static List<Map<String, Object>> genFormatBtn() {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        BarItemAp formatBtn = new BarItemAp();
        formatBtn.setKey(BTN_FORMAT);
        formatBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u683c\u5f0f\u6807\u51c6\u5316", (String)"FormulaSettingEdit_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        formatBtn.setOperationKey(FORMULAFORMAT);
        items.add(formatBtn.createControl());
        return items;
    }

    private static List<Map<String, Object>> genPreViewBtn() {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        BarItemAp formatBtn = new BarItemAp();
        formatBtn.setKey(BTN_PRE_VIEW);
        formatBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9884\u89c8", (String)"FormulaSettingEdit_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        formatBtn.setOperationKey(FORMULAPREVIEW);
        items.add(formatBtn.createControl());
        return items;
    }

    private void refreshFormulaEdit() {
        CustomControl formulaEditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("method", "refreshKey");
        data.put("key", FormulaDataServiceHelper.getEditorKey((IFormView)this.getView(), this.getFormulaAllCacheMap()));
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaEditor.setData(data);
    }

    protected boolean refreshCacheAndCheckFormulaIsEmpty() {
        boolean checkIsFail = false;
        if (HRStringUtils.isEmpty((String)this.getOriginalExp())) {
            this.showErrorMsg(ResManager.loadKDString((String)"\u6ca1\u6709\u7ef4\u62a4\u516c\u5f0f\u914d\u7f6e\u3002", (String)"FormulaSettingEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            checkIsFail = true;
        }
        return checkIsFail;
    }

    protected TreeNodeItem getDataGradeRootItem() {
        return FormulaTreeNodeUtils.getDataGradeRootItem();
    }

    @ExcludeFromJacocoGeneratedReport
    private void putIntoUniqueCodeDisplayNameMap(Map<String, String> uniqueCodeDisplayNameMap, Collection<? extends Item> items) {
        if (uniqueCodeDisplayNameMap == null) {
            return;
        }
        for (Item item : items) {
            uniqueCodeDisplayNameMap.put(item.getUniqueCode(), FormulaUtils.getItemMapKey((String)item.getItemCategory(), (String)item.getName()));
        }
    }

    protected void showErrorMsg(String errorMsg) {
        this.getView().showTipNotification(errorMsg);
    }
}

