/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.formula;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.FormulaParseService;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.formula.FormulaSettingEdit;

public class FormulaUnitTestEdit
extends FormulaSettingEdit {
    private static final Log LOGGER = LogFactory.getLog(FormulaUnitTestEdit.class);
    private static final String UNIT_TEST = "UNIT_TEST";
    private static final String CUSTOM_TEST = "CUSTOM_TEST";
    private static final String BASE_DATA_ITEM_TEST = "BASE_DATA_ITEM_TEST";
    private static final String SUM_TEST = "SUM_TEST";

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("refreshcache".equals(operate.getOperateKey())) {
            this.initItemTree(this.getTreeNodeItems().orElseGet(() -> Lists.newArrayListWithExpectedSize((int)0)), true);
            this.initDataGradeTree(this.getDataGradeNodeItems().orElseGet(() -> Lists.newArrayListWithExpectedSize((int)0)), true);
            this.initResultItemCache(this.getResultItems(true).orElseGet(() -> Lists.newArrayListWithExpectedSize((int)0)), true);
            args.setCancel(true);
        } else if ("doupdatedbdata".equals(operate.getOperateKey())) {
            String entityId = this.getView().getEntityId();
            QFilter qFilter = new QFilter("id", "is not null", null);
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
            DynamicObject[] formulas = helper.loadDynamicObjectArray(new QFilter[]{qFilter});
            String bizAppNumber = this.getView().getFormShowParameter().getFormConfig().getBizAppNumber();
            FormulaParseService parseService = new FormulaParseService();
            ArrayList boDys = Lists.newArrayListWithExpectedSize((int)formulas.length);
            for (DynamicObject formula : formulas) {
                try {
                    Optional<List<TreeNodeItem>> treeNodeItemList = this.getTreeNodeItemList();
                    DynamicObject newFormula = parseService.parseFormulaDy(formula, formula.getLong("boid"), bizAppNumber, (List)treeNodeItemList.orElse(null), (List)this.getResultItemList().orElse(null), (List)this.getDataGradeItemList().orElse(null), false);
                    boDys.add(newFormula);
                }
                catch (Exception e) {
                    LOGGER.error("update_data_is_wrong_please_check_error : ", (Throwable)e);
                    this.getView().showTipNotification(String.format("update_data_is_wrong_please_check_name_is_%1$s,id_is_%2$s", formula.getString("name"), formula.getPkValue()));
                }
            }
            if (!boDys.isEmpty()) {
                helper.updateDatas(boDys.toArray(new DynamicObject[0]));
            }
        }
    }

    @Override
    protected Optional<List<TreeNodeItem>> getTreeNodeItemList() {
        return this.getTreeNodeItems();
    }

    private Optional<List<TreeNodeItem>> getTreeNodeItems() {
        QFilter statusFilter;
        QFilter enableFilter;
        BasedataProp customItemProp;
        String metaNumber;
        HRBaseServiceHelper helper;
        DynamicObject[] data;
        QFilter statusFilter2;
        QFilter enableFilter2;
        BasedataProp accumulatorProp;
        String metaNumber2;
        HRBaseServiceHelper helper2;
        DynamicObject[] data2;
        CalItem calItem;
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)(DataTypeEnum.values().length + 1));
        nodes.add(new TreeNodeItem(UNIT_TEST, UNIT_TEST, "", MessageFormat.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u9879\u76ee_{0}", (String)"FormulaUnitTestEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), UNIT_TEST)));
        nodes.add(new TreeNodeItem(CUSTOM_TEST, CUSTOM_TEST, "", MessageFormat.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5\u9879\u76ee_{0}", (String)"FormulaUnitTestEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), CUSTOM_TEST)));
        for (DataTypeEnum type : DataTypeEnum.values()) {
            calItem = new CalItem(UNIT_TEST, "UNIT_TEST_" + type.getCode(), UNIT_TEST, MessageFormat.format(ResManager.loadKDString((String)"\u6d4b\u8bd5_{0}", (String)"FormulaUnitTestEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), type.getAlias()), "UNIT_TEST_" + type.getCode(), type);
            nodes.add(calItem);
        }
        for (DataTypeEnum type : DataTypeEnum.values()) {
            calItem = new CalItem(CUSTOM_TEST, "CUSTOM_TEST_" + type.getCode(), CUSTOM_TEST, MessageFormat.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5_{0}", (String)"FormulaUnitTestEdit_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), type.getAlias()), "CUSTOM_TEST_" + type.getCode(), type, true);
            calItem.setCanAssignment(false);
            nodes.add(calItem);
        }
        CalItem floatBase = new CalItem(UNIT_TEST, "UNIT_TEST_FLOAT_BASE", UNIT_TEST, ResManager.loadKDString((String)"\u6d4b\u8bd5_\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u9009\u9879", (String)"FormulaUnitTestEdit_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "UNIT_TEST_FLOAT_BASE", DataTypeEnum.BASE);
        floatBase.setItemType(CalItemTypeEnum.BASE_DATA);
        floatBase.setEntityNumber("hbss_nationality");
        floatBase.setPropertyField("name");
        floatBase.setqFilters(new QFilter[]{new QFilter("sdsd11.sdsds.sdsd", "=", (Object)"11")});
        nodes.add(floatBase);
        CalItem floatBaseText = new CalItem(UNIT_TEST, "UNIT_TEST_FLOAT_BASE_TEXT", UNIT_TEST, ResManager.loadKDString((String)"\u6d4b\u8bd5_\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u6587\u672c\u9009\u9879", (String)"FormulaUnitTestEdit_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "UNIT_TEST_FLOAT_BASE_TEXT", DataTypeEnum.TEXT);
        floatBaseText.setItemType(CalItemTypeEnum.BASE_DATA);
        floatBaseText.setEntityNumber("hbss_flok");
        floatBaseText.setPropertyField("name");
        nodes.add(floatBaseText);
        CalItem floatEnum = new CalItem(UNIT_TEST, "UNIT_TEST_FLOAT_ENUM", UNIT_TEST, ResManager.loadKDString((String)"\u6d4b\u8bd5_\u679a\u4e3e\u60ac\u6d6e\u6846\u9009\u9879", (String)"FormulaUnitTestEdit_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "UNIT_TEST_FLOAT_ENUM", DataTypeEnum.TEXT);
        floatEnum.setItemType(CalItemTypeEnum.ENUM);
        floatEnum.setEntityNumber("hbss_nationality");
        floatEnum.setPropertyField("initstatus");
        nodes.add(floatEnum);
        CalItem CustFloatBase = new CalItem(CUSTOM_TEST, "CUSTOM_TEST_FLOAT_BASE", CUSTOM_TEST, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5_\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u9009\u9879", (String)"FormulaUnitTestEdit_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "CUSTOM_TEST_FLOAT_BASE", DataTypeEnum.BASE);
        CustFloatBase.setItemType(CalItemTypeEnum.BASE_DATA);
        CustFloatBase.setEntityNumber("hbss_nationality");
        CustFloatBase.setPropertyField("name");
        CustFloatBase.setCustomItem(true);
        nodes.add(CustFloatBase);
        CalItem CustFloatBaseText = new CalItem(CUSTOM_TEST, "CUSTOM_TEST_FLOAT_BASE_SEX", CUSTOM_TEST, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5_\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u6027\u522b", (String)"FormulaUnitTestEdit_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "CUSTOM_TEST_FLOAT_BASE_SEX", DataTypeEnum.BASE);
        CustFloatBaseText.setItemType(CalItemTypeEnum.BASE_DATA);
        CustFloatBaseText.setEntityNumber("hbss_sex");
        CustFloatBaseText.setPropertyField("name");
        CustFloatBaseText.setCustomItem(true);
        nodes.add(CustFloatBaseText);
        CalItem CustFloatEnum = new CalItem(CUSTOM_TEST, "CUSTOM_TEST_FLOAT_ENUM", CUSTOM_TEST, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6d4b\u8bd5_\u679a\u4e3e\u60ac\u6d6e\u6846\u9009\u9879", (String)"FormulaUnitTestEdit_9", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "CUSTOM_TEST_FLOAT_ENUM", DataTypeEnum.TEXT);
        CustFloatEnum.setItemType(CalItemTypeEnum.ENUM);
        CustFloatEnum.setEntityNumber("hbss_nationality");
        CustFloatEnum.setPropertyField("initstatus");
        CustFloatEnum.setCustomItem(true);
        nodes.add(CustFloatEnum);
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DynamicProperty property = dataEntityType.getProperty("accumulator");
        if (property instanceof BasedataProp && Objects.nonNull(data2 = (helper2 = new HRBaseServiceHelper(metaNumber2 = (accumulatorProp = (BasedataProp)property).getBaseEntityId())).loadDynamicObjectArray(new QFilter[]{enableFilter2 = new QFilter("enable", "=", (Object)"1"), statusFilter2 = new QFilter("status", "=", (Object)"C")})) && data2.length > 0) {
            nodes.add(new TreeNodeItem(SUM_TEST, SUM_TEST, "", MessageFormat.format(ResManager.loadKDString((String)"\u7d2f\u52a0\u5668\u6d4b\u8bd5_{0}", (String)"FormulaUnitTestEdit_10", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), SUM_TEST)));
            for (DynamicObject sum : data2) {
                CalItem sumItem = new CalItem();
                sumItem.setId(sum.getString("id"));
                sumItem.setUniqueCode(sum.getString("number"));
                sumItem.setName(sum.getString("name"));
                sumItem.setItemCategory(SUM_TEST);
                sumItem.setParentId(SUM_TEST);
                sumItem.setDataType(DataTypeEnum.NUM);
                nodes.add(sumItem);
            }
        }
        CalItem calItem2 = new CalItem(UNIT_TEST, "UNIT_TEST_ceshifuhao", UNIT_TEST, "ceshi()+-*/fuhao", "CUSTOM_TEST_ceshifuhao", DataTypeEnum.NUM);
        DynamicProperty customItemProperty = dataEntityType.getProperty("basedataitem");
        if (customItemProperty instanceof BasedataProp && Objects.nonNull(data = (helper = new HRBaseServiceHelper(metaNumber = (customItemProp = (BasedataProp)customItemProperty).getBaseEntityId())).loadDynamicObjectArray(new QFilter[]{enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C")})) && data.length > 0) {
            nodes.add(new TreeNodeItem(BASE_DATA_ITEM_TEST, BASE_DATA_ITEM_TEST, "", MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u8ba1\u7b97\u9879\u76ee\u6d4b\u8bd5_{0}", (String)"FormulaUnitTestEdit_11", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), BASE_DATA_ITEM_TEST)));
            for (DynamicObject sum : data) {
                try {
                    CalItem baseDataItem = new CalItem(BASE_DATA_ITEM_TEST, "_" + sum.getString("id"), BASE_DATA_ITEM_TEST, sum.getString("name"), "_" + sum.getString("id"), DataTypeEnum.getDataType((String)sum.getString("datatype")));
                    nodes.add(baseDataItem);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }
        nodes.add(calItem2);
        return Optional.of(nodes);
    }

    @Override
    protected Optional<List<ResultItem>> getResultItemList() {
        return this.getResultItems(false);
    }

    private Optional<List<ResultItem>> getResultItems(boolean isUpdateCache) {
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)DataTypeEnum.values().length);
        for (DataTypeEnum type : DataTypeEnum.values()) {
            ResultItem resultItem = new ResultItem();
            resultItem.setId("UNIT_TEST_" + type.getCode());
            resultItem.setItemCategory(UNIT_TEST);
            resultItem.setDataType(type);
            resultItem.setName(MessageFormat.format(ResManager.loadKDString((String)"\u6d4b\u8bd5_{0}", (String)"FormulaUnitTestEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), type.getAlias()));
            resultItem.setUniqueCode("UNIT_TEST_" + type.getCode());
            if (DataTypeEnum.NUM == type || DataTypeEnum.MONEY == type) {
                resultItem.setScale(Integer.valueOf(4));
            }
            nodes.add(resultItem);
        }
        ResultItem numeratorItem = new ResultItem();
        numeratorItem.setId("UNIT_TEST_NUMERATOR");
        numeratorItem.setItemCategory(UNIT_TEST);
        numeratorItem.setDataType(DataTypeEnum.NUM);
        numeratorItem.setName(MessageFormat.format(ResManager.loadKDString((String)"\u6d4b\u8bd5_{0}", (String)"FormulaUnitTestEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "NUMERATOR"));
        numeratorItem.setUniqueCode("UNIT_TEST_NUMERATOR");
        numeratorItem.setCalProportionItem(true);
        numeratorItem.setScale(Integer.valueOf(2));
        nodes.add(numeratorItem);
        ResultItem denominatorItem = new ResultItem();
        denominatorItem.setId("UNIT_TEST_DENOMINATOR");
        denominatorItem.setItemCategory(UNIT_TEST);
        denominatorItem.setDataType(DataTypeEnum.NUM);
        denominatorItem.setName(MessageFormat.format(ResManager.loadKDString((String)"\u6d4b\u8bd5_{0}", (String)"FormulaUnitTestEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "DENOMINATOR"));
        denominatorItem.setUniqueCode("UNIT_TEST_DENOMINATOR");
        denominatorItem.setCalProportionItem(true);
        denominatorItem.setScale(Integer.valueOf(2));
        nodes.add(denominatorItem);
        ResultItem floatBase = new ResultItem();
        floatBase.setId("UNIT_TEST_FLOAT_BASE");
        floatBase.setItemCategory(UNIT_TEST);
        floatBase.setDataType(DataTypeEnum.BASE);
        floatBase.setName(ResManager.loadKDString((String)"\u6d4b\u8bd5_\u57fa\u7840\u8d44\u6599\u60ac\u6d6e\u6846\u9009\u9879", (String)"FormulaUnitTestEdit_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        floatBase.setUniqueCode("UNIT_TEST_FLOAT_BASE");
        floatBase.setScale(Integer.valueOf(2));
        floatBase.setItemType(CalItemTypeEnum.BASE_DATA);
        floatBase.setEntityNumber("hbss_nationality");
        floatBase.setPropertyField("name");
        nodes.add(floatBase);
        if (isUpdateCache) {
            ResultItem cacheNew = new ResultItem();
            cacheNew.setId("TEST_NEW_CACHE_OBJ");
            cacheNew.setItemCategory(UNIT_TEST);
            cacheNew.setDataType(DataTypeEnum.NUM);
            cacheNew.setName(MessageFormat.format(ResManager.loadKDString((String)"\u6d4b\u8bd5_{0}", (String)"FormulaUnitTestEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "CACHE_OBJ"));
            cacheNew.setUniqueCode("UNIT_TEST_CACHE_OBJ");
            nodes.add(cacheNew);
        }
        return Optional.of(nodes);
    }

    @Override
    protected Optional<List<TreeNodeItem>> getDataGradeItemList() {
        return this.getDataGradeNodeItems();
    }

    private Optional<List<TreeNodeItem>> getDataGradeNodeItems() {
        try {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hbp_datagrade_unittest");
            DynamicObject[] dgs = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1")});
            if (Objects.nonNull(dgs)) {
                ArrayList<DataGradeItem> dgItems = new ArrayList<DataGradeItem>(dgs.length);
                for (DynamicObject item : dgs) {
                    dgItems.add(DataGradeItem.getDataGradeItem((DynamicObject)item));
                }
                return Optional.of(dgItems);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

