/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.formula.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.list.IMobileListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.utils.FormulaCacheUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class FormulaResultItemEdit
extends BasedataEdit {
    public void getLookUpList(List<Object> args) {
        this.checkNullException();
        if (args != null) {
            BasedataEntityType dt = this.getMainEntityType();
            if (dt == null) {
                this.invokeLookUpList(new HashMap<String, Object>());
                return;
            }
            this.invokeLookUpList(this.getLookUpData(args, dt));
        }
    }

    protected void setItemValueByID(Object pk, int index, List<QFilter> baseQFilters) {
        IDataModel dataModel = this.getDataModel();
        BasedataProp property = (BasedataProp)dataModel.getProperty(this.getFieldKey());
        DynamicObjectType complexType = (DynamicObjectType)property.getComplexType();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        QFilter idFilter = new QFilter("id", "=", (Object)("id#" + String.valueOf(pk)));
        qFilters.add(idFilter);
        List itemBySearch = FormulaCacheUtils.getResultItemBySearch((IFormView)this.view, (int)0, (int)1, qFilters, (boolean)false, (boolean)true, (DynamicObjectType)complexType, baseQFilters);
        DynamicObject value = null;
        if (!CollectionUtils.isEmpty((Collection)itemBySearch)) {
            value = (DynamicObject)itemBySearch.get(0);
        }
        dataModel.setValue((IDataEntityProperty)property, dataModel.getDataEntity(), (Object)value);
    }

    public void viewDetail(Map<String, Object> param) {
        int rowKey = (Integer)param.get("rowKey");
        Object pkObject = this.getPkId(rowKey);
        if (pkObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u57fa\u7840\u8d44\u6599\uff01", (String)"BasedataEdit_7", (String)"bos-form-core", (Object[])new Object[0]));
        } else {
            ResultItem resultItem = FormulaCacheUtils.findResultItemById((String)String.valueOf(pkObject), (IFormView)this.getView());
            if (Objects.isNull(resultItem)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u679c\u53c2\u6570\u8be6\u60c5\u67e5\u8be2\u5931\u8d25", (String)"BasedataEdit_7", (String)"bos-form-core", (Object[])new Object[0]));
                return;
            }
            BeforeF7ViewDetailEvent beforeF7ViewDetailEvent = new BeforeF7ViewDetailEvent((Object)this, rowKey, pkObject);
            if (!beforeF7ViewDetailEvent.isCancel()) {
                OrgProp prop;
                Object parameter = this.getView() instanceof IMobileListView ? new MobileBillShowParameter() : new BaseShowParameter();
                this.setParamUseOrgId((FormShowParameter)parameter, (IBasedataField)((BasedataProp)this.getProperty()));
                String baseEntityId = this.getBaseEntityId();
                Object source = beforeF7ViewDetailEvent.getSource();
                if (source instanceof OrgEdit && "01".equals((prop = (OrgProp)((OrgEdit)source).getProperty()).getOrgFunc())) {
                    baseEntityId = "bos_adminorg";
                }
                FormConfig formConfig = FormMetadataCache.getFormConfig((String)baseEntityId);
                LocaleString caption = formConfig.getCaption();
                parameter.setCaption(caption.toString());
                parameter.setParentFormId(this.view.getFormShowParameter().getParentFormId());
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(formConfig.getViewShowType());
                if (formConfig.getViewShowType() != ShowType.Modal) {
                    parameter.getOpenStyle().setTargetKey("tabap");
                }
                parameter.setFormId(HRStringUtils.isNotEmpty((String)this.getLayoutId()) ? this.getLayoutId() : baseEntityId);
                parameter.setBillStatus(BillOperationStatus.VIEW);
                parameter.setCustomParam("resultItem", (Object)resultItem);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    private Map<String, Object> getLookUpData(List<Object> args, BasedataEntityType dt) {
        String searchKey = (String)args.get(1);
        FuzzySearch setting = this.loadLookUpSetting(dt);
        int top = this.getDisplayStyle() == 0 ? setting.getPageSize() : 50;
        List<String> showFields = setting.getComboListFields().stream().map(ShowColumn::getId).collect(Collectors.toList());
        List<List<String>> allData = this.getFuzzySearchList(args, searchKey, setting, top, showFields);
        List<List<String>> queryData = new ArrayList<List<String>>(allData.size());
        boolean hasNext = false;
        if (!allData.isEmpty()) {
            if (allData.size() >= top) {
                hasNext = true;
            }
            queryData.addAll(allData);
        }
        if (this.fuzzySearchListeners != null) {
            BasedataFuzzySearchEvent evt = new BasedataFuzzySearchEvent((Object)this, queryData);
            for (BasedataFuzzySearchListener fuzzySearchListener : this.fuzzySearchListeners) {
                fuzzySearchListener.handleData(evt);
            }
            queryData = evt.getQueryData();
        }
        HashMap fieldsIndexMap = new HashMap(16);
        this.getFieldIndexMap(dt, showFields, fieldsIndexMap);
        int index = 0;
        ArrayList<ShowColumn> showColumns = new ArrayList<ShowColumn>(10);
        for (ShowColumn showColumn : setting.getComboListFields()) {
            if (fieldsIndexMap.containsKey(showColumn.getId())) {
                Integer i = (Integer)fieldsIndexMap.get(showColumn.getId());
                if (i == index) {
                    showColumns.add((Integer)fieldsIndexMap.get(showColumn.getId()), showColumn);
                    continue;
                }
                showColumns.add(new ShowColumn());
                if (i != ++index) continue;
                showColumns.add((Integer)fieldsIndexMap.get(showColumn.getId()), showColumn);
                continue;
            }
            showColumns.add(showColumn);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("columns", showColumns);
        data.put("data", queryData);
        data.put("next", hasNext);
        data.put("k", this.key);
        data.put("size", setting.getPageSize());
        data.put("args", args);
        return data;
    }

    private List<List<String>> getFuzzySearchList(List<Object> args, String searchKey, FuzzySearch setting, int top, List<String> showFields) {
        BasedataProp property = (BasedataProp)this.view.getModel().getProperty("resultitem");
        if (Objects.isNull(property)) {
            return new ArrayList<List<String>>(10);
        }
        DynamicObjectType complexType = (DynamicObjectType)property.getComplexType();
        List resultItems = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.view, (String)"formula_result_item_list_cache_key", ResultItem.class);
        return resultItems.stream().map(item -> ResultItem.getDyByResultItem((ResultItem)item, (DynamicObjectType)complexType)).filter(item -> {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)searchKey)) {
                return true;
            }
            for (String field : setting.getSearchFields()) {
                String fieldValue = item.getString(field);
                if (!HRStringUtils.isNotEmpty((String)fieldValue) || !fieldValue.toLowerCase().contains(searchKey.toLowerCase().trim())) continue;
                return true;
            }
            return false;
        }).sorted(Comparator.comparing(dy -> dy.getString("number"))).map(dy -> {
            ArrayList<String> fieldList = new ArrayList<String>(showFields.size());
            for (String showField : showFields) {
                fieldList.add(dy.getString(showField));
            }
            return fieldList;
        }).skip(((Integer)args.get(3)).intValue()).limit(top).collect(Collectors.toList());
    }

    private void checkNullException() {
        if (StringUtils.isBlank((CharSequence)this.getBaseEntityId())) {
            String name = this.getItemTypeName();
            throw new KDBizException(name);
        }
        if (FormMetadataCache.getListFormConfig((String)this.getBaseEntityId()) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u5c1a\u672a\u8bbe\u8ba1F7\u5217\u8868\u3002", (String)"FormulaResultItemEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    private void invokeLookUpList(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            this.clientViewProxy.invokeControlMethod(this.getEntryKey(), "setLookUpListValue", new Object[]{data});
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, "setLookUpListValue", new Object[]{data});
        }
    }

    private int getCurrentRowIndex() {
        int rowIndex = -1;
        if (this.isEntryProperty(this.getProperty())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        }
        return rowIndex;
    }
}

