/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.funcentity.dataprovider;

import java.util.List;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.funcentity.model.FunctionEntityRowMeta;
import kd.hr.hbp.common.util.HRStringUtils;

class FuzzyQueryDSFunction
extends FilterFunction {
    private static final long serialVersionUID = 8138104306442702228L;
    private final FunctionEntityRowMeta rowMeta;
    private final List<QFilter> fuzzyQFilters;

    public FuzzyQueryDSFunction(FunctionEntityRowMeta rowMeta, List<QFilter> fuzzyQFilters) {
        this.rowMeta = rowMeta;
        this.fuzzyQFilters = fuzzyQFilters;
    }

    public boolean test(Row row) {
        boolean isMatch = false;
        for (QFilter filter : this.fuzzyQFilters) {
            String[] values;
            String filterValue = String.valueOf(filter.getValue());
            String[] fieldAndValueArray = filterValue.split("#");
            String[] fields = fieldAndValueArray[0].split(",");
            boolean filterMatch = this.matchQFilterValue(row, fields, values = fieldAndValueArray[1].split("\b"));
            if (!filterMatch) {
                isMatch = false;
                break;
            }
            isMatch = true;
        }
        return isMatch;
    }

    private boolean matchQFilterValue(Row row, String[] fields, String[] values) {
        boolean filterMatch = false;
        block0: for (String field : fields) {
            String fieldName = this.rowMeta.getEntityFieldPropertyToRowFieldName(field);
            if (fieldName == null) {
                return filterMatch;
            }
            String fieldValue = row.getString(fieldName);
            if (!HRStringUtils.isNotEmpty((String)fieldValue)) continue;
            for (String value : values) {
                if (!fieldValue.toLowerCase().contains(value.toLowerCase())) continue;
                filterMatch = true;
                continue block0;
            }
        }
        return filterMatch;
    }
}

