/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Html;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.function.helper.HRFunctionHelper;
import kd.hr.hbp.business.service.formula.entity.floatcontrol.SelectItem;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.TreeViewSearchTool;

public class ReportFunctionPlugin
extends AbstractFormPlugin
implements ClickListener,
SearchEnterListener,
RowClickEventListener {
    private final String ENTRY_FIELD = "fieldentry";
    private final String FIELD_NAME = "fieldName";
    private final String FIELD_NUMBER = "fieldNumber";
    private final String FIELD_TYPE = "valueType";
    private final String VALUE_TYPE = "valuetype";
    private final String HIDE = "hide";
    private final String TREE_VIEW_FUNCTION = "functree";
    private final String CONTROL_SEARCH_FUNCTION = "searchfunc";
    private final String CONTROL_SEARCH_FIELD = "searchfield";
    private final String DISPLAY_FUNCTION_TEXT = "displayfunctiontext";
    private final String KEY_DISPLAY_EXPR = "displayExpression";
    private final String METHOD_KEY = "method";
    private final String METHOD_INIT = "init";
    private final String METHOD_INSERT = "insert";
    private final String CACHE_KEY_METHOD = "methodFlagKey";
    private final String CONTROL_EXPRESSION = "expressioncontrol";
    private final String FIELDS = "fields";
    private final String KEY_CHANGE_FLAG = "changeFlag";
    private final String PAGE_STATUS = "pageStatus";
    private static final Map<String, String> btnControlMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final Log LOGGER = LogFactory.getLog(ReportFunctionPlugin.class);
    private static final Set<String> skipFunctionSet = Stream.of("REPT").collect(Collectors.toSet());

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Search fieldSearch = (Search)this.getControl("searchfield");
        fieldSearch.addEnterListener((SearchEnterListener)this);
        TreeView tv1 = (TreeView)this.getView().getControl("functree");
        tv1.addTreeNodeClickListener(this.getTreeNodeClickListener());
        Search funcSearch = (Search)this.getControl("searchfunc");
        funcSearch.addEnterListener((SearchEnterListener)this);
        for (String btnControlNum : btnControlMap.keySet()) {
            Button btn = (Button)this.getView().getControl(btnControlNum);
            btn.addClickListener((ClickListener)this);
        }
        EntryGrid fieldEntry = (EntryGrid)this.getView().getControl("fieldentry");
        fieldEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        String expr;
        super.afterBindData(e);
        this.setMethodName("init");
        List fields = (List)this.getView().getFormShowParameter().getCustomParam("fields");
        if (fields != null && !fields.isEmpty()) {
            fields.removeIf(field -> HRStringUtils.equals((String)((String)field.get("hide")), (String)"true"));
            this.getModel().batchCreateNewEntryRow("fieldentry", fields.size());
            HashMap fieldsMap = Maps.newHashMapWithExpectedSize((int)fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                String name = (String)((Map)fields.get(i)).get("fieldName");
                String number = (String)((Map)fields.get(i)).get("fieldNumber");
                this.getModel().setValue("name", (Object)name, i);
                this.getModel().setValue("number", (Object)number, i);
                this.getModel().setValue("valuetype", ((Map)fields.get(i)).get("valueType"), i);
                fieldsMap.put("[" + name + "]", number);
            }
            this.getPageCache().put("fields", SerializationUtils.toJsonString((Object)fieldsMap));
            this.getView().updateView("fieldentry");
            HashMap baseDataNumMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap enumEntityNumMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map field2 : fields) {
                String fieldNumber = (String)field2.get("fieldNumber");
                String baseDataNum = (String)field2.get("baseDataNum");
                String enumEntityNum = (String)field2.get("enumEntityNum");
                if (HRStringUtils.isNotEmpty((String)baseDataNum)) {
                    baseDataNumMap.put(fieldNumber, baseDataNum);
                }
                if (!HRStringUtils.isNotEmpty((String)enumEntityNum)) continue;
                enumEntityNumMap.put(fieldNumber, enumEntityNum);
            }
            this.getPageCache().put("baseDataNumMap", SerializationUtils.toJsonString((Object)baseDataNumMap));
            this.getPageCache().put("enumEntityNumMap", SerializationUtils.toJsonString((Object)enumEntityNumMap));
        }
        if (HRStringUtils.isNotEmpty((String)(expr = (String)this.getView().getFormShowParameter().getCustomParam("displayfunctiontext")))) {
            this.getModel().setValue("displayfunctiontext", (Object)expr);
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata("fieldentry", (Map)map);
        this.getView().setVisible(Boolean.FALSE, new String[]{"funcdescription", "float"});
        this.getModel().setDataChanged(false);
    }

    @ExcludeFromJacocoGeneratedReport
    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String name = e.getEventName();
        String args = e.getEventArgs();
        if ("initExpressionTextDataEvent".equals(e.getEventName())) {
            String displayExpression = (String)this.getModel().getValue("displayfunctiontext");
            this.updateExpressionTextData(displayExpression);
        } else if ("returnExpressionText".equals(e.getEventName())) {
            this.getModel().setValue("displayfunctiontext", (Object)args);
        }
        if (HRStringUtils.equals((String)key, (String)"float")) {
            if (HRStringUtils.equals((String)name, (String)"insertValue")) {
                this.insertItemValue(args);
            } else if ((HRStringUtils.equals((String)name, (String)"appendLoadData") || HRStringUtils.equals((String)name, (String)"searchListItem")) && HRStringUtils.isNotEmpty((String)args)) {
                JSONObject param = JSONObject.parseObject((String)args);
                int start = param.getIntValue("start");
                String nodeId = param.getString("nodeId");
                String searchValue = param.getString("searchValue");
                boolean isAppend = HRStringUtils.equals((String)"true", (String)param.getString("isAppend"));
                FloatResult floatResult = this.getItemValue(nodeId, start, searchValue);
                if (floatResult == null) {
                    return;
                }
                int offset = 0;
                if (floatResult.getItems() != null) {
                    offset = floatResult.getItems().size();
                }
                boolean isSearchInit = HRStringUtils.equals((String)"searchListItem", (String)name);
                floatResult.setNextStart(start + offset);
                this.showFloat(floatResult, nodeId, isAppend, isSearchInit);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void updateExpressionTextData(String displayExpression) {
        String method = this.getMethodName();
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("displayExpression", displayExpression);
        data.put("method", method);
        String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
        data.put("pageStatus", status);
        String fieldsMapStr = this.getPageCache().get("fields");
        if (HRStringUtils.equals((String)method, (String)"init") && HRStringUtils.isNotEmpty((String)fieldsMapStr)) {
            Map fieldsMap = (Map)SerializationUtils.fromJsonString((String)fieldsMapStr, Map.class);
            data.put("fields", fieldsMap.keySet());
            data.put("changeFlag", this.changeFlag());
            this.setMethodName("insert");
        } else {
            data.put("fields", Collections.emptyList());
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl("expressioncontrol");
        customcontrol.setData((Object)data);
    }

    private void setMethodName(String method) {
        this.getPageCache().put("methodFlagKey", method);
    }

    private String getMethodName() {
        return this.getPageCache().get("methodFlagKey");
    }

    @ExcludeFromJacocoGeneratedReport
    private String changeFlag() {
        String changeFlagStr = this.getPageCache().get("changeFlag");
        if (HRStringUtils.isEmpty((String)changeFlagStr)) {
            changeFlagStr = "0";
        }
        this.getPageCache().put("changeFlag", HRStringUtils.equals((String)changeFlagStr, (String)"0") ? "1" : "0");
        return changeFlagStr;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String bizAppNumber = (String)this.getView().getFormShowParameter().getCustomParam("bizAppNumber");
        if (HRStringUtils.isEmpty((String)bizAppNumber)) {
            bizAppNumber = "hbp";
        }
        Optional funcItemList = HRFunctionHelper.getFuncItemList((String)bizAppNumber);
        funcItemList.ifPresent(this::constructFunctionTreeView);
    }

    @ExcludeFromJacocoGeneratedReport
    public void search(SearchEnterEvent event) {
        String searchKey = ((Search)event.getSource()).getKey();
        if (HRStringUtils.equals((String)searchKey, (String)"searchfield")) {
            String text = event.getText();
            List fields = (List)this.getView().getFormShowParameter().getCustomParam("fields");
            List filterFields = fields.stream().filter(field -> ((String)field.get("fieldName")).contains(text)).collect(Collectors.toList());
            int entryCount = this.getModel().getEntryRowCount("fieldentry");
            this.getModel().deleteEntryRows("fieldentry", this.getIntArray(entryCount));
            if (filterFields.size() > 0) {
                this.getModel().batchCreateNewEntryRow("fieldentry", filterFields.size());
                for (int i = 0; i < filterFields.size(); ++i) {
                    this.getModel().setValue("name", ((Map)filterFields.get(i)).get("fieldName"), i);
                    this.getModel().setValue("number", ((Map)filterFields.get(i)).get("fieldNumber"), i);
                    this.getModel().setValue("valuetype", ((Map)filterFields.get(i)).get("valueType"), i);
                }
            }
        } else if (HRStringUtils.equals((String)searchKey, (String)"searchfunc")) {
            String searchText = event.getText();
            TreeView tv = (TreeView)this.getView().getControl("functree");
            TreeViewSearchTool.search(searchText, tv, this.getPageCache(), "functree");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
            if (HRStringUtils.equals((String)status, (String)OperationStatus.VIEW.toString())) {
                return;
            }
            String key = ((Button)source).getKey();
            String calBtnNum = btnControlMap.get(key);
            if (HRStringUtils.isNotEmpty((String)calBtnNum)) {
                this.updateCustomData(btnControlMap.get(key));
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
        if (HRStringUtils.equals((String)status, (String)OperationStatus.VIEW.toString())) {
            return;
        }
        int index = evt.getRow();
        if (index < 0) {
            return;
        }
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("fieldentry").get(index);
        String fieldNumber = row.getString("number");
        FloatResult floatResult = this.getItemValue(fieldNumber, 0, null);
        if (floatResult != null && !HRObjectUtils.isEmpty(floatResult.getItems())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"float"});
            this.showFloat(floatResult, fieldNumber, false, false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"float"});
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void showFloat(FloatResult floatResult, String nodeId, boolean isAppend, boolean isSearchInit) {
        CustomControl floatControl = (CustomControl)this.getView().getControl("float");
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("listItem", floatResult.getItems());
        data.put("treeDom", "flexpanelap12");
        data.put("nodeId", nodeId);
        data.put("nextStart", floatResult.getNextStart());
        if (isAppend) {
            data.put("isAppend", "true");
        }
        if (isSearchInit) {
            data.put("isSearchInit", "true");
        }
        data.put("isEnd", String.valueOf(floatResult.isEnd()));
        data.put("date", String.valueOf(new Date().getTime()));
        floatControl.setData((Object)data);
    }

    @ExcludeFromJacocoGeneratedReport
    public void entryRowDoubleClick(RowClickEvent evt) {
        String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
        if (HRStringUtils.equals((String)status, (String)OperationStatus.VIEW.toString())) {
            return;
        }
        int index = evt.getRow();
        if (index < 0) {
            return;
        }
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("fieldentry").get(index);
        String fieldName = row.getString("name");
        this.updateCustomData("[" + fieldName + "]");
    }

    private void constructFunctionTreeView(List<FunctionItem> funcItems) {
        TreeView tv = (TreeView)this.getView().getControl("functree");
        String rootId = "0";
        TreeNode rootNode = new TreeNode(null, "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportFunctionPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), true);
        rootNode.setIsOpened(true);
        funcItems.forEach(functionGroup -> {
            TreeNode tn1 = new TreeNode("0", functionGroup.getId(), functionGroup.getName(), true);
            tn1.setIsOpened(true);
            functionGroup.getChildren().forEach(functionItem -> {
                if (skipFunctionSet.contains(functionItem.getFunkey())) {
                    return;
                }
                TreeNode tn2 = new TreeNode(functionGroup.getId(), functionItem.getId(), functionItem.getName(), false);
                tn2.setLeaf(true);
                tn1.addChild(tn2);
            });
            rootNode.addChild(tn1);
        });
        tv.addNode(rootNode);
        this.getPageCache().put(tv.getKey(), SerializationUtils.toJsonString((Object)rootNode));
        this.getPageCache().put("functionItems", SerializationUtils.toJsonString(funcItems));
    }

    private TreeNodeClickListener getTreeNodeClickListener() {
        return new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                Optional function = ReportFunctionPlugin.this.findFunctionByNodeId(evt.getNodeId().toString());
                if (!function.isPresent()) {
                    return;
                }
                Html funcDescription = (Html)ReportFunctionPlugin.this.getView().getControl("funcdescription");
                funcDescription.setConent(((FunctionItem)function.get()).getFuncDescription());
                ReportFunctionPlugin.this.getView().setVisible(Boolean.TRUE, new String[]{"funcdescription"});
            }

            public void treeNodeDoubleClick(TreeNodeEvent evt) {
                Optional function = ReportFunctionPlugin.this.findFunctionByNodeId(evt.getNodeId().toString());
                if (!function.isPresent()) {
                    return;
                }
                String status = (String)ReportFunctionPlugin.this.getView().getFormShowParameter().getCustomParam("status");
                if (HRStringUtils.equals((String)status, (String)OperationStatus.VIEW.toString())) {
                    return;
                }
                ReportFunctionPlugin.this.updateCustomData(((FunctionItem)function.get()).getFuncFullName());
            }
        };
    }

    @ExcludeFromJacocoGeneratedReport
    private Optional<FunctionItem> findFunctionByNodeId(String nodeId) {
        String functionItemStr = this.getPageCache().get("functionItems");
        List functionItems = JSON.parseArray((String)functionItemStr, FunctionItem.class);
        if (functionItems == null) {
            return Optional.empty();
        }
        return functionItems.stream().map(FunctionItem::getChildren).flatMap(Collection::stream).filter(func -> func != null && HRStringUtils.equals((String)func.getId(), (String)nodeId)).findFirst();
    }

    @ExcludeFromJacocoGeneratedReport
    private void updateCustomData(String text) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("displayExpression", " " + text + " ");
        dataMap.put("changeFlag", this.changeFlag());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("expressioncontrol");
        customcontrol.setData((Object)dataMap);
    }

    @ExcludeFromJacocoGeneratedReport
    private void insertItemValue(String text) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("displayExpression", "\"" + text + "\"");
        dataMap.put("changeFlag", this.changeFlag());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("expressioncontrol");
        customcontrol.setData((Object)dataMap);
    }

    @ExcludeFromJacocoGeneratedReport
    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int rowI = 0; rowI < intArray.length; ++rowI) {
            intArray[rowI] = rowI;
        }
        return intArray;
    }

    @ExcludeFromJacocoGeneratedReport
    private FloatResult getItemValue(String nodeId, int start, String searchValue) {
        Set<String> baseDataFields = this.getBaseDataFields();
        Set<String> enumFields = this.getEnumFields();
        if (baseDataFields.isEmpty() && enumFields.isEmpty()) {
            return null;
        }
        if (baseDataFields.contains(nodeId) && (nodeId.endsWith(".name") || nodeId.endsWith(".number"))) {
            return this.getBaseDataFloatList(nodeId, start, searchValue);
        }
        if (enumFields.contains(nodeId)) {
            FloatResult fileSourceFieldEnumItems = this.getFileSourceFieldEnumItems(nodeId, start, searchValue);
            if (fileSourceFieldEnumItems == null) {
                return this.getEnumItemFloatList(nodeId, start, searchValue);
            }
            return fileSourceFieldEnumItems;
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, String> getBaseDataMap() {
        String baseDataNumMapStr = this.getPageCache().get("baseDataNumMap");
        if (HRStringUtils.isNotEmpty((String)baseDataNumMapStr)) {
            return (Map)SerializationUtils.fromJsonString((String)baseDataNumMapStr, Map.class);
        }
        return Collections.emptyMap();
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, String> getEnumEntityNumMap() {
        String enumEntityNumMapStr = this.getPageCache().get("enumEntityNumMap");
        if (HRStringUtils.isNotEmpty((String)enumEntityNumMapStr)) {
            return (Map)SerializationUtils.fromJsonString((String)enumEntityNumMapStr, Map.class);
        }
        return Collections.emptyMap();
    }

    private Set<String> getBaseDataFields() {
        String baseDataNumMapStr = this.getPageCache().get("baseDataNumMap");
        if (HRStringUtils.isNotEmpty((String)baseDataNumMapStr)) {
            Map baseDataNumMap = (Map)SerializationUtils.fromJsonString((String)baseDataNumMapStr, Map.class);
            return baseDataNumMap.keySet();
        }
        return Collections.emptySet();
    }

    private Set<String> getEnumFields() {
        String enumEntityNumMapStr = this.getPageCache().get("enumEntityNumMap");
        if (HRStringUtils.isNotEmpty((String)enumEntityNumMapStr)) {
            Map enumEntityNumMap = (Map)SerializationUtils.fromJsonString((String)enumEntityNumMapStr, Map.class);
            return enumEntityNumMap.keySet();
        }
        return Collections.emptySet();
    }

    @ExcludeFromJacocoGeneratedReport
    public FloatResult getBaseDataFloatList(String nodeId, int start, String searchValue) {
        DynamicObjectCollection dys;
        Map<String, String> baseDataNumMap = this.getBaseDataMap();
        String baseDataNum = baseDataNumMap.get(nodeId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseDataNum);
        QFilter filter = null;
        if (HRStringUtils.isNotEmpty((String)searchValue)) {
            if (nodeId.endsWith(".name")) {
                filter = QFilter.like((String)"name", (String)searchValue);
            } else if (nodeId.endsWith(".number")) {
                filter = QFilter.like((String)"number", (String)searchValue);
            }
        }
        if (HRStringUtils.equals((String)"hbjm_jobgradehr", (String)baseDataNum)) {
            QFilter jobGradQFilter = new QFilter("jobgradescm.iscurrentversion", "=", (Object)Boolean.TRUE);
            dys = helper.queryOriginalCollection("id, number, name", new QFilter[]{filter, jobGradQFilter});
        } else {
            String entityType = HisCommonService.getInstance().entityInhRelation(baseDataNum);
            if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType)) {
                QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
                dys = helper.queryOriginalCollection("id, number, name", new QFilter[]{hisFilter, filter});
            } else {
                dys = helper.queryOriginalCollection("id, number, name", new QFilter[]{filter});
            }
        }
        ArrayList selectItems = Lists.newArrayListWithExpectedSize((int)dys.size());
        if (dys.size() == 0) {
            return new FloatResult(selectItems, true);
        }
        dys.stream().skip(start).limit(20L).forEach(baseData -> {
            SelectItem selectItem = new SelectItem();
            selectItem.setShowValue(baseData.getString("name") + " | " + baseData.getString("number"));
            if (nodeId.endsWith(".name")) {
                selectItem.setShowKey(baseData.getString("name"));
            } else if (nodeId.endsWith(".number")) {
                selectItem.setShowKey(baseData.getString("number"));
            }
            selectItems.add(selectItem);
        });
        boolean isEnd = start + selectItems.size() == dys.size();
        return new FloatResult(selectItems, isEnd);
    }

    @ExcludeFromJacocoGeneratedReport
    public FloatResult getEnumItemFloatList(String nodeId, int start, String searchValue) {
        IDataEntityProperty property;
        Map<String, String> enumEntityNumMap = this.getEnumEntityNumMap();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)enumEntityNumMap.get(nodeId));
        String propName = nodeId;
        if (nodeId.contains(".")) {
            propName = nodeId.substring(nodeId.lastIndexOf(46) + 1);
        }
        if ((property = (IDataEntityProperty)mainEntityType.getAllFields().get(propName)) instanceof ComboProp) {
            List<SelectItem> selectItems;
            ComboProp prop = (ComboProp)property;
            List comboItems = prop.getComboItems();
            if (comboItems == null) {
                return null;
            }
            if (HRStringUtils.isNotEmpty((String)searchValue)) {
                comboItems = comboItems.stream().filter(item -> item.getName().getLocaleValue().contains(searchValue)).collect(Collectors.toList());
            }
            boolean isEnd = start + (selectItems = comboItems.stream().skip(start).limit(20L).map(item -> {
                SelectItem selectItem = new SelectItem();
                selectItem.setShowValue(item.getName().getLocaleValue());
                selectItem.setShowKey(item.getName().getLocaleValue());
                return selectItem;
            }).collect(Collectors.toList())).size() == comboItems.size();
            return new FloatResult(selectItems, isEnd);
        }
        throw new KDBizException("property is error.");
    }

    @ExcludeFromJacocoGeneratedReport
    private FloatResult getFileSourceFieldEnumItems(String fieldNumber, int start, String searchValue) {
        List<SelectItem> selectItems;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        String enumItemMapStr = this.getView().getViewNoPlugin(parentPageId).getPageCache().get("enumItemMap");
        if (HRStringUtils.isEmpty((String)enumItemMapStr)) {
            return null;
        }
        Map enumItemMap = (Map)SerializationUtils.fromJsonString((String)enumItemMapStr, Map.class);
        List enumItems = enumItemMap.getOrDefault(fieldNumber, Lists.newArrayListWithCapacity((int)10));
        if (enumItems == null) {
            return null;
        }
        if (HRStringUtils.isNotEmpty((String)searchValue)) {
            enumItems = enumItems.stream().filter(item -> item.contains(searchValue)).collect(Collectors.toList());
        }
        boolean isEnd = start + (selectItems = enumItems.stream().skip(start).limit(20L).map(enumItem -> {
            SelectItem selectItem = new SelectItem();
            selectItem.setShowValue(enumItem);
            selectItem.setShowKey(enumItem);
            return selectItem;
        }).collect(Collectors.toList())).size() == enumItems.size();
        return new FloatResult(selectItems, isEnd);
    }

    static {
        btnControlMap.put("btnplus", "+");
        btnControlMap.put("btnsub", "-");
        btnControlMap.put("btnmul", "*");
        btnControlMap.put("btndiv", "/");
        btnControlMap.put("btngt", ">");
        btnControlMap.put("btnlt", "<");
        btnControlMap.put("btnge", ">=");
        btnControlMap.put("btnle", "<=");
        btnControlMap.put("btnnt", "!=");
        btnControlMap.put("btneq", "=");
        btnControlMap.put("btnleft", "(");
        btnControlMap.put("btnright", ")");
        btnControlMap.put("btnquo", "\"");
        btnControlMap.put("btnand", "and");
        btnControlMap.put("btnor", "or");
    }

    static class FloatResult {
        private final List<SelectItem> items;
        private final boolean isEnd;
        private int nextStart;

        public FloatResult(List<SelectItem> items, boolean isEnd) {
            this.items = items;
            this.isEnd = isEnd;
            if (items != null) {
                this.nextStart = items.size();
            }
        }

        public List<SelectItem> getItems() {
            return this.items;
        }

        public boolean isEnd() {
            return this.isEnd;
        }

        public int getNextStart() {
            return this.nextStart;
        }

        public void setNextStart(int nextStart) {
            this.nextStart = nextStart;
        }
    }
}

