/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.common.model.AdminOrgQueryParamInfo;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgTreeHelper {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgTreeHelper.class);

    public static DynamicObjectCollection getFirstLevelCollection(String parentId, DynamicObjectCollection firstLevelCollection, List<String> firstLevelIdList, AuthorizedOrgResultWithSub permOrgResult, AdminOrgQueryParamInfo queryParamInfo) {
        List orgsWithSub = permOrgResult.getHasPermOrgsWithSub();
        DynamicObjectCollection secondLevelCollection = AdminOrgTreeHelper.getSecondLevelOrgs(firstLevelIdList, queryParamInfo);
        boolean hasAll = false;
        hasAll = permOrgResult.isHasAllOrgPerm() ? true : AdminOrgTreeHelper.hasAllCurrentNodePerm(parentId, orgsWithSub);
        if (hasAll) {
            return AdminOrgTreeHelper.getFirstLevelWithAllPerm(firstLevelCollection, secondLevelCollection);
        }
        return AdminOrgTreeHelper.getFirstLevelWithoutAllPerm(firstLevelCollection, secondLevelCollection, orgsWithSub);
    }

    private static DynamicObjectCollection getFirstLevelWithAllPerm(DynamicObjectCollection firstLevelCollection, DynamicObjectCollection secondLevelCollection) {
        HashSet parentIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dyno : secondLevelCollection) {
            parentIdSet.add(dyno.getLong("parentorg.id"));
        }
        DynamicObjectCollection result = new DynamicObjectCollection();
        for (DynamicObject dyno : firstLevelCollection) {
            if (parentIdSet.contains(dyno.getLong("id"))) {
                dyno.set("isleaf", (Object)Boolean.FALSE);
            } else {
                dyno.set("isleaf", (Object)Boolean.TRUE);
            }
            result.add((Object)dyno);
        }
        return result;
    }

    private static DynamicObjectCollection getFirstLevelWithoutAllPerm(DynamicObjectCollection firstLevelCollection, DynamicObjectCollection secondLevelCollection, List<OrgSubInfo> orgsWithSub) {
        Set<String> getAllParentStructNumber = AdminOrgTreeHelper.getAllParentStructNumber(orgsWithSub);
        HashSet parentIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dyno : secondLevelCollection) {
            String structNumber = dyno.getString("structnumber");
            if (!getAllParentStructNumber.contains(structNumber)) continue;
            parentIdSet.add(dyno.getLong("parentorg.id"));
        }
        DynamicObjectCollection result = new DynamicObjectCollection();
        for (DynamicObject dyno : firstLevelCollection) {
            if (parentIdSet.contains(dyno.getLong("id"))) {
                dyno.set("isleaf", (Object)Boolean.FALSE);
            } else {
                dyno.set("isleaf", (Object)Boolean.TRUE);
            }
            if (!getAllParentStructNumber.contains(dyno.getString("structnumber"))) continue;
            result.add((Object)dyno);
        }
        return result;
    }

    private static String getLongStructNumber(String id) {
        QFilter idFilter = new QFilter("adminorg", "=", (Object)Long.parseLong(id));
        idFilter.and("structproject", "=", (Object)1010L);
        DynamicObject dyno = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryOriginalOne("structlongnumber", new QFilter[]{idFilter});
        return dyno.getString("structlongnumber");
    }

    private static boolean hasAllCurrentNodePerm(String parentId, List<OrgSubInfo> orgsWithSub) {
        String longStructNumber = AdminOrgTreeHelper.getLongStructNumber(parentId);
        for (OrgSubInfo orgSubInfo : orgsWithSub) {
            if (HRStringUtils.isEmpty((String)orgSubInfo.getLongStructNumber())) {
                LOGGER.error("hasAllCurrentNodePerm org has not longstructnumber:" + orgSubInfo);
                continue;
            }
            if (!orgSubInfo.isContainsSub() || !longStructNumber.startsWith(orgSubInfo.getLongStructNumber())) continue;
            return true;
        }
        return false;
    }

    public static DynamicObjectCollection getSecondLevelOrgs(List<String> firstLevelIdList, AdminOrgQueryParamInfo queryParamInfo) {
        QFilter parentFilter = new QFilter("parentorg", "in", AdminOrgTreeHelper.str2LongList(firstLevelIdList));
        parentFilter.and("structproject", "=", (Object)1010L);
        QFilter[] filterArrayByFilterParams = AdminOrgTreeHelper.getFilterArrayByFilterParams(parentFilter, queryParamInfo.isShowDept(), queryParamInfo.isShowDisable(), queryParamInfo.isShowUnUsing());
        return HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryColl("structlongnumber,parentorg.id,adminorg.structnumber structnumber", filterArrayByFilterParams, null);
    }

    private static List<Long> str2LongList(List<String> strList) {
        if (CollectionUtils.isEmpty(strList)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)strList.size());
        for (String str : strList) {
            if (!HRStringUtils.isNotEmpty((String)str)) continue;
            resultList.add(Long.parseLong(str));
        }
        return resultList;
    }

    private static Set<String> getAllParentStructNumber(List<OrgSubInfo> orgsWithSub) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgSubInfo orgSubInfo : orgsWithSub) {
            result.addAll(AdminOrgTreeHelper.splitLongNumber(orgSubInfo.getLongStructNumber()));
        }
        HashSet containSubIdList = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgSubInfo orgSubInfo : orgsWithSub) {
            if (!orgSubInfo.isContainsSub()) continue;
            containSubIdList.add(orgSubInfo.getOrgId());
        }
        QFilter qFilter = new QFilter("parentorg", "in", (Object)containSubIdList);
        qFilter.and("structproject", "=", (Object)1010L);
        DynamicObjectCollection childCollection = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryColl("structlongnumber", new QFilter[]{qFilter}, null);
        for (DynamicObject dyno : childCollection) {
            result.addAll(AdminOrgTreeHelper.splitLongNumber(dyno.getString("structlongnumber")));
        }
        return result;
    }

    private static Set<String> splitLongNumber(String longNumber) {
        String[] structNumberArr;
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)longNumber)) {
            return result;
        }
        for (String structNumber : structNumberArr = longNumber.split("!")) {
            result.add(structNumber);
        }
        return result;
    }

    public static QFilter[] getFilterArrayByFilterParams(QFilter filter, boolean isshowdepartment, boolean isshowdisable, boolean isshowunusing) {
        QFilter[] qFilters = null;
        QFilter qFilter = null;
        if (!isshowunusing) {
            qFilter = new QFilter("adminorg.enable", "!=", (Object)"2");
            filter.and(qFilter);
        }
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        if (!isshowdepartment) {
            HashSet<Long> longSet = new HashSet<Long>();
            longSet.add(Long.valueOf("1020"));
            longSet.add(Long.valueOf("1010"));
            longSet.add(Long.valueOf("1030"));
            QFilter companyTypeFilter = new QFilter("adminorg.adminorgtype.adminorgtypestd", "in", longSet);
            if (isshowdisable) {
                qFilters = new QFilter[]{filter, companyTypeFilter, currentFilter};
            } else {
                QFilter filterShowEnable = new QFilter("adminorg.enable", "!=", (Object)"0");
                qFilters = new QFilter[]{filter, companyTypeFilter, filterShowEnable, currentFilter};
            }
        } else if (isshowdisable) {
            qFilters = new QFilter[]{filter, currentFilter};
        } else {
            QFilter filterShowEnable = new QFilter("adminorg.enable", "!=", (Object)"0");
            qFilters = new QFilter[]{filter, filterShowEnable, currentFilter};
        }
        AdminOrgTreeHelper.addFiltersOfAdminorg(filter);
        return qFilters;
    }

    private static void addFiltersOfAdminorg(QFilter filter) {
        filter.and(new QFilter("adminorg.initstatus", "in", (Object)"2"));
        ArrayList<String> dstatus = new ArrayList<String>();
        dstatus.add("1");
        dstatus.add("2");
        filter.and(new QFilter("adminorg.datastatus", "in", dstatus));
    }
}

