/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;

public class BasedataQueryDesc {
    private IBasedataField prop;
    private String parentEntity;
    private Map<String, Object> whereMap;
    private String importKey;
    private String importValue;
    private Set<String> selectProp;
    private JSONObject useOrg;

    public BasedataQueryDesc(BasedataProp prop, String importKey) {
        this(prop, importKey, Sets.newHashSet((Object[])"id,name,number,status,enable".split(",")));
    }

    public BasedataQueryDesc(BasedataProp prop, String importKey, Set<String> selectProp) {
        this.prop = prop;
        this.importKey = importKey;
        this.selectProp = selectProp;
        this.whereMap = Maps.newHashMap();
    }

    public BasedataQueryDesc(BasedataProp prop, String importKey, Set<String> selectProp, JSONObject useOrg) {
        this.prop = prop;
        this.importKey = importKey;
        this.selectProp = selectProp;
        this.whereMap = Maps.newHashMap();
        this.useOrg = useOrg;
    }

    public BasedataQueryDesc(MulBasedataProp prop, String importKey, Set<String> selectProp, JSONObject useOrg) {
        this.prop = prop;
        this.importKey = importKey;
        this.selectProp = selectProp;
        this.whereMap = Maps.newHashMap();
        this.useOrg = useOrg;
    }

    public QFilter[] getQFiltrs() {
        return (QFilter[])this.whereMap.entrySet().stream().map(entry -> {
            QFilter qFilter = new QFilter((String)entry.getKey(), "in", entry.getValue());
            if (this.hasEnable()) {
                QFilter statusQFilter = new QFilter("enable", "=", (Object)"1");
                return qFilter.and(statusQFilter);
            }
            return qFilter;
        }).toArray(QFilter[]::new);
    }

    public QFilter[] getHisQFiltrs() {
        List<QFilter> qFilters = this.whereMap.entrySet().stream().map(entry -> new QFilter((String)entry.getKey(), "in", entry.getValue())).collect(Collectors.toList());
        if (this.hasEnable()) {
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
        }
        if (this.hasHis()) {
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')));
        }
        return qFilters.toArray(new QFilter[0]);
    }

    private boolean hasHis() {
        String entityType = HisCommonService.getInstance().entityInhRelation(this.prop.getBaseEntityId());
        return EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType);
    }

    private boolean hasEnable() {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)this.prop.getBaseEntityId());
        return mainType.getProperties().stream().map(IMetadata::getName).anyMatch(pro -> pro.equals("enable"));
    }

    public void putWhere(String queryField, Object value) {
        this.whereMap.put(queryField, value);
    }

    public IBasedataField getProp() {
        return this.prop;
    }

    public Map<String, Object> getWhereMap() {
        return this.whereMap;
    }

    public Set<String> getSelectProp() {
        return this.selectProp;
    }

    public String getImportKey() {
        return this.importKey;
    }

    public void setImportKey(String importKey) {
        this.importKey = importKey;
    }

    public String getImportValue() {
        return this.importValue;
    }

    public String getParentEntity() {
        return this.parentEntity;
    }

    public void setParentEntity(String parentEntity) {
        this.parentEntity = parentEntity;
    }

    public void setImportValue(String importValue) {
        this.importValue = importValue;
    }

    public String getUseOrg() {
        if (null == this.useOrg) {
            return "";
        }
        String importPropTemp = this.useOrg.getString("importprop");
        return this.useOrg.getString(importPropTemp);
    }

    public JSONObject getUseOrgJson() {
        return this.useOrg;
    }
}

