/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.HRSheetHandler;
import kd.hr.hbp.formplugin.web.imp.ImportHelper;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.xml.sax.SAXException;

public class BatchImportFailedSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(BatchImportFailedSheetHandler.class);
    private static final String COLOR = "color";
    private static final String HRMP_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";
    private static final int INT_4000 = 4000;
    private SXSSFWorkbook book;
    private Map<String, CellStyle> styles = new HashMap<String, CellStyle>();
    private ImportLogger importLogger;
    private FileService service;
    private ImportContext ctx;
    private int cursorRowNum;
    private SheetHandler.ParsedRow currentRow;
    private Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>();
    private boolean hasErrorCol;
    private final int ERR_ROW_COUNT = 5000;
    private boolean isNewFormat = true;
    private boolean isDropdownItemsSheet = false;
    private Map<String, SXSSFRow> nameRows = new HashMap<String, SXSSFRow>();

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public BatchImportFailedSheetHandler(ImportContext ctx, ImportLogger importLogger, FileService service) {
        this.setInterrupt(false);
        this.ctx = ctx;
        this.importLogger = importLogger;
        this.service = service;
        importLogger.getDelRows().sort((o1, o2) -> o1[0] - o2[0]);
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            if (this.book == null) {
                this.book = new SXSSFWorkbook(1000);
                this.book.setCompressTempFiles(true);
            }
            sheet = this.book.createSheet(row.getSheetName());
            if (this.sheets.size() == 0) {
                sheet.setColumnWidth(0, 10000);
            }
            this.isDropdownItemsSheet = "dropdown_items_sheet".equals(row.getSheetName());
            this.sheets.put(row.getSheetName(), sheet);
        }
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        if (this.isDropdownItemsSheet) {
            this.handleDropdownSheet(sheet, currRowNum);
            return;
        }
        if (this.sheets.size() > 1) {
            this.handleSheet(sheet, currRowNum);
            return;
        }
        this.handleWorkSheet(row, sheet, currRowNum);
    }

    private void handleWorkSheet(SheetHandler.ParsedRow row, SXSSFSheet sheet, int currRowNum) {
        int titleRowIndex;
        String entityName;
        if (currRowNum == 0 && (StringUtils.isBlank((CharSequence)(entityName = this.currentRow.get(Integer.valueOf(0)))) || !entityName.contains(" # "))) {
            this.hasErrorCol = true;
        }
        if (currRowNum == 2) {
            this.isNewFormat = !((String)row.getData().get(this.hasErrorCol ? 1 : 0)).contains(" # ");
        }
        int n = titleRowIndex = this.isNewFormat ? 3 : 2;
        if (currRowNum == titleRowIndex) {
            SXSSFRow nameRow = this.getRow(sheet, this.cursorRowNum);
            this.nameRows.put(row.getSheetName(), nameRow);
            SXSSFCell cell = nameRow.createCell(0);
            cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"BatchImportFailedSheetHandler_0", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
        } else if (currRowNum > titleRowIndex) {
            if (this.isRowSucceed(this.importLogger.getDelRows(), currRowNum)) {
                return;
            }
            this.getLogStr(sheet, currRowNum, titleRowIndex);
        }
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            this.putSXSSFSheet(sheet, currRowNum, titleRowIndex, entry);
        }
        ++this.cursorRowNum;
    }

    private void putSXSSFSheet(SXSSFSheet sheet, int currRowNum, int titleRowIndex, Map.Entry<Integer, String> entry) {
        CellStyle cellStyle;
        if (this.hasErrorCol && entry.getKey() == 0) {
            return;
        }
        JSONObject styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
        int cellIndex = this.countIndex(entry.getKey());
        SXSSFCell cell = this.getRow(sheet, this.cursorRowNum).createCell(cellIndex);
        if (currRowNum == titleRowIndex) {
            styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
            if (entry.getValue().startsWith("*")) {
                styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            }
            sheet.setColumnWidth(cellIndex, ImportHelper.calcColumnWidth(entry.getValue(), 0));
        }
        if ((cellStyle = this.getCellStyle(styleObj)) != null) {
            cell.setCellStyle(cellStyle);
        }
        this.initCellStyle(cell, entry, styleObj);
    }

    private void getLogStr(SXSSFSheet sheet, int currRowNum, int titleRowIndex) {
        List logs = (List)this.importLogger.getLogCache().get(currRowNum);
        if (logs != null && !logs.isEmpty()) {
            String mergeLogStr;
            if (this.cursorRowNum - titleRowIndex <= 5000) {
                StringBuilder logStringBuilder = new StringBuilder();
                for (ImportLogger.ImportLog importLog : logs) {
                    logStringBuilder.append(importLog.toString()).append(System.lineSeparator());
                    if (logStringBuilder.length() <= 4000) continue;
                    logStringBuilder.replace(3997, 4000, "...").setLength(4000);
                    break;
                }
                mergeLogStr = logStringBuilder.toString();
            } else {
                mergeLogStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u884c\u6570\u636e\u3002", (String)"BatchImportFailedSheetHandler_1", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]);
            }
            SXSSFCell cell = this.getRow(sheet, this.cursorRowNum).createCell(0);
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            cell.setCellStyle(this.getCellStyle(styleObj));
            cell.setCellValue(mergeLogStr);
        }
    }

    private void handleSheet(SXSSFSheet sheet, int currRowNum) {
        this.hasErrorCol = true;
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            JSONObject styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(((Integer)entry.getKey()).intValue());
            CellStyle style = this.getCellStyle(styleObj);
            if (Objects.nonNull(style)) {
                cell.setCellStyle(style);
            }
            this.initCellStyle(cell, entry, styleObj);
        }
    }

    private void initCellStyle(SXSSFCell cell, Map.Entry<Integer, String> entry, JSONObject styleObj) {
        String fmt = styleObj.getString("fmt");
        if (HRStringUtils.isNotEmpty((String)fmt)) {
            try {
                cell.setCellValue(new BigDecimal(entry.getValue()).doubleValue());
            }
            catch (NumberFormatException e) {
                cell.setCellValue(entry.getValue());
            }
        } else {
            cell.setCellValue(entry.getValue());
        }
    }

    private void handleDropdownSheet(SXSSFSheet sheet, int currRowNum) {
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(((Integer)entry.getKey()).intValue());
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)entry.getValue());
        }
    }

    private CellStyle getCellStyle(JSONObject style) {
        String fmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short bg = style.getShort("bg");
        Short color = style.getShort(COLOR);
        String styleStr = String.format(Locale.ROOT, "%s_-_%d_-_%d_-_%s", fmt, bg, color, align);
        CellStyle cellStyle = this.styles.get(styleStr);
        if (cellStyle == null) {
            cellStyle = HRSheetHandler.getCellStyle(fmt, bg, color, styleStr, this.styles, this.book);
            cellStyle.setAlignment(this.getAlignment(align));
        }
        return cellStyle;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private boolean isRowSucceed(List<int[]> delRows, int currRowNum) {
        for (int[] rs : delRows) {
            if (rs[1] < rs[0]) {
                return currRowNum >= rs[0];
            }
            if (currRowNum > rs[1]) continue;
            return currRowNum >= rs[0];
        }
        return false;
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int intdexRow) {
        SXSSFRow row = sheet.getRow(intdexRow);
        if (row == null) {
            row = sheet.createRow(intdexRow);
        }
        return row;
    }

    private int countIndex(int index) {
        if (this.hasErrorCol) {
            return index;
        }
        return ++index;
    }

    public void endDocument() throws SAXException {
        this.setInterrupt(false);
        super.endDocument();
        Set sheetNames = this.getSheetNames();
        sheetNames.remove(this.getSheetName());
        if (sheetNames.isEmpty()) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                int dropdownItemsSheetIndex = this.book.getSheetIndex("dropdown_items_sheet");
                if (dropdownItemsSheetIndex >= 0) {
                    this.book.setSheetHidden(dropdownItemsSheetIndex, true);
                }
                this.book.write((OutputStream)os);
                byte[] data = os.toByteArray();
                TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
                LocalDate now = LocalDate.now();
                String dataStr = String.format(Locale.ROOT, "%02d%02d", now.getMonthValue(), now.getDayOfMonth());
                String tempFileName = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_%1$s_%2$s.xlsx\u3002", (String)"BatchImportFailedSheetHandler_2", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]), this.ctx.getListName(), dataStr);
                String fileName = tempFileName.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
                String fileUrl = tempFile.saveAsUrl(fileName, data, data.length);
                RequestContext requestContext = RequestContext.getOrCreate();
                String path = FileNameUtils.getExportFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)this.ctx.getAppId(), (String)(this.ctx.getBillFormId() + UUID.randomUUID().toString()), (String)fileName);
                fileUrl = this.service.upload(new FileItem(fileName, path, tempFile.getInputStream(fileUrl)));
                this.importLogger.setErrFile(UrlService.getAttachmentFullUrl((String)fileUrl));
            }
            catch (Exception exp) {
                throw new KDBizException((Throwable)exp, new ErrorCode("", exp instanceof KDBizException ? exp.getMessage() : ResManager.loadKDString((String)"\u6570\u636e\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"BatchImportFailedSheetHandler_3", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0])), new Object[0]);
            }
            finally {
                this.closeResource(this.book);
                this.sheets.clear();
                this.importLogger = null;
                this.ctx = null;
            }
        }
    }

    private void closeResource(SXSSFWorkbook book) {
        try {
            if (book != null) {
                book.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        HRSheetHandler.handleDataValidation(cellValidations, this.sheets, this.hasErrorCol);
    }

    public void handleSheetComments(Map<String, CommentsTable> comments) {
        HRSheetHandler.handleSheetComments(comments, this.isNewFormat, this.book, this.nameRows, this.hasErrorCol);
    }
}

