/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRMultiEntityImptUtil;
import kd.hr.hbp.formplugin.web.imp.ImportEntity;
import kd.hr.hbp.formplugin.web.imp.ImportEntityMapping;
import kd.hr.hbp.formplugin.web.imp.ImportHelper;
import kd.hr.hbp.formplugin.web.multisheet.helper.MultiSheetHelper;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class BatchImportSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(ExcelReader.class);
    private static final String HRMP_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";
    int lastStartRowNum = 0;
    private Map<Long, Set<String>> setNullFields = new HashMap<Long, Set<String>>();
    private ImportContext importContext;
    private String url;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private Map<Integer, String> nameRow;
    private List<ImportEntityMapping> importEntityMapping;
    private List<ImportEntity> importEntity;
    private ImportLogger importLogger;
    private String currEntityId = "";
    private String preEntityId = "";
    private String tempCode = "";
    private String multiTempCode = "";
    private Map<String, ImportLogger> importLoggerMap = Maps.newHashMap();
    private SheetHandler.ParsedRow currentRow;
    private JSONObject rowJson = new JSONObject();
    private int startRowNum = 0;
    private int startEntryRowNum = 0;
    private int dataIndex = 0;
    private boolean isSetNullEffective = false;
    private int completeEmptyRowNum = 0;

    public BatchImportSheetHandler(ImportContext importContext, String path, LinkedBlockingQueue<ImportBillData> linkedBlockingQueue) {
        this.importContext = importContext;
        this.url = path;
        this.dataQueue = linkedBlockingQueue;
    }

    public BatchImportSheetHandler(List<ImportEntity> importEntity, ImportContext importContext, String path) {
        this.importContext = importContext;
        this.url = path;
        this.importEntity = importEntity;
        this.dataQueue = this.importContext.getDataQueue(this.url);
        this.importLogger = this.importContext.getLogger(this.url);
    }

    public BatchImportSheetHandler(ImportContext importContext, String path, Map<String, ImportLogger> importLoggerMap) {
        this.importContext = importContext;
        this.url = path;
        this.dataQueue = this.importContext.getDataQueue(this.url);
        this.importLogger = this.importContext.getLogger(this.url);
        this.importLoggerMap = importLoggerMap;
    }

    public BatchImportSheetHandler(ImportContext importContext, String path) {
        this.importContext = importContext;
        this.url = path;
        this.dataQueue = this.importContext.getDataQueue(this.url);
        this.importLogger = this.importContext.getLogger(this.url);
    }

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        if (row.getSheetName().contains("DDM_")) {
            return;
        }
        int currRowNum = row.getRowNum();
        if (row.getData().isEmpty()) {
            ++this.completeEmptyRowNum;
        }
        if (currRowNum > 3) {
            this.buildImportBillData(row);
        } else if (currRowNum == 3) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.importEntity.get(0).getEntityName());
            this.importEntityMapping.add(ImportEntityMapping.create((DynamicObjectType)entityType, this.nameRow, row.getData()));
        } else if (currRowNum == 2) {
            this.nameRow = row.getData();
        } else if (currRowNum == 0) {
            LOG.info("BatchImportSheetHandler--begin to handleRow,sheetName:{},currRowNum:{},completeEmptyRowNum:{}", new Object[]{row.getSheetName(), currRowNum, this.completeEmptyRowNum});
            this.importLogger.setRowIndex(currRowNum - this.completeEmptyRowNum);
            this.importLogger.setLastRowIndex(this.getRowCount() - this.completeEmptyRowNum);
            this.initMultiImportParams(row, currRowNum);
            if (row.isEmpty()) {
                LOG.error("row...number...0...data is null...continue,logId: {}", this.importContext.getLogId());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildImportBillData(SheetHandler.ParsedRow row) {
        try {
            int currRowNum = row.getRowNum();
            ImportEntityMapping importEntityMappingTemp = this.importEntityMapping.get(0);
            if (!importEntityMappingTemp.isEntryRow(this.currentRow, row)) {
                this.addNewBillData(row);
            } else if (row.getRowNum() - this.startEntryRowNum >= this.importContext.getBatchEntryRowSize()) {
                String overSizeErr = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u6570\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff1a%s\u3002", (String)"BatchImportSheetHandler_3", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]), this.importContext.getBatchEntryRowSize());
                this.importLogger.log(Integer.valueOf(currRowNum), overSizeErr);
                this.importLoggerMap.get(this.currEntityId).log(Integer.valueOf(currRowNum), overSizeErr);
                return;
            }
            this.fillBlankValues(importEntityMappingTemp, row.getData());
            List<String> errMsg = importEntityMappingTemp.push(row.getData(), this.rowJson);
            if (!errMsg.isEmpty()) {
                String errMsgTemp = String.join((CharSequence)"; ", errMsg);
                this.importLogger.log(Integer.valueOf(currRowNum), errMsgTemp);
                this.importLoggerMap.get(this.currEntityId).log(Integer.valueOf(currRowNum), errMsgTemp);
            }
        }
        finally {
            this.currentRow = row;
        }
    }

    private void fillBlankValues(ImportEntityMapping mapping, Map<Integer, String> rowData) {
        Optional<ImportEntityMapping> entryMapping;
        if (rowData == null || rowData.size() == 0 || !this.isSetNullEffective) {
            return;
        }
        this.setNullFields.clear();
        HashMap mainFieldIndex = new HashMap();
        mapping.getCols().entrySet().forEach(col -> {
            mainFieldIndex.put(((ImportEntityMapping.ColInfo)col.getValue()).getIndex(), col.getKey());
            this.handMultiLangField(mainFieldIndex, (Map.Entry<String, ImportEntityMapping.ColInfo>)col);
        });
        HashMap entryFieldIndex = new HashMap();
        Long entryId = 0L;
        int entryIdIndex = -1;
        if (mapping.getEntries().size() > 0 && (entryMapping = mapping.getEntries().entrySet().stream().map(Map.Entry::getValue).findFirst()).isPresent() && entryMapping.get().getCols() != null) {
            final ImportEntityMapping importEntityMapping = entryMapping.get();
            ImportEntityMapping.ColInfo entryIdColInfo = importEntityMapping.getCols().get(importEntityMapping.getEntityTypeId() + "." + "id");
            if (entryIdColInfo != null) {
                entryIdIndex = entryIdColInfo.getIndex();
                importEntityMapping.getCols().entrySet().forEach(col -> {
                    entryFieldIndex.put(((ImportEntityMapping.ColInfo)col.getValue()).getIndex(), col.getKey());
                    this.handMultiLangField(entryFieldIndex, (Map.Entry<String, ImportEntityMapping.ColInfo>)col);
                });
            }
            this.setNullFields.put(-1L, (Set<String>)new HashSet<String>(){
                private static final long serialVersionUID = -6069433966951898960L;
                {
                    this.add(importEntityMapping.getEntityTypeId());
                }
            });
        }
        HashSet mainSetNullField = new HashSet();
        HashSet entrySetNullField = new HashSet();
        for (Map.Entry<Integer, String> map : rowData.entrySet()) {
            if ("NULL".equals(map.getValue()) && mainFieldIndex.containsKey(map.getKey())) {
                mainSetNullField.add(mainFieldIndex.get(map.getKey()));
                map.setValue(null);
                continue;
            }
            if ("NULL".equals(map.getValue()) && entryFieldIndex.containsKey(map.getKey())) {
                entrySetNullField.add(entryFieldIndex.get(map.getKey()));
                map.setValue(null);
                continue;
            }
            if (map.getKey() != entryIdIndex) continue;
            entryId = Long.valueOf(map.getValue());
        }
        if (mainSetNullField.size() > 0) {
            this.setNullFields.put(0L, mainSetNullField);
        }
        if (entrySetNullField.size() > 0) {
            this.setNullFields.put(entryId, entrySetNullField);
        }
    }

    private void handMultiLangField(Map<Integer, String> mainFieldIndex, Map.Entry<String, ImportEntityMapping.ColInfo> col) {
        col.getValue().getFlexColIndex().keySet().forEach(colIndex -> {
            String cfr_ignored_0 = (String)mainFieldIndex.put((Integer)colIndex, (String)col.getKey());
        });
    }

    private void initMultiImportParams(SheetHandler.ParsedRow row, int currRowNum) {
        if (StringUtils.isNotBlank((CharSequence)this.currEntityId)) {
            this.preEntityId = this.currEntityId;
        }
        String entityName = row.get(Integer.valueOf(0));
        try {
            ImportHelper.multiSheetInitLog(this.importLoggerMap, entityName);
            this.currEntityId = HRMultiEntityImptUtil.getEntityId((String)entityName, (int)1);
            this.tempCode = HRMultiEntityImptUtil.getEntityId((String)entityName, (int)2);
            if (StringUtils.isEmpty((CharSequence)this.multiTempCode)) {
                this.multiTempCode = HRMultiEntityImptUtil.getEntityId((String)entityName, (int)3);
            }
            if (this.importEntity == null) {
                this.importEntity = Lists.newArrayListWithExpectedSize((int)16);
            }
            if (this.importEntityMapping == null) {
                this.importEntityMapping = Lists.newArrayListWithExpectedSize((int)16);
            }
            this.importEntity.clear();
            this.importEntityMapping.clear();
            this.isSetNullEffective = this.isSetNullEffective();
            Set sheetNames = this.getSheetNames();
            sheetNames.forEach(name -> {
                String sheetName = HRMultiEntityImptUtil.getEntityId((String)entityName, (int)0);
                if (sheetName.contains((CharSequence)name)) {
                    ImportEntity importEntityTemp = new ImportEntity();
                    importEntityTemp.setEntityName(HRMultiEntityImptUtil.getEntityId((String)entityName, (int)1));
                    this.importEntity.add(importEntityTemp);
                }
            });
        }
        catch (RuntimeException runtimeException) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u6570\u636e\uff1a%s\u3002", (String)"BatchImportSheetHandler_0", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]), StringUtils.isBlank((CharSequence)entityName) ? row.getSheetName() : entityName));
        }
        this.importLoggerMap.get(this.currEntityId).setRowIndex(currRowNum - this.completeEmptyRowNum);
        this.importLoggerMap.get(this.currEntityId).setLastRowIndex(this.getRowCount() - this.completeEmptyRowNum);
    }

    private boolean addNewBillData(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (this.rowJson.size() != 0) {
            this.preEntityId = this.currEntityId;
            ImportBillData billData = this.constructBillData(currRowNum);
            this.addBillData(billData, false);
            this.setNullFields.clear();
        }
        this.rowJson = new JSONObject();
        this.startRowNum = currRowNum;
        this.startEntryRowNum = currRowNum;
        return true;
    }

    private ImportBillData constructBillData(int currRowNum) {
        ++this.dataIndex;
        String preSheetName = this.currentRow.getSheetName();
        JSONObject rowEntity = new JSONObject();
        rowEntity.put(this.preEntityId, (Object)this.rowJson);
        JSONObject rowObj = new JSONObject();
        rowObj.put("data", (Object)rowEntity);
        rowObj.put("rownum", (Object)this.startRowNum);
        rowObj.put("sheetName", (Object)(StringUtils.isNotBlank((CharSequence)preSheetName) ? preSheetName : this.getSheetName()));
        rowObj.put("tempCode", (Object)this.multiTempCode);
        rowObj.put("setNullFields", JSONObject.toJSON(this.setNullFields));
        ImportBillData billData = new ImportBillData(rowObj, this.startRowNum, currRowNum - 1, new kd.bos.form.plugin.impt.ImportEntityMapping());
        billData.setDataIndex(this.dataIndex);
        billData.setStartRowIndex(this.startRowNum);
        return billData;
    }

    private void addBillData(ImportBillData billData, boolean isSheetEnd) {
        try {
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"BatchImportSheetHandler_1", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        catch (InterruptedException | KDBizException e) {
            LOG.error("Analysis Thread Exception.", e);
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"BatchImportSheetHandler_2", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
        }
        finally {
            ImportLogger logger = this.importContext.getLogger(this.url);
            logger.setTotal(logger.getTotal() + 1);
        }
        if (this.lastStartRowNum == 0 || billData.getEndIndex() - this.lastStartRowNum >= 500 || isSheetEnd) {
            ImportLogger logger = this.importContext.getLogger(this.url);
            logger.setRowIndex(billData.getEndIndex() - this.completeEmptyRowNum);
            logger.setLastRowIndex(billData.getEndIndex() + 1 - this.completeEmptyRowNum);
            this.importContext.feedbackProgress(0, logger, null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }

    private boolean isSetNullEffective() {
        if (!"new".equals(this.importContext.getOption().get("importtype"))) {
            QFilter qFilter = new QFilter("number", "=", (Object)this.tempCode);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_importtemplate", (String)"enablesetnull", (QFilter[])new QFilter[]{qFilter});
            if (Objects.nonNull(dynamicObject)) {
                return dynamicObject.getBoolean("enablesetnull");
            }
        }
        return false;
    }

    public void endDocument() throws SAXException {
        LOG.info("BatchImportSheetHandler--endDocument row size:{},currEntityNumber:{}", (Object)this.rowJson.size(), (Object)this.currEntityId);
        if (this.currentRow != null && this.rowJson.size() != 0) {
            this.preEntityId = this.currEntityId;
            int currRowNum = this.currentRow.getRowNum();
            ImportBillData lastBillData = this.constructBillData(currRowNum + 1);
            this.addBillData(lastBillData, true);
            this.rowJson = new JSONObject();
        }
        boolean isEndFlag = MultiSheetHelper.handSheetNames(this.getSheetNames(), this.getSheetName());
        this.setInterrupt(isEndFlag);
        if (this.currentRow != null && Objects.nonNull(this.getSheetName()) && !this.getSheetName().contains("DDM_")) {
            int currRowNum = this.currentRow.getRowNum();
            this.importContext.setResolveComplete(this.url);
            ImportLogger logger = this.importContext.getLogger(this.url);
            logger.setRowIndex(currRowNum - this.completeEmptyRowNum);
            logger.setLastRowIndex(currRowNum + 1 - this.completeEmptyRowNum);
            this.importContext.feedbackProgress(0, logger, null);
            LOG.info("BatchImportSheetHandler-endDocument() LogId:{},currRowNum:{},sheetName:{},completeEmptyRowNum:{}", new Object[]{this.importContext.getLogId(), currRowNum, this.getSheetName(), this.completeEmptyRowNum});
            this.completeEmptyRowNum = 0;
        }
    }
}

