/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.config.client.util.StringUtils;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.formplugin.web.imp.BaseDataElement;
import kd.hr.hbp.formplugin.web.imp.BatchImportFailedSheetHandler;
import kd.hr.hbp.formplugin.web.imp.BatchImportSheetHandler;
import kd.hr.hbp.formplugin.web.imp.EntityRowData;
import kd.hr.hbp.formplugin.web.imp.ImportEntity;

public class HRBatchImportPlugin
extends BatchImportPlugin {
    public static final String OPKEY_SAVE = "save";
    public static final String VARIABLE_VALUE = "import";
    private boolean isBacthFecthData = true;
    private HashSet<String> excludeEntityIdSet = Sets.newHashSet();
    private Map<String, String> keyfieldsMap = Maps.newHashMap();
    private Map<String, Set<String>> entitySelectPropes = Maps.newHashMap();
    protected static final Log log = LogFactory.getLog(HRBatchImportPlugin.class);
    public static final String IMPORT_NEW_TYPE = "new";
    public static final String IMPORT_OVERRIDE_TYPE = "override";
    public static final String IMPORT_OVERRIDENEW_TYPE = "overridenew";
    public static final String IMPORT_TYPE = "importtype";
    private ImportContext conf;
    private DynamicObject currUser;
    private Map<String, List<EntityRowData>> entityQueenDataMap = Maps.newHashMap();
    private List<ImportEntity> entitiesList = Lists.newArrayList();
    private Map<String, List<Map<String, JSONObject>>> basedataRefKeyValuesMap = Maps.newHashMap();
    private Map<String, Map<String, String>> basedataRefFkMap = Maps.newHashMap();
    private Map<String, List<DynamicObject>> checkPassObjsMap = Maps.newHashMap();
    private Map<String, Map<String, List<DynamicObject>>> localCacheBasedataRefMap = Maps.newHashMap();
    private Map<String, List<JSONObject>> checkSuccessRowsFidMap = Maps.newHashMap();
    private int batchQueryNum = 500;

    public HashSet<String> addExcludeEntityIds() {
        return this.excludeEntityIdSet;
    }

    public Map<String, String> updateRowdataByFileds() {
        return this.keyfieldsMap;
    }

    public void afterCreateDynamicObjectProcess(String entityId, DynamicObject dynamicObject, EntityRowData rowData, ImportLogger importLogger) {
    }

    public boolean configFecthQueenDataMode() {
        return true;
    }

    private void initImportMainEntityType(ImportContext conf) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)conf.getBillFormId());
        List joinEntities = null;
        String parentEntityName = null;
        ImportEntity mainEntity = new ImportEntity();
        if (mainType instanceof QueryEntityType) {
            joinEntities = ((QueryEntityType)mainType).getJoinEntitys();
            parentEntityName = ((QueryEntityType)mainType).getEntityName();
            mainEntity.setMainEntity(true);
            mainEntity.setEntityName(parentEntityName);
            this.entitiesList.add(mainEntity);
        } else {
            parentEntityName = mainType.getName();
            mainEntity.setMainEntity(true);
            mainEntity.setEntityName(parentEntityName);
            this.entitiesList.add(mainEntity);
        }
        if (joinEntities != null && joinEntities.size() > 0) {
            int size = joinEntities.size();
            for (int i = 0; i < size; ++i) {
                MainEntityType subType = MetadataServiceHelper.getDataEntityType((String)((JoinEntity)joinEntities.get(i)).getEntityName());
                ImportEntity subentity = new ImportEntity();
                subentity.setMainEntity(false);
                subentity.setEntityRelationId(parentEntityName);
                subentity.setFkProperty(((JoinEntity)joinEntities.get(i)).getFKProperty());
                subentity.setProperty(((JoinEntity)joinEntities.get(i)).getProperty());
                subentity.setBaseRef(subentity.getFkProperty().equals(subentity.getProperty()));
                subentity.setEntityName(subType.getName());
                this.entitiesList.add(subentity);
            }
        }
    }

    public final void init() {
        this.initImportMainEntityType(this.conf);
        this.excludeEntityIdSet = this.addExcludeEntityIds();
        this.keyfieldsMap = this.updateRowdataByFileds();
        this.isBacthFecthData = this.configFecthQueenDataMode();
        this.entitySelectPropes = this.selectEntityProps();
        this.batchQueryNum = this.configBatchQueryNum();
    }

    public int configBatchQueryNum() {
        return this.batchQueryNum;
    }

    public Map<String, Set<String>> selectEntityProps() {
        return this.entitySelectPropes;
    }

    public final void resolve() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader excelReader = new ExcelReader();
        for (String url : this.conf.getAllUrls()) {
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    excelReader.read(in, (SheetHandler)new BatchImportSheetHandler(this.entitiesList, this.conf, url));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof KDBizException) {
                    this.conf.getLogger(url).log(Integer.valueOf(0), cause.getMessage());
                } else {
                    this.conf.getLogger(url).log(Integer.valueOf(3), ImportLogger.formatException((Throwable)e));
                }
                log.error((Throwable)e);
                JSONObject json = new JSONObject();
                json.put("errCode", (Object)e.getMessage());
                this.conf.getDataQueue(url).add(new ImportBillData(json, 0, 0));
                this.ctx.setResolveComplete(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importData(ImportContext conf) {
        HashMap<String, Object> retdata;
        try {
            for (String url : conf.getAllUrls()) {
                LinkedBlockingQueue dataQ = conf.getDataQueue(url);
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = conf.getLogger(url);
                importLogger.setDelRows(delRows);
                if (this.isBacthFecthData) {
                    this.fecthBacthQueenData(conf, url, dataQ, importLogger);
                    continue;
                }
                this.fecthAllQueenData(conf, url, dataQ, importLogger);
            }
            retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
        }
        catch (Exception e) {
            HashMap<String, Object> retdata2;
            try {
                log.error((Throwable)e);
                retdata2 = new HashMap<String, Object>();
                retdata2.put("complete", Boolean.TRUE);
            }
            catch (Throwable throwable) {
                HashMap<String, Object> retdata3 = new HashMap<String, Object>();
                retdata3.put("complete", Boolean.TRUE);
                retdata3.put("info", this.ctx.getUrlLoggers());
                int total = 0;
                int failed = 0;
                for (String url : this.ctx.getAllUrls()) {
                    ImportLogger logger = this.ctx.getLogger(url);
                    total += logger.getTotal();
                    failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
                    if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
                    this.outputFailedData(url, logger);
                }
                ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata3), (int)total, (int)failed);
                this.ctx.feedbackProgress(100, null, null);
                throw throwable;
            }
            retdata2.put("info", this.ctx.getUrlLoggers());
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                ImportLogger logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
                if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
                this.outputFailedData(url, logger);
            }
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata2), (int)total, (int)failed);
            this.ctx.feedbackProgress(100, null, null);
        }
        retdata.put("info", this.ctx.getUrlLoggers());
        int total = 0;
        int failed = 0;
        for (String url : this.ctx.getAllUrls()) {
            ImportLogger logger = this.ctx.getLogger(url);
            total += logger.getTotal();
            failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
            if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
            this.outputFailedData(url, logger);
        }
        ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
        this.ctx.feedbackProgress(100, null, null);
    }

    private void fecthAllQueenData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ, ImportLogger importLogger) throws Exception {
        int timeout = 0;
        ArrayList<ImportBillData> allRowdatas = new ArrayList<ImportBillData>();
        while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 500)) {
            ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>();
            int lastLeftCount = rowdatas.size();
            int needCount = 5000 - lastLeftCount;
            if (rowdatas.isEmpty() && needCount > 0) {
                ImportBillData rowdata = dataQ.poll(2L, TimeUnit.SECONDS);
                if (rowdata == null || rowdata.isEmpty()) {
                    if (rowdatas.isEmpty()) {
                        log.info(conf.getBillFormId() + "...read...null");
                        ++timeout;
                        continue;
                    }
                } else {
                    rowdatas.add(rowdata);
                    dataQ.drainTo(rowdatas, needCount);
                    rowdatas.removeIf(ImportBillData::isEmpty);
                    allRowdatas.addAll(rowdatas);
                }
            }
            timeout = 0;
        }
        boolean importResultFlag = true;
        if (allRowdatas.size() > 0 && conf.isResolveComplete(url)) {
            importResultFlag = this.importBatchData(allRowdatas, importLogger, conf.getOption());
        }
        if (importResultFlag) {
            this.feedbackProgressDealWith(conf, importLogger, allRowdatas);
            allRowdatas.clear();
        }
    }

    private void fecthBacthQueenData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ, ImportLogger importLogger) throws Exception {
        int timeout = 0;
        while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 5)) {
            ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>();
            int lastLeftCount = rowdatas.size();
            int needCount = 500 - lastLeftCount;
            if (rowdatas.isEmpty() && needCount > 0) {
                ImportBillData rowdata = dataQ.poll(1L, TimeUnit.MINUTES);
                if (rowdata == null || rowdata.isEmpty()) {
                    if (rowdatas.isEmpty()) {
                        log.info(conf.getBillFormId() + "...read...null");
                        ++timeout;
                        continue;
                    }
                } else {
                    rowdatas.add(rowdata);
                    dataQ.drainTo(rowdatas, needCount);
                    rowdatas.removeIf(ImportBillData::isEmpty);
                }
            }
            timeout = 0;
            boolean importResultFlag = true;
            if (rowdatas.size() > 0) {
                importResultFlag = this.importBatchData(rowdatas, importLogger, conf.getOption());
            }
            if (!importResultFlag) continue;
            this.feedbackProgressDealWith(conf, importLogger, rowdatas);
            rowdatas.clear();
        }
    }

    private void feedbackProgressDealWith(ImportContext conf, ImportLogger importLogger, List<ImportBillData> rowdatas) {
        importLogger.getLogCache().remove(-1);
        int faileNum = importLogger.getLogCache().size();
        importLogger.setFailed(faileNum);
        importLogger.setTotal(importLogger.getFailed() + importLogger.getDelRows().size());
        int lastEndIndex = rowdatas.get(rowdatas.size() - 1).getEndIndex();
        conf.feedbackProgress(Math.min(99, lastEndIndex * 100 / importLogger.getLastRowIndex()), importLogger, null);
        log.info(String.format("----import %s --batch--succeed=%d--failed=%d", importLogger.getSrcFile(), importLogger.getDelRows().size(), importLogger.getFailed()));
    }

    private void feedbackProgressError(ImportContext conf, ImportLogger importLogger, List<ImportBillData> rowdatas) {
        for (ImportBillData bill : rowdatas) {
            Integer rownum = bill.getStartIndex();
            importLogger.log(rownum, ResManager.loadKDString((String)"\u6a21\u677f\u6570\u636e\u6821\u9a8c\u5f02\u5e38", (String)"HRBatchImportPlugin_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        int failedNum = importLogger.getLogCache().size();
        int total = failedNum + importLogger.getDelRows().size();
        importLogger.setFailed(failedNum);
        importLogger.setTotal(total);
        int lastEndIndex = rowdatas.get(rowdatas.size() - 1).getEndIndex();
        conf.feedbackProgress(Math.min(99, lastEndIndex * 100 / importLogger.getLastRowIndex()), importLogger, null);
        log.info(String.format("----import %s --batch--succeed=%d--failed=%d", importLogger.getSrcFile(), importLogger.getDelRows().size(), importLogger.getFailed()));
    }

    private boolean importBatchData(List<ImportBillData> rowdatas, ImportLogger importLogger, Map<String, Object> option) throws Exception {
        try {
            if (rowdatas.get(0).getData().containsKey((Object)"errCode")) {
                throw new Exception((String)rowdatas.get(0).getData().get((Object)"errCode"));
            }
            String optionCode = (String)option.get(IMPORT_TYPE);
            this.wrapOriginalJson(rowdatas, importLogger, optionCode);
            switch (optionCode) {
                case "new": {
                    this.addBatchQueenData(rowdatas, importLogger, optionCode);
                    break;
                }
                case "override": {
                    this.updateBatchQueenData(rowdatas, importLogger, optionCode);
                    break;
                }
                case "overridenew": {
                    this.addOrUpdateBatchQueenData(rowdatas, importLogger, optionCode);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.feedbackProgressError(this.conf, importLogger, rowdatas);
            log.error((Throwable)e);
            return false;
        }
        return true;
    }

    protected void wrapOriginalJson(List<ImportBillData> rowdatas, ImportLogger importLogger, String optionCode) {
    }

    private void updateBatchQueenData(List<ImportBillData> rowdatas, ImportLogger importLogger, String optionCode) throws Exception {
        this.resolveRowData(rowdatas, importLogger, optionCode);
        this.queryBatchExistsRowDynamicObj(importLogger);
        this.updateRowDynamicObjValues(importLogger);
        this.queryBaseDataRef(importLogger);
        this.setDynamicObjValues(importLogger, optionCode);
        this.extendProcessRowData(importLogger, optionCode, this.entityQueenDataMap);
        this.removeCheckErrorDynamicObjs(importLogger);
        this.callOpSave(importLogger);
    }

    private void updateRowDynamicObjValues(ImportLogger importLogger) {
        for (Map.Entry<String, List<EntityRowData>> entityId : this.entityQueenDataMap.entrySet()) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId.getKey());
            for (EntityRowData rowdata : entityId.getValue()) {
                DynamicObject mainDbj = rowdata.getRowDynamicObject().get(entityId.getKey());
                if (Objects.isNull(mainDbj)) continue;
                Long pkId = mainDbj.getLong("id");
                for (IDataEntityProperty prop : mainEntityType.getProperties()) {
                    this.initDynamicObjValues(entityId.getKey(), mainDbj, prop, rowdata, importLogger, rowdata.getEntityJson(), pkId, false, rowdata.getOptionCode());
                }
                this.afterCreateDynamicObjectProcess(entityId.getKey(), mainDbj, rowdata, importLogger);
            }
        }
    }

    private void queryBatchExistsRowDynamicObj(ImportLogger importLogger) {
        for (Map.Entry<String, List<EntityRowData>> entityId : this.entityQueenDataMap.entrySet()) {
            List<List<EntityRowData>> batchRowDataList = this.splitRowDataListByNum(entityId.getValue(), this.batchQueryNum);
            for (List<EntityRowData> rowdataList : batchRowDataList) {
                List<DynamicObject> batchDyobjList = this.queryBathDynamicObjsByNum(entityId.getKey(), rowdataList);
                for (EntityRowData row : rowdataList) {
                    List<String> keys = row.getKeyfields();
                    Optional<DynamicObject> targetDyObj = batchDyobjList.stream().filter(e -> this.condictionFilter(row, keys, (DynamicObject)e)).findAny();
                    if (targetDyObj.isPresent()) {
                        DynamicObject source = targetDyObj.get();
                        DynamicObject target = new DynamicObject(source.getDynamicObjectType(), source.getPkValue());
                        HRDynamicObjectUtils.copy((DynamicObject)source, (DynamicObject)target);
                        target.set("id", source.getPkValue());
                        this.validateExistDynamicObject(target, entityId.getKey(), row, importLogger);
                        row.getRowDynamicObject().put(entityId.getKey(), target);
                        row.setOptionCode(IMPORT_OVERRIDE_TYPE);
                        continue;
                    }
                    if (this.logUpdateExistsEntityErrorMsg(entityId.getKey(), row.getEntityJson(), row.getExcelLineIndex(), keys, importLogger)) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e0d\u5b58\u5728:%s", (String)"HRBatchImportPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), row.getKeyfields());
                    importLogger.log(row.getExcelLineIndex(), msg);
                }
            }
        }
        for (Map.Entry<String, List<EntityRowData>> entry : this.entityQueenDataMap.entrySet()) {
            this.entityQueenDataMap.get(entry.getKey()).removeIf(data -> Objects.isNull(data.getRowDynamicObject().get(entry.getKey())));
        }
    }

    protected boolean logUpdateExistsEntityErrorMsg(String entityId, Map<String, Object> entityJson, Integer excelLineIndex, List<String> keys, ImportLogger importLogger) {
        return false;
    }

    private void outputFailedData(String url, ImportLogger logger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            new ExcelReader().read(service.getInputStream(url), (SheetHandler)new BatchImportFailedSheetHandler(this.ctx, logger, service));
        }
        catch (Throwable e) {
            logger.log(Integer.valueOf(0), e);
        }
    }

    private void addOrUpdateBatchQueenData(List<ImportBillData> rowdatas, ImportLogger importLogger, String optionCode) throws Exception {
        this.resolveRowData(rowdatas, importLogger, optionCode);
        this.queryOrCreateBatchRowDynamicObj(importLogger);
        this.updateRowDynamicObjValues(importLogger);
        this.queryBaseDataRef(importLogger);
        this.setDynamicObjValues(importLogger, optionCode);
        this.extendProcessRowData(importLogger, optionCode, this.entityQueenDataMap);
        this.removeCheckErrorDynamicObjs(importLogger);
        this.callOpSave(importLogger);
    }

    protected void extendProcessRowData(ImportLogger importLogger, String optionCode, Map<String, List<EntityRowData>> entityQueenDataMap) {
    }

    private List<List<EntityRowData>> splitRowDataListByNum(List<EntityRowData> entityRowdataList, int batchNum) {
        if (entityRowdataList == null || entityRowdataList.size() == 0 || batchNum < 1) {
            return null;
        }
        ArrayList<List<EntityRowData>> resultList = new ArrayList<List<EntityRowData>>();
        int size = entityRowdataList.size();
        for (int i = 0; i < size; ++i) {
            if (i % batchNum != 0) continue;
            long count = i / batchNum;
            List subList = entityRowdataList.stream().limit((count + 1L) * (long)batchNum).skip(count * (long)batchNum).collect(Collectors.toList());
            resultList.add(subList);
        }
        return resultList;
    }

    private void queryOrCreateBatchRowDynamicObj(ImportLogger importLogger) {
        for (Map.Entry<String, List<EntityRowData>> entityId : this.entityQueenDataMap.entrySet()) {
            this.handleBatchDynamicObjs(entityId.getKey(), entityId.getValue(), importLogger);
        }
    }

    private boolean condictionFilter(EntityRowData rowdata, List<String> keys, DynamicObject dynamicObject) {
        int size = keys.size();
        if (size == 1) {
            String key = keys.get(0);
            String value = (String)rowdata.getEntityJson().get(key);
            String dynamicObjValue = dynamicObject.getString(key);
            return StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)dynamicObjValue) && value.equals(dynamicObjValue);
        }
        if (size == 2) {
            String keyOne = keys.get(0);
            String keyTwo = keys.get(1);
            String valueOne = (String)rowdata.getEntityJson().get(keyOne);
            String valueTwo = (String)rowdata.getEntityJson().get(keyTwo);
            String dynamicObjValueOne = dynamicObject.getString(keyOne);
            String dynamicObjValueTwo = dynamicObject.getString(keyTwo);
            return StringUtils.isNotEmpty((String)valueOne) && StringUtils.isNotEmpty((String)valueTwo) && StringUtils.isNotEmpty((String)dynamicObjValueOne) && StringUtils.isNotEmpty((String)dynamicObjValueTwo) && valueOne.equals(dynamicObjValueOne) && valueTwo.equals(dynamicObjValueTwo);
        }
        if (size == 3) {
            String keyOne = keys.get(0);
            String keyTwo = keys.get(1);
            String keyThree = keys.get(2);
            String valueOne = (String)rowdata.getEntityJson().get(keyOne);
            String valueTwo = (String)rowdata.getEntityJson().get(keyTwo);
            String valueThree = (String)rowdata.getEntityJson().get(keyThree);
            String dynamicObjValueOne = dynamicObject.getString(keyOne);
            String dynamicObjValueTwo = dynamicObject.getString(keyTwo);
            String dynamicObjValueThree = dynamicObject.getString(keyThree);
            return StringUtils.isNotEmpty((String)valueOne) && StringUtils.isNotEmpty((String)valueTwo) && StringUtils.isNotEmpty((String)valueThree) && StringUtils.isNotEmpty((String)dynamicObjValueOne) && StringUtils.isNotEmpty((String)dynamicObjValueTwo) && StringUtils.isNotEmpty((String)dynamicObjValueThree) && valueOne.equals(dynamicObjValueOne) && valueTwo.equals(dynamicObjValueTwo) && valueTwo.equals(dynamicObjValueThree);
        }
        if (size == 4) {
            String keyOne = keys.get(0);
            String keyTwo = keys.get(1);
            String keyThree = keys.get(2);
            String keyFour = keys.get(3);
            String valueOne = (String)rowdata.getEntityJson().get(keyOne);
            String valueTwo = (String)rowdata.getEntityJson().get(keyTwo);
            String valueThree = (String)rowdata.getEntityJson().get(keyThree);
            String valueFour = (String)rowdata.getEntityJson().get(keyFour);
            String dynamicObjValueOne = dynamicObject.getString(keyOne);
            String dynamicObjValueTwo = dynamicObject.getString(keyTwo);
            String dynamicObjValueThree = dynamicObject.getString(keyThree);
            String dynamicObjValueFour = dynamicObject.getString(keyFour);
            return StringUtils.isNotEmpty((String)valueOne) && StringUtils.isNotEmpty((String)valueTwo) && StringUtils.isNotEmpty((String)valueThree) && StringUtils.isNotEmpty((String)valueFour) && StringUtils.isNotEmpty((String)dynamicObjValueOne) && StringUtils.isNotEmpty((String)dynamicObjValueTwo) && StringUtils.isNotEmpty((String)dynamicObjValueThree) && valueOne.equals(dynamicObjValueOne) && valueTwo.equals(dynamicObjValueTwo) && valueTwo.equals(dynamicObjValueThree) && valueTwo.equals(dynamicObjValueFour);
        }
        return false;
    }

    private void handleBatchDynamicObjs(String entityId, List<EntityRowData> entityRowdataList, ImportLogger importLogger) {
        List<List<EntityRowData>> batchRowDataList = this.splitRowDataListByNum(entityRowdataList, this.batchQueryNum);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        for (List<EntityRowData> rowdataList : batchRowDataList) {
            List<DynamicObject> batchDyobjList = this.queryBathDynamicObjsByNum(entityId, rowdataList);
            this.handleDbRowData(entityId, importLogger, mainEntityType, rowdataList, batchDyobjList);
        }
    }

    private void handleDbRowData(String entityId, ImportLogger importLogger, MainEntityType mainEntityType, List<EntityRowData> rowdataList, List<DynamicObject> batchDyobjList) {
        if (CollectionUtils.isEmpty(rowdataList)) {
            return;
        }
        long[] longIds = DBServiceHelper.genLongIds((String)entityId, (int)rowdataList.size());
        int index = 0;
        for (EntityRowData row : rowdataList) {
            List<String> keys = row.getKeyfields();
            Optional<DynamicObject> targetDyObj = batchDyobjList.stream().filter(e -> this.condictionFilter(row, keys, (DynamicObject)e)).findAny();
            if (targetDyObj.isPresent()) {
                row.getRowDynamicObject().put(entityId, targetDyObj.get());
                row.setOptionCode(IMPORT_OVERRIDE_TYPE);
                this.validateExistDynamicObject(targetDyObj.get(), entityId, row, importLogger);
                continue;
            }
            DynamicObject mainDbj = (DynamicObject)mainEntityType.createInstance();
            Long pkId = longIds[index];
            mainDbj.set("id", (Object)pkId);
            row.getRowDynamicObject().put(entityId, mainDbj);
            row.setOptionCode(IMPORT_NEW_TYPE);
            ++index;
        }
    }

    private List<DynamicObject> queryBathDynamicObjsByNum(String entityId, List<EntityRowData> rowdataList) {
        HashMap sourceValueMap = Maps.newHashMap();
        for (EntityRowData entityRowData : rowdataList) {
            for (String key : entityRowData.getKeyfields()) {
                if (null == sourceValueMap.get(key)) {
                    sourceValueMap.put(key, Lists.newArrayList());
                }
                ((List)sourceValueMap.get(key)).add(entityRowData.getEntityJson().get(key));
            }
        }
        QFilter batchQFilter = null;
        for (Map.Entry entry : sourceValueMap.entrySet()) {
            if (batchQFilter == null) {
                batchQFilter = new QFilter((String)entry.getKey(), "in", entry.getValue());
                continue;
            }
            batchQFilter.and(new QFilter((String)entry.getKey(), "in", entry.getValue()));
        }
        Object var5_7 = null;
        Object var6_13 = null;
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)entityId, (String)"id", (QFilter[])new QFilter[]{batchQFilter});
        Object[] pks = new Long[dynamicObjectArray.length];
        int i = 0;
        for (DynamicObject dy : dynamicObjectArray) {
            pks[i] = dy.getLong("id");
            ++i;
        }
        Object var5_9 = null;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        Object[] load = BusinessDataReader.load((Object[])pks, (DynamicObjectType)mainEntityType, (Boolean)Boolean.TRUE);
        pks = null;
        ArrayList arrayList = Lists.newArrayList((Object[])load);
        return arrayList;
    }

    private void addBatchQueenData(List<ImportBillData> rowdatas, ImportLogger importLogger, String optionCode) throws Exception {
        this.resolveRowData(rowdatas, importLogger, optionCode);
        this.convertExcelRowDataToDynamicObjs(importLogger, optionCode);
        this.queryBaseDataRef(importLogger);
        this.setDynamicObjValues(importLogger, optionCode);
        this.extendProcessRowData(importLogger, optionCode, this.entityQueenDataMap);
        this.removeCheckErrorDynamicObjs(importLogger);
        this.callOpSave(importLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOpSave(ImportLogger importLogger) {
        TXHandle txHandle = TX.required();
        OperationResult localOperationResult = new OperationResult();
        ArrayList pkList = Lists.newArrayList();
        HashMap opResult = Maps.newHashMap();
        try {
            OperationServiceImpl opImpl = new OperationServiceImpl();
            for (Map.Entry<String, List<DynamicObject>> entityId : this.checkPassObjsMap.entrySet()) {
                DynamicObject[] multiEntityDyobjRelArray = (DynamicObject[])entityId.getValue().stream().toArray(DynamicObject[]::new);
                if (multiEntityDyobjRelArray.length == 0) continue;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(VARIABLE_VALUE, "1");
                OperationResult operationResult = opImpl.localInvokeOperation(OPKEY_SAVE, multiEntityDyobjRelArray, operateOption);
                if (Objects.isNull(opResult.get(entityId.getKey()))) {
                    ArrayList opList = Lists.newArrayList();
                    opResult.put(entityId.getKey(), opList);
                }
                if (!operationResult.isSuccess()) {
                    ((List)opResult.get(entityId.getKey())).add(operationResult);
                }
                pkList.addAll(operationResult.getSuccessPkIds());
            }
            this.logOpFaileInfo(opResult, importLogger);
            this.logOpSuccessInfo(pkList, importLogger);
        }
        catch (Exception e) {
            this.logOpFaileInfo(e.getMessage(), importLogger);
            localOperationResult.setSuccess(false);
        }
        finally {
            if (!localOperationResult.isSuccess()) {
                txHandle.markRollback();
            }
            txHandle.close();
            this.checkPassObjsMap.clear();
        }
    }

    private void logOpFaileInfo(String message, ImportLogger importLogger) {
        this.checkSuccessRowsFidMap.forEach((k, v) -> v.forEach(e -> importLogger.log(e.getInteger("rownum"), ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4fdd\u5b58\u6570\u636e\u5f02\u5e38\u3002", (String)"HRBatchImportPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]))));
    }

    private void logOpSuccessInfo(List<Object> pkList, ImportLogger importLogger) {
        if (CollectionUtil.isNotEmpty(pkList)) {
            int size = pkList.size();
            for (int i = 0; i < size; ++i) {
                long pkid = (Long)pkList.get(i);
                this.checkSuccessRowsFidMap.forEach((k, v) -> {
                    Optional<JSONObject> successRow = v.stream().filter(e -> e.getLong("pkid") == pkid).findAny();
                    if (successRow.isPresent()) {
                        JSONObject row = successRow.get();
                        int startindex = row.getInteger("startindex");
                        int endindex = row.getInteger("endindex");
                        long count = importLogger.getDelRows().stream().filter(e -> e[0] == startindex && e[1] == endindex).count();
                        if (count == 0L) {
                            importLogger.getDelRows().add(new int[]{endindex, endindex});
                        }
                    }
                });
            }
        }
    }

    private void logOpFaileInfo(Map<String, List<OperationResult>> opResult, ImportLogger importLogger) {
        Integer errorRowInteger = null;
        for (Map.Entry<String, List<OperationResult>> entityId : opResult.entrySet()) {
            int size = entityId.getValue().size();
            for (int i = 0; i < size; ++i) {
                OperationResult op = entityId.getValue().get(i);
                List operateInfos = op.getAllErrorOrValidateInfo();
                for (IOperateInfo info : operateInfos) {
                    String pkId = String.valueOf(info.getPkValue());
                    Optional<JSONObject> errorRow = this.checkSuccessRowsFidMap.get(entityId.getKey()).stream().filter(e -> e.getString("pkid").equals(pkId)).findAny();
                    errorRowInteger = errorRow.isPresent() ? errorRow.get().getInteger("rownum") : -1;
                    importLogger.log(errorRowInteger, String.join((CharSequence)",", info.getMessage()));
                }
            }
        }
    }

    private void removeCheckErrorDynamicObjs(ImportLogger importLogger) {
        Set checkFaileRows = importLogger.getLogCache().keySet();
        importLogger.setFailed(importLogger.getFailed() + checkFaileRows.size());
        importLogger.setTotal(importLogger.getFailed() + importLogger.getDelRows().size());
        for (Map.Entry<String, List<EntityRowData>> entry : this.entityQueenDataMap.entrySet()) {
            if (Objects.isNull(this.checkPassObjsMap.get(entry.getKey()))) {
                ArrayList lst = Lists.newArrayList();
                this.checkPassObjsMap.put(entry.getKey(), lst);
            }
            entry.getValue().forEach(e -> {
                DynamicObject obj;
                if (!checkFaileRows.contains(e.getExcelLineIndex()) && Objects.nonNull(obj = e.getRowDynamicObject().get(entry.getKey()))) {
                    this.checkPassObjsMap.get(entry.getKey()).add(obj);
                    if (null == this.checkSuccessRowsFidMap.get(entry.getKey())) {
                        ArrayList fidList = Lists.newArrayList();
                        this.checkSuccessRowsFidMap.put((String)entry.getKey(), fidList);
                    }
                    JSONObject json = new JSONObject();
                    json.put("rownum", (Object)e.getExcelLineIndex());
                    json.put("pkid", obj.getPkValue());
                    json.put("startindex", (Object)e.getStartIndex());
                    json.put("endindex", (Object)e.getEndIndex());
                    this.checkSuccessRowsFidMap.get(entry.getKey()).add(json);
                }
            });
        }
        this.entityQueenDataMap.clear();
    }

    protected void validateExistDynamicObject(DynamicObject rowDynamicObject, String entityId, EntityRowData rowData, ImportLogger importLogger) {
    }

    private void setDynamicObjValues(ImportLogger importLogger, String optionCode) {
        Object dynamicObjectList = null;
        for (Map.Entry<String, List<EntityRowData>> entryRowData : this.entityQueenDataMap.entrySet()) {
            Map<String, List<DynamicObject>> entityBaseData = this.localCacheBasedataRefMap.get(entryRowData.getKey());
            List<EntityRowData> rowDataList = entryRowData.getValue();
            for (EntityRowData rowData : rowDataList) {
                this.setRowData(importLogger, optionCode, entryRowData, entityBaseData, rowData);
            }
        }
    }

    private void setRowData(ImportLogger importLogger, String optionCode, Map.Entry<String, List<EntityRowData>> entryRowData, Map<String, List<DynamicObject>> entityBaseData, EntityRowData rowData) {
        ImportEntity importEntity = rowData.getImportEntity();
        DynamicObject rowDynamicObject = rowData.getRowDynamicObject().get(entryRowData.getKey());
        for (BaseDataElement e : rowData.getBasedataList()) {
            List<DynamicObject> dynamicObjectList = entityBaseData.get(e.getMapKey());
            if ((Objects.isNull(dynamicObjectList) || dynamicObjectList.size() == 0) && !this.logErrorMsg(dynamicObjectList, entryRowData.getKey(), importLogger, e.getFiledName(), e.getValue(), e.getKey(), rowData.getExcelLineIndex())) {
                importLogger.log(rowData.getExcelLineIndex(), String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5173\u8054\u5f15\u7528\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728{%s}:", (String)"HRBatchImportPlugin_28", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), e.getFiledName()));
            }
            if (Objects.isNull(dynamicObjectList) || dynamicObjectList.size() == 0) {
                rowDynamicObject.set(e.getFiledName(), null);
                continue;
            }
            rowDynamicObject.set(e.getFiledName(), (Object)dynamicObjectList.get(0));
        }
        List<DynamicObject> rowDynamicObjectList = this.findRowDynamicObjectList(rowData.getExcelLineIndex());
        this.validateDynamicObject(rowDynamicObjectList, entryRowData.getKey(), rowData.getExcelLineIndex(), importLogger, optionCode, rowData);
        this.setDynamicObjectValuesAfterPropsFilled(rowDynamicObjectList, rowData.getExcelLineIndex(), importLogger, optionCode, rowData);
        if (IMPORT_NEW_TYPE.equals(optionCode) && !this.customBindEntityRelations(rowDynamicObject, importEntity, rowData, importLogger)) {
            this.bindEntityRelations(rowDynamicObject, importEntity, rowData, importLogger);
        }
    }

    protected boolean logErrorMsg(List<DynamicObject> dynamicObjectList, String entityId, ImportLogger importLogger, String filed, String value, String key, Integer rowNum) {
        return false;
    }

    public void setDynamicObjectValuesAfterPropsFilled(List<DynamicObject> rowDynamicObjectList, Integer excelLineIndex, ImportLogger importLogger, String optionCode, EntityRowData rowData) {
    }

    protected void validateDynamicObject(List<DynamicObject> rowDynamicObjectList, String entityId, Integer row, ImportLogger importLogger, String optionCode, EntityRowData rowData) {
    }

    private List<DynamicObject> findRowDynamicObjectList(Integer row) {
        ArrayList rowDynamicObjects = Lists.newArrayList();
        this.entityQueenDataMap.forEach((k, v) -> {
            Optional<EntityRowData> rowdyobj;
            if ((Objects.nonNull(v) || v.size() > 0) && (rowdyobj = v.stream().filter(e -> e.getExcelLineIndex().equals(row)).findAny()).isPresent()) {
                rowDynamicObjects.add(rowdyobj.get().getRowDynamicObject().get(k));
                return;
            }
        });
        return rowDynamicObjects;
    }

    private DynamicObject getLocalBaseDataRef(EntityRowData rowData) {
        DynamicObject obj = null;
        block0: for (Map.Entry<String, Map<String, List<DynamicObject>>> entityId : this.localCacheBasedataRefMap.entrySet()) {
            for (String key : entityId.getValue().keySet()) {
                if (!key.equals(rowData.getBasedataMapKey())) continue;
                obj = entityId.getValue().get(key).get(0);
                continue block0;
            }
        }
        return obj;
    }

    private DynamicObject getRelationMainDynamiObj(EntityRowData rowData, String entityRelationName) {
        Optional<EntityRowData> mainObjOpt = this.entityQueenDataMap.get(entityRelationName).stream().filter(e -> e.getExcelLineIndex().equals(rowData.getExcelLineIndex())).findAny();
        if (!mainObjOpt.isPresent()) {
            return null;
        }
        return mainObjOpt.get().getRowDynamicObject().get(entityRelationName);
    }

    private void bindEntityRelations(DynamicObject rowDynamicObject, ImportEntity entity, EntityRowData rowData, ImportLogger importLogger) {
        if (!entity.isMainEntity()) {
            DynamicObject refObj = null;
            if (entity.isBaseRef()) {
                refObj = this.getLocalBaseDataRef(rowData);
                if (null == refObj) {
                    String msg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5173\u8054\u5f15\u7528\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728:%s", (String)"HRBatchImportPlugin_29", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), rowData.getBasedataMapKey());
                    importLogger.log(rowData.getExcelLineIndex(), msg);
                } else {
                    rowDynamicObject.set(entity.getFkProperty(), refObj.get("id"));
                }
            } else {
                refObj = rowDynamicObject;
            }
            DynamicObject mainObj = this.getRelationMainDynamiObj(rowData, entity.getEntityRelationId());
            if (null != mainObj) {
                if (refObj != null) {
                    mainObj.set(entity.getFkProperty(), refObj.get("id"));
                }
            } else {
                importLogger.log(rowData.getExcelLineIndex(), ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u5230\u4e3b\u5b9e\u4f53\u6570\u636e\u3002", (String)"HRBatchImportPlugin_30", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public boolean customBindEntityRelations(DynamicObject rowDynamicObject, ImportEntity importEntity, EntityRowData rowData, ImportLogger importLogger) {
        return false;
    }

    private void queryBaseDataRef(ImportLogger importLogger) {
        for (Map.Entry<String, List<Map<String, JSONObject>>> entityId : this.basedataRefKeyValuesMap.entrySet()) {
            if (Objects.isNull(this.localCacheBasedataRefMap.get(entityId.getKey()))) {
                HashMap entityBaseData = Maps.newHashMap();
                this.localCacheBasedataRefMap.put(entityId.getKey(), entityBaseData);
            }
            Object[] dyobjs = null;
            List<Map<String, JSONObject>> baseDataList = entityId.getValue();
            for (Map<String, JSONObject> basedataMap : baseDataList) {
                ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)basedataMap.size());
                String baseDataId = "";
                Integer execlRow = 0;
                StringBuilder baseMapKey = new StringBuilder();
                for (Map.Entry<String, JSONObject> entry : basedataMap.entrySet()) {
                    String key = entry.getValue().getString("importprop");
                    baseDataId = entry.getKey();
                    execlRow = entry.getValue().getInteger("row");
                    String val = entry.getValue().getString(key);
                    baseMapKey.append((CharSequence)baseMapKey);
                    baseMapKey.append(baseDataId);
                    baseMapKey.append(entry.getValue().getString("importprop"));
                    baseMapKey.append(entry.getValue().getString(entry.getValue().getString("importprop")));
                    QFilter qFilter = new QFilter(key, "=", (Object)val);
                    qFilters.add(qFilter);
                }
                if (this.localCacheBasedataRefMap.get(entityId.getKey()).containsKey(baseMapKey.toString())) continue;
                QFilter allQFilter = null;
                int size = qFilters.size();
                for (int i = 0; i < size; ++i) {
                    if (null == allQFilter) {
                        allQFilter = (QFilter)qFilters.get(i);
                        continue;
                    }
                    allQFilter.and((QFilter)qFilters.get(i));
                }
                Set<String> selectProps = this.getbasedataProps(this.basedataRefFkMap.get(entityId.getKey()).get(baseDataId));
                dyobjs = BusinessDataServiceHelper.load((String)this.basedataRefFkMap.get(entityId.getKey()).get(baseDataId), (String)String.join((CharSequence)",", selectProps), (QFilter[])new QFilter[]{allQFilter});
                ArrayList basedataList = Lists.newArrayList((Object[])dyobjs);
                if (!this.validateBaseDataRef(basedataList, entityId.getKey(), baseDataId, basedataMap, this.entityQueenDataMap, execlRow, importLogger) && (dyobjs == null || dyobjs.length == 0)) continue;
                this.localCacheBasedataRefMap.get(entityId.getKey()).put(baseMapKey.toString(), basedataList);
            }
        }
    }

    protected boolean validateBaseDataRef(List<DynamicObject> basedatas, String entityId, String baseDataId, Map<String, JSONObject> basedataValues, Map<String, List<EntityRowData>> entityQueenDataMap, Integer execlRow, ImportLogger importLogger) {
        return false;
    }

    private void convertExcelRowDataToDynamicObjs(ImportLogger importLogger, String optionCode) {
        for (Map.Entry<String, List<EntityRowData>> entityId : this.entityQueenDataMap.entrySet()) {
            List<EntityRowData> importRowDataList = entityId.getValue();
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId.getKey());
            this.convertRowData(importLogger, optionCode, entityId, importRowDataList, mainEntityType);
        }
    }

    private void convertRowData(ImportLogger importLogger, String optionCode, Map.Entry<String, List<EntityRowData>> entityId, List<EntityRowData> importRowDataList, MainEntityType mainEntityType) {
        DynamicObject mainDbj = null;
        if (CollectionUtils.isEmpty(importRowDataList)) {
            return;
        }
        long[] longIds = DBServiceHelper.genLongIds((String)entityId.getKey(), (int)importRowDataList.size());
        int index = 0;
        for (EntityRowData rowdata : importRowDataList) {
            mainDbj = (DynamicObject)mainEntityType.createInstance();
            rowdata.getRowDynamicObject().put(entityId.getKey(), mainDbj);
            long pkId = longIds[index];
            mainDbj.set("id", (Object)pkId);
            ++index;
            for (IDataEntityProperty prop : mainEntityType.getProperties()) {
                this.initDynamicObjValues(entityId.getKey(), mainDbj, prop, rowdata, importLogger, rowdata.getEntityJson(), pkId, false, optionCode);
            }
            this.afterCreateDynamicObjectProcess(entityId.getKey(), mainDbj, rowdata, importLogger);
        }
    }

    private void resolveRowData(List<ImportBillData> rowdatas, ImportLogger importLogger, String optionCode) throws Exception {
        for (ImportBillData bill : rowdatas) {
            Map rowdata = (Map)bill.getData().get((Object)"data");
            for (Map.Entry entityId : rowdata.entrySet()) {
                if (this.excludeEntityIdSet.contains(entityId.getKey())) continue;
                Map entityData = (Map)entityId.getValue();
                Integer rownum = Integer.valueOf(String.valueOf(entityData.get("rownum")));
                EntityRowData entityRowdata = new EntityRowData(rownum, bill.getStartIndex(), bill.getEndIndex());
                entityRowdata.setOptionCode(optionCode);
                Optional<ImportEntity> optEntity = this.entitiesList.stream().filter(e -> e.getEntityName().equals(entityId.getKey())).findFirst();
                if (!optEntity.isPresent()) {
                    importLogger.log(rownum, ResManager.loadKDString((String)"\u6a21\u677f\u6821\u9a8c\u5931\u8d25\uff1b", (String)"HRBatchImportPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    throw new Exception(ResManager.loadKDString((String)"\u6a21\u677f\u6821\u9a8c\u5931\u8d25\uff1b", (String)"HRBatchImportPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                }
                ImportEntity importEntity = optEntity.get();
                entityRowdata.setEntityJson(entityData);
                entityRowdata.setNeedRelation(optEntity.get().isBaseRef());
                entityRowdata.setFkProperty(optEntity.get().getFkProperty());
                entityRowdata.setImportEntity(optEntity.get());
                if (!IMPORT_NEW_TYPE.equals(optionCode)) {
                    this.validateKeyFields(entityRowdata, (String)entityId.getKey(), importLogger);
                }
                if (!importEntity.isMainEntity() && entityRowdata.isNeedRelation()) {
                    entityRowdata.setBasedataMapKey(this.getBasedataMapKey(entityRowdata));
                }
                if (!this.entityQueenDataMap.containsKey(entityId.getKey())) {
                    ArrayList entityRowDataList = Lists.newArrayList();
                    entityRowDataList.add(entityRowdata);
                    this.entityQueenDataMap.put((String)entityId.getKey(), entityRowDataList);
                    continue;
                }
                this.entityQueenDataMap.get(entityId.getKey()).add(entityRowdata);
            }
        }
    }

    private void validateKeyFields(EntityRowData entityRowdata, String entityId, ImportLogger importLogger) throws Exception {
        String keyfieldstr = this.keyfieldsMap.get(entityId);
        if (StringUtils.isEmpty((String)keyfieldstr)) {
            throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u672a\u6307\u5b9a\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c", (String)"HRBatchImportPlugin_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        for (String key : keyfieldstr.split(",")) {
            entityRowdata.getEntityJson().get(key);
            if (Objects.isNull(entityRowdata.getEntityJson().get(key))) {
                importLogger.log(entityRowdata.getExcelLineIndex(), ResManager.loadKDString((String)"\u6570\u636e\u66ff\u6362\u552f\u4e00\u503c\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HRBatchImportPlugin_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                continue;
            }
            entityRowdata.getKeyfields().add(key);
        }
    }

    private String getBasedataMapKey(EntityRowData entityRowdata) {
        StringBuilder sb = new StringBuilder();
        sb.append(entityRowdata.getFkProperty());
        Map fkprop = (Map)entityRowdata.getEntityJson().get(entityRowdata.getFkProperty());
        if (Objects.isNull(fkprop)) {
            return null;
        }
        return sb.append(fkprop.get("importprop")).append(fkprop.get(fkprop.get("importprop"))).toString();
    }

    public final void initDynamicObjValues(String entityId, DynamicObject dynamicObject, IDataEntityProperty prop, EntityRowData importRowData, ImportLogger importLogger, Map<String, Object> propdataMap, Long pkId, boolean isEntry, String operkey) {
        Object fieldValue = this.getPropValues(propdataMap, prop);
        String fieldKey = prop.getName();
        if (Objects.isNull(fieldValue)) {
            if (prop instanceof CreateDateProp || prop instanceof ModifyDateProp) {
                dynamicObject.set(fieldKey, (Object)new Date());
            } else if (prop instanceof CreaterProp || prop instanceof ModifierProp) {
                dynamicObject.set(fieldKey, this.getCurrUser(RequestContext.get().getUserId(), ((BasedataProp)prop).getBaseEntityId()));
            }
            return;
        }
        if (prop instanceof EntryProp) {
            JSONArray jSONArray = (JSONArray)fieldValue;
            DynamicObjectCollection entryCollcetion = dynamicObject.getDynamicObjectCollection(prop.getName());
            int size = jSONArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject dataMap = jSONArray.getJSONObject(i);
                DynamicObjectType entryType = null;
                DynamicObject entryItem = null;
                entryType = entryCollcetion.getDynamicObjectType();
                if (IMPORT_NEW_TYPE.equals(operkey)) {
                    entryItem = new DynamicObject(entryType);
                    entryCollcetion.add((Object)entryItem);
                } else if (IMPORT_OVERRIDE_TYPE.equals(operkey)) {
                    if (entryCollcetion.size() == 0) {
                        entryItem = new DynamicObject(entryType);
                        entryCollcetion.add((Object)entryItem);
                    } else {
                        entryItem = (DynamicObject)entryCollcetion.get(0);
                    }
                }
                for (IDataEntityProperty p : entryType.getProperties()) {
                    this.initDynamicObjValues(entityId, entryItem, p, importRowData, importLogger, (Map<String, Object>)dataMap, pkId, true, operkey);
                }
            }
        } else if (prop instanceof TextProp || prop instanceof LargeTextProp || prop instanceof VarcharProp || prop instanceof MuliLangTextProp || prop instanceof ComboProp) {
            dynamicObject.set(fieldKey, fieldValue);
        } else if (prop instanceof DecimalProp) {
            dynamicObject.set(fieldKey, (Object)new BigDecimal(String.valueOf(fieldValue)));
        } else if (prop instanceof DateProp) {
            this.parsePropData(fieldKey, fieldValue, dynamicObject, importLogger, importRowData.getExcelLineIndex());
        } else if (prop instanceof DateTimeProp) {
            this.parseTimePropData(fieldKey, fieldValue, dynamicObject, importLogger, importRowData.getExcelLineIndex());
        } else if (prop instanceof BooleanProp) {
            dynamicObject.set(fieldKey, fieldValue);
        } else if (prop instanceof BasedataProp) {
            if (isEntry) {
                JSONObject basedata = (JSONObject)propdataMap.get(fieldKey);
                this.initEntryBasedataPropData(entityId, fieldKey, prop, importRowData, dynamicObject, basedata, importLogger);
            } else {
                this.parseBasedataPropData(entityId, fieldKey, prop, importRowData);
            }
        }
    }

    private Object getPropValues(Map<String, Object> dataMap, IDataEntityProperty dp) {
        Object val = null;
        if (dp instanceof BasedataProp) {
            JSONObject basedata = (JSONObject)dataMap.get(dp.getName());
            if (Objects.isNull(basedata)) {
                return null;
            }
            val = basedata.getString(basedata.getString("importprop"));
        } else {
            val = dataMap.get(dp.getName());
        }
        return val;
    }

    private Object getCurrUser(String userId, String basedataEntityId) {
        if (this.currUser == null) {
            DynamicObject[] dyobjs = null;
            QFilter qFilter = new QFilter("id", "=", (Object)userId);
            Set<String> selectProps = this.getbasedataProps(basedataEntityId);
            dyobjs = BusinessDataServiceHelper.load((String)basedataEntityId, (String)String.join((CharSequence)",", selectProps), (QFilter[])new QFilter[]{qFilter});
            if (dyobjs == null) {
                return null;
            }
            this.currUser = dyobjs[0];
        }
        return this.currUser;
    }

    private Set<String> getbasedataProps(String basedataid) {
        Set<String> entitySelectPropesValue = this.entitySelectPropes.get(basedataid);
        if (!CollectionUtils.isEmpty(entitySelectPropesValue)) {
            return entitySelectPropesValue;
        }
        HashSet defSelectProps = Sets.newHashSet((Object[])"id,name,number,status,enable".split(","));
        return defSelectProps;
    }

    private void parsePropData(String fieldKey, Object fieldValue, DynamicObject dyobj, ImportLogger importLogger, Integer rowNum) {
        try {
            dyobj.set(fieldKey, (Object)HRDateTimeUtils.parseDate((String)String.valueOf(fieldValue)));
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef,", (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u65e0\u6548\u503c\u4e3a\uff1a%s", (String)"HRBatchImportPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), fieldValue);
            importLogger.log(rowNum, msg);
        }
    }

    private void parseTimePropData(String fieldKey, Object fieldValue, DynamicObject dyobj, ImportLogger importLogger, Integer rowNum) {
        try {
            dyobj.set(fieldKey, (Object)HRDateTimeUtils.parseDate((String)String.valueOf(fieldValue)));
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef,", (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u65e0\u6548\u503c\u4e3a\uff1a%s", (String)"HRBatchImportPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), fieldValue);
            importLogger.log(rowNum, msg);
        }
    }

    private void initEntryBasedataPropData(String entityId, String fieldKey, IDataEntityProperty prop, EntityRowData importRowData, DynamicObject dynamicObject, JSONObject basedata, ImportLogger importLogger) {
        String key = basedata.getString("importprop");
        String val = basedata.getString(key);
        QFilter qFilter = new QFilter(key, "=", (Object)val);
        String basedataEntityId = ((BasedataProp)prop).getBaseEntityId();
        Set<String> selectProps = this.getbasedataProps(basedataEntityId);
        Object[] dyobjs = null;
        dyobjs = BusinessDataServiceHelper.load((String)basedataEntityId, (String)String.join((CharSequence)",", selectProps), (QFilter[])new QFilter[]{qFilter});
        if (!this.logErrorMsg(Lists.newArrayList((Object[])dyobjs), entityId, importLogger, fieldKey, key, val, importRowData.getExcelLineIndex())) {
            String msg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e0d\u5b58\u5728:%s", (String)"HRBatchImportPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), fieldKey);
            if (dyobjs == null || dyobjs.length == 0) {
                importLogger.log(importRowData.getExcelLineIndex(), msg);
            }
            if (dyobjs != null && dyobjs.length > 1) {
                String msgField = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5b58\u5728\u591a\u4e2a\u503c:%s", (String)"HRBatchImportPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), fieldKey);
                importLogger.log(importRowData.getExcelLineIndex(), msgField);
            }
        }
        if (dyobjs != null && dyobjs.length > 0) {
            dynamicObject.set(fieldKey, dyobjs[0]);
        }
    }

    private void parseBasedataPropData(String entityId, String fieldKey, IDataEntityProperty dp, EntityRowData importRowData) {
        ArrayList baseList = this.basedataRefKeyValuesMap.get(entityId);
        HashMap entityBaseData = this.basedataRefFkMap.get(entityId);
        StringBuilder basedataKey = new StringBuilder();
        basedataKey.append(fieldKey);
        if (Objects.isNull(entityBaseData)) {
            entityBaseData = Maps.newHashMap();
            this.basedataRefFkMap.put(entityId, entityBaseData);
        }
        if (Objects.isNull(baseList)) {
            baseList = Lists.newArrayList();
            this.basedataRefKeyValuesMap.put(entityId, baseList);
        }
        String basedataEntityId = ((BasedataProp)dp).getBaseEntityId();
        if (!entityBaseData.containsKey(fieldKey)) {
            entityBaseData.put(fieldKey, basedataEntityId);
        }
        JSONObject basedata = (JSONObject)importRowData.getEntityJson().get(fieldKey);
        String val = basedata.getString(basedata.getString("importprop"));
        basedata.put("row", (Object)importRowData.getExcelLineIndex());
        basedataKey.append(basedata.getString("importprop"));
        basedataKey.append(val);
        HashMap keyMap = Maps.newHashMap();
        keyMap.put(fieldKey, basedata);
        BaseDataElement element = new BaseDataElement();
        element.setFiledName(fieldKey);
        element.setEntityId(entityId);
        element.setMapKey(basedataKey.toString());
        element.setValue(val);
        element.setKey(basedata.getString("importprop"));
        importRowData.getBasedataList().add(element);
        this.checkRepetElement(baseList, fieldKey, val, keyMap);
    }

    private void checkRepetElement(List<Map<String, JSONObject>> baseList, String fieldKey, String val, Map<String, JSONObject> basedata) {
        int size = (int)baseList.stream().filter(e -> e.containsKey(fieldKey)).filter(e -> {
            JSONObject jsonObject = (JSONObject)e.get(fieldKey);
            String otherVal = jsonObject.getString(jsonObject.getString("importprop"));
            return val.equals(otherVal);
        }).count();
        if (size == 0) {
            baseList.add(basedata);
        }
    }

    protected void resolveExcel() {
        if (this.conf == null) {
            this.conf = this.ctx;
        }
        this.init();
        this.resolve();
    }

    protected void importData() throws Throwable {
        this.importData(this.conf);
    }
}

