/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.BasedataContianer;
import kd.hr.hbp.formplugin.web.imp.BatchImportFailedSheetHandler;
import kd.hr.hbp.formplugin.web.imp.BatchImportSheetHandler;
import kd.hr.hbp.formplugin.web.imp.ImportEntity;
import kd.hr.hbp.formplugin.web.imp.InitQueryEntity;
import kd.hr.hbp.formplugin.web.imp.MultiEntityQueryConfig;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hbp.formplugin.web.imp.MultiImportHelper;

public class HRBatchMultiEntityImportPlugin
extends BatchImportPlugin {
    public static final String OPKEY_SAVE = "save";
    public static final String VARIABLE_VALUE = "import";
    private static final String ERR_CODE = "errCode";
    private boolean isBacthFecthData = false;
    private Set<String> excludeEntityIdSet = Sets.newHashSet();
    private Map<String, String> keyfieldsMap = Maps.newHashMap();
    private Map<String, Set<String>> entitySelectPropes = Maps.newHashMap();
    private static final Log LOG = LogFactory.getLog(HRBatchMultiEntityImportPlugin.class);
    private ImportContext conf;
    private DynamicObject currUser;
    private List<ImportEntity> entitiesList = Lists.newArrayList();
    private int batchQueryNum = 500;
    private MultiEntityQueryConfig queryConfig;
    private List<MultiEntityRowData> rowDataList = Lists.newArrayListWithExpectedSize((int)16);
    private BasedataContianer contianer;

    public Set<String> addExcludeEntityIds() {
        return this.excludeEntityIdSet;
    }

    public Map<String, String> updateRowdataByFileds() {
        return this.keyfieldsMap;
    }

    public void afterCreateDynamicObjectProcess(DynamicObject dynamicObject, MultiEntityRowData rowData, ImportLogger importLogger) {
    }

    public boolean configFecthQueenDataMode() {
        return true;
    }

    public final void init() {
        InitQueryEntity.initImportMainEntityType(this.conf, this.queryConfig, this.entitiesList, this.selectCustomMainEntityProps());
        this.excludeEntityIdSet = this.addExcludeEntityIds();
        this.keyfieldsMap = this.updateRowdataByFileds();
        this.isBacthFecthData = this.configFecthQueenDataMode();
        this.entitySelectPropes = this.selectEntityProps();
        this.batchQueryNum = this.configBatchQueryNum();
        this.contianer = new BasedataContianer();
    }

    public int configBatchQueryNum() {
        return this.batchQueryNum;
    }

    public Map<String, Set<String>> selectEntityProps() {
        return this.entitySelectPropes;
    }

    protected List<String> selectCustomMainEntityProps() {
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public final void resolve() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader excelReader = new ExcelReader();
        for (String url : this.conf.getAllUrls()) {
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    excelReader.read(in, (SheetHandler)new BatchImportSheetHandler(this.entitiesList, this.conf, url));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof KDBizException) {
                    this.conf.getLogger(url).log(Integer.valueOf(0), cause.getMessage());
                } else {
                    this.conf.getLogger(url).log(Integer.valueOf(3), ImportLogger.formatException((Throwable)e));
                }
                LOG.error((Throwable)e);
                JSONObject json = new JSONObject();
                json.put(ERR_CODE, (Object)e.getMessage());
                this.conf.getDataQueue(url).add(new ImportBillData(json, 0, 0));
                this.ctx.setResolveComplete(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importData(ImportContext conf) {
        HashMap<String, Object> retdata;
        try {
            for (String url : conf.getAllUrls()) {
                LinkedBlockingQueue dataQ = conf.getDataQueue(url);
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = conf.getLogger(url);
                importLogger.setDelRows(delRows);
                if (this.isBacthFecthData) {
                    this.fecthBacthQueenData(conf, url, dataQ, importLogger);
                    continue;
                }
                this.fecthAllQueenData(conf, url, dataQ, importLogger);
            }
            retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
        }
        catch (Exception e) {
            HashMap<String, Object> retdata2;
            try {
                LOG.error((Throwable)e);
                retdata2 = new HashMap<String, Object>();
                retdata2.put("complete", Boolean.TRUE);
            }
            catch (Throwable throwable) {
                HashMap<String, Object> retdata3 = new HashMap<String, Object>();
                retdata3.put("complete", Boolean.TRUE);
                retdata3.put("info", this.ctx.getUrlLoggers());
                int total = 0;
                int failed = 0;
                for (String url : this.ctx.getAllUrls()) {
                    ImportLogger logger = this.ctx.getLogger(url);
                    total += logger.getTotal();
                    failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
                    if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
                    this.outputFailedData(url, logger);
                }
                ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata3), (int)total, (int)failed);
                this.ctx.feedbackProgress(100, null, null);
                throw throwable;
            }
            retdata2.put("info", this.ctx.getUrlLoggers());
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                ImportLogger logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
                if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
                this.outputFailedData(url, logger);
            }
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata2), (int)total, (int)failed);
            this.ctx.feedbackProgress(100, null, null);
        }
        retdata.put("info", this.ctx.getUrlLoggers());
        int total = 0;
        int failed = 0;
        for (String url : this.ctx.getAllUrls()) {
            ImportLogger logger = this.ctx.getLogger(url);
            total += logger.getTotal();
            failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
            if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
            this.outputFailedData(url, logger);
        }
        ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
        this.ctx.feedbackProgress(100, null, null);
    }

    private void fecthAllQueenData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ, ImportLogger importLogger) throws Exception {
        int timeout = 0;
        ArrayList<ImportBillData> allRowdatas = new ArrayList<ImportBillData>();
        while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 500)) {
            ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>();
            int lastLeftCount = rowdatas.size();
            int needCount = 5000 - lastLeftCount;
            if (rowdatas.isEmpty() && needCount > 0) {
                ImportBillData rowdata = dataQ.poll(2L, TimeUnit.SECONDS);
                if (rowdata == null || rowdata.isEmpty()) {
                    if (rowdatas.isEmpty()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info(conf.getBillFormId() + "...read...null");
                        }
                        ++timeout;
                        continue;
                    }
                } else {
                    rowdatas.add(rowdata);
                    dataQ.drainTo(rowdatas, needCount);
                    rowdatas.removeIf(ImportBillData::isEmpty);
                    allRowdatas.addAll(rowdatas);
                }
            }
            timeout = 0;
        }
        boolean importResultFlag = true;
        if (allRowdatas.size() > 0 && conf.isResolveComplete(url)) {
            importResultFlag = this.importBatchData(allRowdatas, importLogger, conf.getOption());
        }
        if (importResultFlag) {
            MultiImportHelper.feedbackProgressDealWith(conf, importLogger, allRowdatas);
            allRowdatas.clear();
        }
    }

    private void fecthBacthQueenData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ, ImportLogger importLogger) throws InterruptedException {
        int timeout = 0;
        while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 5)) {
            ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>();
            int lastLeftCount = rowdatas.size();
            int needCount = 500 - lastLeftCount;
            if (rowdatas.isEmpty() && needCount > 0) {
                ImportBillData rowdata = dataQ.poll(1L, TimeUnit.MINUTES);
                if (rowdata == null || rowdata.isEmpty()) {
                    if (rowdatas.isEmpty()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info(conf.getBillFormId() + "...read...null");
                        }
                        ++timeout;
                        continue;
                    }
                } else {
                    rowdatas.add(rowdata);
                    dataQ.drainTo(rowdatas, needCount);
                    rowdatas.removeIf(ImportBillData::isEmpty);
                }
            }
            timeout = 0;
            boolean importResultFlag = true;
            if (rowdatas.size() > 0) {
                importResultFlag = this.importBatchData(rowdatas, importLogger, conf.getOption());
            }
            if (!importResultFlag) continue;
            MultiImportHelper.feedbackProgressDealWith(conf, importLogger, rowdatas);
            rowdatas.clear();
        }
    }

    private boolean importBatchData(List<ImportBillData> rowdatas, ImportLogger importLogger, Map<String, Object> option) throws KDBizException {
        try {
            if (rowdatas.get(0).getData().containsKey((Object)ERR_CODE)) {
                throw new KDBizException((String)rowdatas.get(0).getData().get((Object)ERR_CODE));
            }
            String optionCode = (String)option.get("importtype");
            this.wrapOriginalJson(rowdatas, importLogger, optionCode);
            switch (optionCode) {
                case "new": {
                    this.addBatchQueenData(rowdatas, importLogger, optionCode);
                    break;
                }
                case "override": {
                    this.updateBatchQueenData(rowdatas, importLogger, optionCode);
                    break;
                }
                case "overridenew": {
                    this.addOrUpdateBatchQueenData(rowdatas, importLogger, optionCode);
                    break;
                }
            }
        }
        catch (KDBizException e) {
            MultiImportHelper.feedbackProgressError(this.conf, importLogger, rowdatas);
            LOG.error((Throwable)e);
            return false;
        }
        return true;
    }

    protected void wrapOriginalJson(List<ImportBillData> rowdatas, ImportLogger importLogger, String optionCode) {
    }

    private void updateBatchQueenData(List<ImportBillData> rowdatas, ImportLogger importLogger, String optionCode) throws KDBizException {
        this.resolveRowData(rowdatas, importLogger, optionCode);
        this.convertExcelRowDataToDynamicObjs(importLogger, optionCode);
        this.queryBatchExistsRowDynamicObj(importLogger);
        this.queryBaseDataRef(importLogger);
        this.setDynamicObjValues(importLogger, optionCode);
        this.extendProcessRowData(importLogger, optionCode, this.rowDataList);
        this.removeCheckErrorDynamicObjs(importLogger);
        this.callOpSave(importLogger, opService -> {
            OperateOption operateOpt = OperateOption.create();
            operateOpt.setVariableValue(VARIABLE_VALUE, "1");
            Map<String, List<DynamicObject>> callOpSaveDynMap = this.callOpSave(this.rowDataList);
            return callOpSaveDynMap.entrySet().stream().map(entry -> {
                DynamicObject[] dynamicArr = (DynamicObject[])((List)entry.getValue()).stream().toArray(DynamicObject[]::new);
                return opService.localInvokeOperation((String)entry.getKey(), dynamicArr, operateOpt);
            }).collect(Collectors.toList());
        });
    }

    private void queryBatchExistsRowDynamicObj(ImportLogger importLogger) {
        List<Map<String, Object>> resultList = this.queryBatchExistsRowDynamicObj();
        Iterator<MultiEntityRowData> iterator = this.rowDataList.iterator();
        while (iterator.hasNext()) {
            MultiEntityRowData rowData = iterator.next();
            Optional<Map<String, Object>> optinalMap = MultiImportHelper.filterDataSetMap(rowData, resultList);
            if (!optinalMap.isPresent()) {
                this.logUpdateExistsEntityErrorMsg(rowData, importLogger);
                iterator.remove();
                continue;
            }
            rowData.updateDyFromDataSetMap(optinalMap.get());
            this.validateExistDynamicObject(rowData, optinalMap.get(), importLogger);
        }
    }

    private List<Map<String, Object>> queryBatchExistsRowDynamicObj() {
        HashMap sourceValueMap = Maps.newHashMapWithExpectedSize((int)this.rowDataList.size());
        this.rowDataList.stream().forEach(rowData -> rowData.getKeyfields().stream().forEach(key -> {
            List queryFieldList = (List)sourceValueMap.get(key);
            if (Objects.isNull(queryFieldList)) {
                queryFieldList = Lists.newArrayListWithExpectedSize((int)(this.rowDataList.size() * rowData.getKeyfields().size()));
                sourceValueMap.put(key, queryFieldList);
            }
            queryFieldList.add(rowData.getEntityJson().get(rowData.getMainEntity()).get(key));
        }));
        QFilter batchQFilter = null;
        for (Map.Entry entry : sourceValueMap.entrySet()) {
            if (batchQFilter == null) {
                batchQFilter = new QFilter((String)entry.getKey(), "in", entry.getValue());
                continue;
            }
            batchQFilter.and(new QFilter((String)entry.getKey(), "in", entry.getValue()));
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)16);
        try (DataSet queryDataSet = this.queryConfig.getQuery().getQueryDataSet(this.queryConfig.getQueryFileds(), new QFilter[]{batchQFilter}, null);){
            RowMeta rowMeta = queryDataSet.getRowMeta();
            while (queryDataSet.hasNext()) {
                HashMap rowMap = Maps.newHashMapWithExpectedSize((int)16);
                Row next = queryDataSet.next();
                String[] fieldNames = rowMeta.getFieldNames();
                Arrays.stream(fieldNames).forEach(fieldName -> rowMap.put(fieldName, next.get(fieldName)));
                resultList.add(rowMap);
            }
        }
        return resultList;
    }

    protected boolean logUpdateExistsEntityErrorMsg(MultiEntityRowData rowData, ImportLogger importLogger) {
        return false;
    }

    private void outputFailedData(String url, ImportLogger importLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            new ExcelReader().read(service.getInputStream(url), (SheetHandler)new BatchImportFailedSheetHandler(this.ctx, importLogger, service));
        }
        catch (Exception e) {
            importLogger.log(Integer.valueOf(0), (Throwable)e);
        }
    }

    private void addOrUpdateBatchQueenData(List<ImportBillData> rowdatas, ImportLogger logger, String optionCodeStr) throws KDBizException {
        this.resolveRowData(rowdatas, logger, optionCodeStr);
        this.convertExcelRowDataToDynamicObjs(logger, optionCodeStr);
        this.queryOrCreateBatchRowDynamicObj(logger);
        this.queryBaseDataRef(logger);
        this.setDynamicObjValues(logger, optionCodeStr);
        this.extendProcessRowData(logger, optionCodeStr, this.rowDataList);
        this.removeCheckErrorDynamicObjs(logger);
        this.callOpSave(logger, opService -> {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(VARIABLE_VALUE, "1");
            Map<String, List<DynamicObject>> callOpSaveMap = this.callOpSave(this.rowDataList);
            return callOpSaveMap.entrySet().stream().map(entry -> opService.localInvokeOperation((String)entry.getKey(), (DynamicObject[])((List)entry.getValue()).stream().toArray(DynamicObject[]::new), operateOption)).collect(Collectors.toList());
        });
    }

    protected void extendProcessRowData(ImportLogger importLogger, String optionCode, List<MultiEntityRowData> rowDataList) {
    }

    private void queryOrCreateBatchRowDynamicObj(ImportLogger importLogger) {
        List<Map<String, Object>> resultList = this.queryBatchExistsRowDynamicObj();
        for (MultiEntityRowData rowData : this.rowDataList) {
            Optional<Map<String, Object>> optinalMap = MultiImportHelper.filterDataSetMap(rowData, resultList);
            if (!optinalMap.isPresent()) continue;
            rowData.updateDyFromDataSetMap(optinalMap.get());
            this.validateExistDynamicObject(rowData, optinalMap.get(), importLogger);
        }
    }

    private void addBatchQueenData(List<ImportBillData> rowdatas, ImportLogger importLogger, String optionCode) throws KDBizException {
        this.resolveRowData(rowdatas, importLogger, optionCode);
        this.convertExcelRowDataToDynamicObjs(importLogger, optionCode);
        this.queryBaseDataRef(importLogger);
        this.setDynamicObjValues(importLogger, optionCode);
        this.extendProcessRowData(importLogger, optionCode, this.rowDataList);
        this.removeCheckErrorDynamicObjs(importLogger);
        this.callOpSave(importLogger, opService -> {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(VARIABLE_VALUE, "1");
            Map<String, List<DynamicObject>> callOpSaveMap = this.callOpSave(this.rowDataList);
            return callOpSaveMap.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).map(entry -> opService.localInvokeOperation((String)entry.getKey(), (DynamicObject[])((List)entry.getValue()).stream().toArray(DynamicObject[]::new), operateOption)).collect(Collectors.toList());
        });
    }

    protected Map<String, List<DynamicObject>> callOpSave(List<MultiEntityRowData> rowDataList) {
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callOpSave(ImportLogger importLogger, Function<OperationServiceImpl, List<OperationResult>> func) {
        DynamicObject[] opEntityArr = MultiImportHelper.convertDy(this.rowDataList);
        if (Objects.isNull(opEntityArr) || opEntityArr.length == 0) {
            return;
        }
        TXHandle txHandle = TX.required();
        OperationResult localOperationResult = new OperationResult();
        ArrayList pkList = Lists.newArrayList();
        try {
            OperationServiceImpl opImpl = new OperationServiceImpl();
            List<OperationResult> operationResultList = func.apply(opImpl);
            operationResultList.stream().forEach(operationResult -> {
                pkList.addAll(operationResult.getSuccessPkIds());
                MultiImportHelper.logOpFaileInfo(operationResult, importLogger, this.rowDataList);
            });
            this.logOpSuccessInfo(pkList, importLogger);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            this.logOpFaileInfo(e.getMessage(), importLogger);
            localOperationResult.setSuccess(false);
        }
        finally {
            if (!localOperationResult.isSuccess()) {
                txHandle.markRollback();
            }
            txHandle.close();
        }
    }

    private void logOpFaileInfo(String message, ImportLogger importLogger) {
        this.rowDataList.forEach(rowData -> importLogger.log(rowData.getRownum(), ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4fdd\u5b58\u6570\u636e\u5f02\u5e38\u3002", (String)"HRBatchImportPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
    }

    private void logOpSuccessInfo(List<Object> pkList, ImportLogger importLogger) {
        if (CollectionUtil.isNotEmpty(pkList)) {
            int size = pkList.size();
            for (int i = 0; i < size; ++i) {
                long pkId = (Long)pkList.get(i);
                this.rowDataList.stream().filter(rowData -> HRStringUtils.equals((String)rowData.getOpEntity().getString("id"), (String)String.valueOf(pkId))).findAny().ifPresent(rowData -> {
                    ImportBillData row = rowData.getBillData();
                    int startindex = row.getStartIndex();
                    int endindex = row.getEndIndex();
                    long count = importLogger.getDelRows().stream().filter(ints -> ints[0] == startindex && ints[1] == endindex).count();
                    if (count == 0L) {
                        importLogger.getDelRows().add(new int[]{endindex, endindex});
                    }
                });
            }
        }
    }

    private void removeCheckErrorDynamicObjs(ImportLogger importLogger) {
        Set checkFaileRows = importLogger.getLogCache().keySet();
        importLogger.setFailed(importLogger.getFailed() + checkFaileRows.size());
        importLogger.setTotal(importLogger.getFailed() + importLogger.getDelRows().size());
        Iterator<MultiEntityRowData> iterator = this.rowDataList.iterator();
        while (iterator.hasNext()) {
            MultiEntityRowData rowData = iterator.next();
            if (!checkFaileRows.contains(rowData.getRownum())) continue;
            iterator.remove();
        }
    }

    protected void validateExistDynamicObject(MultiEntityRowData rowData, Map<String, Object> dataSetMap, ImportLogger importLogger) {
    }

    private void setDynamicObjValues(ImportLogger importLogger, String optionCode) {
        this.rowDataList.forEach(rowData -> {
            this.setBasedataValues((MultiEntityRowData)rowData, importLogger);
            DynamicObject mainDy = rowData.getMainEntityDy();
            rowData.getEntityMap().entrySet().forEach(entry -> {
                ImportEntity importEntity = (ImportEntity)entry.getValue();
                if (!importEntity.isMainEntity() && !importEntity.isBaseRef()) {
                    DynamicObject subDy = rowData.getRowDynamicObject().get(entry.getKey());
                    subDy.set(importEntity.getProperty(), (Object)mainDy);
                }
            });
            this.validateDynamicObject(optionCode, (MultiEntityRowData)rowData);
        });
        DynamicObject opEntity = null;
        Set checkFaileRows = importLogger.getLogCache().keySet();
        Iterator<MultiEntityRowData> iterator = this.rowDataList.iterator();
        while (iterator.hasNext()) {
            MultiEntityRowData rowData2 = iterator.next();
            if (checkFaileRows.contains(rowData2.getRownum())) {
                iterator.remove();
                continue;
            }
            opEntity = this.convertToOpEntity(rowData2, this.rowDataList);
            if (Objects.isNull(opEntity)) {
                iterator.remove();
                continue;
            }
            rowData2.setOpEntity(opEntity);
        }
    }

    protected DynamicObject convertToOpEntity(MultiEntityRowData rowData, List<MultiEntityRowData> rowAllDataList) {
        return null;
    }

    public void setBasedataValues(MultiEntityRowData rowData, ImportLogger importLogger) {
        rowData.getEntityBasedataMap().entries().forEach(entry -> {
            String entityName = (String)entry.getKey();
            String fieldKey = (String)entry.getValue();
            rowData.getEntityBaseDataRefMap().get(fieldKey).forEach((key1, baseEntryValues) -> {
                for (String baseEntryValue : baseEntryValues) {
                    String key;
                    JSONObject jsonObject;
                    String value;
                    List<DynamicObject> basedataList = this.contianer.getBasedata((String)key1, baseEntryValue);
                    ArrayList filterRefList = Lists.newArrayListWithExpectedSize((int)1);
                    boolean validatePass = this.validateBaseDataRef(basedataList, fieldKey, entityName, rowData, this.rowDataList, () -> filterRefList);
                    if (!CollectionUtils.isEmpty((Collection)filterRefList) && validatePass) {
                        DynamicObject entityDy = rowData.getRowDynamicObject().get(entityName);
                        entityDy.set(fieldKey, filterRefList.get(0));
                        continue;
                    }
                    if (!CollectionUtils.isEmpty((Collection)filterRefList) || this.logErrorMsg(basedataList, fieldKey, importLogger, fieldKey, value = (jsonObject = rowData.getEntityJson().get(entityName).getJSONObject(fieldKey)).getString(key = jsonObject.getString("importprop")), key, rowData.getRownum())) continue;
                    importLogger.log(rowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67e5\u8be2\u5173\u8054\u5f15\u7528\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728{%s}:", (String)"HRBatchImportPlugin_28", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), fieldKey));
                }
            });
        });
    }

    protected boolean logErrorMsg(List<DynamicObject> dynamicObjectList, String entityId, ImportLogger importLogger, String filed, String value, String key, Integer rowNum) {
        return false;
    }

    protected void validateDynamicObject(String optionCode, MultiEntityRowData rowData) {
    }

    private void queryBaseDataRef(ImportLogger importLogger) {
        this.contianer.queryBasedataFromStore();
    }

    protected boolean validateBaseDataRef(List<DynamicObject> basedataList, String entityId, String baseDataId, MultiEntityRowData current, List<MultiEntityRowData> rowDataList, Supplier<List<DynamicObject>> filterRefListSuppier) {
        filterRefListSuppier.get().addAll(basedataList);
        return true;
    }

    private void convertExcelRowDataToDynamicObjs(ImportLogger importLogger, String optionCode) {
        this.rowDataList.forEach(rowData -> rowData.convertToDynamicObject(baseEntityId -> MultiImportHelper.getbasedataProps(baseEntityId, this.entitySelectPropes), (entityRowData, dy) -> this.afterCreateDynamicObjectProcess((DynamicObject)dy, (MultiEntityRowData)entityRowData, importLogger)));
    }

    private void resolveRowData(List<ImportBillData> rowDatas, ImportLogger importLogger, String optionCode) throws KDBizException {
        ArrayList tempRowDataList = Lists.newArrayListWithExpectedSize((int)rowDatas.size());
        for (ImportBillData bill : rowDatas) {
            MultiEntityRowData rowData = new MultiEntityRowData(this.queryConfig, bill, optionCode, importLogger, this.contianer, null);
            this.excludeEntityIdSet.forEach(entityId -> bill.getData().remove(entityId));
            rowData.setBillData(bill);
            rowData.buildRowData(this.entitiesList);
            if (!"new".equals(optionCode)) {
                MultiImportHelper.validateKeyFields(rowData, rowData.getMainEntity(), importLogger, this.keyfieldsMap);
            }
            tempRowDataList.add(rowData);
        }
        this.rowDataList.addAll(tempRowDataList);
    }

    protected Object getCurrUser(String userId, String basedataEntityId) {
        return MultiImportHelper.getUser(userId, basedataEntityId, this.currUser, this.entitySelectPropes);
    }

    protected void resolveExcel() {
        if (this.conf == null) {
            this.conf = this.ctx;
        }
        this.init();
        this.resolve();
    }

    protected void importData() throws Throwable {
        this.importData(this.conf);
    }
}

