/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class HRSheetHandler {
    private static final Log LOG = LogFactory.getLog(HRSheetHandler.class);

    private static List<Integer> splitRange(String[] subRanges, boolean hasErrorCol) {
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        try {
            for (int rowI = 0; rowI < subRanges.length; ++rowI) {
                char charAt;
                int rowK;
                int rowJ = 0;
                int len = subRanges[rowI].length();
                for (rowK = 1; rowK < len && (charAt = subRanges[rowI].charAt(rowK)) >= 'A' && charAt <= 'Z'; ++rowK) {
                }
                ranges.add(HRSheetHandler.charsToNumber(subRanges[rowI].substring(rowJ, rowK), hasErrorCol));
                ranges.add(Integer.parseInt(subRanges[rowI].substring(rowK)));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return ranges;
    }

    private static int countIndex(int index, boolean hasErrorCol) {
        if (hasErrorCol) {
            return index;
        }
        return ++index;
    }

    private static int charsToNumber(String letter, boolean hasErrorCol) {
        if (letter == null || letter.isEmpty()) {
            return -1;
        }
        String upperLetter = letter.toUpperCase(Locale.ROOT);
        if (!upperLetter.matches("[A-Z]+")) {
            return -1;
        }
        long num = 0L;
        long base = 1L;
        for (int rowI = upperLetter.length() - 1; rowI >= 0; --rowI) {
            char ch = upperLetter.charAt(rowI);
            if ((num += (long)(ch - 65 + HRSheetHandler.countIndex(0, hasErrorCol)) * (base *= 26L)) <= Integer.MAX_VALUE) continue;
            return -1;
        }
        return (int)num;
    }

    public static void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations, Map<String, SXSSFSheet> sheets, boolean hasErrorCol) {
        for (SheetHandler.CellValidation validation : cellValidations) {
            SXSSFSheet sheet = sheets.get(validation.getSheetName());
            DataValidationHelper helper = sheet.getDataValidationHelper();
            String[] rangeStrs = validation.getRange().toUpperCase(Locale.ROOT).split(" ");
            if (rangeStrs == null || rangeStrs.length <= 0) continue;
            for (String rg : rangeStrs) {
                List<Integer> ranges = HRSheetHandler.splitRange(rg.split(":"), hasErrorCol);
                int rangeSize = ranges.size();
                CellRangeAddressList addressList = null;
                if (ranges.contains(-1)) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("handleDataValidation ranges can not find");
                    }
                } else if (rangeSize == 2) {
                    addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(1) - 1, ranges.get(0).intValue(), ranges.get(0).intValue());
                } else if (rangeSize == 4) {
                    addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(3) - 1, ranges.get(0).intValue(), ranges.get(2).intValue());
                }
                if (addressList == null) continue;
                DataValidationConstraint constraint = helper.createFormulaListConstraint(validation.getValidation());
                DataValidation dataValidation = helper.createValidation(constraint, addressList);
                if (dataValidation instanceof XSSFDataValidation) {
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                } else {
                    dataValidation.setSuppressDropDownArrow(false);
                }
                sheet.addValidationData(dataValidation);
            }
        }
    }

    public static void handleSheetComments(Map<String, CommentsTable> comments, boolean isNewFormat, SXSSFWorkbook book, Map<String, SXSSFRow> nameRows, boolean hasErrorCol) {
        int rowNum;
        int n = rowNum = isNewFormat ? 3 : 2;
        if (!comments.isEmpty()) {
            for (Map.Entry<String, CommentsTable> entry : comments.entrySet()) {
                String sheetName = entry.getKey();
                SXSSFSheet sheet = book.getSheet(sheetName);
                SXSSFRow row = nameRows.get(entry.getKey());
                if (row == null) continue;
                SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
                Iterator cellAddressesIterator = entry.getValue().getCellAddresses();
                while (cellAddressesIterator.hasNext()) {
                    CellAddress addr = (CellAddress)cellAddressesIterator.next();
                    XSSFComment comment = entry.getValue().findCellComment(addr);
                    SXSSFCell cell = row.getCell(HRSheetHandler.countIndex(addr.getColumn(), hasErrorCol));
                    if (comment.getRow() != rowNum) continue;
                    Comment temp = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)HRSheetHandler.countIndex(comment.getColumn(), hasErrorCol)), rowNum, (short)HRSheetHandler.countIndex(comment.getColumn(), hasErrorCol) + 2, 5));
                    temp.setString((RichTextString)comment.getString());
                    cell.setCellComment(temp);
                }
            }
            comments.clear();
        }
    }

    public static CellStyle getCellStyle(String fmt, Short bg, Short color, String styleStr, Map<String, CellStyle> styles, SXSSFWorkbook book) {
        CellStyle cellStyle = book.createCellStyle();
        styles.put(styleStr, cellStyle);
        cellStyle.setDataFormat(book.createDataFormat().getFormat(fmt));
        if (bg != null) {
            cellStyle.setFillForegroundColor(bg.shortValue());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (color != null) {
            Font font = book.createFont();
            font.setColor(color.shortValue());
            cellStyle.setFont(font);
        }
        return cellStyle;
    }
}

