/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.formplugin.web.imp.ImportEntity;
import kd.hr.hbp.formplugin.web.imp.ImportEntityMapping;
import org.xml.sax.SAXException;

public class ImportSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(ExcelReader.class);
    private static final String HRMP_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";
    private ImportConfig conf;
    private String url;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private Map<Integer, String> nameRow;
    private List<ImportEntityMapping> entityMappings = Lists.newArrayList();
    private List<ImportEntity> entitiesList;
    private int startRowNum = 0;
    int lastStartRowNum = 0;
    private boolean errorData = false;
    private JSONObject data = new JSONObject();
    private SheetHandler.ParsedRow currentRow;

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public ImportSheetHandler(ImportConfig conf, String path, LinkedBlockingQueue<ImportBillData> linkedBlockingQueue) {
        this.conf = conf;
        this.url = path;
        this.dataQueue = linkedBlockingQueue;
    }

    public ImportSheetHandler(List<ImportEntity> entities, ImportConfig conf, String path) {
        this.conf = conf;
        this.url = path;
        this.entitiesList = entities;
        this.dataQueue = (LinkedBlockingQueue)this.conf.getDataQueues().get(this.url);
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        ((ImportLogger)this.conf.getUrlLoggers().get(this.url)).setRowIndex(currRowNum);
        if (currRowNum > 2) {
            JSONObject rowEntity = new JSONObject();
            this.setEntityMappings(row, currRowNum, rowEntity);
            if (rowEntity.size() > 0) {
                JSONObject rowObj = new JSONObject();
                rowObj.put("data", (Object)rowEntity);
                this.addBillData(new ImportBillData(rowObj, this.startRowNum, currRowNum - 1));
            }
        } else if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.entitiesList.forEach(importEntity -> {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)importEntity.getEntityName());
                this.entityMappings.add(ImportEntityMapping.create((DynamicObjectType)entityType, this.nameRow));
            });
        } else if (currRowNum == 0) {
            ((ImportLogger)this.conf.getUrlLoggers().get(this.url)).setLastRowIndex(this.getRowCount());
            if (row.isEmpty()) {
                LOG.error(this.conf.getPageId() + "...data is null...Continue");
                return;
            }
            String entityName = row.get(Integer.valueOf(0));
            MainEntityType entityType = this.conf.getEntityType();
            this.validateRntityType(currRowNum, entityName, entityType);
        }
    }

    private void validateRntityType(int currRowNum, String entityName, MainEntityType entityType) {
        String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u6570\u636e\uff1a%s\u3002", (String)"ImportSheetHandler_0", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]), entityName);
        if (entityType instanceof QueryEntityType) {
            QueryEntityType queryEntityType = (QueryEntityType)entityType;
            if (this.checkValiditeName(entityName) || !queryEntityType.getMainEntityType().getName().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
                this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum));
                this.conf.setComplete(this.url);
                throw new KDBizException(msg);
            }
        } else if (this.checkValiditeName(entityName) || !this.conf.getEntityType().getName().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
            this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum));
            this.conf.setComplete(this.url);
            throw new KDBizException(msg);
        }
    }

    private void setEntityMappings(SheetHandler.ParsedRow row, int currRowNum, JSONObject rowEntity) {
        for (ImportEntityMapping importEntityMapping : this.entityMappings) {
            JSONObject entityData = new JSONObject();
            List<String> errMsg = importEntityMapping.push(row.getData(), entityData);
            if (!errMsg.isEmpty()) {
                if (!this.errorData) {
                    // empty if block
                }
                this.errorData = true;
                ((ImportLogger)this.conf.getUrlLoggers().get(this.url)).log(Integer.valueOf(currRowNum), String.join((CharSequence)"; ", errMsg));
            }
            if (importEntityMapping.isEntityEmpty(row.getData())) {
                return;
            }
            if (entityData != null) {
                if (this.errorData) {
                    ((ImportLogger)this.conf.getUrlLoggers().get(this.url)).fail().tick();
                } else {
                    this.initBlankValues(importEntityMapping, entityData);
                    entityData.put("rownum", (Object)currRowNum);
                    rowEntity.put(importEntityMapping.getEntityTypeId(), (Object)entityData);
                }
                this.errorData = false;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(this.conf.getPageId() + "...Analysis Import Excel First Data\uff1a" + JSON.toJSONString((Object)row.getData()));
            }
            this.startRowNum = currRowNum;
        }
    }

    private boolean checkValiditeName(String entityName) {
        return entityName == null || !entityName.contains(" # ");
    }

    private void initBlankValues(ImportEntityMapping mapping, JSONObject data) {
        if (data != null && !data.isEmpty()) {
            this.fillBlankValues(mapping, data);
        }
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"ImportSheetHandler_1", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            LOG.error("Analysis Thread Exception.", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"ImportSheetHandler_2", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (this.lastStartRowNum == 0 || billData.getEndIndex() - this.lastStartRowNum >= 500) {
            this.conf.feedbackProgress(0, (ImportLogger)this.conf.getUrlLoggers().get(this.url), null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }

    private void fillBlankValues(ImportEntityMapping mapping, JSONObject data) {
        if (data != null) {
            for (String key : mapping.getCols().keySet()) {
                if (data.containsKey((Object)key)) continue;
                data.put(key, null);
            }
            this.filterhandle(mapping, data);
        }
    }

    private void filterhandle(ImportEntityMapping importEntityMapping, JSONObject data) {
        for (Map.Entry<String, ImportEntityMapping> subMapping : importEntityMapping.getEntries().entrySet()) {
            JSONArray rows = data.getJSONArray(subMapping.getKey());
            if (rows == null || rows.isEmpty()) continue;
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                this.fillBlankValues(subMapping.getValue(), rows.getJSONObject(i));
            }
        }
    }

    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        if (this.currentRow != null) {
            int currentRowNumber = this.currentRow.getRowNum();
            this.conf.setComplete(this.url);
            if (this.lastStartRowNum == 0 || currentRowNumber - this.lastStartRowNum >= 500) {
                this.conf.feedbackProgress(0, (ImportLogger)this.conf.getUrlLoggers().get(this.url), null);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(this.conf.getPageId() + "...doAfterAllAnalysed..." + this.errorData + "..." + currentRowNumber);
            }
        }
    }
}

