/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.BasedataContianer;
import kd.hr.hbp.formplugin.web.imp.BasedataQueryDesc;
import kd.hr.hbp.formplugin.web.imp.ImportEntity;
import kd.hr.hbp.formplugin.web.imp.MultiEntityQueryConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MultiEntityRowData
implements Serializable {
    private static final long serialVersionUID = -277438146593827899L;
    private static final Log LOG = LogFactory.getLog(MultiEntityRowData.class);
    private static final String HR_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";
    private static final String ENTRY_ID_REGEX = "^\\d{10,19}$";
    private static final Pattern ENTRY_ID_PATTERN = Pattern.compile("^\\d{10,19}$");
    private final Map<Function<IDataEntityProperty, Boolean>, BiConsumer<Pair<String, Object>, DynamicObject>> instanceofMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
    private final Map<String, Map<String, List<String>>> entityBaseDataRefMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, JSONObject> entityJson = Maps.newHashMap();
    private Map<String, DynamicObject> rowDynamicObjectMap = Maps.newHashMap();
    private Multimap<String, String> entityBasedataMap = ArrayListMultimap.create();
    private Map<String, ImportEntity> entityMap = Maps.newHashMap();
    private ImportBillData billData;
    private String tempCode;
    private String optionCode;
    private String mainEntity;
    private ImportLogger importLogger;
    private Integer rownum;
    private BasedataContianer contianer;
    private DynamicObject opEntity;
    private List<String> keyfields = Lists.newArrayList();
    private MultiEntityQueryConfig queryConfig;

    public MultiEntityRowData(MultiEntityQueryConfig queryConfig, ImportBillData billData, String optionCode, ImportLogger importLogger, BasedataContianer contianer, String tempCode) {
        this.billData = billData;
        this.optionCode = optionCode;
        this.importLogger = importLogger;
        this.contianer = contianer;
        this.queryConfig = queryConfig;
        this.init();
        this.tempCode = tempCode;
    }

    private void init() {
        this.instanceofMap.put(prop -> prop instanceof TextProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof LargeTextProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof VarcharProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof MuliLangTextProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof ComboProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof BooleanProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof LongProp, (pair, dy) -> dy.set((String)pair.getLeft(), pair.getRight()));
        this.instanceofMap.put(prop -> prop instanceof DecimalProp, (pair, dy) -> dy.set((String)pair.getLeft(), (Object)new BigDecimal(String.valueOf(pair.getRight()))));
        this.instanceofMap.put(prop -> prop instanceof DateProp, (pair, dy) -> this.parseDatePropData((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
        this.instanceofMap.put(prop -> prop instanceof TimeProp, (pair, dy) -> this.parseTimePropData((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
        this.instanceofMap.put(prop -> prop instanceof DateTimeProp, (pair, dy) -> this.parseDateTimePropData((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
        this.instanceofMap.put(prop -> prop instanceof EntryProp, (pair, dy) -> this.parseEntryPropData((String)pair.getLeft(), pair.getRight(), (DynamicObject)dy));
    }

    public void buildRowData(List<ImportEntity> entitiesList) {
        Set jsonFieldSet = this.billData.getData().getJSONObject("data").keySet();
        this.rownum = this.billData.getData().getInteger("rownum");
        Map tempEntityMap = entitiesList.stream().collect(Collectors.toMap(ImportEntity::getEntityName, Function.identity()));
        Set diffEntitySet = Sets.difference((Set)jsonFieldSet, tempEntityMap.keySet()).copyInto((Set)Sets.newHashSetWithExpectedSize((int)jsonFieldSet.size()));
        if (diffEntitySet.size() > 0) {
            this.importLogger.log(this.rownum, ResManager.loadKDString((String)"\u6a21\u677f\u6821\u9a8c\u5931\u8d25\uff1b", (String)"MultiEntityRowData_1", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u6821\u9a8c\u5931\u8d25\uff1b", (String)"MultiEntityRowData_1", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]));
        }
        Iterator iterator = tempEntityMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if (jsonFieldSet.contains(next.getKey())) continue;
            iterator.remove();
        }
        this.entityMap = tempEntityMap;
        entitiesList.stream().filter(ImportEntity::isMainEntity).findAny().map(ImportEntity::getEntityName).ifPresent(entityName -> {
            this.mainEntity = entityName;
        });
        this.getBillData().getData().getJSONObject("data").entrySet().forEach(entry -> this.entityJson.put((String)entry.getKey(), (JSONObject)entry.getValue()));
    }

    public DynamicObject getMainEntityDy() {
        return this.getRowDynamicObject().get(this.getMainEntity());
    }

    public void updateDyFromDataSetMap(Map<String, Object> dataSetMap) {
        this.getRowDynamicObject().entrySet().stream().forEach(entry -> {
            String idProp;
            String entityName = (String)entry.getKey();
            DynamicObject entityDy = (DynamicObject)entry.getValue();
            String idKey = idProp = this.queryConfig.getIdProp(entityName);
            if (!HRStringUtils.equals((String)this.getMainEntity(), (String)entityName)) {
                idKey = this.queryConfig.getDataSetIdKey(entityName, idProp);
            }
            Object idValue = dataSetMap.get(idKey);
            entityDy.set(idProp, idValue);
        });
        this.optionCode = "override";
    }

    public void updateRowDyFromDataSetMap(Map<String, Object> dataSetMap, DynamicObject dbDy, String entityId) {
        JSONObject setNullFields = (JSONObject)this.getBillData().getData().get((Object)"setNullFields");
        JSONArray mainFieldArray = setNullFields.getJSONArray("0");
        JSONArray entryFieldKey = setNullFields.getJSONArray("-1");
        DynamicObject entityDy = this.getRowDynamicObject().get(entityId);
        for (Map.Entry<String, Object> entry2 : dataSetMap.entrySet()) {
            Object value = entityDy.get(entry2.getKey());
            if (("id".equals(entry2.getKey()) || !Objects.nonNull(value)) && (!Objects.nonNull(mainFieldArray) || !mainFieldArray.contains((Object)entry2.getKey()))) continue;
            if (dbDy.getDynamicObjectType().getProperty(entry2.getKey()) instanceof MuliLangTextProp) {
                if (!(value instanceof ILocaleString)) continue;
                dbDy.set(entry2.getKey(), new HashMap((ILocaleString)value));
                continue;
            }
            if (dbDy.getDynamicObjectType().getProperty(entry2.getKey()) instanceof EntryProp) continue;
            dbDy.set(entry2.getKey(), value);
        }
        if (entryFieldKey != null) {
            String entryNumber = entryFieldKey.getString(0);
            DynamicObjectCollection idEmptyCollection = new DynamicObjectCollection();
            DynamicObjectCollection idNotEmptyCollection = new DynamicObjectCollection();
            entityDy.getDynamicObjectCollection(entryNumber).forEach(entry -> {
                if (entry.getPkValue() == null || entry.getPkValue().toString().length() == 0 || "0".equals(entry.getPkValue().toString())) {
                    idEmptyCollection.add(entry);
                } else {
                    idNotEmptyCollection.add(entry);
                }
            });
            DynamicObjectCollection entryCollection = dbDy.getDynamicObjectCollection(entryNumber);
            Map<String, DynamicObject> entryMap = entryCollection.stream().collect(Collectors.toMap(entry -> entry.getPkValue().toString(), entry -> entry));
            for (DynamicObject importEntry2 : idNotEmptyCollection) {
                DynamicObject entry3 = entryMap.get(importEntry2.getPkValue().toString());
                if (entry3 == null) {
                    DynamicObject newEntry = entryCollection.addNew();
                    this.handleEntry(setNullFields, newEntry, importEntry2);
                    continue;
                }
                this.handleEntry(setNullFields, entry3, importEntry2);
            }
            idEmptyCollection.forEach(importEntry -> {
                DynamicObject newEntry = entryCollection.addNew();
                this.handleEntry(setNullFields, newEntry, (DynamicObject)importEntry);
            });
        }
        this.getRowDynamicObject().put(entityId, dbDy);
    }

    private void handleEntry(JSONObject setNullFields, DynamicObject entry, DynamicObject importEntry) {
        JSONArray entrySetNullFields = setNullFields.getJSONArray(String.valueOf(entry.getPkValue()));
        entry.getDynamicObjectType().getProperties().forEach(property -> {
            String name = property.getName();
            if (!"id".equals(name) && Objects.nonNull(importEntry.get(name)) || Objects.nonNull(entrySetNullFields) && entrySetNullFields.contains((Object)name)) {
                entry.set(name, importEntry.get(name));
            }
        });
    }

    public void convertToDynamicObject(Function<String, Set<String>> baseDataPropsFunc, BiConsumer<MultiEntityRowData, DynamicObject> consumer) {
        this.entityMap.forEach((key, value) -> this.convertToDynamicObject((String)key, baseDataPropsFunc, consumer));
    }

    private void convertToDynamicObject(String entityName, Function<String, Set<String>> baseDataPropsFunc, BiConsumer<MultiEntityRowData, DynamicObject> consumer) {
        JSONObject jsonObject = this.entityJson.get(entityName);
        if (Objects.isNull(jsonObject)) {
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        DynamicObject dynamicObject = (DynamicObject)entityType.createInstance();
        Long pkId = ORM.create().genLongId(entityName);
        dynamicObject.set(entityType.getPrimaryKey().getName(), (Object)pkId);
        this.rowDynamicObjectMap.put(entityName, dynamicObject);
        for (IDataEntityProperty prop : entityType.getProperties()) {
            Object fieldValue;
            if (prop instanceof FieldProp && ((FieldProp)prop).getDefValue() != null) {
                dynamicObject.set(prop.getName(), ((FieldProp)prop).getDefValue());
            }
            if (prop instanceof CreaterProp) {
                dynamicObject.set(prop.getName(), (Object)RequestContext.get().getCurrUserId());
            }
            if (Objects.isNull(fieldValue = this.getPropValues((Map<String, Object>)jsonObject, prop))) continue;
            this.setBaseDataRef(entityName, baseDataPropsFunc, jsonObject, prop);
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties();
                List baseDataPropList = entryProperties.stream().filter(dataEntityProperty -> dataEntityProperty instanceof BasedataProp || dataEntityProperty instanceof MulBasedataProp).collect(Collectors.toList());
                JSONArray entityArray = jsonObject.getJSONArray(prop.getName());
                if (!entityArray.isEmpty()) {
                    for (IDataEntityProperty entryProp : baseDataPropList) {
                        entityArray.stream().filter(entity -> ((JSONObject)entity).containsKey((Object)entryProp.getName())).forEach(entityObj -> this.setBaseDataRef(entityName, baseDataPropsFunc, (JSONObject)entityObj, entryProp));
                    }
                }
            }
            this.setDynamicObject(dynamicObject, prop, fieldValue, prop.getName());
            if ("new".equals(this.getOptionCode())) {
                this.checkEntityIDDuplicate(dynamicObject, prop);
            }
            consumer.accept(this, dynamicObject);
        }
    }

    private void checkEntityIDDuplicate(DynamicObject dynamicObject, IDataEntityProperty prop) {
        if (prop instanceof EntryProp) {
            DynamicObjectCollection propCol = dynamicObject.getDynamicObjectCollection(prop.getName());
            if (propCol.isEmpty()) {
                return;
            }
            DynamicObjectType propertyType = ((EntryProp)prop).getDynamicCollectionItemPropertyType();
            ISimpleProperty primaryKey = propertyType.getPrimaryKey();
            String alias = primaryKey.getAlias();
            List entryIds = propCol.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            List duplicateIds = entryIds.stream().filter(obj -> !"0".equals(String.valueOf(obj))).collect(Collectors.toMap(ele -> ele, ele -> 1, Integer::sum)).entrySet().stream().filter(ele -> (Integer)ele.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            if (!duplicateIds.isEmpty()) {
                this.writeImportLogger(MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\u5185\u7801\uff1a{0}\u5728\u5206\u5f55\u4e2d\u5b58\u5728\u76f8\u540c\u5185\u7801\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u6570\u636e\u3002", (String)"HRBatchImportPlugin_14", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), StringUtils.join(duplicateIds, (String)",")));
            }
            if (HRStringUtils.isEmpty((String)propertyType.getAlias()) || HRStringUtils.isEmpty((String)alias)) {
                this.writeImportLogger(MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\uff1a{0}\u6ca1\u6709\u7ed1\u5b9a\u5177\u4f53\u7684\u5b9e\u4f53\u8868\u6216\u5b9e\u4f53\u8868\u6ca1\u6709\u7ed1\u5b9a\u4e3b\u952e\u5b57\u6bb5\u3002", (String)"HRBatchImportPlugin_16", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), propertyType.getDisplayName().getLocaleValue()));
                return;
            }
            String selectSql = "select " + alias + " from " + propertyType.getAlias() + " where " + alias + " in (" + StringUtils.join(entryIds, (String)",") + ')';
            List ids = (List)HRDBUtil.query((DBRoute)new DBRoute(propertyType.getDBRouteKey()), (String)selectSql, null, rs -> {
                ArrayList<Long> result = new ArrayList<Long>(16);
                while (rs.next()) {
                    result.add(rs.getLong(alias));
                }
                return result;
            });
            if (!ids.isEmpty()) {
                this.writeImportLogger(MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\u5185\u7801\uff1a{0}\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u6570\u636e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"HRBatchImportPlugin_13", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), StringUtils.join((Iterable)ids, (String)",")));
            }
        }
    }

    private void setBaseDataRef(String entityName, Function<String, Set<String>> baseDataPropsFunc, JSONObject jsonObject, IDataEntityProperty prop) {
        String fieldKey = prop.getName();
        if ((prop instanceof BasedataProp || prop instanceof MulBasedataProp) && Objects.nonNull(jsonObject.getJSONObject(fieldKey))) {
            IBasedataField basedataProp = (IBasedataField)prop;
            boolean isEntryField = prop.getParent() instanceof EntryType;
            JSONObject baseData = jsonObject.getJSONObject(fieldKey);
            String importProp = baseData.getString("importprop");
            String importValue = baseData.getString(importProp);
            JSONObject uesOrg = null;
            String baseEntityId = basedataProp.getBaseEntityId();
            Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)baseEntityId);
            LOG.info("MultiEntityRowData--setBaseDataRef(),importValue:{},baseEntityId:{},isBaseDataCtrl:{}", new Object[]{importValue, baseEntityId, isBaseDataCtrl});
            if (isBaseDataCtrl.booleanValue()) {
                String orgProp = basedataProp.getOrgProp();
                if (StringUtils.isNotEmpty((CharSequence)orgProp) && null != this.entityJson.get(entityName).getJSONObject(orgProp)) {
                    uesOrg = this.entityJson.get(entityName).getJSONObject(orgProp).clone();
                    uesOrg.put("useorgfieldkey", (Object)orgProp);
                    uesOrg.put("useorgentitynum", (Object)(isEntryField ? ((BasedataProp)prop.getParent().getParent().getProperties().get((Object)orgProp)).getBaseEntityId() : ((BasedataProp)prop.getParent().getProperties().get((Object)orgProp)).getBaseEntityId()));
                    baseData.put("useorgvalue", uesOrg.get((Object)uesOrg.getString("importprop")));
                }
                String mainOrg = prop.getParent() instanceof EntryType ? ((MainEntityType)prop.getParent().getParent()).getMainOrg() : ((MainEntityType)prop.getParent()).getMainOrg();
                if (null == uesOrg && StringUtils.isEmpty((CharSequence)orgProp) && null != this.entityJson.get(entityName).getJSONObject(mainOrg)) {
                    uesOrg = this.entityJson.get(entityName).getJSONObject(mainOrg).clone();
                    uesOrg.put("useorgfieldkey", (Object)mainOrg);
                    uesOrg.put("useorgentitynum", (Object)(isEntryField ? ((BasedataProp)prop.getParent().getParent().getProperties().get((Object)mainOrg)).getBaseEntityId() : ((BasedataProp)prop.getParent().getProperties().get((Object)mainOrg)).getBaseEntityId()));
                    baseData.put("useorgvalue", uesOrg.get((Object)uesOrg.getString("importprop")));
                }
                LOG.info("MultiEntityRowData--setBaseDataRef(),uesOrg:{}", uesOrg);
            }
            String baseDataEntityNum = basedataProp.getBaseEntityId();
            this.putBaseDataIntoMap(fieldKey, baseDataEntityNum, importValue);
            this.entityBasedataMap.put((Object)entityName, (Object)fieldKey);
            Set<String> baseDataProps = baseDataPropsFunc.apply(importProp);
            BasedataQueryDesc desc = prop instanceof MulBasedataProp ? new BasedataQueryDesc((MulBasedataProp)prop, importProp, baseDataProps, uesOrg) : new BasedataQueryDesc((BasedataProp)prop, importProp, baseDataProps, uesOrg);
            String[] value = importValue.split(",");
            if (prop instanceof BasedataProp && value.length > 1) {
                this.writeImportLogger(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u662f\u5355\u9009\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u80fd\u586b\u5199\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7f16\u7801\u6216\u540d\u79f0\u3002", (String)"HRBatchImportPlugin_18", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), prop.getDisplayName().getLocaleValue()));
            }
            desc.setParentEntity(entityName);
            desc.setImportValue(importValue);
            desc.putWhere(importProp, value);
            this.contianer.addBasedataQuery(desc);
        }
    }

    private void setDynamicObject(DynamicObject dynamicObject, IDataEntityProperty prop, Object fieldValue, String fieldKey) {
        for (Map.Entry<Function<IDataEntityProperty, Boolean>, BiConsumer<Pair<String, Object>, DynamicObject>> entry : this.instanceofMap.entrySet()) {
            if (!entry.getKey().apply(prop).booleanValue()) continue;
            try {
                entry.getValue().accept((Pair<String, Object>)Pair.of((Object)fieldKey, (Object)fieldValue), dynamicObject);
            }
            catch (RuntimeException runtimeException) {
                String msg = String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff0c\u65e0\u6548\u503c\u4e3a:%s\u3002", (String)"HRBatchImportPlugin_10", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), fieldValue);
                this.writeImportLogger(msg);
            }
            break;
        }
    }

    public void writeImportLogger(String errMsg) {
        if (!this.importLogger.getLogCache().containsKey(this.getRownum())) {
            this.importLogger.log(this.getRownum(), errMsg);
        } else {
            List importLogs = (List)this.importLogger.getLogCache().get(this.getRownum());
            for (ImportLogger.ImportLog log : importLogs) {
                if (!log.msg.equals(errMsg)) continue;
                return;
            }
            this.importLogger.log(this.getRownum(), errMsg);
        }
    }

    private void parseDatePropData(String fieldKey, Object fieldValue, DynamicObject dyobj) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setLenient(false);
            dyobj.set(fieldKey, (Object)simpleDateFormat.parse(String.valueOf(fieldValue)));
        }
        catch (ParseException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u65e0\u6548\u503c\u4e3a\uff1a%s", (String)"HRBatchImportPlugin_3", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), fieldValue);
            this.writeImportLogger(msg);
        }
    }

    private void parseDateTimePropData(String fieldKey, Object fieldValue, DynamicObject dyobj) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setLenient(false);
            dyobj.set(fieldKey, (Object)simpleDateFormat.parse(String.valueOf(fieldValue)));
        }
        catch (ParseException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u65e0\u6548\u503c\u4e3a\uff1a%s", (String)"HRBatchImportPlugin_3", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), fieldValue);
            this.writeImportLogger(msg);
        }
    }

    private void parseTimePropData(String fieldKey, Object fieldValue, DynamicObject dyobj) {
        try {
            if (fieldValue instanceof Integer && (Integer)fieldValue == -1) {
                dyobj.set(fieldKey, (Object)-1);
            } else {
                String time = String.valueOf(fieldValue);
                Date date = time.length() > 10 ? HRDateTimeUtils.parseDate((String)String.valueOf(fieldValue)) : new SimpleDateFormat("HH:mm:ss").parse(String.valueOf(fieldValue));
                dyobj.set(fieldKey, (Object)TimeProp.timeToSecond((Object)new SimpleDateFormat("HH:mm:ss").format(date), (String)""));
            }
        }
        catch (ParseException | KDBizException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u8f6c\u6362\u9519\u8bef,\u65e0\u6548\u503c\u4e3a:%s\u3002", (String)"HRBatchImportPlugin_9", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), fieldValue);
            this.writeImportLogger(msg);
        }
    }

    private void parseEntryPropData(String fieldKey, Object fieldValue, DynamicObject dyobj) {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)dyobj.get(fieldKey);
        if (fieldValue instanceof JSONArray) {
            for (int i = 0; i < ((JSONArray)fieldValue).size(); ++i) {
                DynamicObject dynamicObject = dynamicObjects.addNew();
                JSONObject excelObj = ((JSONArray)fieldValue).getJSONObject(i);
                for (IDataEntityProperty prop : dynamicObjects.getDynamicObjectType().getProperties()) {
                    String fieldKeyTemp = prop.getName();
                    Object fieldValueTemp = this.getPropValues((Map<String, Object>)excelObj, prop);
                    if (Objects.isNull(fieldValueTemp = this.handleEntryId(fieldKey, dynamicObject, excelObj, fieldKeyTemp, fieldValueTemp))) continue;
                    this.setDynamicObject(dynamicObject, prop, fieldValueTemp, fieldKeyTemp);
                }
            }
        }
    }

    private Object handleEntryId(String fieldKey, DynamicObject dynamicObject, JSONObject excelObj, String fieldKeyTemp, Object fieldValueTemp) {
        if ("id".equals(fieldKeyTemp)) {
            fieldValueTemp = excelObj.get((Object)(fieldKey + "." + "id"));
            if (Objects.isNull(fieldValueTemp)) {
                fieldValueTemp = ORM.create().genLongId(dynamicObject.getDataEntityType());
                excelObj.put(fieldKey + "." + "id", fieldValueTemp);
            } else if (!ENTRY_ID_PATTERN.matcher(String.valueOf(fieldValueTemp)).matches()) {
                this.importLogger.log(this.getRownum(), MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\u5185\u7801\uff1a\u201c{0}\u201d\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u5fc5\u987b\u4e3a10~19\u4f4d\u6570\u5b57\u3002", (String)"HRBatchImportPlugin_15", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]), fieldValueTemp));
            }
        }
        return fieldValueTemp;
    }

    private Object getPropValues(Map<String, Object> dataMap, IDataEntityProperty dp) {
        Object val;
        if (dp instanceof BasedataProp) {
            JSONObject basedata = (JSONObject)dataMap.get(dp.getName());
            if (Objects.isNull(basedata)) {
                return null;
            }
            val = basedata.getString(basedata.getString("importprop"));
        } else {
            val = dataMap.get(dp.getName());
        }
        return val;
    }

    public void addKey(String key) {
        this.keyfields.add(key);
    }

    public ImportBillData getBillData() {
        return this.billData;
    }

    public void setBillData(ImportBillData billData) {
        this.billData = billData;
    }

    public Map<String, DynamicObject> getRowDynamicObject() {
        return this.rowDynamicObjectMap;
    }

    public void setRowDynamicObject(Map<String, DynamicObject> rowDynamicObject) {
        this.rowDynamicObjectMap = rowDynamicObject;
    }

    public Map<String, JSONObject> getEntityJson() {
        return this.entityJson;
    }

    public Multimap<String, String> getEntityBasedataMap() {
        return this.entityBasedataMap;
    }

    public Map<String, ImportEntity> getEntityMap() {
        return this.entityMap;
    }

    public String getMainEntity() {
        return this.mainEntity;
    }

    public void setMainEntity(String mainEntity) {
        this.mainEntity = mainEntity;
    }

    public Integer getRownum() {
        return this.rownum;
    }

    public List<String> getKeyfields() {
        return this.keyfields;
    }

    public ImportLogger getImportLogger() {
        return this.importLogger;
    }

    public DynamicObject getOpEntity() {
        return this.opEntity;
    }

    public void setOpEntity(DynamicObject opEntity) {
        this.opEntity = opEntity;
    }

    public String getOptionCode() {
        return this.optionCode;
    }

    public void setOptionCode(String optionCode) {
        this.optionCode = optionCode;
    }

    public String getTempCode() {
        return this.tempCode;
    }

    public void putBaseDataIntoMap(String entityName, String importProp, String value) {
        List values;
        HashMap importValueMap = this.entityBaseDataRefMap.get(entityName);
        if (Objects.isNull(importValueMap)) {
            importValueMap = Maps.newHashMapWithExpectedSize((int)16);
            this.entityBaseDataRefMap.put(entityName, importValueMap);
        }
        if (Objects.isNull(values = (List)importValueMap.get(importProp))) {
            values = Lists.newArrayListWithExpectedSize((int)10);
            importValueMap.put(importProp, values);
        }
        values.add(value);
    }

    public Map<String, Map<String, List<String>>> getEntityBaseDataRefMap() {
        return this.entityBaseDataRefMap;
    }
}

