/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;

public class MultiImportHelper {
    private static final Log LOG = LogFactory.getLog(MultiImportHelper.class);

    public static Object getUser(String userId, String basedataEntityId, DynamicObject currUser, Map<String, Set<String>> entitySelectPropes) {
        if (currUser == null) {
            DynamicObject[] dynObjs = null;
            QFilter qFilter = new QFilter("id", "=", (Object)userId);
            Set<String> selectPropSet = MultiImportHelper.getbasedataProps(basedataEntityId, entitySelectPropes);
            dynObjs = BusinessDataServiceHelper.load((String)basedataEntityId, (String)String.join((CharSequence)",", selectPropSet), (QFilter[])new QFilter[]{qFilter});
            if (dynObjs == null) {
                return null;
            }
            currUser = dynObjs[0];
        }
        return currUser;
    }

    public static Set<String> getbasedataProps(String baseEntityId, Map<String, Set<String>> entitySelectPropes) {
        Set<String> entitySelectPropesValue = entitySelectPropes.get(baseEntityId);
        if (!CollectionUtils.isEmpty(entitySelectPropesValue)) {
            return entitySelectPropesValue;
        }
        return Sets.newHashSet((Object[])"id,name,number,status,enable".split(","));
    }

    public static void logOpFaileInfo(OperationResult op, ImportLogger importLogger, List<MultiEntityRowData> rowDataList) {
        Integer errorRowInteger = null;
        List operateInfos = op.getAllErrorOrValidateInfo();
        for (IOperateInfo info : operateInfos) {
            String pkId = String.valueOf(info.getPkValue());
            errorRowInteger = rowDataList.stream().filter(rowData -> HRStringUtils.equals((String)rowData.getOpEntity().getString("id"), (String)pkId)).map(rowData -> rowData.getRownum()).findFirst().orElse(-1);
            importLogger.log(errorRowInteger, String.join((CharSequence)",", info.getMessage()));
        }
    }

    public static void validateKeyFields(MultiEntityRowData rowdata, String entityId, ImportLogger importLogger, Map<String, String> keyfieldsMap) throws KDBizException {
        String keyfieldstr = keyfieldsMap.get(entityId);
        if (StringUtils.isEmpty((String)keyfieldstr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u672a\u6307\u5b9a\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c", (String)"MultiImportHelper_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        for (String key : keyfieldstr.split(",")) {
            if (Objects.isNull(rowdata.getEntityJson().get(entityId).get((Object)key))) {
                importLogger.log(rowdata.getRownum(), ResManager.loadKDString((String)"\u6570\u636e\u66ff\u6362\u552f\u4e00\u503c\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MultiImportHelper_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                continue;
            }
            rowdata.addKey(key);
        }
    }

    public static void feedbackProgressError(ImportContext conf, ImportLogger importLogger, List<ImportBillData> rowdatas) {
        for (ImportBillData bill : rowdatas) {
            Integer rownum = bill.getStartIndex();
            importLogger.log(rownum, ResManager.loadKDString((String)"\u6a21\u677f\u6570\u636e\u6821\u9a8c\u5f02\u5e38", (String)"MultiImportHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        int failedNum = importLogger.getLogCache().size();
        int total = failedNum + importLogger.getDelRows().size();
        importLogger.setFailed(failedNum);
        importLogger.setTotal(total);
        int lastEndIndex = rowdatas.get(rowdatas.size() - 1).getEndIndex();
        conf.feedbackProgress(Math.min(99, lastEndIndex * 100 / importLogger.getLastRowIndex()), importLogger, null);
        LOG.info(String.format(Locale.ROOT, "----import %s --batch--succeed=%d--failed=%d", importLogger.getSrcFile(), importLogger.getDelRows().size(), importLogger.getFailed()));
    }

    public static void feedbackProgressDealWith(ImportContext conf, ImportLogger importLogger, List<ImportBillData> rowdatas) {
        importLogger.getLogCache().remove(-1);
        int faileNum = importLogger.getLogCache().size();
        importLogger.setFailed(faileNum);
        importLogger.setTotal(importLogger.getFailed() + importLogger.getDelRows().size());
        int lastEndIndex = rowdatas.get(rowdatas.size() - 1).getEndIndex();
        conf.feedbackProgress(Math.min(99, lastEndIndex * 100 / importLogger.getLastRowIndex()), importLogger, null);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format(Locale.ROOT, "----import %s --batch--succeed=%d--failed=%d", importLogger.getSrcFile(), importLogger.getDelRows().size(), importLogger.getFailed()));
        }
    }

    public static Optional<Map<String, Object>> filterDataSetMap(MultiEntityRowData rowData, List<Map<String, Object>> resultList) {
        return resultList.stream().filter(dataSetMap -> {
            JSONObject jsonObject = rowData.getEntityJson().get(rowData.getMainEntity());
            for (String key : rowData.getKeyfields()) {
                if (HRStringUtils.equals((String)jsonObject.getString(key), (String)dataSetMap.get(key).toString())) continue;
                return false;
            }
            return true;
        }).findAny();
    }

    public static DynamicObject[] convertDy(List<MultiEntityRowData> rowDataList) {
        return (DynamicObject[])rowDataList.stream().filter(rowData -> Objects.nonNull(rowData.getOpEntity())).map(MultiEntityRowData::getOpEntity).toArray(DynamicObject[]::new);
    }
}

