/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.labelandreport;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.service.complexobj.util.JoinExprUtil;
import kd.hr.hbp.business.service.labelandreport.SelectEntityFieldUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.SelectFieldTreeNode;
import kd.hr.hbp.common.util.HRStringUtils;

public class SelectEntityFieldsPlugin
extends AbstractFormPlugin {
    private static final String TREE_VIEW = "treeviewap";
    private static final String TREE_ROOT_CACHE_KEY = "treeRoot";
    private static final String FIELD = "field";
    private static final String VALUE = "value";
    private static final String ENUM_VALUE = "enumvalue";
    private static final String MUL_ENUM_VALUE = "mulenumvalue";
    private static final String SET_VALUE = "setvalue";
    private static final String BASE_DATA_VALUE = "basedatavalue";
    private static final String BASE_DATA_ID = "basedataid";
    private static final String SELECT_VALUE = "selectvalue";
    private static final String VALUE_FLEX = "valueflex";
    private static final String STYLE = "style";
    private static final String CONTROL_TYPE_FLEX = "typeflex";
    private static final String CALLBACK_KEY_BASEDATA_F7 = "baseDataF7CloseCallBack";
    private static final Pattern numberPattern = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit baseDataValueEdit = (TextEdit)this.getControl(BASE_DATA_VALUE);
        baseDataValueEdit.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        TreeNode entityTreeNode;
        String entityNum = (String)this.getView().getFormShowParameter().getCustomParam("entityNum");
        String entityAlias = (String)this.getView().getFormShowParameter().getCustomParam("entityAlias");
        String entityType = (String)this.getView().getFormShowParameter().getCustomParam("entityType");
        boolean isLeftMainEntity = HRStringUtils.equals((String)entityType, (String)"main");
        String joinEntityNum = (String)this.getView().getFormShowParameter().getCustomParam("joinEntityNum");
        String joinEntityAlias = (String)this.getView().getFormShowParameter().getCustomParam("joinEntityAlias");
        String joinEntityType = (String)this.getView().getFormShowParameter().getCustomParam("joinEntityType");
        String otherParentAlias = (String)this.getView().getFormShowParameter().getCustomParam("otherParentAlias");
        boolean isRightMainEntity = HRStringUtils.equals((String)joinEntityType, (String)"main");
        boolean showHRPersonQuery = false;
        try {
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            parentPageId = this.getView().getViewNoPlugin(parentPageId).getFormShowParameter().getParentPageId();
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            String entityName = parentView.getModel().getDataEntityType().getExtendName();
            if ("hrcs_warnobjtpl".equalsIgnoreCase(entityName) || "hrcs_warnscene".equalsIgnoreCase(entityName)) {
                showHRPersonQuery = true;
            }
        }
        catch (Exception parentPageId) {
            // empty catch block
        }
        TreeView tv = (TreeView)this.getView().getControl(TREE_VIEW);
        String rootId = "root";
        TreeNode rootNode = new TreeNode(null, rootId, "all", true);
        rootNode.setIsOpened(true);
        if (HRStringUtils.equals((String)otherParentAlias, (String)entityAlias)) {
            TreeNode joinEntityTreeNode = this.getEntityTreeNode(joinEntityNum, joinEntityAlias, isRightMainEntity, rootId, showHRPersonQuery);
            rootNode.addChild(joinEntityTreeNode);
        } else if (HRStringUtils.equals((String)otherParentAlias, (String)joinEntityAlias)) {
            entityTreeNode = this.getEntityTreeNode(entityNum, entityAlias, isLeftMainEntity, rootId, showHRPersonQuery);
            rootNode.addChild(entityTreeNode);
        } else {
            entityTreeNode = this.getEntityTreeNode(entityNum, entityAlias, isLeftMainEntity, rootId, showHRPersonQuery);
            rootNode.addChild(entityTreeNode);
            TreeNode joinEntityTreeNode = this.getEntityTreeNode(joinEntityNum, joinEntityAlias, isRightMainEntity, rootId, showHRPersonQuery);
            rootNode.addChild(joinEntityTreeNode);
        }
        tv.addNode(rootNode);
        this.getPageCache().put(TREE_ROOT_CACHE_KEY, SerializationUtils.toJsonString((Object)rootNode));
        this.getView().setEnable(Boolean.FALSE, new String[]{"entity", "joinentity"});
        this.getView().setVisible(Boolean.FALSE, new String[]{VALUE_FLEX});
        String leftOrRight = (String)this.getView().getFormShowParameter().getCustomParam("leftOrRight");
        if (HRStringUtils.equals((String)leftOrRight, (String)"left")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_TYPE_FLEX});
        } else {
            String baseDataNum = (String)this.getView().getFormShowParameter().getCustomParam("baseDataNum");
            String rightType = (String)this.getView().getFormShowParameter().getCustomParam("rightType");
            if (HRStringUtils.equals((String)rightType, (String)VALUE)) {
                String rightVal = (String)this.getView().getFormShowParameter().getCustomParam("rightVal");
                if (HRStringUtils.isNotEmpty((String)baseDataNum)) {
                    String rightBaseDataIds = (String)this.getView().getFormShowParameter().getCustomParam("rightBaseDataId");
                    this.getView().setVisible(Boolean.TRUE, new String[]{VALUE_FLEX, BASE_DATA_VALUE});
                    this.getView().setVisible(Boolean.FALSE, new String[]{TREE_VIEW, VALUE});
                    this.getModel().setValue(STYLE, (Object)SELECT_VALUE);
                    rightBaseDataIds = HRStringUtils.isEmpty((String)rightBaseDataIds) ? rightVal : rightBaseDataIds;
                    LargeTextOtherEdit valueLargeTextEdit = (LargeTextOtherEdit)this.getControl(BASE_DATA_ID);
                    String tagFieldKey = valueLargeTextEdit.getTagFieldKey();
                    this.getModel().setValue(tagFieldKey, (Object)rightBaseDataIds);
                    this.getModel().setValue(BASE_DATA_VALUE, (Object)rightVal);
                } else if (this.leftIsEnumType()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{VALUE_FLEX});
                    this.getView().setVisible(Boolean.FALSE, new String[]{TREE_VIEW, BASE_DATA_VALUE, VALUE});
                    boolean isMulti = this.leftValueIsMulti();
                    this.getView().setVisible(Boolean.valueOf(isMulti), new String[]{MUL_ENUM_VALUE});
                    this.getView().setVisible(Boolean.valueOf(!isMulti), new String[]{ENUM_VALUE});
                    this.getModel().setValue(STYLE, (Object)SELECT_VALUE);
                    String enums = (String)this.getView().getFormShowParameter().getCustomParam("enums");
                    enums = this.removeSpecial(enums);
                    if (isMulti) {
                        this.getModel().setValue(MUL_ENUM_VALUE, (Object)enums);
                    } else {
                        this.getModel().setValue(ENUM_VALUE, (Object)enums);
                    }
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{VALUE_FLEX, VALUE});
                    this.getView().setVisible(Boolean.FALSE, new String[]{TREE_VIEW, BASE_DATA_VALUE});
                    this.getModel().setValue(STYLE, (Object)SET_VALUE);
                    this.getModel().setValue(VALUE, (Object)rightVal);
                }
            }
            if (HRStringUtils.isNotEmpty((String)baseDataNum)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SET_VALUE, ENUM_VALUE, MUL_ENUM_VALUE});
            } else if (this.leftIsEnumType()) {
                this.setEnumItems();
                this.getView().setVisible(Boolean.FALSE, new String[]{SET_VALUE, VALUE, BASE_DATA_VALUE});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_VALUE, ENUM_VALUE, MUL_ENUM_VALUE});
            }
        }
    }

    private String removeSpecial(String value) {
        ArrayList values = Lists.newArrayListWithCapacity((int)10);
        values.addAll(Arrays.stream(value.split(",")).filter(HRStringUtils::isNotEmpty).map(val -> val.substring(1, val.length() - 1)).collect(Collectors.toList()));
        return String.join((CharSequence)",", values);
    }

    private void setEnumItems() {
        String comboItemStr = (String)this.getView().getFormShowParameter().getCustomParam("comboItems");
        List valueMapItems = JSON.parseArray((String)comboItemStr, ValueMapItem.class);
        ComboEdit comboEdit = this.leftValueIsMulti() ? (ComboEdit)this.getView().getControl(MUL_ENUM_VALUE) : (ComboEdit)this.getView().getControl(ENUM_VALUE);
        ArrayList comboItems = Lists.newArrayListWithCapacity((int)10);
        for (ValueMapItem valueMapItem : valueMapItems) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(valueMapItem.getName());
            comboItem.setValue(valueMapItem.getValue());
            comboItems.add(comboItem);
        }
        comboEdit.setComboItems((List)comboItems);
    }

    private TreeNode getEntityTreeNode(String entityNum, String entityAlias, boolean isMainEntity, String rootId, boolean showHRPersonQuery) {
        SelectFieldTreeNode entityFieldBo = SelectEntityFieldUtil.getEntityFieldsShowHR((boolean)showHRPersonQuery, (String)entityNum, (String)entityAlias, (boolean)isMainEntity);
        TreeNode entityNode = new TreeNode(rootId, entityAlias, entityFieldBo.getName(), true);
        entityNode.setIsOpened(true);
        entityNode.setData(this.getFieldData(entityFieldBo));
        this.structureTreeView(entityNode, entityFieldBo.getChildren());
        return entityNode;
    }

    private void structureTreeView(TreeNode parent, List<SelectFieldTreeNode> entityFiledBos) {
        for (SelectFieldTreeNode entityFiledBo : entityFiledBos) {
            boolean isParent = entityFiledBo.getChildren() != null && !entityFiledBo.getChildren().isEmpty();
            TreeNode node = new TreeNode(parent.getId(), entityFiledBo.getFieldAlias(), entityFiledBo.getName(), isParent);
            node.setData(this.getFieldData(entityFiledBo));
            parent.addChild(node);
            if (!isParent) continue;
            this.structureTreeView(node, entityFiledBo.getChildren());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (HRStringUtils.equals((String)args.getProperty().getName(), (String)STYLE)) {
            ChangeData changeData = args.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            if (HRStringUtils.equals((String)newValue, (String)FIELD)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{TREE_VIEW});
                this.getView().setVisible(Boolean.FALSE, new String[]{VALUE_FLEX});
            } else if (HRStringUtils.equals((String)newValue, (String)SET_VALUE)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TREE_VIEW, BASE_DATA_VALUE});
                this.getView().setVisible(Boolean.TRUE, new String[]{VALUE_FLEX, VALUE});
                this.getView().setVisible(Boolean.FALSE, new String[]{ENUM_VALUE, MUL_ENUM_VALUE});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{TREE_VIEW, VALUE});
                this.getView().setVisible(Boolean.TRUE, new String[]{VALUE_FLEX});
                if (this.leftIsEnumType()) {
                    boolean isMulti = this.leftValueIsMulti();
                    this.getView().setVisible(Boolean.valueOf(!isMulti), new String[]{ENUM_VALUE});
                    this.getView().setVisible(Boolean.valueOf(isMulti), new String[]{MUL_ENUM_VALUE});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{BASE_DATA_VALUE});
                }
            }
        }
    }

    private boolean leftIsEnumType() {
        String comboItemStr = (String)this.getView().getFormShowParameter().getCustomParam("comboItems");
        return HRStringUtils.isNotEmpty((String)comboItemStr);
    }

    private boolean leftValueIsMulti() {
        String condition = (String)this.getView().getFormShowParameter().getCustomParam("condition");
        return HRStringUtils.equals((String)condition, (String)"in") || HRStringUtils.equals((String)condition, (String)"not in");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof TextEdit && HRStringUtils.equals((String)(key = ((TextEdit)evt.getSource()).getKey()), (String)BASE_DATA_VALUE)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String baseDataNum = (String)customParams.get("baseDataNum");
            String condition = (String)this.getView().getFormShowParameter().getCustomParam("condition");
            boolean isMultiSelect = HRStringUtils.equals((String)condition, (String)"in") || HRStringUtils.equals((String)condition, (String)"not in");
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)baseDataNum, (boolean)isMultiSelect);
            listShowParameter.setLookUp(true);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_BASEDATA_F7));
            LargeTextOtherEdit valueLargeTextEdit = (LargeTextOtherEdit)this.getControl(BASE_DATA_ID);
            String tagFieldKey = valueLargeTextEdit.getTagFieldKey();
            String value = (String)this.getModel().getValue(tagFieldKey);
            if (HRStringUtils.isNotEmpty((String)value)) {
                List<Object> strIds = Arrays.stream(value.split(",")).collect(Collectors.toList());
                String idType = (String)customParams.get("otherFieldType");
                if (HRStringUtils.equals((String)idType, (String)"long")) {
                    listShowParameter.setSelectedRows(strIds.stream().map(Long::parseLong).toArray());
                } else {
                    listShowParameter.setSelectedRows(strIds.toArray(new Object[0]));
                }
            }
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)evt.getActionId(), (String)CALLBACK_KEY_BASEDATA_F7) && (selectedRows = (ListSelectedRowCollection)evt.getReturnData()) != null && !selectedRows.isEmpty()) {
            List ids = selectedRows.stream().map(row -> row.getPrimaryKeyValue().toString()).collect(Collectors.toList());
            LargeTextOtherEdit valueLargeTextEdit = (LargeTextOtherEdit)this.getControl(BASE_DATA_ID);
            String tagFieldKey = valueLargeTextEdit.getTagFieldKey();
            this.getModel().setValue(tagFieldKey, (Object)String.join((CharSequence)",", ids));
            List names = selectedRows.stream().map(ListSelectedRow::getName).collect(Collectors.toList());
            this.getModel().setValue(BASE_DATA_VALUE, (Object)String.join((CharSequence)",", names));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String leftOrRight = (String)this.getView().getFormShowParameter().getCustomParam("leftOrRight");
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"ok")) {
            String otherFieldType;
            String valueType;
            TreeView tv;
            String focusNodeId;
            HashMap returnDataMap = Maps.newHashMapWithExpectedSize((int)16);
            if (HRStringUtils.equals((String)leftOrRight, (String)"right")) {
                String style = (String)this.getModel().getValue(STYLE);
                if (!HRStringUtils.equals((String)style, (String)FIELD)) {
                    this.returnRight(returnDataMap, args);
                    return;
                }
                returnDataMap.put("rightType", FIELD);
            }
            if (HRStringUtils.isEmpty((String)(focusNodeId = (tv = (TreeView)this.getView().getControl(TREE_VIEW)).getTreeState().getFocusNodeId()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u3002", (String)"SelectEntityFieldsPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String rootNodeStr = this.getPageCache().get(TREE_ROOT_CACHE_KEY);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            TreeNode treeNode = rootNode.getTreeNode(focusNodeId);
            Map data = (Map)treeNode.getData();
            if (data == null || !((Boolean)data.get("isField")).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u3002", (String)"SelectEntityFieldsPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String parentAlias = (String)tv.getTreeState().getFocusNode().get("parentid");
            if (parentAlias.contains(".")) {
                parentAlias = parentAlias.substring(0, parentAlias.indexOf(46));
            }
            if (!this.validateFieldType(args, valueType = (String)data.get("valueType"), otherFieldType = (String)this.getView().getFormShowParameter().getCustomParam("otherFieldType"))) {
                return;
            }
            String displayName = data.get("longName") + " | " + data.get("fieldAlias");
            returnDataMap.put("displayName", displayName);
            returnDataMap.put("valueType", valueType);
            returnDataMap.put("complexType", data.get("complexType"));
            returnDataMap.put("parentAlias", parentAlias);
            returnDataMap.put("entityAlias", data.get("entityAlias"));
            returnDataMap.putAll(data);
            this.getView().returnDataToParent((Object)returnDataMap);
        }
    }

    private void returnRight(Map<String, Object> returnDataMap, BeforeDoOperationEventArgs args) {
        String style = (String)this.getModel().getValue(STYLE);
        if (HRStringUtils.equals((String)style, (String)SET_VALUE)) {
            this.returnNormalValue(returnDataMap, args);
        } else if (HRStringUtils.equals((String)style, (String)SELECT_VALUE)) {
            if (this.leftIsEnumType()) {
                this.returnEnumValue(returnDataMap);
            } else {
                this.returnBaseDataValue(returnDataMap);
            }
        }
    }

    private void returnNormalValue(Map<String, Object> returnDataMap, BeforeDoOperationEventArgs args) {
        LargeTextOtherEdit valueLargeTextEdit = (LargeTextOtherEdit)this.getControl(VALUE);
        String tagFieldKey = valueLargeTextEdit.getTagFieldKey();
        String value = (String)this.getModel().getValue(tagFieldKey);
        String otherFieldType = (String)this.getView().getFormShowParameter().getCustomParam("otherFieldType");
        String condition = (String)this.getView().getFormShowParameter().getCustomParam("condition");
        if (this.validateValue(value, condition, otherFieldType)) {
            returnDataMap.put("displayName", value);
            returnDataMap.put("rightType", VALUE);
            this.getView().returnDataToParent(returnDataMap);
        } else {
            args.setCancel(true);
        }
    }

    private void returnEnumValue(Map<String, Object> returnDataMap) {
        String comboItemStr = (String)this.getView().getFormShowParameter().getCustomParam("comboItems");
        List valueMapItems = JSON.parseArray((String)comboItemStr, ValueMapItem.class);
        if (this.leftValueIsMulti()) {
            String enumValue = (String)this.getModel().getValue(MUL_ENUM_VALUE);
            ArrayList names = Lists.newArrayListWithCapacity((int)16);
            ArrayList ids = Lists.newArrayListWithCapacity((int)16);
            for (String enumItem : enumValue.split(",")) {
                if (HRStringUtils.isEmpty((String)enumItem)) continue;
                ids.add("'" + enumItem + "'");
                valueMapItems.stream().filter(item -> HRStringUtils.equals((String)item.getValue(), (String)enumItem)).findAny().ifPresent(item -> names.add(item.getName().getLocaleValue()));
            }
            returnDataMap.put("displayName", String.join((CharSequence)",", names));
            returnDataMap.put("enums", String.join((CharSequence)",", ids));
        } else {
            String enumValue = (String)this.getModel().getValue(ENUM_VALUE);
            Optional<ValueMapItem> itemOp = valueMapItems.stream().filter(item -> HRStringUtils.equals((String)item.getValue(), (String)enumValue)).findAny();
            if (itemOp.isPresent()) {
                returnDataMap.put("displayName", itemOp.get().getName().getLocaleValue());
                returnDataMap.put("enums", "'" + enumValue + "'");
            } else {
                return;
            }
        }
        returnDataMap.put("rightType", VALUE);
        this.getView().returnDataToParent(returnDataMap);
    }

    private void returnBaseDataValue(Map<String, Object> returnDataMap) {
        LargeTextOtherEdit valueLargeTextEdit = (LargeTextOtherEdit)this.getControl(BASE_DATA_ID);
        String tagFieldKey = valueLargeTextEdit.getTagFieldKey();
        String baseDataIdStr = (String)this.getModel().getValue(tagFieldKey);
        returnDataMap.put("displayName", this.getModel().getValue(BASE_DATA_VALUE));
        returnDataMap.put("baseDataIds", baseDataIdStr);
        returnDataMap.put("rightType", VALUE);
        this.getView().returnDataToParent(returnDataMap);
    }

    private boolean validateValue(String valueStr, String condition, String otherFieldType) {
        ArrayList values = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.equals((String)condition, (String)"in") || HRStringUtils.equals((String)condition, (String)"not in")) {
            values.addAll(Arrays.stream(valueStr.split(",")).collect(Collectors.toList()));
        } else {
            values.add(valueStr);
        }
        for (String value : values) {
            if (HRStringUtils.equals((String)otherFieldType, (String)DataTypeEnum.STRING.getDataTypeKey())) {
                if (!value.startsWith("'") || !value.endsWith("'")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u503c\u9700\u8981\u52a0\u5355\u5f15\u53f7\u3002", (String)"SelectEntityFieldsPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    return false;
                }
                int quoteCount = 0;
                for (char chr : value.toCharArray()) {
                    if (chr != '\'') continue;
                    ++quoteCount;
                }
                if (quoteCount <= 2) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u5f15\u53f7\u4e0d\u80fd\u91cd\u590d\u591a\u6b21\u3002", (String)"SelectEntityFieldsPlugin_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (HRStringUtils.equals((String)otherFieldType, (String)DataTypeEnum.LONG.getDataTypeKey()) || HRStringUtils.equals((String)otherFieldType, (String)DataTypeEnum.BIGDECIMAL.getDataTypeKey()) || HRStringUtils.equals((String)otherFieldType, (String)DataTypeEnum.INTEGER.getDataTypeKey())) {
                if (numberPattern.matcher(value).find()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u5b57\u4ee5\u586b\u5145\u6570\u503c\u7c7b\u578b\u7684\u503c\u3002", (String)"SelectEntityFieldsPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (HRStringUtils.equals((String)otherFieldType, (String)DataTypeEnum.DATETIME.getDataTypeKey())) {
                if (JoinExprUtil.isDateExpr((String)value)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u7c7b\u578b\u7684\u503c\u9700\u8981\u6309{ts'1995-10-01 00:00:00'}\u683c\u5f0f\u8f93\u5165\u3002", (String)"SelectEntityFieldsPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!HRStringUtils.equals((String)otherFieldType, (String)DataTypeEnum.BOOLEAN.getDataTypeKey()) || value.equals("'1'") || value.equals("'0'")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e03\u5c14\u7c7b\u578b\u7684\u503c\u5fc5\u987b\u662f'1'\u6216'0'\u3002", (String)"SelectEntityFieldsPlugin_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateFieldType(BeforeDoOperationEventArgs args, String thisFieldType, String otherFieldType) {
        if (HRStringUtils.isEmpty((String)otherFieldType)) {
            return true;
        }
        if (!HRStringUtils.equals((String)thisFieldType, (String)otherFieldType)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u540c\u7c7b\u578b\u5b57\u6bb5\u5173\u8054\uff0c\u8bf7\u66f4\u6539\u3002", (String)"SelectEntityFieldsPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> getFieldData(SelectFieldTreeNode fieldBo) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
        fieldMap.put("name", fieldBo.getName());
        fieldMap.put("longName", fieldBo.getLongName());
        fieldMap.put("number", fieldBo.getNumber());
        fieldMap.put("entityAlias", fieldBo.getEntityAlias());
        fieldMap.put("fieldAlias", fieldBo.getFieldAlias());
        fieldMap.put("valueType", fieldBo.getValueType());
        fieldMap.put("complexType", fieldBo.getComplexType());
        fieldMap.put("isField", fieldBo.getField());
        return fieldMap;
    }
}

