/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multiexpt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ExportProgressImpl;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.mvc.export.ListExporter;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.export.MultiEntityService;
import kd.hr.hbp.business.multimpt.MultiSheetListDataExporter;
import kd.hr.hbp.formplugin.web.multisheet.helper.MultiSheetHelper;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.springframework.util.LinkedMultiValueMap;

public class MultiSheetExportDataTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(MultiSheetExportDataTask.class);
    private static final String HR_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";
    private static final String ALGO_KEY = "MultiSheetExportDataTask.query";
    private Set<String> TRUE = Sets.newHashSet((Object[])new String[]{ResManager.loadKDString((String)"\u662f", (String)"MultiSheetExportDataTask_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"MultiSheetExportDataTask_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"MultiSheetExportDataTask_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"MultiSheetExportDataTask_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "true", "yes", "ok"});
    private ConcurrentHashMap<String, Object> params = new ConcurrentHashMap();
    private DynamicObject exportLogObj;
    private ExportProgress exportProgress;
    private IFormView parentView;
    private int currDataIndex = 0;
    private int curDataColIndex = 0;
    private SXSSFRow curRow;
    private ExportSheetStyle exportSheetStyle;
    private LinkedMultiValueMap<String, Object> conditionValueMap = new LinkedMultiValueMap();
    private HashMap<String, String> leftConditionFieldMap = new HashMap();
    private List<Object> mainIds = Lists.newArrayListWithCapacity((int)10);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDBizException {
        IFormView parentView;
        LOGGER.info("kd.hr.hbp.formplugin.web.multiexpt.MultiSheetExportDataTask execute start ---------");
        if (params != null) {
            this.params.putAll(params);
            Object custCtx = params.get("requestcontext");
            if (custCtx instanceof RequestContext) {
                RequestContext.set((RequestContext)((RequestContext)custCtx));
            } else if (custCtx != null) {
                RequestContext reqctx = (RequestContext)JSONObject.parseObject((String)custCtx.toString(), RequestContext.class);
                RequestContext.set((RequestContext)reqctx);
            }
        }
        if ((parentView = this.getParentView()) instanceof IListView) {
            this.exportLogObj = this.buildExportLogObj();
            try {
                LOGGER.info("kd.hr.hbp.formplugin.web.multiexpt.MultiSheetExportDataTask export start ---------");
                this.export(params);
                LOGGER.info("kd.hr.hbp.formplugin.web.multiexpt.MultiSheetExportDataTask export end ---------");
            }
            catch (Throwable throwable) {
                String errMsg = null;
                if (throwable instanceof KDBizException) {
                    errMsg = throwable.getMessage();
                } else if (SystemParamServiceHelper.isShowStackTrace()) {
                    errMsg = ListExporter.formatException((Throwable)throwable);
                }
                if (StringUtils.isBlank((String)errMsg)) {
                    errMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"MultiSheetExportDataTask_4", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]);
                }
                LOGGER.error(throwable);
                this.exportLogObj.set("logs", (Object)errMsg);
                this.exportLogObj.set("complete", (Object)0);
                throw new KDBizException(throwable, new ErrorCode("exportdataerror", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", (String)"MultiSheetExportDataTask_5", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0])), new Object[0]);
            }
            finally {
                this.saveExportLog();
                Object pkValue = this.exportLogObj.getPkValue();
                this.getExportProgress().feedbackLogId(pkValue);
                this.getExportProgress().feedbackFileUrl(this.exportLogObj.getString("downloadurl"));
                this.getExportProgress().complete();
            }
        } else {
            this.getExportProgress().fail(ResManager.loadKDString((String)"\u7236\u5217\u8868\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5\u83b7\u53d6\u9700\u8981\u5bfc\u51fa\u7684\u5355\u636e\u3002", (String)"MultiSheetExportDataTask_6", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void export(Map<String, Object> params) throws ParseException {
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)params.get("templateId"), (String)"hrcs_multientityimptmpl");
        MultiSheetListDataExporter multiSheetTemplate = MultiSheetHelper.getMultiSheetTemplate(templateData);
        DynamicObject mainEntityTmplDyo = templateData.getDynamicObject("mainentitytmpl");
        String mainBizObjNum = mainEntityTmplDyo.getString("bizobject.number");
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)mainBizObjNum);
        List formats = MultiEntityService.loadExportFormat((String)mainBizObjNum, (Long)((Long)mainEntityTmplDyo.getPkValue()));
        SXSSFSheet sheet = multiSheetTemplate.getSheet(mainEntity.getDisplayName().getLocaleValue());
        this.exportSheetData(mainBizObjNum, formats, sheet);
        DynamicObjectCollection assocEntityTmplDyoColl = templateData.getDynamicObjectCollection("assocentitytmplentry");
        for (DynamicObject dynamicObject : assocEntityTmplDyoColl) {
            DynamicObject assocEntityTmplDyo = dynamicObject.getDynamicObject("assocentitytmpl");
            String assocBizObjNum = assocEntityTmplDyo.getString("bizobject.number");
            MainEntityType assocEntityType = EntityMetadataCache.getDataEntityType((String)assocBizObjNum);
            List entryFormat = MultiEntityService.loadExportFormat((String)assocBizObjNum, (Long)((Long)assocEntityTmplDyo.getPkValue()));
            SXSSFSheet entrySheet = multiSheetTemplate.getSheet(assocEntityType.getDisplayName().getLocaleValue());
            this.exportSheetData(assocBizObjNum, entryFormat, entrySheet);
        }
        LocalDate now = LocalDate.now();
        String exportFileName = MultiSheetHelper.getExportFileName(now, templateData);
        String excelUrl = multiSheetTemplate.flush(null, new ExportFileEvent(this.getParentView(), (BillEntityType)mainEntity, exportFileName));
        String downloadUrl = this.getDownloadUrl(excelUrl, mainEntity.getName(), "4730fc9f000004ae");
        this.exportLogObj.set("downloadurl", (Object)downloadUrl);
        this.mainIds.clear();
    }

    private String getDownloadUrl(String surl, String entityId, String permId) {
        DisposableUrlParam param = new DisposableUrlParam();
        param.setEntityNum(entityId);
        param.setPath(surl);
        param.setPermItem(permId);
        param.setPkId((Object)0L);
        return AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)param);
    }

    private void exportSheetData(String bizObjNum, List<ExportWriterFormat> formats, SXSSFSheet sheet) throws ParseException {
        this.exportSheetStyle = new ExportSheetStyle(sheet.getWorkbook(), bizObjNum);
        DynamicObject[] dynamicObjects = this.getSheetSelectedData(bizObjNum);
        LOGGER.info("exportSheetData--entityNumber:{},selected data size:{}", (Object)bizObjNum, (Object)dynamicObjects.length);
        if (this.isImpt()) {
            sheet.getRow(0).setHidden(Boolean.TRUE);
            sheet.getRow(1).setHidden(Boolean.TRUE);
            sheet.getRow(2).setHidden(Boolean.TRUE);
        }
        this.currDataIndex = 4;
        this.exportSheetDataDes(sheet, formats.get(0), dynamicObjects, 0);
        int total = dynamicObjects.length + this.exportLogObj.getInt("total");
        this.exportLogObj.set("total", (Object)total);
        this.exportLogObj.set("complete", (Object)total);
    }

    private void exportSheetDataDes(SXSSFSheet sheet, ExportWriterFormat exportWriterFormat, DynamicObject[] billObjs, int colDataStartIndex) throws ParseException {
        for (DynamicObject dynamicObject : billObjs) {
            this.curDataColIndex = colDataStartIndex;
            this.curRow = ExcelWriter.getRow((SXSSFSheet)sheet, (int)this.currDataIndex);
            this.createRowCell(sheet, exportWriterFormat, dynamicObject);
            if (exportWriterFormat.next.size() > 0) {
                ExportWriterFormat entryExportWriterFormat = (ExportWriterFormat)exportWriterFormat.next.get(0);
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryExportWriterFormat.name);
                DynamicObject[] objects = (DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[0]);
                this.exportSheetDataDes(sheet, entryExportWriterFormat, objects, this.curDataColIndex);
                continue;
            }
            ++this.currDataIndex;
        }
        if (billObjs.length == 0) {
            ++this.currDataIndex;
        }
    }

    private void createRowCell(SXSSFSheet sheet, ExportWriterFormat exportWriterFormat, DynamicObject dynamicObject) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < exportWriterFormat.fields.size(); ++i) {
            Date date;
            List splitCols;
            String fieldName = (String)exportWriterFormat.fields.get(i);
            Map stringObjectMap = (Map)exportWriterFormat.properties.get(fieldName);
            Object inputType = stringObjectMap.get("InputType");
            boolean splitColFlag = "basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType);
            String replaceKey = exportWriterFormat.name + ".";
            String string = fieldName = fieldName.startsWith(replaceKey) ? fieldName.replaceFirst(replaceKey, "") : fieldName;
            if (this.curRow == null) break;
            if (dynamicObject.get(fieldName) == null) {
                if (splitColFlag) {
                    splitCols = (List)exportWriterFormat.flexColumn.get(fieldName);
                    for (String splitCol2 : splitCols) {
                        this.createCell(this.exportSheetStyle.getTextStyle(), dynamicObject.getString(splitCol2));
                        ++this.curDataColIndex;
                    }
                    continue;
                }
                this.createCell(this.exportSheetStyle.getTextStyle(), dynamicObject.getString(fieldName));
                ++this.curDataColIndex;
                continue;
            }
            if (inputType instanceof JSONArray) {
                HashMap dropdownSheet = Maps.newHashMapWithExpectedSize((int)16);
                ((JSONArray)inputType).forEach(obj -> {
                    String objStr = obj.toString();
                    if (objStr.contains("#")) {
                        String[] split = objStr.split("#", -1);
                        dropdownSheet.put(split[1].trim(), split[0].trim());
                    } else {
                        dropdownSheet.put(this.TRUE.contains(obj.toString()) ? "true" : "false", obj.toString());
                    }
                });
                this.createCell(this.exportSheetStyle.getTextStyle(), (String)dropdownSheet.get(dynamicObject.getString(fieldName)));
                ++this.curDataColIndex;
                continue;
            }
            if ("date".equals(inputType)) {
                date = dateFormat.parse(dynamicObject.getString(fieldName));
                this.createCell(this.exportSheetStyle.getDateStyle(), dateFormat.format(date));
                ++this.curDataColIndex;
                continue;
            }
            if ("time".equals(inputType)) {
                this.createCell(this.exportSheetStyle.getDatetimeStyle(), dynamicObject.getInt(fieldName) == -1 ? "" : timeFormat.format(dynamicObject.getInt(fieldName) * 1000 - 28800000));
                ++this.curDataColIndex;
                continue;
            }
            if ("datetime".equals(inputType)) {
                date = dateTimeFormat.parse(dynamicObject.getString(fieldName));
                this.createCell(this.exportSheetStyle.getDatetimeStyle(), dateTimeFormat.format(date));
                ++this.curDataColIndex;
                continue;
            }
            if ("decimal".equals(inputType)) {
                this.createCell(this.exportSheetStyle.getDecimalStyle(sheet.getWorkbook(), ((JSONObject)stringObjectMap.get("DecimalFormat")).getInnerMap()), dynamicObject.getBigDecimal(fieldName).compareTo(new BigDecimal(0)) == 0 ? "" : dynamicObject.getBigDecimal(fieldName).toPlainString());
                ++this.curDataColIndex;
                continue;
            }
            if (splitColFlag) {
                splitCols = (List)exportWriterFormat.flexColumn.get(fieldName);
                if (dynamicObject.get(fieldName) instanceof DynamicObjectCollection) {
                    DynamicObjectCollection multiDyColl = (DynamicObjectCollection)dynamicObject.get(fieldName);
                    splitCols.forEach(splitCol -> {
                        String[] subFieldNameArr = splitCol.split("\\.", 2);
                        String subFieldName = "fbasedataid." + subFieldNameArr[subFieldNameArr.length - 1];
                        StringBuilder fieldValueBuilder = new StringBuilder();
                        multiDyColl.forEach(dy -> fieldValueBuilder.append(dy.getString(subFieldName)).append(","));
                        String fieldValue = "";
                        if (fieldValueBuilder.length() > 1) {
                            fieldValue = fieldValueBuilder.substring(0, fieldValueBuilder.length() - 1);
                        }
                        this.createCell(this.exportSheetStyle.getTextStyle(), fieldValue);
                        ++this.curDataColIndex;
                    });
                    continue;
                }
                for (String splitCol2 : splitCols) {
                    this.createCell(this.exportSheetStyle.getTextStyle(), dynamicObject.getString(splitCol2));
                    ++this.curDataColIndex;
                }
                continue;
            }
            this.createCell(this.exportSheetStyle.getTextStyle(), dynamicObject.getString(fieldName));
            ++this.curDataColIndex;
        }
    }

    private void createCell(CellStyle cellStyle, String cellValue) {
        SXSSFCell cell = this.curRow.createCell(this.curDataColIndex);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(cellValue);
    }

    public boolean isDefaultExportListAll() {
        ListShowParameter showParameter = (ListShowParameter)this.getParentView().getFormShowParameter();
        if (!(showParameter instanceof ListShowParameter)) {
            return false;
        }
        ListUserOption listOption = showParameter.getListUserOption();
        if (listOption == null) {
            listOption = new ListUserOption();
        }
        return listOption.isDefaultExportListAll();
    }

    private DynamicObject[] getSheetSelectedData(String entityNumber) {
        BillList billList = this.getBillList();
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = listSelectedRows.getPrimaryKeyValues();
        boolean isNoSelect = primaryKeyValues == null || primaryKeyValues.length == 0;
        boolean defaultExportAll = this.isDefaultExportListAll();
        if (isNoSelect && defaultExportAll) {
            if (CollectionUtils.isEmpty(this.mainIds)) {
                FilterParameter filterParameter = billList.generalFilterParameter();
                String orderBy = StringUtils.isBlank((String)filterParameter.getOrderBy()) ? "" : filterParameter.getOrderBy();
                this.mainIds = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])filterParameter.getQFilters().toArray(new QFilter[0]), (String)orderBy, (int)-1);
            }
            primaryKeyValues = this.mainIds.toArray();
        }
        if (listSelectedRows.size() >= 0x100000 || primaryKeyValues != null && primaryKeyValues.length >= 0x100000) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u6570%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExportDataTask_3", (String)"bos-export", (Object[])new Object[0]), 0x100000));
        }
        this.constructConditionMap(primaryKeyValues);
        List conditionValue = this.conditionValueMap.get((Object)entityNumber);
        String leftConditionField = this.leftConditionFieldMap.get(entityNumber);
        LOGGER.info("getSheetSelectedData--entityNumber:{}--leftConditionField:{}", (Object)entityNumber, (Object)leftConditionField);
        if (conditionValue == null || StringUtils.isBlank((String)leftConditionField)) {
            String errMsg = String.format(Locale.ROOT, "can't not find conditionValue or leftConditionField,entityNumber:%s,leftConditionField:%s", entityNumber, leftConditionField);
            this.exportLogObj.set("logs", (Object)errMsg);
            return new DynamicObject[0];
        }
        QFilter qFilter = new QFilter(leftConditionField, "in", (Object)conditionValue);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
    }

    private void constructConditionMap(Object[] ids) {
        if (this.conditionValueMap.size() > 0) {
            return;
        }
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)this.params.get("templateId"), (String)"hrcs_multientityimptmpl");
        DynamicObjectCollection assocentitytmplentry = templateData.getDynamicObjectCollection("assocentitytmplentry");
        HashMap rightConditionFieldsMap = Maps.newHashMapWithExpectedSize((int)assocentitytmplentry.size());
        HashMap selectFieldsMap = Maps.newHashMapWithExpectedSize((int)assocentitytmplentry.size());
        this.constructConditionStepOne(assocentitytmplentry, rightConditionFieldsMap, selectFieldsMap);
        this.constructConditionStepTwo(ids, templateData, rightConditionFieldsMap, selectFieldsMap);
        this.constructConditionStepThree(assocentitytmplentry, rightConditionFieldsMap, selectFieldsMap);
    }

    private void constructConditionStepOne(DynamicObjectCollection assocEntityTmplEntry, HashMap<String, String> rightConditionFieldsMap, HashMap<String, String> selectFieldsMap) {
        for (DynamicObject dynamicObject : assocEntityTmplEntry) {
            String rightConditionCompute;
            String field;
            String relationRightProp;
            String assocEntityNumber = dynamicObject.getDynamicObject("assocentitytmpl").getString("bizobject.number");
            String relationLeftProp = dynamicObject.getString("relationleftprop");
            if (!StringUtils.isBlank((String)relationLeftProp)) {
                this.leftConditionFieldMap.put(assocEntityNumber, relationLeftProp.replaceFirst(assocEntityNumber + ".", ""));
            }
            if (StringUtils.isBlank((String)(relationRightProp = dynamicObject.getString("relationrightprop")))) continue;
            int dotIndex = relationRightProp.indexOf(46);
            String entityNumber = relationRightProp.substring(0, dotIndex);
            String selectFieldCompute = selectFieldsMap.computeIfPresent(entityNumber, (arg_0, arg_1) -> MultiSheetExportDataTask.lambda$constructConditionStepOne$3(field = relationRightProp.substring(dotIndex + 1), arg_0, arg_1));
            if (StringUtils.isEmpty((String)selectFieldCompute)) {
                selectFieldsMap.put(entityNumber, field);
            }
            if (!StringUtils.isEmpty((String)(rightConditionCompute = rightConditionFieldsMap.computeIfPresent(relationRightProp, (key, value) -> value + "," + assocEntityNumber)))) continue;
            rightConditionFieldsMap.put(relationRightProp, assocEntityNumber);
        }
    }

    private void constructConditionStepTwo(Object[] ids, DynamicObject templateData, HashMap<String, String> rightConditionFieldsMap, HashMap<String, String> selectFieldsMap) {
        DynamicObject mainEntityTmplDyo = templateData.getDynamicObject("mainentitytmpl");
        String mainBizObjNum = mainEntityTmplDyo.getString("bizobject.number");
        this.conditionValueMap.put((Object)mainBizObjNum, new LinkedList<Object>(Arrays.asList(ids)));
        this.leftConditionFieldMap.put(mainBizObjNum, "id");
        this.constructConditionValueMap(rightConditionFieldsMap, selectFieldsMap, mainBizObjNum, "id");
    }

    private void constructConditionStepThree(DynamicObjectCollection assocEntityTmplEntry, HashMap<String, String> conditionFieldsMap, HashMap<String, String> selectFieldsMap) {
        for (DynamicObject dynamicObject : assocEntityTmplEntry) {
            String assocEntityNum = dynamicObject.getDynamicObject("assocentitytmpl").getString("bizobject.number");
            if (!StringUtils.isNotEmpty((String)selectFieldsMap.get(assocEntityNum))) continue;
            String relationLeftProp = dynamicObject.getString("relationleftprop");
            this.constructConditionValueMap(conditionFieldsMap, selectFieldsMap, assocEntityNum, relationLeftProp);
        }
    }

    private void constructConditionValueMap(HashMap<String, String> conditionFieldsMap, HashMap<String, String> selectFieldsMap, String entityNum, String relationLeftProp) {
        QFilter qFilter = new QFilter(relationLeftProp.replaceFirst(entityNum + ".", ""), "in", (Object)this.conditionValueMap.get((Object)entityNum));
        String selectFields = selectFieldsMap.get(entityNum);
        DataSet rows = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)entityNum, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");
        while (rows.hasNext()) {
            String[] split;
            Row row = rows.next();
            for (String key : split = selectFields.split(",")) {
                Object object = row.get(key);
                String entityNumbers = conditionFieldsMap.get(entityNum + "." + key);
                Arrays.stream(entityNumbers.split(",")).forEach(entityNumber -> this.conditionValueMap.add(entityNumber, object));
            }
        }
    }

    public IFormView getParentView() {
        if (this.parentView == null) {
            String parentPageId = (String)this.params.get("parentpageid");
            if (StringUtils.isBlank((String)parentPageId)) {
                return null;
            }
            this.parentView = SessionManager.getCurrent().getView(parentPageId);
            ((AbstractListView)this.parentView).getEntityTypeId();
            IFormController srv = (IFormController)this.parentView.getService(IFormController.class);
            srv.registerListener();
        }
        return this.parentView;
    }

    private ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new ExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    private BillList getBillList() {
        return (BillList)this.getParentView().getControl("billlistap");
    }

    private String getExptType() {
        if (this.params.containsKey("expttype")) {
            return (String)this.params.get("expttype");
        }
        return this.isImpt() ? "3" : "2";
    }

    private boolean isImpt() {
        String type = (String)this.params.get("EXPORT_LIST_TYPE");
        if (StringUtils.isBlank((String)type)) {
            return false;
        }
        return type.equalsIgnoreCase("EXPT");
    }

    private DynamicObject buildExportLogObj() {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject obj = (DynamicObject)objType.createInstance();
        obj.set("bizobject", this.params.get("entityname"));
        obj.set("billstatus", (Object)"C");
        obj.set("exportstatus", (Object)"0");
        obj.set("createtime", (Object)TimeServiceHelper.now());
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        obj.set("expttype", (Object)this.getExptType());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_exportlog", obj, null);
        obj.set("billno", (Object)billno);
        obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        return obj;
    }

    private void saveExportLog() {
        this.exportLogObj.set("exportstatus", (Object)"1");
        this.exportLogObj.set("finishtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((IDataEntityType)this.exportLogObj.getDataEntityType(), (Object[])new DynamicObject[]{this.exportLogObj});
    }

    private static /* synthetic */ String lambda$constructConditionStepOne$3(String field, String key, String value) {
        if (!value.contains(field)) {
            value = value + "," + field;
        }
        return value;
    }
}

