/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimport;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.Map;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.imp.BatchImportSheetHandler;

public class HRMultiEntityFileParse {
    private static final Log LOG = LogFactory.getLog(HRMultiEntityFileParse.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveExcel(ImportContext ctx, Map<String, ImportLogger> importLoggerMap) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader excelReader = new ExcelReader();
        for (String url : ctx.getAllUrls()) {
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    excelReader.read(in, (SheetHandler)new BatchImportSheetHandler(ctx, url, importLoggerMap));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception exc) {
                ImportLogger logger = ctx.getLogger(url);
                String errMessage = exc.getMessage();
                if (exc instanceof KDBizException) {
                    logger.log(Integer.valueOf(0), errMessage);
                } else {
                    logger.log(Integer.valueOf(3), ImportLogger.formatException((Throwable)exc));
                }
                LOG.error((Throwable)exc);
                JSONObject json = new JSONObject();
                json.put("errCode", (Object)errMessage);
                ctx.getDataQueue(url).add(new ImportBillData(json, 0, 0, null));
            }
            finally {
                ctx.setResolveComplete(url);
            }
        }
    }
}

