/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.BasedataContianer;
import kd.hr.hbp.formplugin.web.imp.BasedataQueryDesc;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;

public class HRMultiEntityQueryBaseData {
    private static final Log LOG = LogFactory.getLog(HRMultiEntityQueryBaseData.class);

    public static void queryBaseDataRef(BasedataContianer contianer) {
        contianer.queryBaseDataRef();
    }

    public static void setDynamicObjValues(Map<String, ImportLogger> importLoggerMap, List<MultiEntityRowData> rowDataList, BasedataContianer contianer, Function<Map<String, Object>, Boolean> function) {
        rowDataList.forEach(rowData -> {
            ImportLogger importLogger = (ImportLogger)importLoggerMap.get(rowData.getMainEntity());
            HRMultiEntityQueryBaseData.setBasedataValues(rowData, importLogger, contianer, rowDataList, function);
            DynamicObject mainDy = rowData.getMainEntityDy();
            rowData.getEntityMap().forEach((key, importEntity) -> {
                if (!importEntity.isMainEntity() && !importEntity.isBaseRef()) {
                    DynamicObject subDy = rowData.getRowDynamicObject().get(key);
                    subDy.set(importEntity.getProperty(), (Object)mainDy);
                }
            });
        });
        Iterator<MultiEntityRowData> iterator = rowDataList.iterator();
        while (iterator.hasNext()) {
            MultiEntityRowData rowData2 = iterator.next();
            DynamicObject opEntity = HRMultiEntityQueryBaseData.convertToOpEntity(rowData2);
            if (Objects.isNull(opEntity)) {
                iterator.remove();
                continue;
            }
            rowData2.setOpEntity(opEntity);
        }
    }

    private static void setBasedataValues(MultiEntityRowData rowData, ImportLogger importLogger, BasedataContianer contianer, List<MultiEntityRowData> rowDataList, Function<Map<String, Object>, Boolean> function) {
        rowData.getEntityBasedataMap().entries().forEach(entry -> {
            String entityNumber = (String)entry.getKey();
            String fieldKey = (String)entry.getValue();
            String entryrntityKey = rowData.getRowDynamicObject().get(entityNumber).getDataEntityType().getProperties().getCollectionProperties(true).stream().filter(prop -> prop instanceof EntryProp).map(prop1 -> prop1.getName()).findAny().orElse("entryrntity");
            rowData.getEntityBaseDataRefMap().get(fieldKey).forEach((baseDataNum, baseDataValues) -> {
                for (String baseDataValue : baseDataValues) {
                    JSONObject jsonObject = rowData.getEntityJson().get(entityNumber);
                    String useOrgValue = "";
                    JSONObject baseDataImportJson = new JSONObject();
                    if (jsonObject.containsKey((Object)fieldKey)) {
                        baseDataImportJson = jsonObject.getJSONObject(fieldKey);
                        useOrgValue = baseDataImportJson.getOrDefault((Object)"useorgvalue", (Object)"").toString();
                    } else if (jsonObject.containsKey((Object)entryrntityKey) && StringUtils.isEmpty((Object)useOrgValue)) {
                        JSONObject finalBaseDataImportJson = baseDataImportJson;
                        baseDataImportJson = jsonObject.getJSONArray(entryrntityKey).stream().filter(ob -> ((JSONObject)ob).getJSONObject(fieldKey).containsValue((Object)baseDataValue)).map(ob1 -> ((JSONObject)ob1).getJSONObject(fieldKey)).findAny().orElseGet(() -> finalBaseDataImportJson);
                        useOrgValue = baseDataImportJson.getOrDefault((Object)"useorgvalue", (Object)"").toString();
                    }
                    ArrayList baseDataList = Lists.newArrayListWithCapacity((int)16);
                    baseDataList.addAll(contianer.getBasedata((String)baseDataNum, baseDataValue));
                    BasedataQueryDesc basedataQueryDesc = contianer.getBasedataProperty(fieldKey, useOrgValue);
                    if (CollectionUtils.isEmpty((Collection)baseDataList)) {
                        HRMultiEntityQueryBaseData.nonExistsInfo(rowData, baseDataValue, basedataQueryDesc);
                        continue;
                    }
                    HRMultiEntityQueryBaseData.handleBaseDataPerm(rowData, contianer, entityNumber, baseDataNum, baseDataList, baseDataImportJson, basedataQueryDesc);
                    HashMap<String, Object> functionParams = HRMultiEntityQueryBaseData.constructFunctionParams(rowData, rowDataList, entityNumber, fieldKey, baseDataNum, baseDataList, baseDataList);
                    boolean validatePass = (Boolean)function.apply(functionParams);
                    if (CollectionUtils.isEmpty((Collection)baseDataList) || !validatePass || basedataQueryDesc == null) continue;
                    DynamicObject entityDy = rowData.getRowDynamicObject().get(entityNumber);
                    if (HRMultiEntityQueryBaseData.checkIsEntryBaseData(basedataQueryDesc)) {
                        DynamicObjectCollection entityCol = entityDy.getDynamicObjectCollection(((DynamicProperty)basedataQueryDesc.getProp()).getParent().getName());
                        for (DynamicObject entityObj : entityCol) {
                            HRMultiEntityQueryBaseData.handleBasedata(rowData, importLogger, fieldKey, baseDataValue, baseDataList, entityObj, basedataQueryDesc);
                        }
                        continue;
                    }
                    HRMultiEntityQueryBaseData.handleBasedata(rowData, importLogger, fieldKey, baseDataValue, baseDataList, entityDy, basedataQueryDesc);
                }
            });
        });
    }

    private static void handleBaseDataPerm(MultiEntityRowData rowData, BasedataContianer contianer, String entityNumber, String baseDataNum, List<DynamicObject> baseDataList, JSONObject baseDataImportJson, BasedataQueryDesc basedataQueryDesc) {
        List<Long> orgPermScopeBasedata;
        String useOrg;
        String number = baseDataImportJson.getString("number");
        String name = baseDataImportJson.getString("name");
        Set<Long> permBasedata = contianer.getPermBasedata(entityNumber, baseDataNum);
        if (CollectionUtils.isEmpty(permBasedata) || !permBasedata.contains(baseDataList.get(0).getLong("id"))) {
            HRMultiEntityQueryBaseData.nonPermInfo(rowData, number, name);
        }
        if (HRStringUtils.isNotEmpty((String)(useOrg = basedataQueryDesc.getUseOrg()))) {
            List<Long> strategyPermBasedata = contianer.getStrategyPermBasedata(baseDataNum, useOrg);
            LOG.info("HRMultiEntityQueryBaseData--handleBaseDataPerm(),baseDataNum:{},useOrg:{},strategyPermBasedata:{}", new Object[]{baseDataNum, useOrg, strategyPermBasedata});
            if (baseDataList.size() > 1) {
                LOG.info("HRMultiEntityQueryBaseData--handleBaseDataPerm(),baseDataList:{}", baseDataList);
                baseDataList.removeAll(baseDataList.stream().filter(dy -> !dy.getString(basedataQueryDesc.getUseOrgJson().getString("useorgfieldkey") + "." + basedataQueryDesc.getUseOrgJson().getString("importprop")).equals(useOrg)).collect(Collectors.toList()));
                LOG.info("HRMultiEntityQueryBaseData--handleBaseDataPerm(),baseDataList.size:{}", (Object)baseDataList.size());
            }
            if (baseDataList.size() == 0) {
                HRMultiEntityQueryBaseData.nonStrategyPermInfo(rowData, number, name);
                return;
            }
            if (CollectionUtils.isEmpty(strategyPermBasedata) || !strategyPermBasedata.contains(baseDataList.get(0).getLong("id"))) {
                HRMultiEntityQueryBaseData.nonStrategyPermInfo(rowData, number, name);
            }
        }
        if (!CollectionUtils.isEmpty(orgPermScopeBasedata = contianer.getPermScopeBasedata(entityNumber, basedataQueryDesc.getProp().getName())) && !orgPermScopeBasedata.contains(baseDataList.get(0).getLong("id"))) {
            HRMultiEntityQueryBaseData.nonOrgPermScope(rowData, number, name);
        }
    }

    private static void nonExistsInfo(MultiEntityRowData rowData, String baseEntryValue, BasedataQueryDesc basedataProperty) {
        rowData.writeImportLogger(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67e5\u8be2\u5173\u8054\u5f15\u7528\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u201c%1$s.\u7f16\u7801\u6216\u540d\u79f0\u201d=%2$s", (String)"HRBatchImportPlugin_12", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), basedataProperty.getProp().getDisplayName().getLocaleValue(), baseEntryValue));
    }

    private static void nonPermInfo(MultiEntityRowData rowData, String baseDataNumValue, String baseDataNameValue) {
        String msg = StringUtils.isEmpty((Object)baseDataNumValue) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u540d\u79f0\u7684\u6570\u636e\u6743\u9650\u3002", (String)"HRBatchImportPlugin_23", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNameValue) : (StringUtils.isEmpty((Object)baseDataNameValue) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u7f16\u7801\u7684\u6570\u636e\u6743\u9650\u3002", (String)"HRBatchImportPlugin_24", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNumValue) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u7f16\u7801\u3001\u201c%2$s\u201d\u540d\u79f0\u7684\u6570\u636e\u6743\u9650\u3002", (String)"HRBatchImportPlugin_19", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNumValue, baseDataNameValue));
        rowData.writeImportLogger(msg);
    }

    private static void nonOrgPermScope(MultiEntityRowData rowData, String baseDataNumValue, String baseDataNameValue) {
        String msg = StringUtils.isEmpty((Object)baseDataNumValue) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u4e1a\u52a1\u7ec4\u7ec7\u7684\u6570\u636e\u6743\u9650\u3002", (String)"HRBatchImportPlugin_25", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNameValue) : (StringUtils.isEmpty((Object)baseDataNameValue) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u7f16\u7801\u7684\u6570\u636e\u6743\u9650\u3002", (String)"HRBatchImportPlugin_26", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNumValue) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u7f16\u7801\u3001\u201c%2$s\u201d\u540d\u79f0\u7684\u6570\u636e\u6743\u9650\u3002", (String)"HRBatchImportPlugin_27", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNumValue, baseDataNameValue));
        rowData.writeImportLogger(msg);
    }

    private static void nonStrategyPermInfo(MultiEntityRowData rowData, String baseDataNumValue, String baseDataNameValue) {
        String msg = StringUtils.isEmpty((Object)baseDataNumValue) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6839\u636e\u7ba1\u63a7\u7b56\u7565\uff0c\u6ca1\u6709\u201c%s\u201d\u540d\u79f0\u7684\u57fa\u7840\u8d44\u6599\u4f7f\u7528\u6743\u9650\u3002", (String)"HRBatchImportPlugin_21", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNameValue) : (StringUtils.isEmpty((Object)baseDataNameValue) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6839\u636e\u7ba1\u63a7\u7b56\u7565\uff0c\u6ca1\u6709\u201c%s\u201d\u7f16\u7801\u7684\u57fa\u7840\u8d44\u6599\u4f7f\u7528\u6743\u9650\u3002", (String)"HRBatchImportPlugin_22", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNumValue) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6839\u636e\u7ba1\u63a7\u7b56\u7565\uff0c\u6ca1\u6709\u201c%1$s\u201d\u7f16\u7801\u3001\u201c%2$s\u201d\u540d\u79f0\u7684\u57fa\u7840\u8d44\u6599\u4f7f\u7528\u6743\u9650\u3002", (String)"HRBatchImportPlugin_20", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseDataNumValue, baseDataNameValue));
        rowData.writeImportLogger(msg);
    }

    private static void handleBasedata(MultiEntityRowData rowData, ImportLogger importLogger, String fieldKey, String baseEntryValue, List<DynamicObject> filterRefList, DynamicObject entityDy, BasedataQueryDesc basedataProperty) {
        if (basedataProperty.getProp() instanceof MulBasedataProp) {
            String[] excelValues = baseEntryValue.split(",");
            MulBasedataDynamicObjectCollection mulBasedataCollection = (MulBasedataDynamicObjectCollection)entityDy.get(fieldKey);
            Map<Object, List<DynamicObject>> grouped = filterRefList.stream().collect(Collectors.groupingBy(dynamicObject -> {
                Object value = dynamicObject.get(basedataProperty.getImportKey());
                if (value instanceof ILocaleString) {
                    return ((ILocaleString)value).getLocaleValue();
                }
                return value;
            }));
            for (String excelValue : excelValues) {
                if (grouped.containsKey(excelValue)) continue;
                HRMultiEntityQueryBaseData.nonExistsInfo(rowData, excelValue, basedataProperty);
                return;
            }
            if (HRMultiEntityQueryBaseData.checkIsEntryBaseData(basedataProperty)) {
                JSONArray entityArray = rowData.getEntityJson().get(rowData.getMainEntity()).getJSONArray(entityDy.getDataEntityType().getName());
                String dbEntityId = String.valueOf(entityDy.getPkValue());
                for (int index = 0; index < entityArray.size(); ++index) {
                    String excelEntityDataValue;
                    JSONObject entityObj = entityArray.getJSONObject(index);
                    String entityId = entityObj.getString(entityDy.getDataEntityType().getName() + "." + "id");
                    if (!HRStringUtils.isNotEmpty((String)entityId) || !entityId.equals(dbEntityId)) continue;
                    JSONObject excelEntityObj = entityObj.getJSONObject(fieldKey);
                    if (Objects.nonNull(excelEntityObj) && baseEntryValue.equals(excelEntityDataValue = excelEntityObj.getString(basedataProperty.getImportKey()))) {
                        mulBasedataCollection.clear();
                        grouped.forEach((key, value) -> HRMultiEntityQueryBaseData.setMultiBaseDataValue(value, rowData, importLogger, baseEntryValue, mulBasedataCollection, basedataProperty));
                    }
                    break;
                }
            } else {
                grouped.forEach((key, value) -> HRMultiEntityQueryBaseData.setMultiBaseDataValue(value, rowData, importLogger, baseEntryValue, mulBasedataCollection, basedataProperty));
            }
        } else {
            if (HRMultiEntityQueryBaseData.checkIsEntryBaseData(basedataProperty)) {
                JSONArray entityArray = rowData.getEntityJson().get(rowData.getMainEntity()).getJSONArray(entityDy.getDataEntityType().getName());
                String dbEntityId = String.valueOf(entityDy.getPkValue());
                for (int index = 0; index < entityArray.size(); ++index) {
                    JSONObject entityObj = entityArray.getJSONObject(index);
                    String entityId = entityObj.getString(entityDy.getDataEntityType().getName() + "." + "id");
                    if (!HRStringUtils.isNotEmpty((String)entityId) || !entityId.equals(dbEntityId)) continue;
                    HRMultiEntityQueryBaseData.updateEntityDyBaseDataField(entityObj, fieldKey, filterRefList, entityDy);
                    break;
                }
            } else {
                entityDy.set(fieldKey, (Object)filterRefList.get(0));
            }
            if (filterRefList.size() > 1) {
                HRMultiEntityQueryBaseData.baseDataRepeatTip(rowData, importLogger, baseEntryValue, basedataProperty);
            }
        }
    }

    private static void setMultiBaseDataValue(List<DynamicObject> value, MultiEntityRowData rowData, ImportLogger importLogger, String baseEntryValue, MulBasedataDynamicObjectCollection mulBasedataCollection, BasedataQueryDesc basedataProperty) {
        if (value.size() > 1) {
            HRMultiEntityQueryBaseData.multiBaseDataRepeatTip(rowData, importLogger, baseEntryValue, basedataProperty);
        } else {
            DynamicObject basedata = value.get(0);
            DynamicObject dynamicObject = mulBasedataCollection.addNew();
            dynamicObject.set("pkid", (Object)DB.genLongId((String)dynamicObject.getDataEntityType().getAlias()));
            dynamicObject.set("fbasedataid_id", basedata.getPkValue());
            dynamicObject.set("fbasedataid", (Object)basedata);
        }
    }

    private static void updateEntityDyBaseDataField(JSONObject entityObj, String fieldKey, List<DynamicObject> filterRefList, DynamicObject entityDy) {
        String excelValue;
        DynamicObject baseData;
        String baseDataKeyValue;
        String importProp;
        JSONObject excelEntityObj = entityObj.getJSONObject(fieldKey);
        if (Objects.nonNull(excelEntityObj) && !StringUtils.isEmpty((Object)(importProp = excelEntityObj.getString("importprop"))) && (baseDataKeyValue = (baseData = filterRefList.get(0)).getString(importProp)).equalsIgnoreCase(excelValue = excelEntityObj.getString(importProp))) {
            entityDy.set(fieldKey, (Object)baseData);
        }
    }

    private static HashMap<String, Object> constructFunctionParams(MultiEntityRowData rowData, List<MultiEntityRowData> rowDataList, String entityNumber, String fieldKey, String baseDataEntityNum, List<DynamicObject> baseDataList, List<DynamicObject> filterRefList) {
        HashMap functionParams = Maps.newHashMapWithExpectedSize((int)16);
        functionParams.put("baseDataList", baseDataList);
        functionParams.put("fieldKey", fieldKey);
        functionParams.put("entityNumber", entityNumber);
        functionParams.put("baseDataEntityNum", baseDataEntityNum);
        functionParams.put("currentRow", rowData);
        functionParams.put("rowDataList", rowDataList);
        functionParams.put("filterRefList", filterRefList);
        return functionParams;
    }

    private static void multiBaseDataRepeatTip(MultiEntityRowData rowData, ImportLogger importLogger, String baseEntryValue, BasedataQueryDesc basedataProperty) {
        importLogger.log(rowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u7f16\u7801\u6216\u540d\u79f0\u201c%1$s\u201d\u7684{%2$s}\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"HRBatchImportPlugin_11", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseEntryValue, basedataProperty.getProp().getDisplayName().getLocaleValue()));
    }

    private static void baseDataRepeatTip(MultiEntityRowData rowData, ImportLogger importLogger, String baseEntryValue, BasedataQueryDesc basedataProperty) {
        importLogger.log(rowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u7f16\u7801\u6216\u540d\u79f0\u201c%1$s\u201d\u7684{%2$s}\u6216\u5355\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u586b\u5199\u4e86\u591a\u4e2a\u7f16\u7801\u548c\u540d\u79f0\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"HRBatchImportPlugin_17", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), baseEntryValue, basedataProperty.getProp().getDisplayName().getLocaleValue()));
    }

    private static DynamicObject convertToOpEntity(MultiEntityRowData rowData) {
        return rowData.getRowDynamicObject().get(rowData.getMainEntity());
    }

    private static boolean checkIsEntryBaseData(BasedataQueryDesc queryDesc) {
        return ((DynamicProperty)queryDesc.getProp()).getParent() instanceof EntryType;
    }
}

