/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimport;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;

public class HRMultiEntityUpdate {
    private static final List<Class<? extends DynamicProperty>> TEXT_TYPE_PROPS = Lists.newArrayList((Object[])new Class[]{TextProp.class, VarcharProp.class, ComboProp.class, PictureProp.class});
    private static final List<Class<? extends DynamicProperty>> LONG_TYPE_PROPS = Lists.newArrayList((Object[])new Class[]{LongProp.class});

    public static void queryBatchExistsRowDynamicObj(List<MultiEntityRowData> rowDataList, Map<String, String> entityQueryFieldMap, String optionCode, Set<Object> updateIds) {
        Map<String, List<MultiEntityRowData>> sheetGroupList = rowDataList.stream().collect(Collectors.groupingBy(MultiEntityRowData::getMainEntity));
        sheetGroupList.forEach((entityId, sheetDataList) -> {
            List<Map<String, Object>> resultList = HRMultiEntityUpdate.queryBatchExistsRowDynamicObj(sheetDataList, entityId, entityQueryFieldMap);
            if (resultList.size() > 0) {
                List<DynamicObject> dbDyList = HRMultiEntityUpdate.queryDbDys(resultList, entityId);
                HRMultiEntityUpdate.updateSheetData(resultList, dbDyList, entityId, sheetDataList, optionCode, updateIds);
            } else if ("override".equals(optionCode)) {
                sheetDataList.forEach(HRMultiEntityUpdate::logUpdateFindDbNoData);
            }
        });
    }

    private static void logUpdateFindDbNoData(MultiEntityRowData row) {
        StringBuilder keyMsg = new StringBuilder();
        for (String keyField : row.getKeyfields()) {
            DynamicProperty property = ((DynamicObjectType)row.getMainEntityDy().getDataEntityType()).getProperty(keyField);
            keyMsg.append(Objects.nonNull(property.getDisplayName()) ? property.getDisplayName().getLocaleValue() : property.getName()).append("=").append(Objects.nonNull(row.getEntityJson().get(row.getMainEntity()).get((Object)keyField)) ? row.getEntityJson().get(row.getMainEntity()).get((Object)keyField) : "").append(",");
        }
        keyMsg.deleteCharAt(keyMsg.length() - 1);
        row.writeImportLogger(MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u7cfb\u7edf\u627e\u4e0d\u5230\u201c{0}\u201d\u7684\u6570\u636e\u884c\u3002", (String)"HRMultiEntityUpdate_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), keyMsg.toString()));
    }

    private static List<Map<String, Object>> queryBatchExistsRowDynamicObj(List<MultiEntityRowData> sheetDataList, String entityId, Map<String, String> entityQueryFieldMap) {
        DynamicObject[] results;
        HashMap sourceValueMap = Maps.newHashMapWithExpectedSize((int)sheetDataList.size());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        sheetDataList.forEach(rowData -> rowData.getKeyfields().forEach(key -> {
            DynamicProperty property = mainEntityType.getProperty(key);
            Object value = rowData.getEntityJson().get(rowData.getMainEntity()).get(key);
            key = property instanceof BasedataProp ? key + "." + ((JSONObject)value).getString("importprop") : key;
            List queryFieldList = (List)sourceValueMap.get(key);
            if (Objects.isNull(queryFieldList)) {
                queryFieldList = Lists.newArrayListWithExpectedSize((int)(sheetDataList.size() * rowData.getKeyfields().size()));
                sourceValueMap.put(key, queryFieldList);
            }
            queryFieldList.add(HRMultiEntityUpdate.changeValueType(value, property));
        }));
        QFilter batchQFilter = null;
        for (Map.Entry entry : sourceValueMap.entrySet()) {
            if (batchQFilter == null) {
                batchQFilter = new QFilter((String)entry.getKey(), "in", entry.getValue());
                continue;
            }
            batchQFilter.and(new QFilter((String)entry.getKey(), "in", entry.getValue()));
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)16);
        String selectFields = entityQueryFieldMap.get(entityId);
        if (selectFields != null && !selectFields.contains(",id,")) {
            selectFields = "id," + selectFields;
        }
        for (DynamicObject result : results = new HRBaseServiceHelper(entityId).query(selectFields, new QFilter[]{batchQFilter})) {
            HashMap rowMap = Maps.newHashMapWithExpectedSize((int)16);
            DataEntityPropertyCollection properties = result.getDynamicObjectType().getProperties();
            properties.forEach(property -> rowMap.put(property.getName(), result.get(property.getName())));
            resultList.add(rowMap);
        }
        return resultList;
    }

    private static List<DynamicObject> queryDbDys(List<Map<String, Object>> resultList, String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String mainEntityFields = properties.stream().filter(filed -> !Objects.equals(filed.getName(), "multilanguagetext") && (filed instanceof LongProp && !((LongProp)filed).isRefId() || !(filed instanceof LongProp))).map(IMetadata::getName).collect(Collectors.joining(","));
        Optional<IDataEntityProperty> entryOptional = properties.stream().filter(propertie -> propertie instanceof EntryProp).findFirst();
        if (entryOptional.isPresent()) {
            DynamicObjectType entryPropertyType = ((EntryProp)entryOptional.get()).getDynamicCollectionItemPropertyType();
            String entryName = entryPropertyType.getName();
            StringJoiner joiner = new StringJoiner(",");
            if (entryPropertyType.getProperties().size() > 0) {
                mainEntityFields = mainEntityFields + ",";
            }
            HashSet baseDataIdSet = Sets.newHashSetWithExpectedSize((int)entryPropertyType.getProperties().size());
            for (IDataEntityProperty field : entryPropertyType.getProperties()) {
                if (field instanceof BasedataProp) {
                    baseDataIdSet.add(entryName + "." + field.getName());
                }
                if ("multilanguagetext".equals(field.getName())) continue;
                String fieldTemp = entryName + "." + field.getName();
                joiner.add(fieldTemp);
            }
            mainEntityFields = mainEntityFields + joiner;
            for (String baseDataId : baseDataIdSet) {
                mainEntityFields = mainEntityFields.replaceAll("," + baseDataId + "_id", "");
            }
        }
        List pkList = resultList.stream().map(el -> el.get("id")).collect(Collectors.toList());
        Object[] dbDyArrays = new HRBaseServiceHelper(entityNumber).query(mainEntityFields, new QFilter[]{new QFilter("id", "in", pkList)});
        return Lists.newArrayList((Object[])dbDyArrays);
    }

    private static void updateSheetData(List<Map<String, Object>> resultList, List<DynamicObject> dbDyList, String entityId, List<MultiEntityRowData> rowDataList, String optionCode, Set<Object> updateIndex) {
        for (MultiEntityRowData rowData : rowDataList) {
            List<Map<String, Object>> optMapList = HRMultiEntityUpdate.filterDataSetMap(rowData, resultList);
            if (optMapList.size() > 1) {
                ImportLogger importLogger = rowData.getImportLogger();
                StringBuilder stringBuilder = new StringBuilder();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
                dataEntityType.getProperties().forEach(property -> {
                    if (rowData.getKeyfields().contains(property.getName())) {
                        stringBuilder.append(property.getDisplayName().getLocaleValue()).append('+');
                    }
                });
                importLogger.log(rowData.getRownum(), ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u552f\u4e00\u503c\u5b57\u6bb5\u201c%s\u201d\uff0c\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"HRMultiEntityUpdate_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[]{stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : ""}));
                continue;
            }
            if (optMapList.size() > 0) {
                DynamicObject[] updateData = (DynamicObject[])dbDyList.stream().filter(el -> el.get("id").equals(((Map)optMapList.get(0)).get("id"))).toArray(DynamicObject[]::new);
                rowData.updateRowDyFromDataSetMap(optMapList.get(0), updateData[0], entityId);
                updateIndex.add(rowData.getRowDynamicObject().get(entityId).getPkValue());
                continue;
            }
            if (!"override".equals(optionCode)) continue;
            HRMultiEntityUpdate.logUpdateFindDbNoData(rowData);
        }
    }

    private static List<Map<String, Object>> filterDataSetMap(MultiEntityRowData rowData, List<Map<String, Object>> resultList) {
        return resultList.stream().filter(dataSetMap -> {
            JSONObject jsonObject = rowData.getEntityJson().get(rowData.getMainEntity());
            for (String key : rowData.getKeyfields()) {
                if (jsonObject.get((Object)key) instanceof Map && dataSetMap.get(key) instanceof Map) {
                    String locale = RequestContext.get().getLang().name();
                    if (Objects.equals(((Map)jsonObject.get((Object)key)).get(locale), ((Map)dataSetMap.get(key)).get(locale))) continue;
                    return false;
                }
                if (jsonObject.get((Object)key) instanceof JSONObject && jsonObject.getJSONObject(key).containsKey((Object)"importprop")) {
                    String importprop = jsonObject.getJSONObject(key).getString("importprop");
                    if (HRStringUtils.equals((String)jsonObject.getJSONObject(key).getString(importprop), (String)((DynamicObject)dataSetMap.get(key)).getString(importprop))) continue;
                    return false;
                }
                if (HRStringUtils.equals((String)jsonObject.getString(key), (String)dataSetMap.get(key).toString())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private static Object changeValueType(Object value, DynamicProperty property) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (HRMultiEntityUpdate.instanceOf(property, LONG_TYPE_PROPS)) {
            return Long.valueOf(String.valueOf(value));
        }
        if (property instanceof MuliLangTextProp) {
            Map multiLangMap = (Map)value;
            return multiLangMap.get(RequestContext.get().getLang().name());
        }
        if (HRMultiEntityUpdate.instanceOf(property, TEXT_TYPE_PROPS)) {
            return String.valueOf(value);
        }
        if (property instanceof BasedataProp) {
            return ((JSONObject)value).getString(((JSONObject)value).getString("importprop"));
        }
        return value;
    }

    public static boolean instanceOf(DynamicProperty property, List<Class<? extends DynamicProperty>> classes) {
        if (property == null || classes == null) {
            return false;
        }
        Class<?> propClass = property.getClass();
        for (Class<? extends DynamicProperty> tmp : classes) {
            if (!tmp.isAssignableFrom(propClass)) continue;
            return true;
        }
        return false;
    }
}

