/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimport;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.formplugin.web.imp.HRSheetHandler;
import kd.hr.hbp.formplugin.web.imp.ImportHelper;
import kd.hr.hbp.formplugin.web.multisheet.helper.MultiSheetHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.xml.sax.SAXException;

public class MultiEntityImportFailedSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(MultiEntityImportFailedSheetHandler.class);
    private static final String COLOR = "color";
    private final int ERR_ROW_COUNT = 5000;
    private boolean hasErrorCol;
    private SXSSFWorkbook book;
    private Map<String, CellStyle> styles = new HashMap<String, CellStyle>();
    private ImportLogger importLogger;
    private FileService service;
    private ImportContext ctx;
    private SheetHandler.ParsedRow currentRow;
    private Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>();
    private boolean isDistributeFullData;
    private Map<String, ImportLogger> importLoggerMap;
    private Map<String, String> sheetToEntity = Maps.newHashMap();
    private int cursorRow;
    private boolean isDropdownItemsSheet = false;
    private Map<String, SXSSFRow> nameRows = new HashMap<String, SXSSFRow>();

    public MultiEntityImportFailedSheetHandler(ImportContext ctx, ImportLogger importLogger, FileService service, Map<String, ImportLogger> importLoggerMap, boolean isDistributeFullData) {
        this.setInterrupt(false);
        this.ctx = ctx;
        this.importLogger = importLogger;
        this.service = service;
        importLogger.getDelRows().sort(Comparator.comparingInt(o -> o[0]));
        this.importLoggerMap = importLoggerMap;
        this.isDistributeFullData = isDistributeFullData;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            if (this.book == null) {
                this.book = new SXSSFWorkbook(1000);
                this.book.setCompressTempFiles(true);
            }
            sheet = this.book.createSheet(row.getSheetName());
            sheet.setColumnWidth(0, 10000);
            this.isDropdownItemsSheet = row.getSheetName().startsWith("DDM_");
            if (!this.isDropdownItemsSheet) {
                Map dataJson = row.getData();
                if (StringUtils.isBlank((CharSequence)((CharSequence)dataJson.get(0)))) {
                    this.sheetToEntity.put(row.getSheetName(), ((String)dataJson.get(1)).split("#")[1]);
                } else {
                    this.sheetToEntity.put(row.getSheetName(), ((String)dataJson.get(0)).split("#")[1]);
                }
            }
            this.sheets.put(row.getSheetName(), sheet);
            this.cursorRow = 0;
        }
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        if (this.isDropdownItemsSheet) {
            this.handleDropdownSheet(sheet, currRowNum);
            return;
        }
        this.handleWorkSheet(row, sheet, currRowNum);
    }

    private void handleWorkSheet(SheetHandler.ParsedRow row, SXSSFSheet sheet, int currRowNum) {
        String entityName;
        if (currRowNum == 0 && (StringUtils.isBlank((CharSequence)(entityName = this.currentRow.get(Integer.valueOf(0)))) || !entityName.contains("#"))) {
            this.hasErrorCol = true;
        }
        if (currRowNum == 3) {
            SXSSFRow nameRow = this.getRow(sheet, currRowNum);
            this.nameRows.put(row.getSheetName(), nameRow);
            nameRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"MultiEntityImportFailedSheetHandler_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        } else if (currRowNum > 3 && !this.getLogStr(sheet, currRowNum, 3) && !this.isDistributeFullData) {
            return;
        }
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            this.putSXSSFSheet(sheet, this.cursorRow, 3, entry);
        }
        ++this.cursorRow;
    }

    private void putSXSSFSheet(SXSSFSheet sheet, int currRowNum, int titleRowIndex, Map.Entry<Integer, String> entry) {
        JSONObject styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
        int cellIndex = this.countIndex(entry.getKey());
        SXSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        if (currRowNum == titleRowIndex) {
            int cellWidth;
            styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
            if (entry.getValue().startsWith("*")) {
                styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            }
            if ((cellWidth = ImportHelper.calcColumnWidth(entry.getValue(), 0)) > sheet.getColumnWidth(cellIndex)) {
                sheet.setColumnWidth(cellIndex, cellWidth);
            }
        }
        if (currRowNum == 1) {
            CellStyle textHighLightStyle = new ExportSheetStyle(sheet.getWorkbook(), "").getTextHighLightStyle();
            textHighLightStyle.setWrapText(true);
            sxssfCell.setCellStyle(textHighLightStyle);
            String cellValue = entry.getValue();
            int lineSeparatorIndex = cellValue.indexOf(System.getProperty("line.separator"));
            cellValue = lineSeparatorIndex > 0 ? cellValue.substring(0, lineSeparatorIndex) : cellValue;
            sheet.setColumnWidth(cellIndex, ImportHelper.calcColumnWidth(cellValue, 0));
        } else {
            CellStyle customCellStyle = this.getCellStyle(styleObj);
            if (customCellStyle != null) {
                sxssfCell.setCellStyle(customCellStyle);
            }
        }
        String fmt = styleObj.getString("fmt");
        if (StringUtils.isNotBlank((CharSequence)fmt)) {
            try {
                sxssfCell.setCellValue(new BigDecimal(entry.getValue()).doubleValue());
            }
            catch (NumberFormatException e) {
                sxssfCell.setCellValue(entry.getValue());
            }
        } else {
            sxssfCell.setCellValue(entry.getValue());
        }
    }

    private boolean getLogStr(SXSSFSheet sheet, int currRowNum, int titleRowIndex) {
        String entityName = this.sheetToEntity.get(sheet.getSheetName());
        List logs = Optional.ofNullable(this.importLoggerMap.get(entityName)).map(importLoggers -> importLoggers.getLogCache()).map(importLogger -> (List)importLogger.get(currRowNum)).orElseGet(Lists::newArrayList);
        if (!logs.isEmpty()) {
            String mergeLogStr;
            if (currRowNum - titleRowIndex <= 5000) {
                StringBuilder sb = new StringBuilder();
                for (ImportLogger.ImportLog importLog : logs) {
                    if (!importLog.toString().endsWith(";")) {
                        sb.append(importLog.toString()).append(";");
                    } else {
                        sb.append(importLog.toString());
                    }
                    sb.append(System.lineSeparator());
                    if (sb.length() <= 4000) continue;
                    sb.replace(3997, 4000, "...").setLength(4000);
                    break;
                }
                mergeLogStr = sb.toString();
            } else {
                mergeLogStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u884c\u6570\u636e\u3002", (String)"MultiEntityImportFailedSheetHandler_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            }
            SXSSFCell cell = this.getRow(sheet, this.cursorRow).createCell(0);
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            cell.setCellStyle(this.getCellStyle(styleObj));
            cell.setCellValue(mergeLogStr);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void handleDropdownSheet(SXSSFSheet sheet, int currRowNum) {
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(((Integer)entry.getKey()).intValue());
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)entry.getValue());
        }
    }

    private int countIndex(int index) {
        return ++index;
    }

    private CellStyle getCellStyle(JSONObject style) {
        String defaultFmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short backGround = style.getShort("bg");
        Short titleColor = style.getShort(COLOR);
        String styleStr = String.format(Locale.ROOT, "%s_-_%d_-_%d_-_%s", defaultFmt, backGround, titleColor, align);
        CellStyle customCellStyle = this.styles.get(styleStr);
        if (customCellStyle == null) {
            customCellStyle = HRSheetHandler.getCellStyle(defaultFmt, backGround, titleColor, styleStr, this.styles, this.book);
        }
        return customCellStyle;
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int intdexRow) {
        SXSSFRow row = sheet.getRow(intdexRow);
        if (row == null) {
            row = sheet.createRow(intdexRow);
        }
        return row;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        boolean flag = MultiSheetHelper.handSheetNames(this.getSheetNames(), this.getSheetName());
        this.setInterrupt(flag);
        if (!flag) {
            return;
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            HashSet ddlSheetIndex = new HashSet();
            this.book.forEach(sheet -> {
                if (sheet.getSheetName().contains("DDM_") && this.book.getSheetIndex(sheet.getSheetName()) >= 0) {
                    ddlSheetIndex.add(this.book.getSheetIndex(sheet.getSheetName()));
                }
            });
            ddlSheetIndex.forEach(index -> this.book.setSheetHidden(index.intValue(), true));
            this.book.write((OutputStream)os);
            byte[] data = os.toByteArray();
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            LocalDate now = LocalDate.now();
            String dateStr = String.format(Locale.ROOT, "%02d%02d", now.getMonthValue(), now.getDayOfMonth());
            String tempFileName = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_%1$s_%2$s.xlsx\u3002", (String)"MultiEntityImportFailedSheetHandler_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), this.ctx.getListName(), dateStr);
            String fileName = tempFileName.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
            String url = tempFile.saveAsUrl(fileName, data, data.length);
            RequestContext rc = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)this.ctx.getAppId(), (String)(this.ctx.getBillFormId() + UUID.randomUUID().toString()), (String)fileName);
            url = this.service.upload(new FileItem(fileName, path, tempFile.getInputStream(url)));
            this.importLogger.setErrFile(UrlService.getAttachmentFullUrl((String)url));
        }
        catch (Exception exp) {
            throw new KDBizException((Throwable)exp, new ErrorCode("", exp instanceof KDBizException ? exp.getMessage() : ResManager.loadKDString((String)"\u6570\u636e\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"MultiEntityImportFailedSheetHandler_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            try {
                if (this.book != null) {
                    this.book.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            this.ctx = null;
            this.sheets.clear();
            this.book = null;
            this.importLogger = null;
        }
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        HRSheetHandler.handleDataValidation(cellValidations, this.sheets, this.hasErrorCol);
    }

    public void handleSheetComments(Map<String, CommentsTable> comments) {
        HRSheetHandler.handleSheetComments(comments, !this.isDistributeFullData, this.book, this.nameRows, this.hasErrorCol);
    }
}

