/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multisheet.helper;

import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.export.MultiEntityService;
import kd.hr.hbp.business.multimpt.MultiSheetListDataExporter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class MultiSheetHelper {
    private static final String FIELD_NAME = "name";

    public static MultiSheetListDataExporter getMultiSheetTemplate(DynamicObject templateData) {
        DynamicObject mainEntityTmplDyo = templateData.getDynamicObject("mainentitytmpl");
        String mainBizObjNum = mainEntityTmplDyo.getString("bizobject.number");
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)mainBizObjNum);
        List formats = MultiEntityService.loadExportFormat((String)mainBizObjNum, (Long)((Long)mainEntityTmplDyo.getPkValue()));
        String mainEntitySheetName = mainEntity.getDisplayName().getLocaleValue();
        MultiSheetListDataExporter exporter = new MultiSheetListDataExporter();
        String tempCode = mainEntityTmplDyo.getString("number") + "#" + templateData.getString("number");
        exporter.addSheet(mainEntitySheetName, formats, false, true, tempCode);
        DynamicObjectCollection assocEntityTmplDyoColl = templateData.getDynamicObjectCollection("assocentitytmplentry");
        for (DynamicObject dynamicObject : assocEntityTmplDyoColl) {
            DynamicObject assocEntityTmplDyo = dynamicObject.getDynamicObject("assocentitytmpl");
            Long tmplId = (Long)assocEntityTmplDyo.getPkValue();
            String assocBizObjNum = assocEntityTmplDyo.getString("bizobject.number");
            MainEntityType assocEntityType = EntityMetadataCache.getDataEntityType((String)assocBizObjNum);
            List entryFormat = MultiEntityService.loadExportFormat((String)assocBizObjNum, (Long)tmplId);
            String entitySheetName = assocEntityType.getDisplayName().getLocaleValue();
            exporter.addSheet(entitySheetName, entryFormat, false, false, assocEntityTmplDyo.getString("number"));
        }
        return exporter;
    }

    public static String getExportFileName(LocalDate now, DynamicObject templateData) {
        String fileName = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"MultiEntityDlImptTmplPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
        if (templateData != null) {
            fileName = fileName + templateData.get(FIELD_NAME);
        }
        fileName = fileName.replaceAll(" ", "_");
        fileName = fileName + "_" + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        return fileName;
    }

    public static boolean handSheetNames(Set<String> sheetNames, String sheetName) {
        Set ddlNameSet = sheetNames.stream().filter(name -> name.contains("DDM_")).collect(Collectors.toSet());
        sheetNames.removeAll(ddlNameSet);
        sheetNames.remove(sheetName);
        return sheetNames.size() <= 0;
    }

    public static QFilter handlePermBaseDataReference(String entityNumber, String fieldKey) {
        QFilter permQFilter = new QFilter("1", "=", (Object)1);
        QFilter resultQFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), BizAppServiceHelp.getAppIdByFormNum((String)entityNumber), entityNumber, fieldKey, "47150e89000000ac", null});
        if (Objects.nonNull(resultQFilter)) {
            permQFilter.and(resultQFilter);
        }
        return permQFilter;
    }
}

