/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multisheet.helper;

import java.util.Locale;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class MultiSheetInvoker {
    private static final Log LOGGER = LogFactory.getLog(MultiSheetInvoker.class);
    private static DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("kd.hr.hbp.formplugin.web.multisheet.helper.MultiSheetInvoker");

    public static DistributeSessionlessCache getDistributeSessionlessCache() {
        return CACHE;
    }

    public static Object invoker(String appNum, String formNum, String method, Object ... params) {
        String cloudId = MultiSheetInvoker.getCloudNmuByAppNum(appNum);
        try {
            return DispatchServiceHelper.invokeBizService((String)cloudId, (String)appNum, (String)formNum, (String)method, (Object[])params);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warn("MultiSheetInvoker--error:{}", (Object)runtimeException.getMessage());
            return null;
        }
    }

    private static String getAppIdByFormNum(String FormName) {
        String appId = (String)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"BizAppService", (String)"getAppIdByFormNum", (Object[])new Object[]{FormName});
        if (StringUtils.isNotEmpty((String)appId)) {
            return appId;
        }
        return "";
    }

    public static String getCloudNmuByAppNum(String appNum) {
        String appId = (String)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"BizAppService", (String)"getAppIdByAppNumber", (Object[])new Object[]{appNum});
        DynamicObject dynamicObject = (DynamicObject)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"BizCloudService", (String)"getBizCloudByAppID", (Object[])new Object[]{appId});
        if (Objects.nonNull(dynamicObject)) {
            return dynamicObject.getString("number").toLowerCase(Locale.ROOT);
        }
        return "";
    }

    private static String getServiceFactoryName(String cloudId, String appNum) {
        return "kd." + cloudId + "." + appNum + ".servicehelper.ServiceFactory";
    }
}

